/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import com.rscja.deviceapi.interfaces.ConnectionStatus;
import com.rscja.deviceapi.interfaces.ConnectionStatusCallback;
import com.rscja.deviceapi.interfaces.IHF14443A;
import com.rscja.deviceapi.interfaces.IHF14443B;
import com.rscja.deviceapi.interfaces.IHF15693;
import com.rscja.team.qcom.r1.IPSAM;
import com.rscja.team.qcom.r1.a.b;
import com.rscja.team.qcom.r1.a.c;
import com.rscja.team.qcom.usb.a;
import com.rscja.team.qcom.utility.LogUtility_qcom;
import java.util.Arrays;
import java.util.List;

public class R1HFAndPsamManage {
    private static R1HFAndPsamManage manage = new R1HFAndPsamManage();
    private static String TAG = "R1HFAndPsamManage";
    private com.rscja.team.qcom.r1.a.a hf14443A = null;
    private b hf14443B = null;
    private c hf15693 = null;
    private IPSAM psam = null;
    private a usb;
    private ConnectionStatus connectionStatus;

    private R1HFAndPsamManage() {
        a a2;
        a a3 = a2;
        R1HFAndPsamManage r1HFAndPsamManage = this;
        a a4 = a3;
        a4();
        r1HFAndPsamManage.usb = a4;
        r1HFAndPsamManage.connectionStatus = ConnectionStatus.DISCONNECTED;
        a2.setConnectionStatusCallback(new ConnectionStatusCallback(){

            public void getStatus(ConnectionStatus connectionStatus, Object object) {
                R1HFAndPsamManage.access$002(R1HFAndPsamManage.this, connectionStatus);
            }
        });
    }

    public static R1HFAndPsamManage getInstance() {
        return manage;
    }

    private boolean connect(UsbDevice usbDevice, Context context) {
        if (context == null) {
            return false;
        }
        if (usbDevice == null) {
            return false;
        }
        if (usbDevice.getVendorId() == 8263 && usbDevice.getProductId() == 769) {
            R1HFAndPsamManage r1HFAndPsamManage = this;
            r1HFAndPsamManage.setConnectStatus(ConnectionStatus.CONNECTING, usbDevice);
            r1HFAndPsamManage.usb.init(context);
            if (r1HFAndPsamManage.usb.openPort(usbDevice) == 0) {
                this.setConnectStatus(ConnectionStatus.CONNECTED, usbDevice);
                return true;
            }
            this.setConnectStatus(ConnectionStatus.DISCONNECTED, usbDevice);
            return false;
        }
        LogUtility_qcom.myLogDebug(TAG, "init vid=" + usbDevice.getVendorId() + "  pid=" + usbDevice.getProductId());
        return false;
    }

    private void setConnectStatus(ConnectionStatus connectionStatus, UsbDevice usbDevice) {
        this.connectionStatus = connectionStatus;
    }

    static /* synthetic */ ConnectionStatus access$002(R1HFAndPsamManage r1HFAndPsamManage, ConnectionStatus connectionStatus) {
        r1HFAndPsamManage.connectionStatus = connectionStatus;
        return connectionStatus;
    }

    public IHF14443A getHF14443A() {
        if (this.hf14443A == null) {
            this.hf14443A = new com.rscja.team.qcom.r1.a.a(this.usb);
        }
        return this.hf14443A;
    }

    public IHF14443B getHF14443B() {
        if (this.hf14443B == null) {
            this.hf14443B = new b(this.usb);
        }
        return this.hf14443B;
    }

    public IHF15693 getHF15693() {
        if (this.hf15693 == null) {
            this.hf15693 = new c(this.usb);
        }
        return this.hf15693;
    }

    public IPSAM getPSAM() {
        if (this.psam == null) {
            this.psam = new com.rscja.team.qcom.r1.b.a(this.usb);
        }
        return this.psam;
    }

    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public boolean connect(Context context) {
        if (context == null) {
            return false;
        }
        List<UsbDevice> list = this.usb.getDeviceList(context);
        if (list != null && list.size() != 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                UsbDevice usbDevice = list.get(i2);
                LogUtility_qcom.myLogDebug(TAG, "vid=" + usbDevice.getVendorId() + "  pid=" + usbDevice.getProductId());
                if (usbDevice.getVendorId() != 8263 || usbDevice.getProductId() != 769) continue;
                return this.connect(usbDevice, context);
            }
            return false;
        }
        return false;
    }

    public void disconnect() {
        R1HFAndPsamManage r1HFAndPsamManage = this;
        r1HFAndPsamManage.setConnectStatus(ConnectionStatus.DISCONNECTED, null);
        r1HFAndPsamManage.usb.closeport();
    }

    public String getHFVersion() {
        R1HFAndPsamManage r1HFAndPsamManage = object;
        byte[] byArray = new byte[1];
        Object object = byArray;
        byArray[0] = 2;
        byte[] byArray2 = r1HFAndPsamManage.usb.b((byte[])object);
        object = byArray2;
        if (byArray2 != null && object[1] == false) {
            String string;
            Object object2 = object;
            object = Arrays.copyOfRange((byte[])object2, 2, ((Object)object2).length);
            String string2 = string;
            Object object3 = object;
            string = new String((byte[])object3, 0, ((Object)object3).length);
            LogUtility_qcom.myLogDebug(TAG, "getHFVersion ver=" + string2);
            return string;
        }
        return null;
    }
}

