/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.rscja.deviceapi.BleDevice;
import com.rscja.deviceapi.interfaces.ConnectionStatus;
import com.rscja.deviceapi.interfaces.ScanBTCallback;
import com.rscja.team.qcom.utility.LogUtility_qcom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@RequiresApi(api=18)
public class RFIDWithUHFBLEManage {
    private static RFIDWithUHFBLEManage rfidWithUHFBLEManage = new RFIDWithUHFBLEManage();
    private String TAG = "RFIDWithUHFBLEManage";
    private BluetoothAdapter mBluetoothAdapter = null;
    private HashMap<String, BleDevice> uhfbleHashMap;
    private ScanBTCallback scanBTCallback;
    private BluetoothAdapter.LeScanCallback leScanCallback;

    public RFIDWithUHFBLEManage() {
        BluetoothAdapter.LeScanCallback leScanCallback;
        HashMap hashMap;
        Object object = hashMap;
        hashMap = new HashMap();
        this.uhfbleHashMap = object;
        this.scanBTCallback = null;
        object = leScanCallback;
        leScanCallback = new BluetoothAdapter.LeScanCallback(){

            public void onLeScan(BluetoothDevice bluetoothDevice, int n2, byte[] byArray) {
                if (RFIDWithUHFBLEManage.this.scanBTCallback != null) {
                    RFIDWithUHFBLEManage.this.scanBTCallback.getDevices(bluetoothDevice, n2, byArray);
                }
            }
        };
        this.leScanCallback = object;
    }

    public static RFIDWithUHFBLEManage getInstance() {
        return rfidWithUHFBLEManage;
    }

    public void startScanBTDevices(@NonNull ScanBTCallback scanBTCallback, @NonNull Context context) {
        if (context == null) {
            LogUtility_qcom.myLogDebug(this.TAG, "startBTScan context==null");
            return;
        }
        this.scanBTCallback = scanBTCallback;
        if (this.mBluetoothAdapter == null) {
            this.mBluetoothAdapter = ((BluetoothManager)context.getSystemService("bluetooth")).getAdapter();
        }
        if (this.mBluetoothAdapter != null) {
            RFIDWithUHFBLEManage rFIDWithUHFBLEManage = this;
            LogUtility_qcom.myLogDebug(rFIDWithUHFBLEManage.TAG, "startBTScan begin");
            rFIDWithUHFBLEManage.mBluetoothAdapter.startLeScan(this.leScanCallback);
        }
    }

    public void stopScanBTDevices() {
        BluetoothAdapter bluetoothAdapter = this.mBluetoothAdapter;
        if (bluetoothAdapter != null) {
            bluetoothAdapter.stopLeScan(this.leScanCallback);
        }
    }

    public BleDevice getBleDeviceByMac(String string) {
        if (this.uhfbleHashMap.size() == 0) {
            return null;
        }
        return this.uhfbleHashMap.get(string);
    }

    public boolean addBleDevice(@NonNull String string, @NonNull Context context) {
        if (context != null && string != null) {
            BleDevice bleDevice;
            if (((RFIDWithUHFBLEManage)((Object)bleDevice2)).uhfbleHashMap.containsKey(string)) {
                return false;
            }
            BleDevice bleDevice2 = bleDevice;
            bleDevice = new BleDevice(string, context);
            ((RFIDWithUHFBLEManage)((Object)bleDevice2)).uhfbleHashMap.put(string, bleDevice2);
            return true;
        }
        LogUtility_qcom.myLogDebug(((RFIDWithUHFBLEManage)((Object)bleDevice2)).TAG, "addBleDevice context==null");
        return false;
    }

    public boolean removeBleDevice(@NonNull String string) {
        if (string == null) {
            LogUtility_qcom.myLogDebug(this.TAG, "addBleDevice context==null");
            return false;
        }
        if (!this.uhfbleHashMap.containsKey(string)) {
            return false;
        }
        RFIDWithUHFBLEManage rFIDWithUHFBLEManage = this;
        rFIDWithUHFBLEManage.uhfbleHashMap.get(string).disconnect();
        rFIDWithUHFBLEManage.uhfbleHashMap.remove(string);
        return true;
    }

    public List<BleDevice> getAllBleDevice() {
        ArrayList arrayList;
        if (((RFIDWithUHFBLEManage)((Object)arrayList2)).uhfbleHashMap.size() == 0) {
            return null;
        }
        RFIDWithUHFBLEManage rFIDWithUHFBLEManage = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        Iterator<Map.Entry<String, BleDevice>> iterator = rFIDWithUHFBLEManage.uhfbleHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            arrayList2.add(iterator.next().getValue());
        }
        return arrayList2;
    }

    public void connectAll() {
        if ((this = ((RFIDWithUHFBLEManage)this).getAllBleDevice()) == null) {
            return;
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            BleDevice bleDevice = (BleDevice)this.get(i2);
            if (bleDevice.getConnectStatus() != ConnectionStatus.DISCONNECTED) continue;
            bleDevice.connect();
        }
    }

    public void disConnectAll() {
        if ((this = ((RFIDWithUHFBLEManage)this).getAllBleDevice()) == null) {
            return;
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            BleDevice bleDevice = (BleDevice)this.get(i2);
            if (bleDevice.getConnectStatus() != ConnectionStatus.CONNECTED) continue;
            bleDevice.disconnect();
        }
    }
}

