/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import com.rscja.deviceapi.entity.InventoryParameter;
import com.rscja.deviceapi.entity.LowBatteryEntity;
import com.rscja.deviceapi.exception.LowBatteryException;
import com.rscja.deviceapi.interfaces.ConnectionStatus;
import com.rscja.deviceapi.interfaces.ConnectionStatusCallback;
import com.rscja.deviceapi.interfaces.OnLowBatteryListener;
import com.rscja.utility.StringUtility;

public abstract class UhfBase {
    private static final String TAG = StringUtility.b + "UhfBase";
    private String UHF_POWER_OFF = "com.rscja.deviceapi.action.UHF_POWER_OFF";
    private HandlerThread myHandlerThread = null;
    protected Handler handler = null;
    protected final int MSG_CONNECTION_STATUS;
    protected ConnectionStatusCallback statusCallback = null;
    private PowerOffReceiver powerOffReceiver = null;
    private ScreenReceiver screenReceiver = null;
    private long uhfPowerOffBroadcastSendTime = 0L;
    private boolean isMonitorScreen = false;
    protected Context context = null;
    private boolean isScreen_off = false;
    protected InventoryParameter inventoryParameter = null;

    public UhfBase() {
        this.MSG_CONNECTION_STATUS = 1;
        if (null == null) {
            this.myHandlerThread = new HandlerThread("UhfBase-handler-thread");
            this.myHandlerThread.start();
            UhfBase uhfBase = this;
            this.handler = new Handler(uhfBase.myHandlerThread.getLooper()){

                public void handleMessage(Message message) {
                    if (message.what == 1 && (object = object.UhfBase.this.statusCallback) != null) {
                        1 v0 = object;
                        ConnectionStatusEntity connectionStatusEntity = (ConnectionStatusEntity)message.obj;
                        Object object = connectionStatusEntity.connectionStatus;
                        v0.getStatus((ConnectionStatus)((Object)object), connectionStatusEntity.device);
                    }
                }
            };
        }
    }

    static /* synthetic */ boolean access$502(UhfBase uhfBase, boolean bl) {
        uhfBase.isScreen_off = bl;
        return bl;
    }

    public abstract boolean init(Context var1);

    public boolean free() {
        Log.d((String)TAG, (String)("free() isScreen_off=" + this.isScreen_off));
        if (!this.isScreen_off) {
            UhfBase uhfBase = this;
            uhfBase.unregisterUhfPowerOffReceiver(uhfBase.context);
            uhfBase.unregisterScreenReceiver(uhfBase.context);
        }
        this.isScreen_off = false;
        return true;
    }

    public abstract ConnectionStatus getConnectStatus();

    public abstract boolean isInventorying();

    public abstract boolean stopInventory();

    public boolean setFastInventoryMode(boolean bl) {
        return false;
    }

    public int getFastInventoryMode() {
        return -1;
    }

    protected void sendBroadcastCloseUHF(Context context) {
        if (context != null) {
            this.uhfPowerOffBroadcastSendTime = SystemClock.elapsedRealtime();
            context.sendBroadcast(new Intent(this.UHF_POWER_OFF));
        }
        SystemClock.sleep((long)300L);
    }

    public void setOnLowBatteryListener(Context context, LowBatteryEntity lowBatteryEntity, OnLowBatteryListener onLowBatteryListener) throws LowBatteryException {
        throw new LowBatteryException("Not supported on this device!");
    }

    protected void registerUhfPowerOffReceiver(Context context) {
        Log.d((String)TAG, (String)("registerUhfPowerOffReceiver() context=" + context + "  powerOffReceiver=" + (Object)((Object)this.powerOffReceiver)));
        if (context != null && this.powerOffReceiver == null) {
            IntentFilter intentFilter;
            PowerOffReceiver powerOffReceiver;
            PowerOffReceiver powerOffReceiver2 = powerOffReceiver;
            this.powerOffReceiver = new PowerOffReceiver();
            PowerOffReceiver powerOffReceiver3 = powerOffReceiver2;
            powerOffReceiver2 = intentFilter;
            intentFilter = new IntentFilter(this.UHF_POWER_OFF);
            context.registerReceiver((BroadcastReceiver)powerOffReceiver3, (IntentFilter)powerOffReceiver2);
        }
        this.registerScreenReceiver(context);
    }

    protected void unregisterUhfPowerOffReceiver(Context context) {
        PowerOffReceiver powerOffReceiver;
        Log.d((String)TAG, (String)("unregisterUhfPowerOffReceiver() context=" + context + "  powerOffReceiver=" + (Object)((Object)this.powerOffReceiver)));
        if (context != null && (powerOffReceiver = this.powerOffReceiver) != null) {
            context.unregisterReceiver((BroadcastReceiver)powerOffReceiver);
            this.powerOffReceiver = null;
        }
    }

    protected void unregisterScreenReceiver(Context context) {
        ScreenReceiver screenReceiver;
        Log.d((String)TAG, (String)("unregisterScreenReceiver()=" + context + "  screenReceiver=" + (Object)((Object)this.screenReceiver)));
        if (context != null && (screenReceiver = this.screenReceiver) != null) {
            context.unregisterReceiver((BroadcastReceiver)screenReceiver);
            this.screenReceiver = null;
        }
    }

    protected void registerScreenReceiver(Context context) {
        Log.d((String)TAG, (String)("registerScreenReceiver()=" + context + "  screenReceiver=" + (Object)((Object)uhfBase2.screenReceiver) + "  isMonitorScreen=" + uhfBase2.isMonitorScreen));
        if (!uhfBase2.isMonitorScreen) {
            return;
        }
        if (context != null && uhfBase2.screenReceiver == null) {
            UhfBase uhfBase;
            IntentFilter intentFilter;
            uhfBase2.screenReceiver = uhfBase2.new ScreenReceiver();
            UhfBase uhfBase2 = intentFilter;
            new IntentFilter().addAction("android.intent.action.SCREEN_ON");
            uhfBase2.addAction("android.intent.action.SCREEN_OFF");
            uhfBase2.addAction("android.intent.action.USER_PRESENT");
            context.registerReceiver((BroadcastReceiver)uhfBase.screenReceiver, (IntentFilter)uhfBase2);
        }
    }

    class ScreenReceiver
    extends BroadcastReceiver {
        private ConnectionStatus connectionStatus = ConnectionStatus.DISCONNECTED;

        ScreenReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Log.d((String)TAG, (String)("ScreenReceiver action=" + intent.getAction()));
            if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                ScreenReceiver screenReceiver = this;
                screenReceiver.connectionStatus = screenReceiver.UhfBase.this.getConnectStatus();
                Log.d((String)TAG, (String)("ScreenReceiver ACTION_SCREEN_OFF  connectionStatus=" + (Object)((Object)this.connectionStatus)));
                UhfBase.access$502(screenReceiver.UhfBase.this, true);
                screenReceiver.UhfBase.this.free();
                Log.d((String)TAG, (String)"ScreenReceiver free end");
            } else if (intent.getAction().equals("android.intent.action.SCREEN_ON")) {
                Log.d((String)TAG, (String)"ScreenReceiver ACTION_SCREEN_ON");
            } else if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                Log.d((String)TAG, (String)("ScreenReceiver ACTION_USER_PRESENT connectionStatus=" + (Object)((Object)this.connectionStatus)));
                if (this.connectionStatus == ConnectionStatus.CONNECTED) {
                    UhfBase uhfBase = UhfBase.this;
                    uhfBase.init(uhfBase.context);
                }
            }
        }
    }

    class PowerOffReceiver
    extends BroadcastReceiver {
        PowerOffReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent != null && intent.getAction().equals(UhfBase.this.UHF_POWER_OFF)) {
                if (SystemClock.elapsedRealtime() - UhfBase.this.uhfPowerOffBroadcastSendTime < 2000L) {
                    Log.v((String)TAG, (String)("BroadcastReceiver UHF_POWER_OFF  return , context.getPackageName=" + context.getPackageName()));
                    return;
                }
                Log.v((String)TAG, (String)("BroadcastReceiver UHF_POWER_OFF free() ,context.getPackageName=" + context.getPackageName()));
                UhfBase.this.free();
            }
        }
    }

    public class ErrorCode {
        public static final int ERROR_NO_TAG = 1;
        public static final int ERROR_INSUFFICIENT_PRIVILEGES = 2;
        public static final int ERROR_MEMORY_OVERRUN = 3;
        public static final int ERROR_MEMORY_LOCK = 4;
        public static final int ERROR_TAG_NO_REPLY = 5;
        public static final int ERROR_PASSWORD_IS_INCORRECT = 6;
        public static final int ERROR_RESPONSE_BUFFER_OVERFLOW = 7;
        public static final int ERROR_NO_ENOUGH_POWER_ON_TAG = 11;
        public static final int ERROR_OPERATION_FAILED = 255;
        public static final int ERROR_SEND_FAIL = 252;
        public static final int ERROR_RECV_FAIL = 253;
        public static final int ERRCODE_SUCCESS = 0;
        public static final int ERRCODE_FAILURE = -1;
    }

    protected class ConnectionStatusEntity {
        private ConnectionStatus connectionStatus = null;
        private Object device = null;

        public ConnectionStatusEntity(ConnectionStatus connectionStatus, Object object) {
            this.connectionStatus = connectionStatus;
            this.device = object;
        }

        public ConnectionStatus getConnectionStatus() {
            return this.connectionStatus;
        }

        public void setConnectionStatus(ConnectionStatus connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        public Object getDevice() {
            return this.device;
        }

        public void setDevice(Object object) {
            this.device = object;
        }
    }
}

