/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi.entity;

public class BarcodeResult {
    public static final String A = "UPC-A, UPC-E, UPC-E1, EAN-8, EAN-13";
    public static final String B = "Code 39, Code 32";
    public static final String C = "Codabar";
    public static final String D = "Code 128, ISBT 128, ISBT 128 Concatenated";
    public static final String E = "Code 93";
    public static final String F = "Interleaved 2 of 5";
    public static final String G = "Discrete 2 of 5, or Discrete 2 of 5 IATA";
    public static final String H = "Code 11";
    public static final String J = "MSI";
    public static final String K = "GS1-128";
    public static final String L = "Bookland EAN";
    public static final String M = "Trioptic Code 39";
    public static final String N = "Coupon Code";
    public static final String R = "GS1 DataBar Family";
    public static final String S = "Matrix 2 of 5";
    public static final String T = "UCC Composite, TLC 39";
    public static final String U = "Chinese 2 of 5";
    public static final String V = "Korean 3 of 5";
    public static final String X = "ISSN EAN, PDF417, Macro PDF417, Micro PDF417";
    public static final String Z = "Aztec, Aztec Rune";
    public static final String P00 = "Data Matrix";
    public static final String P01 = "QR Code, MicroQR";
    public static final String P02 = "Maxicode";
    public static final String P03 = "US Postnet";
    public static final String P04 = "US Planet";
    public static final String P05 = "Japan Postal";
    public static final String P06 = "UK Postal";
    public static final String P08 = "Netherlands KIX Code";
    public static final String P09 = "Australia Post";
    public static final String P0A = "USPS 4CB/One Code/Intelligent Mail";
    public static final String P0B = "UPU FICS Postal";
    public static final String P0H = "Han Xin";
    public static final String P0X = "Signature Capture";
    private String barcodeType;
    private byte[] barcodeBytesData;
    private String barcodeSymbology;

    public BarcodeResult(String string, byte[] byArray, String string2) {
        this.barcodeType = string;
        this.barcodeBytesData = byArray;
        this.barcodeSymbology = string2;
    }

    public static BarcodeResult build(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            if (byArray.length == 1) {
                return new BarcodeResult(null, byArray, null);
            }
            String string = new String(byArray).toUpperCase();
            if (string.startsWith("A")) {
                return new BarcodeResult(A, byArray, "A");
            }
            if (string.startsWith("B")) {
                return new BarcodeResult(B, byArray, "B");
            }
            if (string.startsWith("C")) {
                return new BarcodeResult(C, byArray, "C");
            }
            if (string.startsWith("D")) {
                return new BarcodeResult(D, byArray, "D");
            }
            if (string.startsWith("E")) {
                return new BarcodeResult(E, byArray, "E");
            }
            if (string.startsWith("F")) {
                return new BarcodeResult(F, byArray, "F");
            }
            if (string.startsWith("G")) {
                return new BarcodeResult(G, byArray, "G");
            }
            if (string.startsWith("H")) {
                return new BarcodeResult(H, byArray, "H");
            }
            if (string.startsWith("J")) {
                return new BarcodeResult(J, byArray, "J");
            }
            if (string.startsWith("K")) {
                return new BarcodeResult(K, byArray, "K");
            }
            if (string.startsWith("L")) {
                return new BarcodeResult(L, byArray, "L");
            }
            if (string.startsWith("M")) {
                return new BarcodeResult(M, byArray, "M");
            }
            if (string.startsWith("N")) {
                return new BarcodeResult(N, byArray, "N");
            }
            if (string.startsWith("R")) {
                return new BarcodeResult(R, byArray, "R");
            }
            if (string.startsWith("S")) {
                return new BarcodeResult(S, byArray, "S");
            }
            if (string.startsWith("T")) {
                return new BarcodeResult(T, byArray, "T");
            }
            if (string.startsWith("U")) {
                return new BarcodeResult(U, byArray, "U");
            }
            if (string.startsWith("V")) {
                return new BarcodeResult(V, byArray, "V");
            }
            if (string.startsWith("X")) {
                return new BarcodeResult(X, byArray, "X");
            }
            if (string.startsWith("Z")) {
                return new BarcodeResult(Z, byArray, "Z");
            }
            if (byArray.length <= 3) {
                return new BarcodeResult(null, byArray, null);
            }
            if (string.startsWith("P00")) {
                return new BarcodeResult(P00, byArray, "P00");
            }
            if (string.startsWith("P01")) {
                return new BarcodeResult(P01, byArray, "P01");
            }
            if (string.startsWith("P02")) {
                return new BarcodeResult(P02, byArray, "P02");
            }
            if (string.startsWith("P03")) {
                return new BarcodeResult(P03, byArray, "P03");
            }
            if (string.startsWith("P04")) {
                return new BarcodeResult(P04, byArray, "P04");
            }
            if (string.startsWith("P05")) {
                return new BarcodeResult(P05, byArray, "P05");
            }
            if (string.startsWith("P06")) {
                return new BarcodeResult(P06, byArray, "P06");
            }
            if (string.startsWith("P08")) {
                return new BarcodeResult(P08, byArray, "P08");
            }
            if (string.startsWith("P09")) {
                return new BarcodeResult(P09, byArray, "P09");
            }
            if (string.startsWith("P0A")) {
                return new BarcodeResult(P0A, byArray, "P0A");
            }
            if (string.startsWith("P0B")) {
                return new BarcodeResult(P0B, byArray, "P0B");
            }
            if (string.startsWith("P0H")) {
                return new BarcodeResult(P0H, byArray, "P0H");
            }
            if (string.startsWith("P0X")) {
                return new BarcodeResult(P0X, byArray, "P0X");
            }
            return new BarcodeResult(null, byArray, null);
        }
        return null;
    }

    public static String getBarcodeTypeBySymbology(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("A")) {
            return A;
        }
        if (string.startsWith("B")) {
            return B;
        }
        if (string.startsWith("C")) {
            return C;
        }
        if (string.startsWith("D")) {
            return D;
        }
        if (string.startsWith("E")) {
            return E;
        }
        if (string.startsWith("F")) {
            return F;
        }
        if (string.startsWith("G")) {
            return G;
        }
        if (string.startsWith("H")) {
            return H;
        }
        if (string.startsWith("J")) {
            return J;
        }
        if (string.startsWith("K")) {
            return K;
        }
        if (string.startsWith("L")) {
            return L;
        }
        if (string.startsWith("M")) {
            return M;
        }
        if (string.startsWith("N")) {
            return N;
        }
        if (string.startsWith("R")) {
            return R;
        }
        if (string.startsWith("S")) {
            return S;
        }
        if (string.startsWith("T")) {
            return T;
        }
        if (string.startsWith("U")) {
            return U;
        }
        if (string.startsWith("V")) {
            return V;
        }
        if (string.startsWith("X")) {
            return X;
        }
        if (string.startsWith("Z")) {
            return Z;
        }
        if (string.startsWith("P00")) {
            return P00;
        }
        if (string.startsWith("P01")) {
            return P01;
        }
        if (string.startsWith("P02")) {
            return P02;
        }
        if (string.startsWith("P03")) {
            return P03;
        }
        if (string.startsWith("P04")) {
            return P04;
        }
        if (string.startsWith("P05")) {
            return P05;
        }
        if (string.startsWith("P06")) {
            return P06;
        }
        if (string.startsWith("P08")) {
            return P08;
        }
        if (string.startsWith("P09")) {
            return P09;
        }
        if (string.startsWith("P0A")) {
            return P0A;
        }
        if (string.startsWith("P0B")) {
            return P0B;
        }
        if (string.startsWith("P0H")) {
            return P0H;
        }
        if (string.startsWith("P0X")) {
            return P0X;
        }
        return null;
    }

    public String getBarcodeType() {
        return this.barcodeType;
    }

    public void setBarcodeType(String string) {
        this.barcodeType = string;
    }

    public byte[] getBarcodeBytesData() {
        return this.barcodeBytesData;
    }

    public void setBarcodeBytesData(byte[] byArray) {
        this.barcodeBytesData = byArray;
    }

    public String getBarcodeSymbology() {
        return this.barcodeSymbology;
    }

    public void setBarcodeSymbology(String string) {
        this.barcodeSymbology = string;
    }
}

