/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.team.mtk.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.entity.ISO15693Entity;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.deviceapi.exception.RFIDNotFoundException;
import com.rscja.deviceapi.exception.RFIDReadFailureException;
import com.rscja.deviceapi.interfaces.IRFIDWithISO15693;
import com.rscja.team.mtk.deviceapi.i;
import com.rscja.team.mtk.utility.LogUtility_mtk;
import com.rscja.utility.StringUtility;

public class RFIDWithISO15693_mtk
extends i
implements IRFIDWithISO15693 {
    private static final String c = "DeviceAPI_15693";
    private static RFIDWithISO15693_mtk d;

    protected RFIDWithISO15693_mtk() throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithISO15693_mtk a() throws ConfigurationException {
        if (d != null) return d;
        Class<RFIDWithISO15693_mtk> clazz = RFIDWithISO15693_mtk.class;
        synchronized (RFIDWithISO15693_mtk.class) {
            if (d != null) return d;
            d = new RFIDWithISO15693_mtk();
            // ** MonitorExit[var0] (shouldn't be in output)
            return d;
        }
    }

    @Override
    public synchronized ISO15693Entity inventory() {
        ISO15693Entity iSO15693Entity;
        char[] cArray = ((i)object).getDeviceAPI().ISO15693_inventory(1, 0);
        if (cArray[0] != '\u0000') {
            Log.e((String)c, (String)("inventory() err:" + Character.digit(cArray[0], 10)));
            return null;
        }
        char[] cArray2 = new char[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            cArray2[i2] = cArray[i2 + 4];
        }
        String string = "";
        if (cArray.length > 10) {
            char c2 = cArray[10];
            if (c2 != '\u0002') {
                if (c2 != '\u0004') {
                    if (c2 != '\u0007') {
                        if (c2 == '\u0016') {
                            string = TagType.EM4033.toString();
                        }
                    } else {
                        string = TagType.TI2048.toString();
                    }
                } else {
                    string = TagType.ICODE2.toString();
                }
            } else {
                string = TagType.STLRIS64K.toString();
            }
        }
        int n2 = 8;
        char[] cArray3 = new char[8];
        for (int i3 = 0; i3 < 8; ++i3) {
            cArray3[i3] = cArray2[7 - i3];
        }
        String string2 = StringUtility.chars2HexString(cArray3, 8);
        ISO15693Entity iSO15693Entity2 = iSO15693Entity;
        byte[] byArray = StringUtility.charsTobytes(cArray3, n2);
        if (new ISO15693Entity(string2, string, cArray2, byArray).getType().equals(TagType.EM4033.toString())) {
            return iSO15693Entity2;
        }
        Object object = iSO15693Entity2.getType().equals(TagType.STLRIS64K.toString()) ? (Object)((i)object).getDeviceAPI().ISO15693_getSystemInformation(8, cArray2, 0) : (Object)((i)object).getDeviceAPI().ISO15693_getSystemInformation(0, cArray2, 0);
        if (object[0] == false && object[1] > 12) {
            iSO15693Entity2.setAFI(StringUtility.char2HexString((char)object[12]));
            iSO15693Entity2.setDESFID(StringUtility.char2HexString((char)object[11]));
        }
        return iSO15693Entity2;
    }

    @Override
    public synchronized ISO15693Entity read(int n2) throws RFIDReadFailureException {
        char[] cArray;
        ISO15693Entity iSO15693Entity = this.inventory();
        if (iSO15693Entity == null) {
            return null;
        }
        ISO15693Entity iSO15693Entity2 = iSO15693Entity;
        char[] cArray2 = iSO15693Entity2.getOriginalUID();
        if (iSO15693Entity2.getType().equals(TagType.EM4033.toString())) {
            return iSO15693Entity;
        }
        if (iSO15693Entity.getType().equals(TagType.STLRIS64K.toString())) {
            int n3 = cArray2.length;
            cArray = this.getDeviceAPI().ISO15693_read_sm(0, cArray2, n3, n2, 1);
        } else {
            int n4 = cArray2.length;
            cArray = this.getDeviceAPI().ISO15693_read_sm(0, cArray2, n4, n2, 1);
        }
        if (cArray[0] == '\u0000') {
            n2 = cArray[1];
            cArray2 = new char[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                cArray2[i2] = cArray[i2 + 2];
            }
            ISO15693Entity iSO15693Entity3 = iSO15693Entity;
            iSO15693Entity3.setData(StringUtility.chars2HexString(cArray2, n2));
            return iSO15693Entity3;
        }
        Log.e((String)c, (String)("read() err:" + cArray[0]));
        throw new RFIDReadFailureException();
    }

    @Override
    public synchronized ISO15693Entity read(int n2, int n3) throws RFIDReadFailureException {
        char[] cArray;
        ISO15693Entity iSO15693Entity = this.inventory();
        if (iSO15693Entity == null) {
            return null;
        }
        char[] cArray2 = iSO15693Entity.getOriginalUID();
        if (n3 > 10) {
            n3 = 10;
        }
        if (iSO15693Entity.getType().equals(TagType.EM4033.toString())) {
            return iSO15693Entity;
        }
        if (iSO15693Entity.getType().equals(TagType.STLRIS64K.toString())) {
            int n4 = cArray2.length;
            cArray = this.getDeviceAPI().ISO15693_read_sm_ex(0, cArray2, n4, n2, n3);
        } else {
            int n5 = cArray2.length;
            cArray = this.getDeviceAPI().ISO15693_read_sm_ex(0, cArray2, n5, n2, n3);
        }
        if (cArray[0] == '\u0000') {
            n2 = cArray[1];
            char[] cArray3 = new char[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                cArray3[i2] = cArray[i2 + 2];
            }
            ISO15693Entity iSO15693Entity2 = iSO15693Entity;
            iSO15693Entity2.setData(StringUtility.chars2HexString(cArray3, n2));
            return iSO15693Entity2;
        }
        Log.e((String)c, (String)("read() err:" + cArray[0]));
        throw new RFIDReadFailureException();
    }

    @Override
    public synchronized boolean write(int n2, String object) throws RFIDNotFoundException {
        if (StringUtility.isEmpty((CharSequence)object)) {
            return false;
        }
        ISO15693Entity iSO15693Entity = this.inventory();
        if (iSO15693Entity != null) {
            int n3;
            Object object2;
            char[] cArray = StringUtility.hexString2Chars((String)object);
            object = cArray;
            LogUtility_mtk.myLogDebug(c, "pszData.length:" + ((Object)object).length);
            if (cArray.length >= 4) {
                object2 = object;
            } else {
                int n4;
                String string;
                String string2 = string;
                string = new String((char[])object);
                int n5 = 4 - ((Object)object).length;
                object2 = new char[4];
                for (n4 = 0; n4 < n5; ++n4) {
                    object2[n4] = 48;
                }
                for (n4 = n5; n4 < 4; ++n4) {
                    object2[n4] = string2.charAt(n4 - n5);
                }
            }
            ISO15693Entity iSO15693Entity2 = iSO15693Entity;
            char[] cArray2 = iSO15693Entity2.getOriginalUID();
            if (iSO15693Entity2.getType().equals(TagType.ICODE2.toString())) {
                n3 = ((Object)object2).length;
                n3 = this.getDeviceAPI().ISO15693_write_sm(0, cArray2, 0, n2, 1, (char[])object2, n3);
            } else if (iSO15693Entity.getType().equals(TagType.TI2048.toString())) {
                n3 = ((Object)object2).length;
                n3 = this.getDeviceAPI().ISO15693_write_sm(4, cArray2, 0, n2, 1, (char[])object2, n3);
            } else if (iSO15693Entity.getType().equals(TagType.STLRIS64K.toString())) {
                n3 = ((Object)object2).length;
                n3 = this.getDeviceAPI().ISO15693_write_sm(0, cArray2, 0, n2, 1, (char[])object2, n3);
            } else {
                n3 = ((Object)object2).length;
                n3 = this.getDeviceAPI().ISO15693_write_sm(0, cArray2, 0, n2, 1, (char[])object2, n3);
            }
            if (n3 == 0) {
                return true;
            }
            Log.e((String)c, (String)("write() err:" + n3));
            return false;
        }
        throw new RFIDNotFoundException();
    }

    @Override
    public synchronized boolean write(int n2, int n3, String object) throws RFIDNotFoundException {
        if (StringUtility.isEmpty((CharSequence)object)) {
            return false;
        }
        ISO15693Entity iSO15693Entity = this.inventory();
        if (iSO15693Entity != null) {
            int n4;
            if (n3 > 10) {
                n3 = 10;
            }
            char[] cArray = StringUtility.hexString2Chars((String)object);
            object = cArray;
            if (cArray.length < ((Object)object).length) {
                int n5 = ((Object)object).length % 4;
                for (int i2 = 0; i2 < ((Object)object).length - n5; ++i2) {
                    Object object2 = object;
                    object2[i2] = object2[i2];
                }
                if (n5 > 0) {
                    if (n5 == 1) {
                        Object object3 = object;
                        n5 = ((Object)object3).length - 1 + 3;
                        object3[n5] = object3[((Object)object3).length - 1];
                    } else if (n5 == 2) {
                        Object object4 = object;
                        n5 = ((Object)object4).length - 2 + 3;
                        object4[n5] = object4[((Object)object4).length - 1];
                        n5 = ((Object)object4).length - 2 + 2;
                        object4[n5] = object4[((Object)object4).length - 2];
                    } else if (n5 == 3) {
                        Object object5 = object;
                        n5 = ((Object)object5).length - 3 + 3;
                        object5[n5] = object5[((Object)object5).length - 1];
                        n5 = ((Object)object5).length - 3 + 2;
                        object5[n5] = object5[((Object)object5).length - 2];
                        n5 = ((Object)object5).length - 3 + 1;
                        object5[n5] = object5[((Object)object5).length - 3];
                    }
                }
            }
            ISO15693Entity iSO15693Entity2 = iSO15693Entity;
            char[] cArray2 = iSO15693Entity2.getOriginalUID();
            if (iSO15693Entity2.getType().equals(TagType.ICODE2.toString())) {
                n4 = cArray2.length;
                int n6 = ((Object)object).length;
                n4 = this.getDeviceAPI().ISO15693_write_sm_ex(0, cArray2, n4, n2, n3, (char[])object, n6);
            } else if (iSO15693Entity.getType().equals(TagType.TI2048.toString())) {
                n4 = cArray2.length;
                int n7 = ((Object)object).length;
                n4 = this.getDeviceAPI().ISO15693_write_sm_ex(4, cArray2, n4, n2, n3, (char[])object, n7);
            } else if (iSO15693Entity.getType().equals(TagType.STLRIS64K.toString())) {
                n4 = cArray2.length;
                int n8 = ((Object)object).length;
                n4 = this.getDeviceAPI().ISO15693_write_sm_ex(0, cArray2, n4, n2, n3, (char[])object, n8);
            } else {
                n4 = cArray2.length;
                int n9 = ((Object)object).length;
                n4 = this.getDeviceAPI().ISO15693_write_sm_ex(0, cArray2, n4, n2, n3, (char[])object, n9);
            }
            if (n4 == 0) {
                return true;
            }
            Log.e((String)c, (String)("write() err:" + n4));
            return false;
        }
        throw new RFIDNotFoundException();
    }

    @Override
    public synchronized boolean writeAFI(int n2) throws RFIDNotFoundException {
        char[] cArray = new char[1];
        n2 = Integer.parseInt(n2 + "", 16);
        ISO15693Entity iSO15693Entity = this.inventory();
        if (iSO15693Entity != null) {
            int n3 = iSO15693Entity.getType().equals(TagType.ICODE2.toString()) ? this.getDeviceAPI().ISO15693_writeAFI(0, cArray, 0, n2) : (iSO15693Entity.getType().equals(TagType.TI2048.toString()) ? this.getDeviceAPI().ISO15693_writeAFI(4, cArray, 0, n2) : (iSO15693Entity.getType().equals(TagType.STLRIS64K.toString()) ? this.getDeviceAPI().ISO15693_writeAFI(0, cArray, 0, n2) : this.getDeviceAPI().ISO15693_writeAFI(0, cArray, 0, n2)));
            if (n3 == 0) {
                return true;
            }
            Log.e((String)c, (String)("writeAFI() err:" + n3));
            return false;
        }
        throw new RFIDNotFoundException();
    }

    @Override
    public synchronized boolean lockAFI() throws RFIDNotFoundException {
        if (((RFIDWithISO15693_mtk)object).inventory() != null) {
            RFIDWithISO15693_mtk rFIDWithISO15693_mtk = object;
            Object object = new char[1];
            int n2 = rFIDWithISO15693_mtk.getDeviceAPI().ISO15693_lockAFI(0, (char[])object, 0);
            if (n2 == 0) {
                return true;
            }
            Log.e((String)c, (String)("LockAFI() err:" + n2));
            return false;
        }
        throw new RFIDNotFoundException();
    }

    @Override
    public synchronized boolean writeDSFID(int n2) throws RFIDNotFoundException {
        char[] cArray = new char[1];
        n2 = Integer.parseInt(n2 + "", 16);
        ISO15693Entity iSO15693Entity = this.inventory();
        if (iSO15693Entity != null) {
            int n3 = iSO15693Entity.getType().equals(TagType.ICODE2.toString()) ? this.getDeviceAPI().ISO15693_writeDSFID(0, cArray, 0, n2) : (iSO15693Entity.getType().equals(TagType.TI2048.toString()) ? this.getDeviceAPI().ISO15693_writeDSFID(4, cArray, 0, n2) : (iSO15693Entity.getType().equals(TagType.STLRIS64K.toString()) ? this.getDeviceAPI().ISO15693_writeDSFID(0, cArray, 0, n2) : this.getDeviceAPI().ISO15693_writeDSFID(0, cArray, 0, n2)));
            if (n3 == 0) {
                return true;
            }
            Log.e((String)c, (String)("writeDSFID() err:" + n3));
            return false;
        }
        throw new RFIDNotFoundException();
    }

    @Override
    public synchronized boolean lockDSFID() throws RFIDNotFoundException {
        char[] cArray = new char[1];
        ISO15693Entity iSO15693Entity = this.inventory();
        if (iSO15693Entity != null) {
            int n2 = iSO15693Entity.getType().equals(TagType.STLRIS64K.toString()) ? this.getDeviceAPI().ISO15693_lockDSFID(0, cArray, 0) : this.getDeviceAPI().ISO15693_lockDSFID(0, cArray, 0);
            if (n2 == 0) {
                return true;
            }
            Log.e((String)c, (String)("LockDSFID() err:" + n2));
            return false;
        }
        throw new RFIDNotFoundException();
    }

    @Override
    public char[] genericFunction(char c2, char[] cArray, char c3) {
        return this.getDeviceAPI().ISO15693_GenericFunction(c2, cArray, c3);
    }

    @Override
    public char[] genericFunction_ex(char c2, char c3, char[] cArray, int n2) {
        char c4 = (char)n2;
        return this.getDeviceAPI().ISO15693_GenericFunctionEx(c2, c3, cArray, c4);
    }

    public static final class TagType
    extends Enum<TagType> {
        public static final /* enum */ TagType ICODE2;
        public static final /* enum */ TagType TI2048;
        public static final /* enum */ TagType STLRIS64K;
        public static final /* enum */ TagType EM4033;
        public static final /* enum */ TagType NUll_;
        private static final /* synthetic */ TagType[] $VALUES;
        private final int value;

        public static TagType[] values() {
            return (TagType[])$VALUES.clone();
        }

        public static TagType valueOf(String string) {
            return Enum.valueOf(TagType.class, string);
        }

        private TagType(int n3) {
            this.value = n3;
        }

        static {
            TagType tagType;
            TagType tagType2;
            TagType tagType3;
            TagType tagType4;
            TagType tagType5;
            TagType tagType6 = tagType5;
            ICODE2 = new TagType(0);
            TagType tagType7 = tagType4;
            TI2048 = new TagType(4);
            TagType tagType8 = tagType3;
            STLRIS64K = new TagType(8);
            TagType tagType9 = tagType2;
            EM4033 = new TagType(12);
            TagType tagType10 = tagType;
            NUll_ = new TagType(100);
            $VALUES = new TagType[]{tagType6, tagType7, tagType8, tagType9, tagType10};
        }

        public int getValue() {
            return this.value;
        }
    }
}

