/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.team.qcom.deviceapi;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.rscja.deviceapi.Module;
import com.rscja.deviceapi.UhfBase;
import com.rscja.deviceapi.entity.Gen2Entity;
import com.rscja.deviceapi.entity.InventoryModeEntity;
import com.rscja.deviceapi.entity.InventoryParameter;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.deviceapi.interfaces.ConnectionStatus;
import com.rscja.deviceapi.interfaces.ConnectionStatusCallback;
import com.rscja.deviceapi.interfaces.IHandheldRFID;
import com.rscja.deviceapi.interfaces.ISingleAntenna;
import com.rscja.deviceapi.interfaces.ITagLocate;
import com.rscja.deviceapi.interfaces.IUHF;
import com.rscja.deviceapi.interfaces.IUHFInventoryCallback;
import com.rscja.deviceapi.interfaces.IUHFLocationCallback;
import com.rscja.deviceapi.interfaces.IUHFOfAndroidUart;
import com.rscja.deviceapi.interfaces.IUHFRadarLocationCallback;
import com.rscja.team.qcom.DeviceConfiguration_qcom;
import com.rscja.team.qcom.deviceapi.DeviceAPI;
import com.rscja.team.qcom.deviceapi.M;
import com.rscja.team.qcom.deviceapi.W;
import com.rscja.team.qcom.utility.LogUtility_qcom;
import com.rscja.utility.StringUtility;
import com.rscja.utility.c;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class G
extends UhfBase
implements IUHF,
IUHFOfAndroidUart,
ISingleAntenna,
IHandheldRFID {
    private static final String TAG = StringUtility.b + "UHF";
    private static G single = null;
    protected int TidLength = 6;
    private boolean isContainReserved = false;
    private boolean DEBUG = StringUtility.a;
    protected DeviceConfiguration_qcom config;
    private byte[] uhfdata = new byte[512];
    private ConnectionStatus connectionStatus = ConnectionStatus.DISCONNECTED;
    private ConnectionStatusCallback<Object> btStatusCallback = null;
    private boolean isPowerOnBySystem = false;
    private boolean isWorking = false;
    private final int CLEAN;
    private final int MSG_LOCATION;
    private a inventoryThread = null;
    private b handler = null;
    private IUHFLocationCallback locationCallback = null;
    private int lastValue = 0;
    private IUHFInventoryCallback inventoryCallback = null;
    private W uhfRadarLocation_qcom = null;
    private boolean isLocation = false;
    private M tagLocate_qcom = null;
    private long idleTime = SystemClock.elapsedRealtime();
    int type = 1;
    protected boolean powerOn = false;

    protected G() throws ConfigurationException {
        this.CLEAN = 1;
        this.MSG_LOCATION = 0;
        Log.d((String)TAG, (String)"RFIDWithUHFUART_qcom()");
        this.config = DeviceConfiguration_qcom.builderUHFConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized G getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<G> clazz = G.class;
        synchronized (G.class) {
            if (single != null) return single;
            single = new G();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    private boolean powerOff() {
        block2: {
            block3: {
                if (!this.isPowerOnBySystem) break block3;
                try {
                    Module.getInstance().powerOff(this.context, 3);
                }
                catch (ConfigurationException configurationException) {
                    break block2;
                }
                break block2;
            }
            int n2 = this.getDeviceAPI().UHFFree(this.config.getDeviceName());
            Log.i((String)TAG, (String)("free()  UHFFree result:" + n2));
        }
        G g2 = this;
        g2.setPowerOn(false);
        g2.setConnectStatus(ConnectionStatus.DISCONNECTED);
        g2.isPowerOnBySystem = false;
        return true;
    }

    private boolean powerOn() {
        int n2;
        block6: {
            G g2 = this;
            n2 = 0;
            g2.setConnectStatus(ConnectionStatus.CONNECTING);
            if (g2.isPowerOnBySystem) {
                try {
                    if (Module.getInstance().powerOn(this.context, 3)) break block6;
                }
                catch (ConfigurationException configurationException) {}
                G g3 = this;
                Log.e((String)TAG, (String)"uhf PowerOn fail!");
                g3.setConnectStatus(ConnectionStatus.DISCONNECTED);
                return false;
            } else {
                n2 = this.getDeviceAPI().UHFInit(this.config.getDeviceName());
            }
        }
        return n2 == 0;
    }

    private String makeVersion1(int n2, int n3, int n4) {
        String string = n2 != 3 ? (n2 != 5 ? (n2 != 7 ? "V" + n2 + "." + n3 + "." + n4 : "E710_V" + n2 + "." + n3 + "." + n4) : "E510_V" + n2 + "." + n3 + "." + n4) : "E310_V" + n2 + "." + n3 + "." + n4;
        Log.e((String)TAG, (String)("makeVersion1\uff1a" + (String)string));
        return string;
    }

    private String makeVersion(char[] cArray, String string) {
        Log.e((String)TAG, (String)("getHardwareType() v:" + string + " arrs[0]=" + cArray[0] + "  arrs[1]=" + cArray[1]));
        if (cArray[0] == 'V') {
            char c2 = cArray[1];
            if (c2 != '3') {
                if (c2 != '5') {
                    if (c2 == '7') {
                        String string2 = string;
                        string = "E710_V" + string2.substring(1, string2.length());
                    }
                } else {
                    String string3 = string;
                    string = "E510_V" + string3.substring(1, string3.length());
                }
            } else {
                String string4 = string;
                string = "E310_V" + string4.substring(1, string4.length());
            }
        }
        return string;
    }

    private synchronized boolean startInventory(int n2, int n3, int n4) {
        if (this.isInventorying()) {
            Log.e((String)TAG, (String)"startInventoryTag() already start!");
            return false;
        }
        n2 = (char)n2;
        n3 = (char)n3;
        n4 = (char)n4;
        n2 = this.getDeviceAPI().UHFInventory_EX_cnt((char)n2, (char)n3, (char)n4);
        if (n2 == 0) {
            G g2 = this;
            g2.setWorking(true);
            if ((g2.inventoryCallback != null || this.isLocation) && this.inventoryThread == null) {
                a a2;
                a a3 = a2;
                a3();
                this.inventoryThread = a3;
                a2.start();
            }
            return true;
        }
        Log.e((String)TAG, (String)("startInventory() err :" + n2));
        return false;
    }

    private void setConnectStatus(ConnectionStatus connectionStatus) {
        ConnectionStatusCallback<Object> connectionStatusCallback = this.btStatusCallback;
        if (connectionStatusCallback != null) {
            connectionStatusCallback.getStatus(connectionStatus, "UHF UART");
        }
        this.connectionStatus = connectionStatus;
    }

    private void stopInventoryThread() {
        a a2 = this.inventoryThread;
        if (a2 != null) {
            a2.b();
            this.inventoryThread = null;
        }
    }

    private void setWorking(boolean bl) {
        this.isWorking = bl;
    }

    static /* synthetic */ int access$102(G g2, int n2) {
        g2.lastValue = n2;
        return n2;
    }

    static /* synthetic */ long access$502(G g2, long l2) {
        g2.idleTime = l2;
        return l2;
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    @Override
    public String getHardwareVersion() {
        Object object;
        if (!((G)object).isPowerOn()) {
            return null;
        }
        char[] cArray = ((G)object).getDeviceAPI().UHFGetHardwareVersionType();
        object = cArray;
        if (cArray != null && object[0] == false) {
            Object object2 = object;
            reference var1_1 = object2[1] + true;
            if (object2[var1_1] > 57) {
                char[] cArray2 = Arrays.copyOfRange((char[])object, 2, (int)var1_1);
                return new String(cArray2) + (int)(object[var1_1] - 48);
            }
            Object object3 = object;
            object = Arrays.copyOfRange((char[])object3, 2, (int)(object3[1] + 2));
            return new String((char[])object);
        }
        Log.e((String)TAG, (String)("getHardwareType() err:" + (char)object[0]));
        return null;
    }

    @Override
    public synchronized void setUart(String string) {
        G g2 = this;
        g2.config.setUart(string);
        g2.config.setDeviceName("unknown");
    }

    @Override
    public synchronized void setPowerOnBySystem(Context context) {
        G g2 = this;
        g2.isPowerOnBySystem = true;
        g2.context = context;
    }

    public synchronized boolean init() {
        if (this.isPowerOn()) {
            Log.i((String)TAG, (String)"uhf already initialized");
            return true;
        }
        int n2 = -1;
        if (this.powerOn()) {
            n2 = this.getDeviceAPI().UHFOpenAndConnect_Ex(this.config.getUart());
            String string = TAG;
            Log.i((String)string, (String)("init() Uart = " + this.config.getUart()));
            if (n2 > -1) {
                G g2 = this;
                g2.setPowerOn(true);
                g2.setConnectStatus(ConnectionStatus.CONNECTED);
                return true;
            }
            Log.e((String)string, (String)("init() err UHFOpenAndConnect result:" + n2));
            String string2 = this.config.getDeviceName();
            if (string2.equals(DeviceConfiguration_qcom.C4000_6577) || string2.equals(DeviceConfiguration_qcom.C4000_6582) || string2.equals(DeviceConfiguration_qcom.C4050_6582) || string2.equals(DeviceConfiguration_qcom.C4050_8909)) {
                G g3 = this;
                g3.getDeviceAPI().UHFCloseAndDisconnect();
                if (g3.getDeviceAPI().UHFOpenAndConnect(this.config.getUart()) > -1) {
                    G g4 = this;
                    g4.setPowerOn(true);
                    g4.setConnectStatus(ConnectionStatus.CONNECTED);
                    return true;
                }
            }
            this.getDeviceAPI().UHFCloseAndDisconnect();
        } else {
            Log.e((String)TAG, (String)("init() err UHFInit result:" + n2));
        }
        this.powerOff();
        return false;
    }

    @Override
    public synchronized boolean init(Context context) {
        G g2 = this;
        this.context = context;
        this.sendBroadcastCloseUHF(context);
        g2.registerUhfPowerOffReceiver(context);
        return g2.init_R2000();
    }

    @Override
    public synchronized boolean init_R2000() {
        if (this.isPowerOn()) {
            Log.i((String)TAG, (String)"uhf already initialized");
            return true;
        }
        int n2 = -1;
        if (this.powerOn()) {
            n2 = this.getDeviceAPI().UHFOpenAndConnect(this.config.getUart());
            String string = TAG;
            Log.i((String)string, (String)("init() Uart = " + this.config.getUart()));
            if (n2 > -1) {
                G g2 = this;
                g2.setPowerOn(true);
                g2.setConnectStatus(ConnectionStatus.CONNECTED);
                return true;
            }
            Log.e((String)string, (String)("init() err UHFOpenAndConnect result:" + n2));
            String string2 = this.config.getDeviceName();
            if (string2.equals(DeviceConfiguration_qcom.C4000_6577) || string2.equals(DeviceConfiguration_qcom.C4000_6582) || string2.equals(DeviceConfiguration_qcom.C4050_6582) || string2.equals(DeviceConfiguration_qcom.C4050_8909)) {
                G g3 = this;
                g3.getDeviceAPI().UHFCloseAndDisconnect();
                if (g3.getDeviceAPI().UHFOpenAndConnect(this.config.getUart()) > -1) {
                    G g4 = this;
                    g4.setPowerOn(true);
                    g4.setConnectStatus(ConnectionStatus.CONNECTED);
                    return true;
                }
            }
            this.getDeviceAPI().UHFCloseAndDisconnect();
        } else {
            Log.e((String)TAG, (String)("init() err UHFInit result:" + n2));
        }
        this.powerOff();
        return false;
    }

    @Override
    public synchronized boolean free() {
        if (!this.isPowerOn()) {
            Log.e((String)TAG, (String)"free() isPowerOn false");
            return true;
        }
        G g2 = this;
        super.free();
        g2.getDeviceAPI().UHFCloseAndDisconnect();
        g2.setWorking(false);
        g2.stopInventoryThread();
        g2.isLocation = false;
        b b2 = g2.handler;
        if (b2 != null) {
            b2.removeMessages(1);
        }
        this.powerOff();
        return true;
    }

    @Override
    public synchronized String getVersion() {
        G object3;
        String string = TAG;
        Log.e((String)string, (String)("getVersion isPowerOn()=" + object3.isPowerOn()));
        if (!object3.isPowerOn()) {
            return null;
        }
        char[] cArray = object3.getDeviceAPI().UHFGetHwType();
        if (cArray != null && cArray[0] == '\u0000') {
            char[] cArray2 = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
            Log.e((String)string, (String)("result\uff1a " + Arrays.toString(cArray2)));
            for (int i2 = 0; i2 < cArray2.length; ++i2) {
                char c2 = cArray2[i2];
                Log.e((String)TAG, (String)("index" + i2 + " value:" + c2));
            }
            if (cArray2[1] <= '9' && cArray2[3] <= '9' && cArray2[5] <= '9') {
                String string2;
                char[] cArray3 = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
                String string3 = string2;
                string2 = new String(cArray3);
                return object3.makeVersion(cArray3, string3);
            }
            int n2 = cArray2[1] - 48;
            int n3 = cArray2[3] - 48;
            int n4 = cArray2[5] - 48;
            return object3.makeVersion1(n2, n3, n4);
        }
        Log.e((String)string, (String)("getHardwareType() err:" + cArray[0]));
        return null;
    }

    @Override
    public synchronized int getPower() {
        char[] cArray = ((G)object).getDeviceAPI().UHFGetPower();
        Object object = cArray;
        if (cArray != null && object[0] == false) {
            return (int)object[1];
        }
        Log.e((String)TAG, (String)("getPower() err :" + (int)object[0]));
        return -1;
    }

    @Override
    public synchronized boolean setPower(int n2) {
        int n3 = this.getDeviceAPI().UHFSetPower((char)n2);
        if (n3 == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setPower() err :" + n3));
        return false;
    }

    @Override
    public synchronized int getFrequencyMode() {
        char[] cArray = ((G)object).getDeviceAPI().UHFGetFrequency_Ex();
        Object object = cArray;
        if (cArray != null && object[0] == false) {
            Object object2 = object[1];
            Log.e((String)TAG, (String)("getFrequencyMode() freMode :" + (int)object2));
            switch (object2) {
                default: {
                    break;
                }
                case 9: {
                    object2 = 52;
                    break;
                }
                case 8: {
                    object2 = 51;
                    break;
                }
                case 7: {
                    object2 = 128;
                    break;
                }
                case 6: {
                    object2 = 50;
                    break;
                }
                case 5: {
                    object2 = 22;
                    break;
                }
                case 4: {
                    object2 = 8;
                    break;
                }
                case 2: {
                    object2 = 4;
                    break;
                }
                case 1: {
                    object2 = true;
                    break;
                }
                case 0: {
                    object2 = 2;
                }
            }
            return (int)object2;
        }
        Log.e((String)TAG, (String)("getFrequencyMode() err :" + (int)object[0]));
        return -1;
    }

    @Override
    public synchronized boolean setFrequencyMode(int n2) {
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 4) {
                    if (n2 != 8) {
                        if (n2 != 22) {
                            if (n2 != 128) {
                                switch (n2) {
                                    default: {
                                        break;
                                    }
                                    case 52: {
                                        n2 = 9;
                                        break;
                                    }
                                    case 51: {
                                        n2 = 8;
                                        break;
                                    }
                                    case 50: {
                                        n2 = 6;
                                        break;
                                    }
                                }
                            } else {
                                n2 = 7;
                            }
                        } else {
                            n2 = 5;
                        }
                    } else {
                        n2 = 4;
                    }
                } else {
                    n2 = 2;
                }
            } else {
                n2 = 0;
            }
        } else {
            n2 = 1;
        }
        int n3 = this.getDeviceAPI().UHFSetFrequency_EX((char)n2);
        if (n3 == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFrequencyMode() err :" + n3));
        return false;
    }

    public synchronized boolean startInventoryTag(InventoryParameter inventoryParameter) {
        this.inventoryParameter = inventoryParameter;
        if (inventoryParameter == null) {
            return this.startInventoryTag();
        }
        if (inventoryParameter.getResultData() == null) {
            return this.startInventoryTag();
        }
        if (!inventoryParameter.getResultData().isContainFrequencyPoint()) {
            return this.startInventoryTag();
        }
        return this.startInventory(255, 254, 6);
    }

    @Override
    public synchronized boolean startInventoryTag() {
        return this.startInventory(0, 0, 6);
    }

    public synchronized boolean startInventoryTag(int n2, int n3, int n4) {
        return this.startInventory(0, 0, 6);
    }

    @Override
    public synchronized UHFTAGInfo readTagFromBuffer() {
        float f2;
        int n2;
        UHFTAGInfo uHFTAGInfo;
        int n3 = 0;
        InventoryParameter inventoryParameter = this.inventoryParameter;
        if (inventoryParameter != null && inventoryParameter.getResultData() != null) {
            n3 = this.inventoryParameter.getResultData().isContainFrequencyPoint();
        }
        int n4 = 0;
        while (true) {
            byte[] byArray = this.uhfdata;
            if (n4 >= this.uhfdata.length) break;
            byArray[n4] = 0;
            ++n4;
        }
        n4 = this.getDeviceAPI().UHFGetReceived_EX2(this.uhfdata);
        if (n4 <= 0) {
            return null;
        }
        if (LogUtility_qcom.isDebug()) {
            LogUtility_qcom.myLogDebug(TAG, "data=" + StringUtility.bytesHexString(this.uhfdata, n4));
        }
        UHFTAGInfo uHFTAGInfo2 = uHFTAGInfo;
        new UHFTAGInfo().setTimestamp(System.currentTimeMillis());
        int n5 = 1;
        byte[] byArray = this.uhfdata;
        int n6 = this.uhfdata[0] + 1;
        int n7 = n6 + 2;
        int n8 = n7 + (byArray[n6] << 8 | byArray[n6 + 1]);
        if (n8 - n7 > 0) {
            int n9;
            int n10 = this.TidLength * 2;
            byte[] byArray2 = Arrays.copyOfRange(byArray, n7, n8);
            int n11 = 0;
            if (n3 != 0) {
                n11 = 3;
                if (byArray2.length % 2 == 0) {
                    n3 = 0;
                    n11 = 0;
                }
            }
            if (byArray2.length > (n9 = n10 + n11)) {
                UHFTAGInfo uHFTAGInfo3 = uHFTAGInfo2;
                byte[] byArray3 = Arrays.copyOfRange(byArray2, n10, byArray2.length - n11);
                uHFTAGInfo3.setUser(StringUtility.bytesHexString(byArray3, byArray3.length));
                uHFTAGInfo3.setUserBytes(byArray3);
            }
            if (byArray2.length >= n9) {
                UHFTAGInfo uHFTAGInfo4 = uHFTAGInfo2;
                byte[] byArray4 = Arrays.copyOfRange(byArray2, 0, n10);
                uHFTAGInfo4.setTid(StringUtility.bytesHexString(byArray4, byArray4.length));
                uHFTAGInfo4.setChipInfo(c.a(uHFTAGInfo4.getTid()));
                uHFTAGInfo4.setTidBytes(byArray4);
            }
            if (n3 != 0) {
                int n12 = byArray2.length - 3;
                byte[] byArray5 = Arrays.copyOfRange(byArray2, n12, n12 + n11);
                uHFTAGInfo2.setFrequencyPoint((float)((byArray5[0] & 0xFF) << 16 | (byArray5[1] & 0xFF) << 8 | byArray5[2] & 0xFF) / 1000.0f);
            }
            n3 = n8 + 2;
            n2 = n3 + 2;
        } else {
            uHFTAGInfo2.setTid("");
            n3 = n7 + 2;
            n2 = n3 + 2;
            n8 = n7;
        }
        G g2 = this;
        Object object = Arrays.copyOfRange(g2.uhfdata, n3, n2);
        byte[] byArray6 = Arrays.copyOfRange(g2.uhfdata, n8, n3);
        G g3 = this;
        Object object2 = Arrays.copyOfRange(g3.uhfdata, n5, 3);
        byte[] byArray7 = Arrays.copyOfRange(g3.uhfdata, 3, n6);
        object = ((object[1] & 0xFF) << 8 | object[0] & 0xFF) + "";
        object2 = StringUtility.bytesHexString(object2, ((byte[])object2).length);
        String string = StringUtility.bytesHexString(byArray7, byArray7.length);
        float f3 = (float)(65535 - Integer.parseInt(StringUtility.bytesHexString(byArray6, byArray6.length), 16)) / 10.0f;
        Object object3 = "N/A";
        if (f2 < 200.0f && f3 > 0.0f) {
            DecimalFormat decimalFormat;
            object3 = decimalFormat;
            decimalFormat = new DecimalFormat("##0.00");
            object3 = "-" + ((NumberFormat)object3).format(f3);
        }
        uHFTAGInfo2.setAnt((String)object);
        uHFTAGInfo2.setRssi((String)object3);
        uHFTAGInfo2.setPc((String)object2);
        uHFTAGInfo2.setEPC(string);
        uHFTAGInfo2.setEpcBytes(byArray7);
        if (this.isContainReserved) {
            UHFTAGInfo uHFTAGInfo5 = uHFTAGInfo2;
            uHFTAGInfo5.setReserved(uHFTAGInfo5.getUser());
            uHFTAGInfo5.setUser(uHFTAGInfo5.getTid());
            uHFTAGInfo5.setTid(null);
        }
        return uHFTAGInfo2;
    }

    @Override
    public synchronized boolean stopInventory() {
        if (!this.isPowerOn()) {
            Log.e((String)TAG, (String)"stopInventory() isPowerOn false");
            return true;
        }
        int n2 = this.getDeviceAPI().UHFStopGet();
        this.setWorking(false);
        if (n2 == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("stopInventory() err :" + n2));
        return true;
    }

    @Override
    public String generateLockCode(ArrayList<Integer> arrayList, int n2) {
        if (arrayList != null && arrayList.size() != 0 && n2 >= 0) {
            if (n2 != 16 && n2 != 32 && n2 != 48 && n2 != 64) {
                throw new IllegalArgumentException("lockMode error");
            }
            return com.rscja.deviceapi.b.a(arrayList, n2);
        }
        return null;
    }

    @Override
    public synchronized boolean lockMem(String string, String string2) {
        StringUtility.hexString2Chars(string);
        StringUtility.hexString2Chars(string2);
        boolean bl = this.lockMem(string, 1, 0, 0, "", string2);
        if (bl) {
            return true;
        }
        Log.e((String)TAG, (String)("lockMem() err :" + bl));
        return false;
    }

    @Override
    public boolean lockMem(String object, int n2, int n3, int n4, String object2, String string) {
        if (StringUtility.isEmpty((CharSequence)object)) {
            return false;
        }
        if (StringUtility.isEmpty(string)) {
            return false;
        }
        if (n4 > 0) {
            if (StringUtility.isEmpty((CharSequence)object2)) {
                return false;
            }
            int n5 = n4;
            int n6 = n5 / 8;
            int n7 = n5 % 8 == 0 ? 0 : 1;
            if (((String)object2).replace(" ", "").length() / 2 < (n6 += n7)) {
                return false;
            }
        } else {
            object2 = "00";
        }
        char[] cArray = StringUtility.hexString2Chars((String)object);
        object = StringUtility.hexString2Chars((String)object2);
        object2 = StringUtility.hexString2Chars(string);
        return DeviceAPI.getInstance().UHFLockMemEx(cArray, (char)n2, n3, n4, (char[])object, (char[])object2) == 0;
    }

    @Override
    public synchronized UHFTAGInfo inventorySingleTag() {
        Object object = this.getDeviceAPI().UHFInventorySingleEPCTIDUSER();
        if (object != null && object[0] == '\u0000') {
            UHFTAGInfo uHFTAGInfo;
            int n2 = object[1] << 8 | object[2] + 3;
            Log.i((String)TAG, (String)("data =" + StringUtility.chars2HexString(object, ((char[])object).length)));
            UHFTAGInfo uHFTAGInfo2 = uHFTAGInfo;
            uHFTAGInfo = new UHFTAGInfo();
            int n3 = 4;
            int n4 = object[3] + n3;
            int n5 = n4 + 2;
            int n6 = n5 + (object[n4] << 8 | object[n4 + 1]);
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            if (n6 - n5 > 0) {
                int n11 = n5;
                n5 = this.TidLength * 2;
                char[] cArray = Arrays.copyOfRange(object, n11, n6);
                if (cArray.length > n5) {
                    char[] cArray2 = Arrays.copyOfRange(cArray, n5, cArray.length);
                    uHFTAGInfo2.setUser(StringUtility.chars2HexString(cArray2, cArray2.length));
                }
                uHFTAGInfo2.setTid(StringUtility.chars2HexString(cArray, n5));
                n5 = n6 + 2;
                if (n2 >= n5) {
                    if (n2 >= (n2 = n5 + 1)) {
                        int n12 = n6;
                        n6 = n5;
                        n7 = n12;
                    } else {
                        int n13 = n6;
                        n2 = n10;
                        n6 = n9;
                        n7 = n13;
                    }
                } else {
                    n2 = n10;
                    n6 = n9;
                    n5 = n8;
                }
                UHFTAGInfo uHFTAGInfo3 = uHFTAGInfo2;
                uHFTAGInfo3.setChipInfo(c.a(uHFTAGInfo3.getTid()));
            } else {
                uHFTAGInfo2.setTid("");
                n6 = n5 + 2;
                if (n2 >= n6) {
                    if (n2 >= (n2 = n6 + 1)) {
                        n7 = n5;
                        n5 = n6;
                    } else {
                        n7 = n5;
                        n5 = n6;
                        n2 = n10;
                        n6 = n9;
                    }
                } else {
                    n5 = n8;
                    n2 = n10;
                    n6 = n9;
                }
            }
            char[] cArray = Arrays.copyOfRange(object, n6, n2);
            String string = "";
            if (n5 > 0) {
                char[] cArray3 = Arrays.copyOfRange(object, n7, n5);
                string = StringUtility.chars2HexString(cArray3, cArray3.length);
            }
            object = Arrays.copyOfRange(object, n3, 6);
            char[] cArray4 = Arrays.copyOfRange(object, 6, n4);
            if (n2 > 0) {
                uHFTAGInfo2.setAnt(cArray[0] + "");
            }
            object = StringUtility.chars2HexString(object, ((char[])object).length);
            String string2 = StringUtility.chars2HexString(cArray4, cArray4.length);
            Object object2 = "N/A";
            if (string != null && string.length() > 0) {
                float f2;
                float f3 = (float)(65535 - Integer.parseInt(string, 16)) / 10.0f;
                if (f2 < 200.0f && f3 > 0.0f) {
                    DecimalFormat decimalFormat;
                    object2 = decimalFormat;
                    decimalFormat = new DecimalFormat("##0.00");
                    object2 = "-" + ((NumberFormat)object2).format(f3);
                }
            }
            uHFTAGInfo2.setEpcBytes(StringUtility.charsTobytes(cArray4, cArray4.length));
            uHFTAGInfo2.setRssi((String)object2);
            uHFTAGInfo2.setPc((String)object);
            uHFTAGInfo2.setEPC(string2);
            if (this.isContainReserved) {
                UHFTAGInfo uHFTAGInfo4 = uHFTAGInfo2;
                uHFTAGInfo4.setReserved(uHFTAGInfo4.getUser());
                uHFTAGInfo4.setUser(uHFTAGInfo4.getTid());
                uHFTAGInfo4.setTid(null);
            }
            return uHFTAGInfo2;
        }
        return null;
    }

    @Override
    public String readData(String string, int n2, int n3, int n4) {
        if (!StringUtility.isEmpty(string) && StringUtility.isHexNumberRex(string)) {
            return this.readData(string, 1, 0, 0, "00", n2, n3, n4);
        }
        return null;
    }

    @Override
    public String readData(String string, int n2, int n3, int n4, String string2, int n5, int n6, int n7) {
        if (!StringUtility.isEmpty(string) && StringUtility.isHexNumberRex(string)) {
            if (!StringUtility.isEmpty(string2) && StringUtility.isHexNumberRex(string2)) {
                if (n4 > 0) {
                    if (StringUtility.isEmpty(string2)) {
                        return null;
                    }
                    int n8 = n4;
                    int n9 = n8 / 8;
                    int n10 = n8 % 8 == 0 ? 0 : 1;
                    if (string2.replace(" ", "").length() / 2 < (n9 += n10)) {
                        return null;
                    }
                } else {
                    string2 = "00";
                    n4 = 0;
                }
                G g2 = object;
                Object object = StringUtility.hexString2Chars(string);
                char c2 = (char)n2;
                char[] cArray = StringUtility.hexString2Chars(string2);
                char c3 = (char)n5;
                char[] cArray2 = g2.getDeviceAPI().UHFReadData_Ex2((char[])object, c2, n3, n4, cArray, c3, n6, n7);
                object = cArray2;
                if (cArray2[0] != '\u0000') {
                    Log.e((String)TAG, (String)("readData() err :" + (int)object[0]));
                    return null;
                }
                Object object2 = object;
                char[] cArray3 = Arrays.copyOfRange((char[])object2, 2, (int)(object2[1] + 2));
                return StringUtility.chars2HexString(cArray3, cArray3.length);
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean writeData(String string, int n2, int n3, int n4, String string2) {
        if (!StringUtility.isEmpty(string) && !StringUtility.isEmpty(string2)) {
            return this.writeData(string, 1, 32, 0, "00", n2, n3, n4, string2);
        }
        return false;
    }

    @Override
    public boolean writeData(String string, int n2, int n3, int n4, String string2, int n5, int n6, int n7, String string3) {
        if (!StringUtility.isEmpty(string) && StringUtility.isHexNumberRex(string)) {
            if (!StringUtility.isEmpty(string3) && StringUtility.isHexNumberRex(string3)) {
                if (n4 > 0) {
                    if (StringUtility.isEmpty(string2)) {
                        return false;
                    }
                    int n8 = n4;
                    int n9 = n8 / 8;
                    int n10 = n8 % 8 == 0 ? 0 : 1;
                    if (string2.replace(" ", "").length() / 2 < (n9 += n10)) {
                        return false;
                    }
                } else {
                    string2 = "00";
                    n4 = 0;
                }
                G g2 = object;
                Object object = StringUtility.hexString2Chars(string);
                char c2 = (char)n2;
                char[] cArray = StringUtility.hexString2Chars(string2);
                char c3 = (char)n5;
                n5 = (char)n7;
                char[] cArray2 = StringUtility.hexString2Chars(string3);
                return g2.getDeviceAPI().UHFWriteData_Ex2((char[])object, c2, n3, n4, cArray, c3, n6, n5, cArray2) == 0;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean blockWriteData(String string, int n2, int n3, int n4, String string2, int n5, int n6, int n7, String string3) {
        if (!StringUtility.isEmpty(string) && StringUtility.isHexNumberRex(string)) {
            if (!StringUtility.isEmpty(string3) && StringUtility.isHexNumberRex(string3)) {
                if (n4 > 0) {
                    if (StringUtility.isEmpty(string2)) {
                        return false;
                    }
                    int n8 = n4;
                    int n9 = n8 / 8;
                    int n10 = n8 % 8 == 0 ? 0 : 1;
                    if (string2.replace(" ", "").length() / 2 < (n9 += n10)) {
                        return false;
                    }
                } else {
                    string2 = "00";
                    n4 = 0;
                }
                G g2 = object;
                Object object = StringUtility.hexString2Chars(string);
                char c2 = (char)n2;
                char[] cArray = StringUtility.hexString2Chars(string2);
                char c3 = (char)n5;
                char[] cArray2 = StringUtility.hexString2Chars(string3);
                return g2.getDeviceAPI().UHFBlockWriteData((char[])object, c2, n3, n4, cArray, c3, n6, n7, cArray2) == 0;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean eraseData(String string, int n2, int n3, int n4, String string2, int n5, int n6, int n7) {
        if (!StringUtility.isEmpty(string) && StringUtility.isHexNumberRex(string)) {
            if (!StringUtility.isEmpty(string2) && StringUtility.isHexNumberRex(string2)) {
                if (n4 > 0) {
                    if (StringUtility.isEmpty(string2)) {
                        return false;
                    }
                    int n8 = n4;
                    int n9 = n8 / 8;
                    int n10 = n8 % 8 == 0 ? 0 : 1;
                    if (string2.replace(" ", "").length() / 2 < (n9 += n10)) {
                        return false;
                    }
                } else {
                    string2 = "00";
                    n4 = 0;
                }
                G g2 = object;
                Object object = StringUtility.hexString2Chars(string);
                char c2 = (char)n2;
                n2 = (char)n4;
                char[] cArray = StringUtility.hexString2Chars(string2);
                char c3 = (char)n5;
                int n11 = g2.getDeviceAPI().UHFEraseDataEx((char[])object, c2, n3, (char)n2, cArray, c3, n6, n7);
                if (n11 == 0) {
                    return true;
                }
                Log.e((String)TAG, (String)("eraseData() err :" + n11));
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean setFilter(int n2, int n3, int n4, String string) {
        if (n4 >= 0 && n3 >= 0) {
            if (n4 > 0) {
                if (StringUtility.isEmpty(string)) {
                    return false;
                }
                int n5 = n4;
                int n6 = n5 / 8;
                int n7 = n5 % 8 == 0 ? 0 : 1;
                if (string.replace(" ", "").length() / 2 < (n6 += n7)) {
                    return false;
                }
            } else {
                string = "00";
            }
            G g2 = object;
            Object object = StringUtility.hexString2Chars(string);
            int n8 = n2;
            n2 = (char)0;
            int n9 = g2.getDeviceAPI().UHFSetFilter_Ex((char)n2, (char)n8, n3, n4, (char[])object);
            if (n9 == 0) {
                return true;
            }
            Log.e((String)TAG, (String)("setFilter() err :" + n9));
            return false;
        }
        return false;
    }

    @Override
    public synchronized boolean killTag(String string) {
        if (StringUtility.isEmpty(string)) {
            return false;
        }
        return this.killTag(string, 1, 0, 0, "00");
    }

    @Override
    public boolean killTag(String object, int n2, int n3, int n4, String string) {
        if (StringUtility.isEmpty((CharSequence)object)) {
            return false;
        }
        if (n4 > 0) {
            if (StringUtility.isEmpty(string)) {
                return false;
            }
            int n5 = n4;
            int n6 = n5 / 8;
            int n7 = n5 % 8 == 0 ? 0 : 1;
            if (string.replace(" ", "").length() / 2 < (n6 += n7)) {
                return false;
            }
        } else {
            string = "00";
        }
        char[] cArray = StringUtility.hexString2Chars((String)object);
        object = StringUtility.hexString2Chars(string);
        char c2 = (char)n2;
        n2 = (char)n4;
        return DeviceAPI.getInstance().UHFKillTagEx(cArray, c2, n3, (char)n2, (char[])object) == 0;
    }

    @Override
    public synchronized boolean setProtocol(int n2) {
        int n3 = this.getDeviceAPI().UHFSetProtocolType(n2);
        if (n3 == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setProtocol() err :" + n3));
        return false;
    }

    @Override
    public synchronized int getProtocol() {
        char[] cArray = ((G)object).getDeviceAPI().UHFGetProtocolType();
        Object object = cArray;
        if (cArray[0] == '\u0000') {
            return (int)object[2];
        }
        return -1;
    }

    @Override
    public synchronized boolean setFreHop(float f2) {
        int n2 = (int)(f2 * 1000.0f);
        n2 = this.getDeviceAPI().R2000_FreHopSet(n2);
        if (n2 == 0) {
            return true;
        }
        G g2 = this;
        Log.e((String)TAG, (String)("setFreHop() err :" + n2));
        g2.isContainReserved = false;
        g2.TidLength = 6;
        return false;
    }

    @Override
    public synchronized boolean setRFLink(int n2) {
        int n3 = this.getDeviceAPI().UHFSetRFLink((char)n2);
        if (n3 == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setRFLink() err :" + n3));
        return false;
    }

    @Override
    public synchronized int getRFLink() {
        byte[] byArray = ((G)object).getDeviceAPI().UHFGetRFLink();
        Object object = byArray;
        if (byArray != null && object[0] == false) {
            if (((Object)object).length > 1) {
                return (int)object[1];
            }
            return -1;
        }
        Log.e((String)TAG, (String)("getRFLink() err :" + (int)object[0]));
        return -1;
    }

    @Override
    public synchronized boolean setFastID(boolean bl) {
        int n2 = this.getDeviceAPI().UHFSetFastID((char)(bl ? 1 : 0));
        if (n2 == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFastID() err :" + n2));
        return false;
    }

    @Override
    public synchronized boolean setTagFocus(boolean bl) {
        int n2 = this.getDeviceAPI().UHFSetTagFocus((char)(bl ? 1 : 0));
        if (n2 == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setTagFocus() err :" + n2));
        return false;
    }

    @Override
    public synchronized boolean setEPCMode() {
        int n2 = this.getDeviceAPI().UHFSetEPCUserMode('\u0000', 0, 0, 0);
        if (n2 == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setEPCUSERMode() err :" + n2));
        return false;
    }

    @Override
    public boolean setEPCAndTIDMode() {
        int n2 = this.getDeviceAPI().UHFSetEPCUserMode('\u0001', 0, 0, 0);
        if (n2 == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setEPCAndTIDMode() err :" + n2));
        return false;
    }

    @Override
    public synchronized boolean setEPCAndTIDUserMode(int n2, int n3) {
        int n4 = this.getDeviceAPI().UHFSetEPCUserMode('\u0002', n2, n3, 0);
        if (n4 == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setEPCAndTIDUserMode() err :" + n4));
        return false;
    }

    public boolean setEPCAndTIDUserModeEx(int n2, int n3, int n4, int n5, int n6) {
        int n7 = n6;
        int n8 = n5;
        n2 = (char)n2;
        n3 = (char)n3;
        n5 = (char)n4;
        n6 = (char)n8;
        char c2 = (char)n7;
        n2 = this.getDeviceAPI().UHFSetEPCTIDUSERAddrLength((char)n2, (char)n3, (char)n5, (char)n6, c2);
        if (n2 == 0) {
            this.TidLength = n4;
            return true;
        }
        Log.e((String)TAG, (String)("setEPCAndTIDUserMode() err :" + n2));
        return false;
    }

    public int getEPCAndTIDUserModeEx(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        char[] cArray = ((G)object).getDeviceAPI().UHFGetEPCTIDUSERAddrLength();
        Object object = cArray;
        if (cArray != null && object[0] == false) {
            Object object2 = object[2];
            if (object2 == true) {
                if (nArray != null && nArray.length > 0) {
                    nArray[0] = (int)object[3];
                }
                if (nArray2 != null && nArray2.length > 0) {
                    nArray2[0] = (int)object[4];
                }
            } else if (object2 == 2) {
                if (nArray != null && nArray.length > 0) {
                    nArray[0] = (int)object[3];
                }
                if (nArray2 != null && nArray2.length > 0) {
                    nArray2[0] = (int)object[4];
                }
                if (nArray3 != null && nArray3.length > 0) {
                    nArray3[0] = (int)object[5];
                }
                if (nArray4 != null && nArray4.length > 0) {
                    nArray4[0] = (int)object[6];
                }
            }
            return (int)object2;
        }
        return -1;
    }

    @Override
    public boolean setEPCAndUserReservedModeEx(int n2, int n3, int n4, int n5, int n6) {
        int n7 = n4;
        int n8 = n3;
        n3 = (char)n2;
        n4 = (char)n5;
        n5 = (char)n6;
        char c2 = (char)n8;
        char c3 = (char)n7;
        n3 = this.getDeviceAPI().UHFSetEPCTIDUSERAddrLength((char)n3, (char)n4, (char)n5, c2, c3);
        if (n3 == 0) {
            if (n2 == 3) {
                G g2 = this;
                g2.TidLength = n6;
                g2.isContainReserved = true;
            } else {
                G g3 = this;
                g3.TidLength = 6;
                g3.isContainReserved = false;
            }
            return true;
        }
        Log.e((String)TAG, (String)("setEPCAndUserReservedModeEx() err :" + n3));
        return false;
    }

    @Override
    public synchronized int getTemperature() {
        char[] cArray = ((G)object).getDeviceAPI().GetTemperature();
        Object object = cArray;
        if (cArray != null && object[0] == false) {
            if (object[1] >= 240) {
                return -((65535 - Integer.valueOf(StringUtility.chars2HexString(new char[]{(char)object[1], (char)object[2]}, 2), 16)) / 100);
            }
            return Integer.valueOf(StringUtility.chars2HexString(new char[]{(char)object[1], (char)object[2]}, 2), 16) / 100;
        }
        return -1;
    }

    @Override
    public boolean uhfBlockPermalock(String string, int n2, int n3, int n4, String string2, int n5, int n6, int n7, int n8, byte[] byArray) {
        char[] cArray = StringUtility.hexString2Chars(string);
        char[] cArray2 = StringUtility.hexString2Chars(string2);
        if (this.DEBUG) {
            Log.i((String)TAG, (String)("accessPwd=" + string + " FilterBank=" + n2 + " FilterStartaddr=" + n3 + " FilterLen=" + n4 + " FilterData=" + string2 + " ReadLock=" + n5 + " uBank=" + n6 + " uPtr=" + n7 + " uMaskbuf=" + StringUtility.bytesHexString(byArray)));
        }
        char c2 = (char)n2;
        char c3 = (char)n5;
        n2 = (char)n6;
        char c4 = (char)n8;
        char[] cArray3 = this.getDeviceAPI().UHFBlockPermalock_Ex(cArray, c2, n3, n4, cArray2, c3, (char)n2, n7, c4, byArray);
        if (cArray3[0] == '\u0000') {
            if (n5 == 0) {
                char[] cArray4 = Arrays.copyOfRange(cArray3, 2, cArray3[1] + 2);
                byArray[0] = (byte)cArray4[0];
                byArray[1] = (byte)cArray4[1];
            }
            return true;
        }
        return false;
    }

    public boolean setGen2(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        if (this.DEBUG) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2;
            StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder;
            StringBuilder stringBuilder4 = stringBuilder2;
            StringBuilder stringBuilder5 = stringBuilder2;
            StringBuilder stringBuilder6 = stringBuilder2;
            StringBuilder stringBuilder7 = stringBuilder2;
            StringBuilder stringBuilder8 = stringBuilder2;
            StringBuilder stringBuilder9 = stringBuilder2;
            StringBuilder stringBuilder10 = stringBuilder2;
            StringBuilder stringBuilder11 = stringBuilder2;
            StringBuilder stringBuilder12 = stringBuilder2;
            StringBuilder stringBuilder13 = stringBuilder2;
            StringBuilder stringBuilder14 = stringBuilder2;
            StringBuilder stringBuilder15 = stringBuilder2;
            StringBuilder stringBuilder16 = stringBuilder2;
            stringBuilder16();
            stringBuilder16.append("target=");
            stringBuilder15.append(String.valueOf(n2));
            stringBuilder15.append(",action=");
            stringBuilder14.append(String.valueOf(n3));
            stringBuilder14.append(",t=");
            stringBuilder13.append(String.valueOf(n4));
            stringBuilder13.append(",q=");
            stringBuilder12.append(String.valueOf(n5));
            stringBuilder12.append(",startQ=");
            stringBuilder11.append(String.valueOf(n6));
            stringBuilder11.append(",minQ=");
            stringBuilder10.append(String.valueOf(n7));
            stringBuilder10.append(",maxQ=");
            stringBuilder9.append(String.valueOf(n8));
            stringBuilder9.append(",dr=");
            stringBuilder8.append(String.valueOf(n9));
            stringBuilder8.append(",coding=");
            stringBuilder7.append(String.valueOf(n10));
            stringBuilder7.append(", p=");
            stringBuilder6.append(String.valueOf(n11));
            stringBuilder6.append(",Sel=");
            stringBuilder5.append(String.valueOf(n12));
            stringBuilder5.append(",Session=");
            stringBuilder4.append(String.valueOf(n13));
            stringBuilder4.append(",g=");
            stringBuilder3.append(String.valueOf(n14));
            stringBuilder3.append(",linkFrequency=");
            stringBuilder.append(String.valueOf(n15));
            Log.i((String)TAG, (String)stringBuilder2.toString());
        }
        char c2 = (char)n2;
        n2 = (char)n3;
        n3 = (char)n4;
        n4 = (char)n5;
        n5 = (char)n6;
        n6 = (char)n7;
        n7 = (char)n8;
        n8 = (char)n9;
        n9 = (char)n10;
        n10 = (char)n11;
        n11 = (char)n12;
        n12 = (char)n13;
        n13 = (char)n14;
        n14 = (char)n15;
        return this.getDeviceAPI().SetGen2(c2, (char)n2, (char)n3, (char)n4, (char)n5, (char)n6, (char)n7, (char)n8, (char)n9, (char)n10, (char)n11, (char)n12, (char)n13, (char)n14) == 0;
    }

    @Override
    public boolean setGen2(Gen2Entity gen2Entity) {
        Gen2Entity gen2Entity2 = gen2Entity;
        int c2 = gen2Entity2.getSelectTarget();
        int n2 = gen2Entity2.getSelectAction();
        int n3 = gen2Entity2.getSelectTruncate();
        int n4 = gen2Entity2.getQ();
        int n5 = gen2Entity2.getStartQ();
        int n6 = gen2Entity2.getMinQ();
        int n7 = gen2Entity2.getMaxQ();
        int n8 = gen2Entity2.getQueryDR();
        int n9 = gen2Entity2.getQueryM();
        int n10 = gen2Entity2.getQueryTRext();
        int n11 = gen2Entity2.getQuerySel();
        int n12 = gen2Entity2.getQuerySession();
        int n13 = gen2Entity2.getQueryTarget();
        int n14 = gen2Entity2.getLinkFrequency();
        if (this.DEBUG) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2;
            StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder;
            StringBuilder stringBuilder4 = stringBuilder2;
            StringBuilder stringBuilder5 = stringBuilder2;
            StringBuilder stringBuilder6 = stringBuilder2;
            StringBuilder stringBuilder7 = stringBuilder2;
            StringBuilder stringBuilder8 = stringBuilder2;
            StringBuilder stringBuilder9 = stringBuilder2;
            StringBuilder stringBuilder10 = stringBuilder2;
            StringBuilder stringBuilder11 = stringBuilder2;
            StringBuilder stringBuilder12 = stringBuilder2;
            StringBuilder stringBuilder13 = stringBuilder2;
            StringBuilder stringBuilder14 = stringBuilder2;
            StringBuilder stringBuilder15 = stringBuilder2;
            StringBuilder stringBuilder16 = stringBuilder2;
            stringBuilder16();
            stringBuilder16.append("target=");
            stringBuilder15.append(String.valueOf(c2));
            stringBuilder15.append(",action=");
            stringBuilder14.append(String.valueOf(n2));
            stringBuilder14.append(",t=");
            stringBuilder13.append(String.valueOf(n3));
            stringBuilder13.append(",q=");
            stringBuilder12.append(String.valueOf(n4));
            stringBuilder12.append(",startQ=");
            stringBuilder11.append(String.valueOf(n5));
            stringBuilder11.append(",minQ=");
            stringBuilder10.append(String.valueOf(n6));
            stringBuilder10.append(",maxQ=");
            stringBuilder9.append(String.valueOf(n7));
            stringBuilder9.append(",dr=");
            stringBuilder8.append(String.valueOf(n8));
            stringBuilder8.append(",coding=");
            stringBuilder7.append(String.valueOf(n9));
            stringBuilder7.append(", p=");
            stringBuilder6.append(String.valueOf(n10));
            stringBuilder6.append(",Sel=");
            stringBuilder5.append(String.valueOf(n11));
            stringBuilder5.append(",Session=");
            stringBuilder4.append(String.valueOf(n12));
            stringBuilder4.append(",g=");
            stringBuilder3.append(String.valueOf(n13));
            stringBuilder3.append(",linkFrequency=");
            stringBuilder.append(String.valueOf(n14));
            Log.i((String)TAG, (String)stringBuilder2.toString());
        }
        char c15 = (char)c2;
        char c3 = (char)n2;
        char c4 = (char)n3;
        char c5 = (char)n4;
        char c6 = (char)n5;
        char c7 = (char)n6;
        char c8 = (char)n7;
        char c9 = (char)n8;
        char c10 = (char)n9;
        char c11 = (char)n10;
        char c12 = (char)n11;
        char c13 = (char)n12;
        char c14 = (char)n13;
        char c16 = (char)n14;
        return this.getDeviceAPI().SetGen2(c15, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c16) == 0;
    }

    @Override
    public Gen2Entity getGen2() {
        Object object;
        if (((G)object18).DEBUG) {
            Log.i((String)TAG, (String)"GetGen2()=========");
        }
        if ((object = ((G)object18).getDeviceAPI().GetGen2())[0] == '\u0000') {
            Gen2Entity gen2Entity;
            if (((G)object18).DEBUG) {
                StringBuilder stringBuilder;
                Object object2 = object18 = stringBuilder;
                Object object3 = object18;
                Object object4 = object18;
                Object object5 = object18;
                Object object6 = object18;
                Object object7 = object18;
                Object object8 = object18;
                Object object9 = object18;
                Object object10 = object18;
                Object object11 = object18;
                Object object12 = object18;
                Object object13 = object18;
                Object object14 = object18;
                Object object15 = object18;
                Object object16 = object18;
                Object object17 = object18;
                ((StringBuilder)object17)();
                ((StringBuilder)object17).append("result data[0]=");
                ((StringBuilder)object16).append(String.valueOf((int)object[0]));
                ((StringBuilder)object16).append("leng data[1]=");
                ((StringBuilder)object15).append(String.valueOf((int)object[1]));
                ((StringBuilder)object15).append("target data[2]=");
                ((StringBuilder)object14).append(String.valueOf((int)object[2]));
                ((StringBuilder)object14).append(",action data[3]=");
                ((StringBuilder)object13).append(String.valueOf((int)object[3]));
                ((StringBuilder)object13).append(",t data[4]=");
                ((StringBuilder)object12).append(String.valueOf((int)object[4]));
                ((StringBuilder)object12).append(",q data[5]=");
                ((StringBuilder)object11).append(String.valueOf((int)object[5]));
                ((StringBuilder)object11).append(",startQ data[6]=");
                ((StringBuilder)object10).append(String.valueOf((int)object[6]));
                ((StringBuilder)object10).append(",minQ data[7]=");
                ((StringBuilder)object9).append(String.valueOf((int)object[7]));
                ((StringBuilder)object9).append(",maxQ data[8]=");
                ((StringBuilder)object8).append(String.valueOf((int)object[8]));
                ((StringBuilder)object8).append(",dr data[9]=");
                ((StringBuilder)object7).append(String.valueOf((int)object[9]));
                ((StringBuilder)object7).append(",coding data[10]=");
                ((StringBuilder)object6).append(String.valueOf((int)object[10]));
                ((StringBuilder)object6).append(", p data[11]=");
                ((StringBuilder)object5).append(String.valueOf((int)object[11]));
                ((StringBuilder)object5).append(",Sel data[12]=");
                ((StringBuilder)object4).append(String.valueOf((int)object[12]));
                ((StringBuilder)object4).append(",Session data[13]=");
                ((StringBuilder)object3).append(String.valueOf((int)object[13]));
                ((StringBuilder)object3).append(",g data[14]=");
                ((StringBuilder)object2).append(String.valueOf((int)object[14]));
                ((StringBuilder)object2).append(",linkFrequency data[15]=");
                stringBuilder.append(String.valueOf((int)object[15]));
                Log.i((String)TAG, (String)((StringBuilder)object18).toString());
            }
            Object object18 = Arrays.copyOfRange((char[])object, 2, object[1] + 2);
            object = gen2Entity;
            ((Gen2Entity)object)();
            ((Gen2Entity)object).setSelectTarget((int)object18[0]);
            ((Gen2Entity)object).setSelectAction((int)object18[1]);
            ((Gen2Entity)object).setSelectTruncate((int)object18[2]);
            ((Gen2Entity)object).setQ((int)object18[3]);
            ((Gen2Entity)object).setStartQ((int)object18[4]);
            ((Gen2Entity)object).setMinQ((int)object18[5]);
            ((Gen2Entity)object).setMaxQ((int)object18[6]);
            ((Gen2Entity)object).setQueryDR((int)object18[7]);
            ((Gen2Entity)object).setQueryM((int)object18[8]);
            ((Gen2Entity)object).setQueryTRext((int)object18[9]);
            ((Gen2Entity)object).setQuerySel((int)object18[10]);
            ((Gen2Entity)object).setQuerySession((int)object18[11]);
            ((Gen2Entity)object).setQueryTarget((int)object18[12]);
            gen2Entity.setLinkFrequency((int)object18[13]);
            return gen2Entity;
        }
        if (((G)object18).DEBUG) {
            Log.i((String)TAG, (String)("error=" + object[0]));
        }
        return null;
    }

    @Override
    public synchronized boolean uhfJump2Boot() {
        this.type = 1;
        return DeviceAPI.getInstance().UHFJump2Boot() == 0;
    }

    @Override
    public boolean uhfJump2Boot(int n2) {
        this.type = n2;
        return DeviceAPI.getInstance().UHFToBoot(n2) == 0;
    }

    @Override
    public synchronized boolean uhfStartUpdate() {
        return DeviceAPI.getInstance().UHFStartUpdate() == 0;
    }

    @Override
    public synchronized boolean uhfUpdating(byte[] byArray) {
        G g2 = object;
        Object object = new byte[64];
        if (g2.type == 3) {
            object = byArray;
        } else if (byArray.length < 64) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                object[i2] = byArray[i2];
            }
        } else {
            for (int i3 = 0; i3 < 64; ++i3) {
                object[i3] = byArray[i3];
            }
        }
        Log.e((String)TAG, (String)("uhfUpdating() data.length :" + ((Object)object).length));
        Object object2 = object;
        return DeviceAPI.getInstance().UHFUpdating((byte[])object2, ((Object)object2).length) == 0;
    }

    @Override
    public synchronized boolean uhfStopUpdate() {
        return DeviceAPI.getInstance().UHFStopUpdate() == 0;
    }

    @Override
    public synchronized int getCW() {
        char[] cArray = ((G)object).getDeviceAPI().UHFGetCW();
        Object object = cArray;
        if (cArray[0] == '\u0000') {
            return (int)object[1];
        }
        return -1;
    }

    @Override
    public boolean setCW(int n2) {
        return this.getDeviceAPI().UHFSetCW((char)n2) == 0;
    }

    @Override
    public InventoryModeEntity getEPCAndTIDUserMode() {
        char[] cArray = ((G)object).getDeviceAPI().UHFGetEPCTIDUSERMode();
        Object object = cArray;
        if (cArray != null && object[0] == false) {
            InventoryModeEntity.b b2;
            InventoryModeEntity.b b3 = b2;
            b3();
            b2.a((int)object[2]);
            if (object[2] == 2) {
                b3.c((int)object[3]);
                b3.b((int)object[4]);
            }
            return b3.a();
        }
        return null;
    }

    @Override
    public boolean eraseData(String string, int n2, int n3, int n4) {
        return this.eraseData(string, 1, 0, 0, "00", n2, n3, n4);
    }

    @Override
    public void setConnectionStatusCallback(ConnectionStatusCallback<Object> connectionStatusCallback) {
        this.btStatusCallback = connectionStatusCallback;
    }

    @Override
    public ConnectionStatus getConnectStatus() {
        return this.connectionStatus;
    }

    @Override
    public boolean isInventorying() {
        return this.isWorking;
    }

    @Override
    public int getErrCode() {
        return this.getDeviceAPI().GetLastError();
    }

    @Override
    public synchronized boolean startLocation(Context context, String object, int n2, int n3, IUHFLocationCallback iUHFLocationCallback) {
        if (this.isInventorying()) {
            Log.e((String)TAG, (String)"inventoryTag() already start!");
            return false;
        }
        if (!this.isPowerOn()) {
            return false;
        }
        if (context != null) {
            if (!TextUtils.isEmpty((CharSequence)object)) {
                if (object.length() % 2 == 1) {
                    object = object + "0";
                }
                if (!this.setFilter(n2, n3, object.length() * 4, (String)object)) {
                    Log.e((String)TAG, (String)"setFilter() fail!");
                    return false;
                }
                this.isLocation = true;
                this.locationCallback = iUHFLocationCallback;
                if (this.startInventoryTag()) {
                    if (this.handler == null) {
                        b b2;
                        object = b2;
                        b2 = new b(context);
                        this.handler = object;
                    }
                    return true;
                }
                this.isLocation = false;
                return false;
            }
            throw new IllegalArgumentException("label is null!");
        }
        throw new IllegalArgumentException("context is null!");
    }

    @Override
    public boolean startRadarLocation(Context context, String string, int n2, int n3, IUHFRadarLocationCallback iUHFRadarLocationCallback) {
        W w2;
        W w3;
        this.stopInventoryThread();
        W w4 = w3 = w2;
        w4(context, this);
        this.uhfRadarLocation_qcom = w4;
        return w2.a(string, n2, n3, iUHFRadarLocationCallback);
    }

    @Override
    public boolean stopRadarLocation() {
        W w2 = ((G)((Object)w2)).uhfRadarLocation_qcom;
        if (w2 != null) {
            w2.a();
        }
        return true;
    }

    @Override
    public boolean setDynamicDistance(int n2) {
        return this.getDeviceAPI().UHFSetPowerOnDynamic((char)n2) == 0;
    }

    @Override
    public ITagLocate getTagLocate(Context context) {
        if (this.tagLocate_qcom == null) {
            M m2;
            M m3 = m2;
            m2 = new M(context, this);
            this.tagLocate_qcom = m3;
        }
        return this.tagLocate_qcom;
    }

    @Override
    public synchronized boolean stopLocation() {
        if (this.isInventorying()) {
            G g2 = this;
            g2.setWorking(false);
            g2.stopInventory();
        } else {
            Log.e((String)TAG, (String)"startLocation() net start!");
        }
        SystemClock.sleep((long)100L);
        this.setFilter(1, 32, 0, "00");
        this.idleTime = SystemClock.elapsedRealtime() + 100000L;
        this.isLocation = false;
        return true;
    }

    @Override
    public boolean isPowerOn() {
        return this.powerOn;
    }

    protected void setPowerOn(boolean bl) {
        Log.d((String)TAG, (String)("----------setPowerOn on=" + bl));
        this.powerOn = bl;
    }

    @Override
    public void setInventoryCallback(IUHFInventoryCallback iUHFInventoryCallback) {
        this.inventoryCallback = iUHFInventoryCallback;
    }

    @Override
    public boolean writeDataToEpc(String string, int n2, int n3, int n4, String string2, String string3) {
        if (string3 != null && string3.length() != 0 && string3.length() % 4 == 0) {
            G g2 = object;
            Object object = StringUtility.byte2HexString((byte)(string3.length() / 2 / 2 << 3));
            object = (String)object + "00" + string3;
            int n5 = ((String)object).length() / 2 / 2;
            return g2.writeData(string, n2, n3, n4, string2, 1, 1, n5, (String)object);
        }
        throw new IllegalArgumentException("Write data of the length of the string must be in multiples of four!");
    }

    @Override
    public boolean writeDataToEpc(String string, String string2) {
        return this.writeDataToEpc(string, 0, 0, 0, "00", string2);
    }

    public byte[] UHFVerifyVoltage() {
        return this.getDeviceAPI().UHFVerifyVoltage();
    }

    @Override
    public boolean setFastInventoryMode(boolean bl) {
        return DeviceAPI.getInstance().UHFSetFastInventoryMode(bl ? 1 : 0) == 0;
    }

    @Override
    public int getFastInventoryMode() {
        return DeviceAPI.getInstance().UHFGetFastInventoryMode();
    }

    class a
    extends Thread {
        boolean a = false;
        Object b;

        a() {
            Object object;
            Object object2 = object;
            object = new Object();
            v1.b = object2;
        }

        private String a() {
            float f2;
            int n2;
            for (n2 = 0; n2 < ((a)object).G.this.uhfdata.length; ++n2) {
                ((G)((a)object).G.this).uhfdata[n2] = 0;
            }
            if (((a)object).G.this.getDeviceAPI().UHFGetReceived_EX2(((a)object).G.this.uhfdata) <= 0) {
                return null;
            }
            n2 = ((a)object).G.this.uhfdata[0] + 1;
            int n3 = n2 + 2;
            if ((n2 = n3 + (((a)object).G.this.uhfdata[n2] << 8 | ((a)object).G.this.uhfdata[n2 + 1])) - n3 > 0) {
                n3 = n2 + 2;
            } else {
                n2 = n3 + 2;
                int n4 = n3;
                n3 = n2;
                n2 = n4;
            }
            byte[] byArray = Arrays.copyOfRange(((a)object).G.this.uhfdata, n2, n3);
            Object object = byArray;
            float f3 = (float)(65535 - ((byArray[0] & 0xFF) << 8 | object[1] & 0xFF)) / 10.0f;
            if (f2 < 100.0f && f3 > 0.0f) {
                return "-" + com.rscja.utility.b.a(2, f3);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void b() {
            this.a = true;
            Object object = this.b;
            synchronized (object) {
                this.b.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Log.d((String)TAG, (String)"start InventoryThread!");
            G.access$502(G.this, SystemClock.elapsedRealtime());
            while (true) {
                if (this.a) {
                    Log.d((String)TAG, (String)"end InventoryThread!");
                    return;
                }
                if (G.this.isLocation) {
                    String string = this.a();
                    if (string != null) {
                        float f2 = com.rscja.utility.b.a(2, Float.parseFloat(string));
                        G.this.handler.sendMessage(G.this.handler.obtainMessage(0, Float.valueOf(f2)));
                        continue;
                    }
                    SystemClock.sleep((long)10L);
                    continue;
                }
                a a2 = this;
                Object object = a2.G.this.readTagFromBuffer();
                if (!a2.G.this.isInventorying() && SystemClock.elapsedRealtime() - G.this.idleTime > 2000L) {
                    object = this.b;
                    a a3 = this;
                    // MONITORENTER : object
                    {
                        catch (InterruptedException interruptedException) {}
                    }
                    a3.b.wait(100L);
                    // MONITOREXIT : object
                    continue;
                }
                if (object != null && !TextUtils.isEmpty((CharSequence)((UHFTAGInfo)object).getEPC())) {
                    a a4 = this;
                    G.access$502(a4.G.this, SystemClock.elapsedRealtime());
                    if (a4.G.this.inventoryCallback == null) continue;
                    G.this.inventoryCallback.callback((UHFTAGInfo)object);
                    continue;
                }
                SystemClock.sleep((long)10L);
            }
        }
    }

    private class b
    extends Handler {
        public b(Context context) {
            super(context.getMainLooper());
        }

        private int a(float f2) {
            float f3;
            float f4 = com.rscja.utility.b.a(2, (f2 + 100.0f - 20.0f) * 2.0f);
            if (f3 > 100.0f) {
                f4 = 100.0f;
            } else if (f4 < 1.0f) {
                f4 = 1.0f;
            }
            return (int)f4;
        }

        public void handleMessage(Message message) {
            int n2 = message.what;
            if (n2 == 0) {
                b b2 = this;
                b2.G.this.handler.removeMessages(1);
                G.access$102(b2.G.this, this.a(((Float)message.obj).floatValue()));
                if (b2.G.this.locationCallback != null) {
                    G.this.locationCallback.getLocationValue(G.this.lastValue, true);
                }
                G.this.handler.sendEmptyMessageDelayed(1, 1000L);
            } else if (n2 == 1) {
                b b3 = this;
                G g2 = b3.G.this;
                G.access$102(g2, g2.lastValue - 20);
                if (b3.G.this.locationCallback != null) {
                    G.this.locationCallback.getLocationValue(G.this.lastValue, false);
                }
                if (G.this.lastValue > 0) {
                    G.this.handler.sendEmptyMessageDelayed(1, 20L);
                }
            }
        }
    }
}

