/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.team.qcom.deviceapi;

import android.content.Context;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import com.rscja.deviceapi.UhfBase;
import com.rscja.deviceapi.entity.AntennaConnectState;
import com.rscja.deviceapi.entity.AntennaPowerEntity;
import com.rscja.deviceapi.entity.AntennaState;
import com.rscja.deviceapi.entity.Gen2Entity;
import com.rscja.deviceapi.entity.InventoryModeEntity;
import com.rscja.deviceapi.entity.ReaderIPEntity;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.enums.AntennaEnum;
import com.rscja.deviceapi.interfaces.ConnectionStatus;
import com.rscja.deviceapi.interfaces.ConnectionStatusCallback;
import com.rscja.deviceapi.interfaces.IConnectionStatusChangedListener;
import com.rscja.deviceapi.interfaces.IRFIDWithUHFUrxNetwork;
import com.rscja.deviceapi.interfaces.IUHFInventoryCallback;
import com.rscja.team.qcom.DeviceConfiguration_qcom;
import com.rscja.team.qcom.deviceapi.S;
import com.rscja.team.qcom.f.b;
import com.rscja.team.qcom.socket.SocketManageUR4;
import com.rscja.team.qcom.utility.LogUtility_qcom;
import com.rscja.utility.StringUtility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class I
extends UhfBase
implements IRFIDWithUHFUrxNetwork,
Observer {
    private static final String TAG = StringUtility.b + "UHFNetwork";
    protected SocketManageUR4 socketManage;
    private boolean DEBUG;
    protected DeviceConfiguration_qcom config;
    private IUHFInventoryCallback inventoryCallback;
    protected S uhfProtocolParse;
    private c inventoryThread;
    private boolean isInventorying;

    public I() {
        I i2 = this;
        i2.socketManage = new SocketManageUR4();
        i2.DEBUG = LogUtility_qcom.isDebug();
        i2.inventoryCallback = null;
        i2.uhfProtocolParse = S.e();
        i2.inventoryThread = null;
        i2.isInventorying = false;
        i2.config = DeviceConfiguration_qcom.builderUrx();
        i2.socketManage.a(new SocketManageUR4.CheckConnectState(){

            @Override
            public boolean isInventorying() {
                return I.this.isInventorying;
            }

            @Override
            public byte[] heartBeatData() {
                return I.this.uhfProtocolParse.getVersionSendData();
            }
        });
        i2.socketManage.a(new IConnectionStatusChangedListener(){

            @Override
            public void onStatusChanged(ConnectionStatus connectionStatus) {
                UhfBase.ConnectionStatusEntity connectionStatusEntity;
                LogUtility_qcom.myLogDebug(TAG, "RFIDWithUHFAxNetWorkBase_qcom update status=" + (Object)((Object)connectionStatus));
                if (connectionStatus == ConnectionStatus.DISCONNECTED) {
                    b b2 = b4;
                    I.access$002(b2.I.this, false);
                    b2.I.this.stopInventoryThread();
                }
                b b3 = b4;
                UhfBase.ConnectionStatusEntity connectionStatusEntity2 = connectionStatusEntity;
                connectionStatusEntity = new UhfBase.ConnectionStatusEntity(connectionStatus, null);
                b b4 = b3.I.this.handler.obtainMessage(1, (Object)connectionStatusEntity2);
                b3.I.this.handler.sendMessage((Message)b4);
            }
        });
    }

    private boolean isCheackConnect() {
        I i2 = string;
        Object object = i2.uhfProtocolParse.getVersionSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        I i3 = string;
        String string = i3.uhfProtocolParse.parseVersionData(object.c);
        if (i3.DEBUG) {
            LogUtility_qcom.myLogDebug(TAG, "isCheackConnect v=" + (String)string);
        }
        return string != null && string.length() != 0;
        {
        }
    }

    private synchronized boolean startInventoryTag(int n2, int n3, int n4) {
        if (!this.isPowerOn()) {
            return false;
        }
        if (this.isInventorying) {
            LogUtility_qcom.myLogDebug(TAG, "isInventorying....true");
            return true;
        }
        I i2 = this;
        i2.socketManage.a();
        LogUtility_qcom.myLogDebug(TAG, "startInventoryTag");
        i2.isInventorying = true;
        byte[] byArray = i2.uhfProtocolParse.getStartInventoryTagSendData();
        if (!i2.socketManage.b(byArray)) {
            this.isInventorying = false;
            return false;
        }
        this.startInventoryThread();
        return true;
    }

    private void stopInventoryThread() {
        LogUtility_qcom.myLogDebug(TAG, "stopInventoryThread inventoryThread=" + this.inventoryThread);
        c c2 = this.inventoryThread;
        if (c2 != null) {
            c2.a();
            this.inventoryThread = null;
        }
    }

    private void startInventoryThread() {
        LogUtility_qcom.myLogDebug(TAG, "startInventoryThread  inventoryCallback=" + this.inventoryCallback);
        if (this.inventoryCallback != null && this.inventoryThread == null) {
            c c2;
            c c3 = c2;
            c3();
            this.inventoryThread = c3;
            c2.start();
        }
    }

    static /* synthetic */ boolean access$002(I i2, boolean bl) {
        i2.isInventorying = bl;
        return bl;
    }

    @Override
    public synchronized void setIPAndPort(String string, int n2) {
        I i2 = this;
        i2.config.setPort(n2);
        i2.config.setIP(string);
    }

    public synchronized boolean init(String string) {
        return this.init(string, this.config.getPort());
    }

    @Override
    public boolean init(Context context) {
        I i2 = this;
        return i2.init(i2.config.getIP(), this.config.getPort());
    }

    @Override
    public synchronized boolean init(String string, int n2) {
        return this.init(string, n2, true);
    }

    @Override
    public boolean init(String string, int n2, boolean bl) {
        if (this.getConnectStatus() == ConnectionStatus.CONNECTED) {
            if (this.DEBUG) {
                LogUtility_qcom.myLogDebug(TAG, "already connected!");
            }
            return true;
        }
        if (!(string == null && string.isEmpty() || n2 < 1)) {
            I i2 = this;
            i2.config.setPort(n2);
            i2.config.setIP(string);
            for (int i3 = 1; i3 <= 2; ++i3) {
                I i4 = this;
                boolean bl2 = i4.socketManage.a(string, n2);
                if (i4.DEBUG) {
                    LogUtility_qcom.myLogDebug(TAG, "init host=" + string + ", port=" + n2 + ">>result=" + bl2);
                }
                if (bl2) {
                    SystemClock.sleep((long)100L);
                    this.stopInventory();
                    if (!bl || this.isCheackConnect()) {
                        return true;
                    }
                }
                this.socketManage.b();
            }
            return false;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getSTM32Version() {
        if (!((I)((Object)string)).isPowerOn()) {
            return null;
        }
        I i2 = string;
        Object object = i2.uhfProtocolParse.getSTM32VersionSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return null;
        }
        I i3 = string;
        String string = i3.uhfProtocolParse.parseSTM32VersionData(object.c);
        if (i3.DEBUG) {
            LogUtility_qcom.myLogDebug(TAG, "getVersion() vesionString:" + (String)string);
        }
        return string;
    }

    @Override
    public List<AntennaConnectState> getAntennaConnectState() {
        if (!((I)object).isPowerOn()) {
            return null;
        }
        I i2 = object;
        Object object = S.e().getAntennaConnectStateSendData();
        if ((object = i2.socketManage.a((byte[])object)) == null) {
            return null;
        }
        return S.e().parseGetAntennaConnectStateReceiveData(((b.a)object).c);
    }

    @Override
    public synchronized boolean free() {
        if (this.DEBUG) {
            LogUtility_qcom.myLogDebug(TAG, "free isInventorying=" + this.isInventorying);
        }
        if (this.isInventorying()) {
            this.stopInventory();
        }
        I i2 = this;
        i2.socketManage.b();
        i2.stopInventoryThread();
        return true;
    }

    @Override
    public synchronized String getVersion() {
        if (!((I)((Object)string)).isPowerOn()) {
            return null;
        }
        I i2 = string;
        Object object = i2.uhfProtocolParse.getVersionSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return null;
        }
        I i3 = string;
        String string = i3.uhfProtocolParse.parseVersionData(object.c);
        if (i3.DEBUG) {
            LogUtility_qcom.myLogDebug(TAG, "getVersion() vesionString:" + (String)string);
        }
        return string;
    }

    public synchronized int getPower() {
        if (!this.isPowerOn()) {
            return -1;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.getPowerSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return -1;
        }
        I i3 = this;
        int n2 = i3.uhfProtocolParse.parseGetPowerData(object.c);
        if (i3.DEBUG) {
            LogUtility_qcom.myLogDebug(TAG, "getPower() err :" + n2);
        }
        return n2;
    }

    public synchronized boolean setPower(int n2) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.setPowerSendData(n2);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        I i3 = this;
        boolean bl = i3.uhfProtocolParse.parseSetPowerData(object.c);
        if (i3.DEBUG) {
            LogUtility_qcom.myLogDebug(TAG, "setPower() err :" + bl);
        }
        return bl;
    }

    @Override
    public synchronized int getFrequencyMode() {
        if (!this.isPowerOn()) {
            return -1;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.getFrequencyModeSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return -1;
        }
        I i3 = this;
        byte by = i3.uhfProtocolParse.parseGetFrequencyModeData(object.c);
        if (i3.DEBUG) {
            LogUtility_qcom.myLogDebug(TAG, "getFrequencyMode() err :" + by);
        }
        return by;
    }

    public synchronized boolean setFrequencyMode(byte by) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.setFrequencyModeSendData(by);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        I i3 = this;
        boolean bl = i3.uhfProtocolParse.parseSetFrequencyModeData(object.c);
        if (i3.DEBUG) {
            LogUtility_qcom.myLogDebug(TAG, "setFrequencyMode() err :" + bl);
        }
        return bl;
    }

    @Override
    public synchronized boolean startInventoryTag() {
        return this.startInventoryTag(0, 0, 6);
    }

    @Override
    public synchronized UHFTAGInfo readTagFromBuffer() {
        b.a a2 = this.socketManage.d();
        if (a2 == null) {
            return null;
        }
        return this.uhfProtocolParse.parseContinuousInventoryTagData(a2.c);
    }

    @Override
    public synchronized boolean stopInventory() {
        if (this.getConnectStatus() != ConnectionStatus.CONNECTED) {
            return false;
        }
        byte[] byArray = this.uhfProtocolParse.getStopInventorySendData();
        LogUtility_qcom.myLogDebug(TAG, "stopInventory begin");
        for (int i2 = 0; i2 < 3; ++i2) {
            b.a a2 = this.socketManage.a(byArray, 1000);
            LogUtility_qcom.myLogDebug(TAG, "stopInventory k=" + i2);
            if (a2 != null) break;
        }
        this.isInventorying = false;
        LogUtility_qcom.myLogDebug(TAG, "stopInventory end");
        return true;
    }

    @Override
    public String generateLockCode(ArrayList<Integer> arrayList, int n2) {
        if (arrayList != null && arrayList.size() != 0 && n2 >= 0) {
            if (n2 != 16 && n2 != 32 && n2 != 48 && n2 != 64) {
                throw new IllegalArgumentException("lockMode error");
            }
            return S.e().generateLockCode(arrayList, n2);
        }
        return null;
    }

    @Override
    public synchronized boolean lockMem(String string, String string2) {
        StringUtility.hexString2Chars(string);
        StringUtility.hexString2Chars(string2);
        boolean bl = this.lockMem(string, 1, 0, 0, "", string2);
        if (bl) {
            return true;
        }
        LogUtility_qcom.myLogDebug(TAG, "lockMem() err :" + bl);
        return false;
    }

    @Override
    public boolean lockMem(String object, int n2, int n3, int n4, String string, String string2) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        object = i2.uhfProtocolParse.getLockSendData((String)object, n2, n3, n4, string, string2);
        if ((object = i2.socketManage.a((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseLockData(((b.a)object).c);
        LogUtility_qcom.myLogDebug(TAG, "lockMem() err :" + bl);
        return bl;
    }

    @Override
    public synchronized UHFTAGInfo inventorySingleTag() {
        if (!this.isPowerOn()) {
            return null;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.getInventorySingleTagSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return null;
        }
        return this.uhfProtocolParse.parseInventorySingleTagData(object.c);
    }

    @Override
    public String readData(String string, int n2, int n3, int n4) {
        if (!StringUtility.isEmpty(string) && StringUtility.isHexNumberRex(string)) {
            return this.readData(string, 1, 0, 0, "00", n2, n3, n4);
        }
        return null;
    }

    @Override
    public String readData(String object, int n2, int n3, int n4, String string, int n5, int n6, int n7) {
        if (!this.isPowerOn()) {
            return null;
        }
        I i2 = this;
        object = i2.uhfProtocolParse.getReadSendData((String)object, n2, n3, n4, string, n5, n6, n7);
        if ((object = i2.socketManage.a((byte[])object)) == null) {
            return null;
        }
        return this.uhfProtocolParse.parseReadData(((b.a)object).c);
    }

    @Override
    public boolean writeData(String string, int n2, int n3, int n4, String string2) {
        if (!StringUtility.isEmpty(string) && !StringUtility.isEmpty(string2)) {
            return this.writeData(string, 1, 32, 0, "00", n2, n3, n4, string2);
        }
        return false;
    }

    @Override
    public boolean writeData(String object, int n2, int n3, int n4, String string, int n5, int n6, int n7, String string2) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        object = i2.uhfProtocolParse.getWriteSendData((String)object, n2, n3, n4, string, n5, n6, n7, string2);
        if ((object = i2.socketManage.a((byte[])object)) == null) {
            return false;
        }
        return this.uhfProtocolParse.parseWriteData(((b.a)object).c);
    }

    @Override
    public boolean writeDataToEpc(String string, int n2, int n3, int n4, String string2, String string3) {
        return false;
    }

    @Override
    public boolean writeDataToEpc(String string, String string2) {
        return false;
    }

    @Override
    public boolean blockWriteData(String string, int n2, int n3, int n4, String string2, int n5, int n6, int n7, String string3) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        char c2 = (char)n2;
        n2 = (char)n5;
        n5 = (char)n7;
        Object object = i2.uhfProtocolParse.blockWriteDataSendData(string, c2, n3, n4, string2, (char)n2, n6, (char)n5, string3);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseBlockWriteData(object.c);
    }

    @Override
    public boolean eraseData(String string, int n2, int n3, int n4, String string2, int n5, int n6, int n7) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        char c2 = (char)n2;
        n2 = (char)n5;
        n5 = (char)n7;
        Object object = i2.uhfProtocolParse.blockEraseDataSendData(string, c2, n3, n4, string2, (char)n2, n6, (char)n5);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseBlockEraseDataData(object.c);
    }

    @Override
    public boolean eraseData(String string, int n2, int n3, int n4) {
        return this.eraseData(string, 1, 0, 0, "00", n2, n3, n4);
    }

    @Override
    public boolean setFilter(int n2, int n3, int n4, String string) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.setFilterSendData((char)n2, n3, n4, string);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetFilterData(object.c);
    }

    @Override
    public synchronized boolean killTag(String string) {
        return this.killTag(string, 0, 0, 0, "00");
    }

    @Override
    public boolean killTag(String object, int n2, int n3, int n4, String string) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        object = i2.uhfProtocolParse.getKillSendData((String)object, n2, n3, n4, string);
        if ((object = i2.socketManage.a((byte[])object)) == null) {
            return false;
        }
        return this.uhfProtocolParse.parseKillData(((b.a)object).c);
    }

    @Override
    public synchronized boolean setProtocol(int n2) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.setProtocolSendData(n2);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetProtocolData(object.c);
    }

    @Override
    public synchronized int getProtocol() {
        if (!this.isPowerOn()) {
            return -1;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.getProtocolSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return -1;
        }
        return this.uhfProtocolParse.parseGetProtocolData(object.c);
    }

    @Override
    public synchronized boolean setFreHop(float f2) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        int n2 = (int)(f2 * 1000.0f);
        Object object = i2.uhfProtocolParse.setJumpFrequencySendData(n2);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetJumpFrequencyData(object.c);
    }

    @Override
    public synchronized boolean setRFLink(int n2) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.setRFLinkSendData(n2);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetRFLinkData(object.c);
    }

    @Override
    public synchronized int getRFLink() {
        if (!this.isPowerOn()) {
            return -1;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.getRFLinkSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return -1;
        }
        return this.uhfProtocolParse.parseGetRFLinkData(object.c);
    }

    @Override
    public synchronized boolean setFastID(boolean bl) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.setFastIdSendData(bl ? 1 : 0);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseFastIdData(object.c);
    }

    @Override
    public synchronized boolean setTagFocus(boolean bl) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.setTagfocusSendData((char)(bl ? 1 : 0));
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetTagfocusData(object.c);
    }

    @Override
    public synchronized boolean setEPCMode() {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.setEPCModeSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetEPCModeData(object.c);
    }

    @Override
    public synchronized boolean setEPCAndTIDMode() {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.setEPCAndTIDModeSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetEPCAndTIDModeData(object.c);
    }

    @Override
    public synchronized boolean setEPCAndTIDUserMode(int n2, int n3) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.setEPCAndTIDUserModeSendData(n2, n3);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetEPCAndTIDUserModeData(object.c);
    }

    @Override
    public synchronized int getTemperature() {
        if (!this.isPowerOn()) {
            return -1;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.getTemperatureSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return -1;
        }
        return this.uhfProtocolParse.parseTemperatureData(object.c);
    }

    @Override
    public boolean uhfBlockPermalock(String string, int n2, int n3, int n4, String string2, int n5, int n6, int n7, int n8, byte[] byArray) {
        if (!this.isPowerOn()) {
            return false;
        }
        return false;
    }

    @Override
    public boolean setGen2(Gen2Entity gen2Entity) {
        Gen2Entity gen2Entity2 = gen2Entity;
        int c2 = gen2Entity2.getSelectTarget();
        int n2 = gen2Entity2.getSelectAction();
        int n3 = gen2Entity2.getSelectTruncate();
        int n4 = gen2Entity2.getQ();
        int n5 = gen2Entity2.getStartQ();
        int n6 = gen2Entity2.getMinQ();
        int n7 = gen2Entity2.getMaxQ();
        int n8 = gen2Entity2.getQueryDR();
        int n9 = gen2Entity2.getQueryM();
        int n10 = gen2Entity2.getQueryTRext();
        int n11 = gen2Entity2.getQuerySel();
        int n12 = gen2Entity2.getQuerySession();
        int n13 = gen2Entity2.getQueryTarget();
        int n14 = gen2Entity2.getLinkFrequency();
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        char object = (char)c2;
        char c3 = (char)n2;
        char c4 = (char)n3;
        char c5 = (char)n4;
        char c6 = (char)n5;
        char c7 = (char)n6;
        char c8 = (char)n7;
        char c9 = (char)n8;
        char c10 = (char)n9;
        char c11 = (char)n10;
        char c12 = (char)n11;
        char c13 = (char)n12;
        char c14 = (char)n13;
        char c15 = (char)n14;
        byte[] byArray = i2.uhfProtocolParse.setGen2SendData(object, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15);
        b.a a2 = i2.socketManage.a(byArray);
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetGen2Data(a2.c);
    }

    @Override
    public Gen2Entity getGen2() {
        Gen2Entity gen2Entity;
        if (((I)object16).DEBUG) {
            Log.d((String)TAG, (String)"GetGen2()=========");
        }
        if (!((I)object16).isPowerOn()) {
            return null;
        }
        I i2 = object16;
        Object object = i2.uhfProtocolParse.getGen2SendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return null;
        }
        object = ((I)object16).uhfProtocolParse.parseGetGen2Data(object.c);
        if (object == null) {
            return null;
        }
        if (((I)object16).DEBUG) {
            StringBuilder stringBuilder;
            I i3 = object16;
            Object object2 = object16 = stringBuilder;
            Object object3 = object16;
            Object object4 = object16;
            Object object5 = object16;
            Object object6 = object16;
            Object object7 = object16;
            Object object8 = object16;
            Object object9 = object16;
            Object object10 = object16;
            Object object11 = object16;
            Object object12 = object16;
            Object object13 = object16;
            Object object14 = object16;
            Object object15 = object16;
            ((StringBuilder)object15)();
            ((StringBuilder)object15).append("target data[0]=");
            ((StringBuilder)object14).append(String.valueOf((int)object[0]));
            ((StringBuilder)object14).append(",action data[1]=");
            ((StringBuilder)object13).append(String.valueOf((int)object[1]));
            ((StringBuilder)object13).append(",t data[2]=");
            ((StringBuilder)object12).append(String.valueOf((int)object[2]));
            ((StringBuilder)object12).append(",q data[3]=");
            ((StringBuilder)object11).append(String.valueOf((int)object[3]));
            ((StringBuilder)object11).append(",startQ data[4]=");
            ((StringBuilder)object10).append(String.valueOf((int)object[4]));
            ((StringBuilder)object10).append(",minQ data[5]=");
            ((StringBuilder)object9).append(String.valueOf((int)object[5]));
            ((StringBuilder)object9).append(",maxQ data[6]=");
            ((StringBuilder)object8).append(String.valueOf((int)object[6]));
            ((StringBuilder)object8).append(",dr data[7]=");
            ((StringBuilder)object7).append(String.valueOf((int)object[7]));
            ((StringBuilder)object7).append(",coding data[8]=");
            ((StringBuilder)object6).append(String.valueOf((int)object[8]));
            ((StringBuilder)object6).append(", p data[9]=");
            ((StringBuilder)object5).append(String.valueOf((int)object[9]));
            ((StringBuilder)object5).append(",Sel data[10]=");
            ((StringBuilder)object4).append(String.valueOf((int)object[10]));
            ((StringBuilder)object4).append(",Session data[11]=");
            ((StringBuilder)object3).append(String.valueOf((int)object[11]));
            ((StringBuilder)object3).append(",g data[12]=");
            ((StringBuilder)object2).append(String.valueOf(object[12]));
            ((StringBuilder)object2).append(",linkFrequency data[13]=");
            stringBuilder.append(String.valueOf(object[13]));
            if (i3.DEBUG) {
                Log.d((String)TAG, (String)((StringBuilder)object16).toString());
            }
        }
        Object object16 = StringUtility.bytesTochars(object, ((byte[])object).length);
        object = gen2Entity;
        object();
        object.setSelectTarget((int)object16[0]);
        object.setSelectAction((int)object16[1]);
        object.setSelectTruncate((int)object16[2]);
        object.setQ((int)object16[3]);
        object.setStartQ((int)object16[4]);
        object.setMinQ((int)object16[5]);
        object.setMaxQ((int)object16[6]);
        object.setQueryDR((int)object16[7]);
        object.setQueryM((int)object16[8]);
        object.setQueryTRext((int)object16[9]);
        object.setQuerySel((int)object16[10]);
        object.setQuerySession((int)object16[11]);
        object.setQueryTarget((int)object16[12]);
        gen2Entity.setLinkFrequency((int)object16[13]);
        return gen2Entity;
    }

    @Override
    public synchronized boolean uhfJump2Boot() {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.uhfJump2BootSendData('\u0001');
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseUHFJump2BootData(object.c);
    }

    @Override
    public boolean uhfJump2Boot(int n2) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.uhfJump2BootSendData((char)n2);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseUHFJump2BootData(object.c);
    }

    @Override
    public boolean uhfJump2BootSTM32() {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.uhfJump2BootSendData('\u0000');
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFJump2BootData(object.c);
        if (bl) {
            I i3 = this;
            i3.socketManage.b();
            if (i3.DEBUG) {
                Log.d((String)TAG, (String)"uhfJump2BootSTM32 result  socketManage.close()");
            }
            I i4 = this;
            SystemClock.sleep((long)1000L);
            bl = i4.socketManage.a(this.config.getIP(), this.config.getPort());
            if (i4.DEBUG) {
                Log.d((String)TAG, (String)("uhfJump2BootSTM32 result connect=" + bl));
            }
        }
        return bl;
    }

    @Override
    public synchronized boolean uhfStartUpdate() {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.uhfStartUpdateSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseUHFStartUpdateData(object.c);
    }

    @Override
    public synchronized boolean uhfUpdating(byte[] object) {
        byte[] byArray = new byte[64];
        if (((byte[])object).length < 64) {
            for (int i2 = 0; i2 < ((byte[])object).length; ++i2) {
                byArray[i2] = object[i2];
            }
        } else {
            for (int i3 = 0; i3 < 64; ++i3) {
                byArray[i3] = object[i3];
            }
        }
        if (!this.isPowerOn()) {
            return false;
        }
        I i4 = this;
        object = i4.uhfProtocolParse.uhfUpdatingSendData(byArray);
        b.a a2 = i4.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseUHFUpdatingData(object.c);
    }

    @Override
    public synchronized boolean uhfStopUpdate() {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.UHFStopUpdateSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseUHFStopUpdateData(object.c);
    }

    @Override
    public synchronized int getCW() {
        if (!this.isPowerOn()) {
            return -1;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.getCWSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return -1;
        }
        return this.uhfProtocolParse.parseGetCWData(object.c);
    }

    @Override
    public boolean setCW(int n2) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.setCWSendData((char)n2);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetCWData(object.c);
    }

    @Override
    public InventoryModeEntity getEPCAndTIDUserMode() {
        InventoryModeEntity.b b2;
        if (!((I)object2).isPowerOn()) {
            return null;
        }
        I i2 = object2;
        Object object = i2.uhfProtocolParse.getEPCTIDModeSendData('\u0000', '\u0000');
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return null;
        }
        byte[] byArray = ((I)object2).uhfProtocolParse.parseGetEPCTIDModeData(((b.a)object).c);
        Object object2 = byArray;
        if (byArray == null) {
            return null;
        }
        object = b2;
        ((InventoryModeEntity.b)object)();
        b2.a((int)object2[0]);
        if (object2[0] == 2) {
            ((InventoryModeEntity.b)object).c((int)(object2[1] & 0xFF));
            ((InventoryModeEntity.b)object).b((int)(object2[2] & 0xFF));
        }
        return ((InventoryModeEntity.b)object).a();
    }

    @Override
    public boolean setUhfReaderIP(ReaderIPEntity object) {
        if (this.isPowerOn() && object != null) {
            I i2 = this;
            object = i2.uhfProtocolParse.setReaderIpSendData((ReaderIPEntity)object);
            if ((object = i2.socketManage.a((byte[])object)) == null) {
                return false;
            }
            return this.uhfProtocolParse.parseSetReaderIpData(((b.a)object).c);
        }
        return false;
    }

    @Override
    public ReaderIPEntity getUhfReaderIP() {
        if (!this.isPowerOn()) {
            return null;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.getReaderIpSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return null;
        }
        return this.uhfProtocolParse.parseGetReaderIpData(object.c);
    }

    @Override
    public boolean softwareReset() {
        if (!this.isPowerOn()) {
            return false;
        }
        if (this.DEBUG) {
            Log.d((String)TAG, (String)"resetUHFSoft begin");
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.getSetSoftResetSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        I i3 = this;
        boolean bl = i3.uhfProtocolParse.parseSetSoftResetData(object.c);
        if (i3.DEBUG) {
            Log.d((String)TAG, (String)"resetUHFSoft emd");
        }
        return bl;
    }

    @Override
    public void update(Observable object, Object object2) {
        UhfBase.ConnectionStatusEntity connectionStatusEntity;
        LogUtility_qcom.myLogDebug(TAG, "update status=" + object2.toString());
        object = (ConnectionStatus)((Object)object2);
        if (object == ConnectionStatus.DISCONNECTED) {
            i3.isInventorying = false;
            i3.stopInventoryThread();
        }
        I i2 = i3;
        object2 = connectionStatusEntity;
        connectionStatusEntity = i3.new UhfBase.ConnectionStatusEntity((ConnectionStatus)((Object)object), null);
        I i3 = i2.handler.obtainMessage(1, object2);
        i2.handler.sendMessage((Message)i3);
    }

    @Override
    public synchronized boolean setFrequencyMode(int n2) {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.setFrequencyModeSendData(n2);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        I i3 = this;
        boolean bl = i3.uhfProtocolParse.parseSetFrequencyModeData(object.c);
        if (i3.DEBUG) {
            Log.d((String)TAG, (String)("setFrequencyMode() err :" + bl));
        }
        return bl;
    }

    @Override
    public void setConnectionStatusCallback(ConnectionStatusCallback<Object> connectionStatusCallback) {
        this.statusCallback = connectionStatusCallback;
    }

    @Override
    public ConnectionStatus getConnectStatus() {
        return this.socketManage.c();
    }

    protected boolean isPowerOn() {
        return this.socketManage.c() == ConnectionStatus.CONNECTED;
    }

    @Override
    public int getErrCode() {
        return 0;
    }

    @Override
    public boolean enableBeep() {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.getBeepSendData(true);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseBeepData(object.c);
    }

    @Override
    public boolean disableBeep() {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.getBeepSendData(false);
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseBeepData(object.c);
    }

    @Override
    public boolean isEnableBeep() {
        if (!this.isPowerOn()) {
            return false;
        }
        I i2 = this;
        Object object = i2.uhfProtocolParse.getReaderBeepStatusSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseGetReaderBeepStatusData(object.c) == 1;
    }

    @Override
    public boolean setANT(List<AntennaState> list) {
        if (!this.isPowerOn()) {
            return false;
        }
        if (list != null && list.size() <= 16) {
            byte[] byArray = new byte[2];
            List<AntennaState> list2 = this.getANT();
            if (list2 == null) {
                LogUtility_qcom.myLogDebug(TAG, "getANT fail");
                return false;
            }
            for (AntennaState antennaState : list2) {
                for (AntennaState antennaState2 : list) {
                    if (antennaState.getAntennaName() != antennaState2.getAntennaName()) continue;
                    antennaState.setEnable(antennaState2.isEnable());
                }
            }
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2();
                LogUtility_qcom.myLogDebug(TAG, stringBuilder.append((Object)list2.get(i2).getAntennaName()).append(" :").append(list2.get(i2).isEnable()).toString());
                if (!list2.get(i2).isEnable()) continue;
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT1) {
                    byArray[1] = (byte)(byArray[1] | 1);
                    continue;
                }
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT2) {
                    byArray[1] = (byte)(byArray[1] | 2);
                    continue;
                }
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT3) {
                    byArray[1] = (byte)(byArray[1] | 4);
                    continue;
                }
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT4) {
                    byArray[1] = (byte)(byArray[1] | 8);
                    continue;
                }
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT5) {
                    byArray[1] = (byte)(byArray[1] | 0x10);
                    continue;
                }
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT6) {
                    byArray[1] = (byte)(byArray[1] | 0x20);
                    continue;
                }
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT7) {
                    byArray[1] = (byte)(byArray[1] | 0x40);
                    continue;
                }
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT8) {
                    byArray[1] = (byte)(byArray[1] | 0x80);
                    continue;
                }
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT9) {
                    byArray[0] = (byte)(byArray[0] | 1);
                    continue;
                }
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT10) {
                    byArray[0] = (byte)(byArray[0] | 2);
                    continue;
                }
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT11) {
                    byArray[0] = (byte)(byArray[0] | 4);
                    continue;
                }
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT12) {
                    byArray[0] = (byte)(byArray[0] | 8);
                    continue;
                }
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT13) {
                    byArray[0] = (byte)(byArray[0] | 0x10);
                    continue;
                }
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT14) {
                    byArray[0] = (byte)(byArray[0] | 0x20);
                    continue;
                }
                if (list2.get(i2).getAntennaName() == AntennaEnum.ANT15) {
                    byArray[0] = (byte)(byArray[0] | 0x40);
                    continue;
                }
                if (list2.get(i2).getAntennaName() != AntennaEnum.ANT16) continue;
                byArray[0] = (byte)(byArray[0] | 0x80);
            }
            I i3 = this;
            Object object = i3.uhfProtocolParse.setAntSendData('\u0001', byArray);
            b.a a2 = i3.socketManage.a((byte[])object);
            object = a2;
            if (a2 == null) {
                return false;
            }
            return this.uhfProtocolParse.parseSetAntData(object.c);
        }
        return false;
    }

    @Override
    public List<AntennaState> getANT() {
        if (!((I)object2).isPowerOn()) {
            return null;
        }
        I i2 = object2;
        Object object = i2.uhfProtocolParse.getAntSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return null;
        }
        byte[] byArray = ((I)object2).uhfProtocolParse.parseGetAntData(((b.a)object).c);
        Object object2 = byArray;
        if (byArray != null && ((Object)object2).length >= 2) {
            Object object3;
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
            AntennaEnum antennaEnum = AntennaEnum.ANT1;
            boolean bl = (object2[1] & 1) == 1;
            AntennaState antennaState = object3;
            antennaState(antennaEnum, bl);
            ((ArrayList)object).add(antennaState);
            antennaEnum = AntennaEnum.ANT2;
            bl = (object2[1] & 2) == 2;
            AntennaState antennaState2 = object3;
            antennaState2(antennaEnum, bl);
            ((ArrayList)object).add(antennaState2);
            antennaEnum = AntennaEnum.ANT3;
            bl = (object2[1] & 4) == 4;
            AntennaState antennaState3 = object3;
            antennaState3(antennaEnum, bl);
            ((ArrayList)object).add(antennaState3);
            antennaEnum = AntennaEnum.ANT4;
            bl = (object2[1] & 8) == 8;
            AntennaState antennaState4 = object3;
            antennaState4(antennaEnum, bl);
            ((ArrayList)object).add(antennaState4);
            antennaEnum = AntennaEnum.ANT5;
            bl = (object2[1] & 0x10) == 16;
            AntennaState antennaState5 = object3;
            antennaState5(antennaEnum, bl);
            ((ArrayList)object).add(antennaState5);
            antennaEnum = AntennaEnum.ANT6;
            bl = (object2[1] & 0x20) == 32;
            AntennaState antennaState6 = object3;
            antennaState6(antennaEnum, bl);
            ((ArrayList)object).add(antennaState6);
            antennaEnum = AntennaEnum.ANT7;
            bl = (object2[1] & 0x40) == 64;
            AntennaState antennaState7 = object3;
            antennaState7(antennaEnum, bl);
            ((ArrayList)object).add(antennaState7);
            antennaEnum = AntennaEnum.ANT8;
            bl = (object2[1] & 0x80) == 128;
            AntennaState antennaState8 = object3;
            antennaState8(antennaEnum, bl);
            ((ArrayList)object).add(antennaState8);
            antennaEnum = AntennaEnum.ANT9;
            bl = (object2[0] & 1) == 1;
            AntennaState antennaState9 = object3;
            antennaState9(antennaEnum, bl);
            ((ArrayList)object).add(antennaState9);
            antennaEnum = AntennaEnum.ANT10;
            bl = (object2[0] & 2) == 2;
            AntennaState antennaState10 = object3;
            antennaState10(antennaEnum, bl);
            ((ArrayList)object).add(antennaState10);
            antennaEnum = AntennaEnum.ANT11;
            bl = (object2[0] & 4) == 4;
            AntennaState antennaState11 = object3;
            antennaState11(antennaEnum, bl);
            ((ArrayList)object).add(antennaState11);
            antennaEnum = AntennaEnum.ANT12;
            bl = (object2[0] & 8) == 8;
            AntennaState antennaState12 = object3;
            antennaState12(antennaEnum, bl);
            ((ArrayList)object).add(antennaState12);
            antennaEnum = AntennaEnum.ANT13;
            bl = (object2[0] & 0x10) == 16;
            AntennaState antennaState13 = object3;
            antennaState13(antennaEnum, bl);
            ((ArrayList)object).add(antennaState13);
            antennaEnum = AntennaEnum.ANT14;
            bl = (object2[0] & 0x20) == 32;
            AntennaState antennaState14 = object3;
            antennaState14(antennaEnum, bl);
            ((ArrayList)object).add(antennaState14);
            antennaEnum = AntennaEnum.ANT15;
            bl = (object2[0] & 0x40) == 64;
            Object object4 = object2;
            AntennaState antennaState15 = object3;
            antennaState15(antennaEnum, bl);
            ((ArrayList)object).add(antennaState15);
            object3 = AntennaEnum.ANT16;
            boolean bl2 = (object4[0] & 0x80) == 128;
            Object object5 = object;
            object2 = new AntennaState((AntennaEnum)((Object)object3), bl2);
            ((ArrayList)object5).add(object2);
            return object5;
        }
        return null;
    }

    @Override
    public boolean setAntennaPower(AntennaEnum object, int n2) {
        LogUtility_qcom.myLogDebug(TAG, "setPower");
        if (object == null) {
            return false;
        }
        if (n2 > 30) {
            n2 = 30;
        } else if (n2 < 1) {
            n2 = 1;
        }
        I i2 = this;
        object = i2.uhfProtocolParse.a(object.getValue(), n2);
        object = i2.socketManage.a((byte[])object);
        if (object == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetPowerData(((b.a)object).c);
        System.out.println("setPower() err :" + bl);
        return bl;
    }

    @Override
    public int getAntennaPower(AntennaEnum antennaEnum) {
        if ((iterator = ((I)((Object)iterator)).getAntennaPower()) != null && iterator.size() != 0) {
            Iterator iterator = iterator.iterator();
            while (iterator.hasNext()) {
                AntennaPowerEntity antennaPowerEntity = (AntennaPowerEntity)iterator.next();
                if (antennaPowerEntity.getAnt() != antennaEnum) continue;
                return antennaPowerEntity.getPower();
            }
            return -1;
        }
        return -1;
    }

    @Override
    public List<AntennaPowerEntity> getAntennaPower() {
        I i2 = this;
        Object object = i2.uhfProtocolParse.getPowerSendData();
        b.a a2 = i2.socketManage.a((byte[])object);
        object = a2;
        if (a2 == null) {
            return null;
        }
        return this.uhfProtocolParse.c(object.c);
    }

    @Override
    public ReaderIPEntity getDestIP() {
        if (!((I)object).isPowerOn()) {
            return null;
        }
        I i2 = object;
        Object object = S.e().getReaderDestIpSendData();
        if ((object = i2.socketManage.a((byte[])object)) == null) {
            return null;
        }
        return S.e().parseGetReaderDestIpData(((b.a)object).c);
    }

    @Override
    public boolean setDestIP(ReaderIPEntity readerIPEntity) {
        if (((I)object).isPowerOn() && readerIPEntity != null) {
            I i2 = object;
            Object object = S.e().setReaderDestIpSendData(readerIPEntity);
            if ((object = i2.socketManage.a((byte[])object)) == null) {
                return false;
            }
            return S.e().parseSetReaderDestIpData(((b.a)object).c);
        }
        return false;
    }

    @Override
    public int getWorkMode() {
        if (!((I)object).isPowerOn()) {
            return -1;
        }
        I i2 = object;
        Object object = S.e().getWorkModeSendData();
        if ((object = i2.socketManage.a((byte[])object)) == null) {
            return -1;
        }
        return S.e().parseGetWorkModeReceiveData(((b.a)object).c);
    }

    @Override
    public boolean setWorkMode(int n2) {
        if (!((I)object).isPowerOn()) {
            return false;
        }
        I i2 = object;
        Object object = S.e().setWorkModeSendData(n2);
        if ((object = i2.socketManage.a((byte[])object)) == null) {
            return false;
        }
        return S.e().parseSetWorkModeReceiveData(((b.a)object).c);
    }

    @Override
    public boolean setTriggerWorkModePara(int n2, int n3, int n4, int n5) {
        if (!((I)object).isPowerOn()) {
            return false;
        }
        I i2 = object;
        Object object = S.e().setTriggerWorkModeParaSendData(n2, n3, n4, n5);
        if ((object = i2.socketManage.a((byte[])object)) == null) {
            return false;
        }
        return S.e().parseSetTriggerWorkModeParaReceiveData(((b.a)object).c);
    }

    @Override
    public int[] getTriggerWorkModePara() {
        if (!((I)object).isPowerOn()) {
            return null;
        }
        I i2 = object;
        Object object = S.e().getTriggerWorkModeParaSendData();
        if ((object = i2.socketManage.a((byte[])object)) == null) {
            return null;
        }
        return S.e().parseGetTriggerWorkModeParaReceiveData(((b.a)object).c);
    }

    @Override
    public byte[] getInputStatus() {
        if (!((I)object).isPowerOn()) {
            return null;
        }
        I i2 = object;
        Object object = S.e().getIOControlSendData();
        if ((object = i2.socketManage.a((byte[])object)) == null) {
            return null;
        }
        return S.e().parseGetIOControlReceiveData(((b.a)object).c);
    }

    @Override
    public boolean setRelayStatus(byte by) {
        if (!((I)object).isPowerOn()) {
            return false;
        }
        I i2 = object;
        Object object = S.e().setIOControlSendData((byte)1, (byte)1, by);
        if ((object = i2.socketManage.a((byte[])object)) == null) {
            return false;
        }
        return S.e().parseSetIOControlReceiveData(((b.a)object).c);
    }

    @Override
    public boolean isInventorying() {
        if (!this.isPowerOn()) {
            return false;
        }
        return this.isInventorying;
    }

    @Override
    public void setInventoryCallback(IUHFInventoryCallback iUHFInventoryCallback) {
        this.inventoryCallback = iUHFInventoryCallback;
    }

    class c
    extends Thread {
        boolean a = false;
        Object b;

        c() {
            Object object;
            Object object2 = object;
            object = new Object();
            v1.b = object2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            LogUtility_qcom.myLogDebug(TAG, "start InventoryThread!");
            while (true) {
                if (this.a) {
                    LogUtility_qcom.myLogDebug(TAG, "end InventoryThread!");
                    return;
                }
                Object object = I.this.readTagFromBuffer();
                if (object == null) {
                    c c2 = this;
                    c c3 = c2;
                    object = c2.b;
                    try {
                        if (c3.I.this.isInventorying()) {
                            this.b.wait(10L);
                        } else {
                            this.b.wait(200L);
                        }
                        // MONITOREXIT : object
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : object
                        try {
                            throw throwable;
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    continue;
                }
                if (I.this.inventoryCallback == null) continue;
                I.this.inventoryCallback.callback((UHFTAGInfo)object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void a() {
            LogUtility_qcom.myLogDebug(TAG, "InventoryThread stopThread begin");
            this.a = true;
            Object object = this.b;
            synchronized (object) {
                this.b.notifyAll();
            }
            LogUtility_qcom.myLogDebug(TAG, "InventoryThread stopThread end");
        }
    }
}

