/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.utility;

class HexUtility {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    HexUtility() {
    }

    public static char[] encodeHex(byte[] byArray) {
        return HexUtility.encodeHex(byArray, true);
    }

    public static char[] encodeHex(byte[] byArray, boolean bl) {
        char[] cArray = bl ? DIGITS_LOWER : DIGITS_UPPER;
        return HexUtility.encodeHex(byArray, cArray);
    }

    protected static char[] encodeHex(byte[] byArray, char[] cArray) {
        int n2 = byArray.length;
        char[] cArray2 = new char[n2 << 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray2[n3++] = cArray[(byArray[i2] & 0xF0) >>> 4];
            int n4 = n3 + 1;
            cArray2[n3] = cArray[byArray[i2] & 0xF];
            n3 = n4;
        }
        return cArray2;
    }

    public static String encodeHexStr(byte[] byArray) {
        return HexUtility.encodeHexStr(byArray, true);
    }

    public static String encodeHexStr(byte[] byArray, boolean bl) {
        char[] cArray = bl ? DIGITS_LOWER : DIGITS_UPPER;
        return HexUtility.encodeHexStr(byArray, cArray);
    }

    protected static String encodeHexStr(byte[] byArray, char[] cArray) {
        return new String(HexUtility.encodeHex(byArray, cArray));
    }

    public static byte[] decodeHex(char[] cArray) {
        int n2 = cArray.length;
        if ((n2 & 1) == 0) {
            byte[] byArray = new byte[n2 >> 1];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = HexUtility.toDigit(cArray[n4], n4) << 4 | HexUtility.toDigit(cArray[++n4], n4);
                ++n4;
                byArray[n3] = (byte)(n5 & 0xFF);
                ++n3;
            }
            return byArray;
        }
        throw new RuntimeException("Odd number of characters.");
    }

    protected static int toDigit(char c2, int n2) {
        int n3 = Character.digit(c2, 16);
        if (n3 != -1) {
            return n3;
        }
        throw new RuntimeException("Illegal hexadecimal character " + c2 + " at index " + n2);
    }
}

