/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.env;

import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.timestamp.client.logging.TscLogging;
import cfca.sadk.tls.sun.security.ssl.JSSEProvider;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.security.Provider;
import java.security.Security;
import java.util.List;

public final class Environments {
    private static final String COMPANY_NAME = "China Financial Certification Authority";
    private static final String PRODUCT_NAME = "TimestampAPI Standard";
    public static final String VERSION = "v4.2.1.0-201904";

    public static Environments getInstance() {
        return Holder.INSTANCE;
    }

    private Environments() {
        cfca.sadk.system.Environments sadkEnvironments = cfca.sadk.system.Environments.environments();
        String sadkInfo = sadkEnvironments.buildEnvironments();
        String appInfo = this.buildEnvironments();
        TscLogging.SYSTEM_LOGGER.info(sadkInfo);
        TscLogging.SYSTEM_LOGGER.info(appInfo);
        TscLogging.ENVIRONMENT_LOGGER.info(sadkInfo);
        TscLogging.ENVIRONMENT_LOGGER.info(appInfo);
    }

    final StringBuilder appendOS(StringBuilder builder) {
        if (builder != null) {
            builder.append("\n");
            builder.append("\n ===================OSx info===================");
            builder.append("\n \u64cd\u4f5c\u7cfb\u7edf\u540d\u79f0: " + System.getProperty("os.name"));
            builder.append("\n \u64cd\u4f5c\u7cfb\u7edf\u67b6\u6784: " + System.getProperty("os.arch"));
            builder.append("\n \u64cd\u4f5c\u7cfb\u7edf\u7248\u672c: " + System.getProperty("os.version"));
            builder.append("\n \u64cd\u4f5c\u7cfb\u7edf\u7528\u6237\u540d: " + System.getProperty("user.name"));
            builder.append("\n user.home: " + System.getProperty("user.home"));
            builder.append("\n user.dir: " + System.getProperty("user.dir"));
            builder.append("\n user.timezone: ").append(System.getProperty("user.timezone"));
            builder.append("\n user.language: ").append(System.getProperty("user.language"));
        }
        return builder;
    }

    final StringBuilder appendJDK(StringBuilder builder) {
        if (builder != null) {
            builder.append("\n");
            builder.append("\n ===================JDK info===================");
            builder.append("\n JDK\u4e3b\u7248\u672c: " + System.getProperty("java.version"));
            builder.append("\n JDK\u4f9b\u5e94\u5546: " + System.getProperty("java.vendor"));
            builder.append("\n JDK\u4e3b\u76ee\u5f55: " + System.getProperty("java.home"));
            builder.append("\n JDK\u7c7b\u8def\u5f84: " + System.getProperty("java.class.path"));
            builder.append("\n JDK\u52a8\u6001\u5e93: " + System.getProperty("java.library.path"));
        }
        return builder;
    }

    final StringBuilder appendJVM(StringBuilder builder) {
        if (builder != null) {
            builder.append("\n");
            builder.append("\n ===================JVM info===================");
            builder.append("\n java.vm.vendor=").append(System.getProperty("java.vm.vendor"));
            builder.append("\n java.vm.name=").append(System.getProperty("java.vm.name"));
            builder.append("\n java.vm.version=").append(System.getProperty("java.vm.version"));
            builder.append("\n java.home=").append(System.getProperty("java.home"));
            builder.append("\n java.class.path=").append(System.getProperty("java.class.path"));
            builder.append("\n java.class.version=").append(System.getProperty("java.class.version"));
            builder.append("\n java.runtime.name=").append(System.getProperty("java.runtime.name"));
            builder.append("\n java.runtime.version=").append(System.getProperty("java.runtime.version"));
            builder.append("\n java.library.path=").append(System.getProperty("java.library.path"));
            builder.append("\n java.version=").append(System.getProperty("java.version"));
            builder.append("\n sun.arch.data.model=").append(System.getProperty("sun.arch.data.model"));
            builder.append("\n sun.os.patch.level=").append(System.getProperty("sun.os.patch.level"));
            builder.append("\n ");
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> inputArguments = null;
            if (runtimeMXBean != null) {
                inputArguments = runtimeMXBean.getInputArguments();
            }
            builder.append("\n JVM\u7248\u672c: " + System.getProperty("java.vm.version"));
            builder.append("\n JVM\u540d\u79f0: " + System.getProperty("java.vm.name"));
            builder.append("\n JVM\u53c2\u6570: " + inputArguments);
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            if (memoryMXBean != null) {
                MemoryUsage nonHeapMemoryUsage;
                MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
                if (heapMemoryUsage != null) {
                    builder.append("\n HeapMemoryUsage:");
                    builder.append(" init = ").append(heapMemoryUsage.getInit() >> 20).append("M");
                    builder.append(" used = ").append(heapMemoryUsage.getUsed() >> 20).append("M");
                    builder.append(" committed = ").append(heapMemoryUsage.getCommitted() >> 20).append("M");
                    builder.append(" max = ").append(heapMemoryUsage.getMax() >> 20).append("M");
                }
                if ((nonHeapMemoryUsage = memoryMXBean.getNonHeapMemoryUsage()) != null) {
                    builder.append("\n NonHeapMemoryUsage:");
                    builder.append(" init = ").append(nonHeapMemoryUsage.getInit() >> 20).append("M");
                    builder.append(" used = ").append(nonHeapMemoryUsage.getUsed() >> 20).append("M");
                    builder.append(" committed = ").append(nonHeapMemoryUsage.getCommitted() >> 20).append("M");
                    builder.append(" max = ").append(nonHeapMemoryUsage.getMax() >> 20).append("M");
                }
            }
        }
        return builder;
    }

    final StringBuilder appendME(StringBuilder builder) {
        if (builder != null) {
            builder.append("\n");
            builder.append("\n ===================TimestampAPI info===================");
            builder.append("\n \u5e94\u7528\u5382\u5546: China Financial Certification Authority");
            builder.append("\n \u5e94\u7528\u540d\u79f0: TimestampAPI Standard");
            builder.append("\n \u5e94\u7528\u7248\u672c: v4.2.1.0-201904");
        }
        return builder;
    }

    public final String buildEnvironments() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n\n");
        this.appendOS(builder);
        this.appendJDK(builder);
        this.appendJVM(builder);
        this.appendME(builder);
        builder.append("\n\n");
        return builder.toString();
    }

    public final void addSM2Provider() {
        TscLogging.ENVIRONMENT_LOGGER.info("addSM2Provider");
        Security.addProvider((Provider)SM2Provider.BC);
        Security.addProvider((Provider)SM2Provider.JSSE);
        TscLogging.ENVIRONMENT_LOGGER.info("addSM2Provider");
    }

    private static class SM2Provider {
        private static final BouncyCastleProvider BC = new BouncyCastleProvider();
        private static final JSSEProvider JSSE = new JSSEProvider();

        private SM2Provider() {
        }
    }

    private static class Holder {
        private static final Environments INSTANCE = new Environments();

        private Holder() {
        }
    }
}

