/*
 * Decompiled with CFR 0.152.
 */
package asposewobfuscated;

import asposewobfuscated.zz6G;
import asposewobfuscated.zz9X;
import java.io.IOException;

public class zz9Z
extends zz9X {
    private byte[] zzkE;
    private int zzkD;
    private int _position;
    private int _length;
    private int _capacity;
    private boolean zzkC;
    private boolean zzkB;
    private boolean zzkA;
    private boolean zzkz;

    public zz9Z() {
        this(0);
    }

    public zz9Z(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity");
        }
        this.zzkE = new byte[n];
        this._capacity = n;
        this.zzkC = true;
        this.zzkB = true;
        this.zzkA = true;
        this.zzkD = 0;
        this.zzkz = true;
    }

    public zz9Z(byte[] byArray) {
        this(byArray, true);
    }

    public zz9Z(byte[] byArray, boolean bl) {
        if (byArray == null) {
            throw new NullPointerException("buffer");
        }
        this.zzkE = byArray;
        this._length = this._capacity = byArray.length;
        this.zzkB = bl;
        this.zzkA = false;
        this.zzkD = 0;
        this.zzkz = true;
    }

    public zz9Z(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, true, false);
    }

    public zz9Z(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        if (byArray == null) {
            throw new NullPointerException("buffer");
        }
        if (n < 0) {
            throw new IllegalArgumentException("index");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("count");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("The buffer length minus index is less than count.");
        }
        this.zzkE = byArray;
        this.zzkD = this._position = n;
        this._length = this._capacity = n + n2;
        this.zzkB = bl;
        this.zzkA = bl2;
        this.zzkC = false;
        this.zzkz = true;
    }

    @Override
    public boolean zzGM() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return this.zzkB;
    }

    @Override
    public void dispose() throws IOException {
        this.close();
    }

    @Override
    public void close() throws IOException {
        this.zzkz = false;
        this.zzkB = false;
        this.zzkC = false;
    }

    public void zzz2() throws IOException {
        this.zzkz = true;
        this.zzkB = true;
        this.zzkC = true;
    }

    @Override
    public void flush() throws Exception {
    }

    private boolean zzTG(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("value");
        }
        if (n > this._capacity) {
            int n2 = n;
            if (n2 < 256) {
                n2 = 256;
            }
            if (n2 < this._capacity << 1) {
                n2 = this._capacity << 1;
            }
            this.zzTF(n2);
            return true;
        }
        return false;
    }

    public byte[] getBuffer() {
        if (!this.zzkA) {
            throw new UnsupportedOperationException("UnauthorizedAccess_MemStreamBuffer");
        }
        return this.zzkE;
    }

    public void zzTF(int n) throws IOException {
        if (!this.zzkz) {
            this.zzz1();
        }
        if (n != this._capacity) {
            if (!this.zzkC) {
                throw new UnsupportedOperationException("This stream is not expandable.");
            }
            if (n < this._length) {
                throw new IllegalArgumentException("capacity");
            }
            if (n > 0) {
                byte[] byArray = new byte[n];
                if (this._length > 0) {
                    System.arraycopy(this.zzkE, 0, byArray, 0, this._length);
                }
                this.zzkE = byArray;
            } else {
                this.zzkE = null;
            }
            this._capacity = n;
        }
    }

    @Override
    public long getLength() throws IOException {
        if (!this.zzkz) {
            this.zzz1();
        }
        return this._length - this.zzkD;
    }

    @Override
    public long getPosition() throws IOException {
        if (!this.zzkz) {
            this.zzz1();
        }
        return this._position - this.zzkD;
    }

    @Override
    public void zzZH(long l) throws IOException {
        if (!this.zzkz) {
            this.zzz1();
        }
        if (l < 0L) {
            throw new IllegalArgumentException("length = " + l);
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("length = " + l);
        }
        this._position = this.zzkD + (int)l;
    }

    @Override
    public long zzU(long l, int n) throws IOException {
        switch (n) {
            case 0: {
                this.zzZH(l);
                break;
            }
            case 1: {
                this.zzZH(this.getPosition() + l);
                break;
            }
            case 2: {
                this.zzZH(this.getLength() + l);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown SeekOrigin type.");
            }
        }
        assert (this._position >= 0);
        return this._position;
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        if (!this.zzkz) {
            this.zzz1();
        }
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        if (buffer.length - offset < count) {
            throw new IllegalArgumentException("The buffer length minus index is less than count.");
        }
        int n = this._length - this._position;
        if (n > count) {
            n = count;
        }
        if (n <= 0) {
            return 0;
        }
        assert (this._position + n >= 0) : "_position + n >= 0";
        if (n <= 8) {
            int n2 = n;
            while (--n2 >= 0) {
                buffer[offset + n2] = this.zzkE[this._position + n2];
            }
        } else {
            System.arraycopy(this.zzkE, this._position, buffer, offset, n);
        }
        this._position += n;
        return n;
    }

    @Override
    public int zzGN() throws IOException {
        if (!this.zzkz) {
            this.zzz1();
        }
        if (this._position >= this._length) {
            return -1;
        }
        return this.zzkE[this._position++] & 0xFF;
    }

    @Override
    public void setLength(long value) throws IOException {
        if (!this.zzkB) {
            this.zzz0();
        }
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("value");
        }
        if (value < 0L || value > (long)(Integer.MAX_VALUE - this.zzkD)) {
            throw new IllegalArgumentException("value");
        }
        int n = this.zzkD + (int)value;
        boolean bl = this.zzTG(n);
        if (!bl && n > this._length) {
            zz6G.fill(this.zzkE, this._length, n - this._length, (byte)0);
        }
        this._length = n;
        if (this._position > n) {
            this._position = n;
        }
    }

    public byte[] toArray() {
        byte[] byArray = new byte[this._length - this.zzkD];
        System.arraycopy(this.zzkE, this.zzkD, byArray, 0, this._length - this.zzkD);
        return byArray;
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        int n;
        if (!this.zzkz) {
            this.zzz1();
        }
        if (!this.zzkB) {
            this.zzz0();
        }
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        if (buffer.length - offset < count) {
            throw new IllegalArgumentException("Argument_InvalidOffLen");
        }
        int n2 = this._position + count;
        if (n2 < 0) {
            throw new IOException("StreamTooLong");
        }
        if (n2 > this._length) {
            boolean bl;
            int n3 = n = this._position > this._length ? 1 : 0;
            if (n2 > this._capacity && (bl = this.zzTG(n2))) {
                n = 0;
            }
            if (n != 0) {
                zz6G.fill(this.zzkE, this._length, n2 - this._length, (byte)0);
            }
            this._length = n2;
        }
        if (count <= 8) {
            n = count;
            while (--n >= 0) {
                this.zzkE[this._position + n] = buffer[offset + n];
            }
        } else {
            System.arraycopy(buffer, offset, this.zzkE, this._position, count);
        }
        this._position = n2;
    }

    @Override
    public void writeByte(byte value) throws IOException {
        if (!this.zzkz) {
            this.zzz1();
        }
        if (!this.zzkB) {
            this.zzz0();
        }
        if (this._position >= this._length) {
            boolean bl;
            boolean bl2;
            int n = this._position + 1;
            boolean bl3 = bl2 = this._position > this._length;
            if (n >= this._capacity && (bl = this.zzTG(n))) {
                bl2 = false;
            }
            if (bl2) {
                zz6G.zzI(this.zzkE, this._length, this._position - this._length);
            }
            this._length = n;
        }
        this.zzkE[this._position++] = value;
    }

    public void zz7(zz9X zz9X2) throws Exception {
        if (!this.zzkz) {
            this.zzz1();
        }
        if (zz9X2 == null) {
            throw new IllegalArgumentException("stream");
        }
        zz9X2.write(this.zzkE, this.zzkD, this._length - this.zzkD);
    }

    private void zzz1() throws IOException {
        throw new IOException("The stream is closed.");
    }

    private void zzz0() {
        throw new UnsupportedOperationException("The stream does not support write operations.");
    }

    public String toString() {
        return zz6G.zzF(this.zzkE, this.zzkD, this._length);
    }
}

