/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table;

import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import java.io.IOException;
import java.io.OutputStream;

public abstract class FontDataTable {
    protected ReadableFontData data;

    FontDataTable(ReadableFontData data) {
        this.data = data;
    }

    public ReadableFontData readFontData() {
        return this.data;
    }

    public String toString() {
        return this.data.toString();
    }

    public final int dataLength() {
        return this.data.length();
    }

    public int serialize(OutputStream os) throws IOException {
        return this.data.copyTo(os);
    }

    protected int serialize(WritableFontData data) {
        return this.data.copyTo(data);
    }

    public static abstract class Builder<T extends FontDataTable> {
        private WritableFontData wData;
        private ReadableFontData rData;
        private boolean modelChanged;
        private boolean containedModelChanged;
        private boolean dataChanged;

        protected Builder(int dataSize) {
            this.wData = WritableFontData.createWritableFontData(dataSize);
        }

        protected Builder(WritableFontData data) {
            this.wData = data;
        }

        protected Builder(ReadableFontData data) {
            this.rData = data;
        }

        public WritableFontData data() {
            WritableFontData newData;
            if (this.modelChanged) {
                if (!this.subReadyToSerialize()) {
                    throw new RuntimeException("Table not ready to build.");
                }
                int size = this.subDataSizeToSerialize();
                newData = WritableFontData.createWritableFontData(size);
                this.subSerialize(newData);
            } else {
                ReadableFontData data = this.internalReadData();
                newData = WritableFontData.createWritableFontData(data != null ? data.length() : 0);
                if (data != null) {
                    data.copyTo(newData);
                }
            }
            return newData;
        }

        public void setData(WritableFontData data) {
            this.internalSetData(data, true);
        }

        public void setData(ReadableFontData data) {
            this.internalSetData(data, true);
        }

        private void internalSetData(WritableFontData data, boolean dataChanged) {
            this.wData = data;
            this.rData = null;
            if (dataChanged) {
                this.dataChanged = true;
                this.subDataSet();
            }
        }

        private void internalSetData(ReadableFontData data, boolean dataChanged) {
            this.rData = data;
            this.wData = null;
            if (dataChanged) {
                this.dataChanged = true;
                this.subDataSet();
            }
        }

        public T build() {
            T table = null;
            ReadableFontData data = this.internalReadData();
            if (this.modelChanged) {
                if (!this.subReadyToSerialize()) {
                    return null;
                }
                int size = this.subDataSizeToSerialize();
                WritableFontData newData = WritableFontData.createWritableFontData(size);
                this.subSerialize(newData);
                data = newData;
            }
            if (data != null) {
                table = this.subBuildTable(data);
                this.notifyPostTableBuild(table);
            }
            this.rData = null;
            this.wData = null;
            return table;
        }

        public boolean readyToBuild() {
            return true;
        }

        protected ReadableFontData internalReadData() {
            if (this.rData != null) {
                return this.rData;
            }
            return this.wData;
        }

        protected WritableFontData internalWriteData() {
            if (this.wData == null) {
                WritableFontData newData = WritableFontData.createWritableFontData(this.rData == null ? 0 : this.rData.length());
                if (this.rData != null) {
                    this.rData.copyTo(newData);
                }
                this.internalSetData(newData, false);
            }
            return this.wData;
        }

        public boolean changed() {
            return this.dataChanged() || this.modelChanged();
        }

        protected boolean dataChanged() {
            return this.dataChanged;
        }

        protected boolean modelChanged() {
            return this.currentModelChanged() || this.containedModelChanged();
        }

        protected boolean currentModelChanged() {
            return this.modelChanged;
        }

        protected boolean containedModelChanged() {
            return this.containedModelChanged;
        }

        protected boolean setModelChanged() {
            return this.setModelChanged(true);
        }

        protected boolean setModelChanged(boolean changed) {
            boolean old = this.modelChanged;
            this.modelChanged = changed;
            return old;
        }

        protected void notifyPostTableBuild(T table) {
        }

        protected abstract int subSerialize(WritableFontData var1);

        protected abstract boolean subReadyToSerialize();

        protected abstract int subDataSizeToSerialize();

        protected abstract void subDataSet();

        protected abstract T subBuildTable(ReadableFontData var1);
    }
}

