/*
 * Decompiled with CFR 0.152.
 */
package cfca.integration.uarc.font.scale;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import sun.font.FontDesignMetrics;

public class SingleFontImage {
    private char ch;
    private Font font;
    private Color color;
    private float alpha;

    public SingleFontImage(Font font, char ch, Color color, float alpha) {
        this.font = font;
        this.ch = ch;
        this.color = color;
        this.alpha = alpha;
    }

    public void createBufferedImage(OutputStream os) throws FontFormatException, IOException {
        FontDesignMetrics fm = FontDesignMetrics.getMetrics(this.font);
        boolean isChinese = false;
        char tmp = this.ch;
        int charWidth = ((FontMetrics)fm).charWidth(this.ch);
        int charHeight = ((FontMetrics)fm).getHeight();
        int ascent = ((FontMetrics)fm).getAscent();
        int descent = ((FontMetrics)fm).getDescent();
        int leading = ((FontMetrics)fm).getLeading();
        BufferedImage bim = new BufferedImage(charWidth, charHeight, 2);
        Graphics2D g2d = bim.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(this.font);
        g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        g2d.setColor(this.color);
        String text = String.valueOf(this.ch);
        g2d.drawString(text, 0, charHeight - descent - leading);
        g2d.setComposite(AlphaComposite.getInstance(3));
        g2d.dispose();
        ImageIO.write((RenderedImage)bim, "png", os);
    }

    public void scaleBufferedImage(InputStream is, OutputStream os, int width, int height) throws IOException {
        BufferedImage bi = ImageIO.read(is);
        Image tempImage = bi.getScaledInstance(width, height, 4);
        double wr = 0.0;
        double hr = 0.0;
        wr = (double)width * 1.0 / (double)bi.getWidth();
        hr = (double)height * 1.0 / (double)bi.getHeight();
        AffineTransformOp ato = new AffineTransformOp(AffineTransform.getScaleInstance(wr, hr), null);
        tempImage = ato.filter(bi, null);
        ImageIO.write((RenderedImage)((BufferedImage)tempImage), "png", os);
    }

    public static void main(String[] args) throws FontFormatException, IOException {
        Font font = Font.createFont(0, new File("TestData/simfang.ttf"));
        font = font.deriveFont(0, 100.0f);
        SingleFontImage sfi = new SingleFontImage(font, '\u4e13', Color.RED, 1.0f);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        sfi.createBufferedImage(baos);
        byte[] imageBytes = baos.toByteArray();
        FileOutputStream fos = new FileOutputStream("TestData/single_font_image.png");
        fos.write(imageBytes);
        fos.close();
        fos = new FileOutputStream("TestData/scale_font_image.png");
        sfi.scaleBufferedImage(new ByteArrayInputStream(imageBytes), fos, 70, 100);
    }
}

