/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.util;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.ofd.base.config.SignInfoConfig;
import cfca.sadk.ofd.base.util.AbstractSigner;
import cfca.sadk.ofd.base.util.SignResultInfo;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.PrivateKey;

public class DefaultSigner
extends AbstractSigner {
    @Override
    public SignResultInfo p1Sign(SignInfoConfig signInfo, byte[] hashValue) throws PKIException {
        SignResultInfo signResult = new SignResultInfo();
        Signature signature = new Signature(false);
        PrivateKey priKey = signInfo.getPrivateKey();
        if (null == priKey) {
            throw new IllegalArgumentException("privateKey is null!");
        }
        X509Cert signCert = signInfo.getSignCert();
        Mechanism signAlg = signInfo.getSignAlg();
        Session session = BCSoftLib.INSTANCE();
        byte[] signedValue = signature.p1SignByHash(signAlg.getMechanismType(), hashValue, priKey, session);
        boolean verifyResult = signature.p1VerifyByHash(signAlg.getMechanismType(), hashValue, signedValue, signCert.getPublicKey(), session);
        if (!verifyResult) {
            signResult.setSignResult(false);
            signResult.setFailReason("SignCert is not match PrivateKey!");
        } else {
            signResult.setSignData(signedValue);
            signResult.setSignResult(true);
        }
        return signResult;
    }
}

