/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.pdfa.checker;

import cfca.sadk.com.itextpdf.io.color.IccProfile;
import cfca.sadk.com.itextpdf.io.image.ImageDataFactory;
import cfca.sadk.com.itextpdf.io.image.Jpeg2000ImageData;
import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.color.PatternColor;
import cfca.sadk.com.itextpdf.kernel.font.PdfTrueTypeFont;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfBoolean;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfIndirectReference;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import cfca.sadk.com.itextpdf.kernel.pdf.colorspace.PdfCieBasedCs;
import cfca.sadk.com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import cfca.sadk.com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import cfca.sadk.com.itextpdf.kernel.pdf.colorspace.PdfPattern;
import cfca.sadk.com.itextpdf.kernel.pdf.colorspace.PdfSpecialCs;
import cfca.sadk.com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import cfca.sadk.com.itextpdf.pdfa.PdfAConformanceException;
import cfca.sadk.com.itextpdf.pdfa.checker.PdfA1Checker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PdfA2Checker
extends PdfA1Checker {
    protected static final Set<PdfName> forbiddenAnnotations = new HashSet<PdfName>(Arrays.asList(PdfName._3D, PdfName.Sound, PdfName.Screen, PdfName.Movie));
    protected static final Set<PdfName> forbiddenActions = new HashSet<PdfName>(Arrays.asList(PdfName.Launch, PdfName.Sound, PdfName.Movie, PdfName.ResetForm, PdfName.ImportData, PdfName.JavaScript, PdfName.Hide, PdfName.SetOCGState, PdfName.Rendition, PdfName.Trans, PdfName.GoTo3DView));
    protected static final Set<PdfName> allowedBlendModes = new HashSet<PdfName>(Arrays.asList(PdfName.Normal, PdfName.Compatible, PdfName.Multiply, PdfName.Screen, PdfName.Overlay, PdfName.Darken, PdfName.Lighten, PdfName.ColorDodge, PdfName.ColorBurn, PdfName.HardLight, PdfName.SoftLight, PdfName.Difference, PdfName.Exclusion, PdfName.Hue, PdfName.Saturation, PdfName.Color, PdfName.Luminosity));
    static final int MAX_PAGE_SIZE = 14400;
    static final int MIN_PAGE_SIZE = 3;
    private static final long serialVersionUID = -5937712517954260687L;
    private boolean transparencyIsUsed = false;
    private boolean currentFillCsIsIccBasedCMYK = false;
    private boolean currentStrokeCsIsIccBasedCMYK = false;
    private Map<PdfName, PdfArray> separationColorSpaces = new HashMap<PdfName, PdfArray>();

    public PdfA2Checker(PdfAConformanceLevel conformanceLevel) {
        super(conformanceLevel);
    }

    @Override
    public void checkInlineImage(PdfStream inlineImage, PdfDictionary currentColorSpaces) {
        PdfObject filter = inlineImage.get(PdfName.Filter);
        if (filter instanceof PdfName) {
            if (filter.equals(PdfName.LZWDecode)) {
                throw new PdfAConformanceException("lzwdecode filter is not permitted");
            }
            if (filter.equals(PdfName.Crypt)) {
                throw new PdfAConformanceException("Crypt filter is not permitted inline image");
            }
        } else if (filter instanceof PdfArray) {
            for (int i = 0; i < ((PdfArray)filter).size(); ++i) {
                PdfName f = ((PdfArray)filter).getAsName(i);
                if (f.equals(PdfName.LZWDecode)) {
                    throw new PdfAConformanceException("lzwdecode filter is not permitted");
                }
                if (!f.equals(PdfName.Crypt)) continue;
                throw new PdfAConformanceException("Crypt filter is not permitted inline image");
            }
        }
        this.checkImage(inlineImage, currentColorSpaces);
    }

    @Override
    public void checkColor(Color color, PdfDictionary currentColorSpaces, Boolean fill) {
        PdfPattern pattern;
        if (color instanceof PatternColor && (pattern = ((PatternColor)color).getPattern()) instanceof PdfPattern.Shading) {
            PdfDictionary shadingDictionary = ((PdfPattern.Shading)pattern).getShading();
            PdfObject colorSpace = shadingDictionary.get(PdfName.ColorSpace);
            this.checkColorSpace(PdfColorSpace.makeColorSpace(colorSpace), currentColorSpaces, true, true);
            final PdfDictionary extGStateDict = ((PdfDictionary)pattern.getPdfObject()).getAsDictionary(PdfName.ExtGState);
            CanvasGraphicsState gState = new CanvasGraphicsState(){
                {
                    this.updateFromExtGState(new PdfExtGState(extGStateDict));
                }
            };
            this.checkExtGState(gState);
        }
        this.checkColorSpace(color.getColorSpace(), currentColorSpaces, true, fill);
    }

    @Override
    public void checkColorSpace(PdfColorSpace colorSpace, PdfDictionary currentColorSpaces, boolean checkAlternate, Boolean fill) {
        byte[] iccBytes;
        if (fill != null) {
            if (fill.booleanValue()) {
                this.currentFillCsIsIccBasedCMYK = false;
            } else {
                this.currentStrokeCsIsIccBasedCMYK = false;
            }
        }
        if (colorSpace instanceof PdfSpecialCs.Separation) {
            PdfSpecialCs.Separation separation = (PdfSpecialCs.Separation)colorSpace;
            this.checkSeparationCS((PdfArray)separation.getPdfObject());
            if (checkAlternate) {
                this.checkColorSpace(separation.getBaseCs(), currentColorSpaces, false, fill);
            }
        } else if (colorSpace instanceof PdfSpecialCs.DeviceN) {
            PdfSpecialCs.DeviceN deviceN = (PdfSpecialCs.DeviceN)colorSpace;
            PdfDictionary attributes = ((PdfArray)deviceN.getPdfObject()).getAsDictionary(4);
            PdfDictionary colorants = attributes.getAsDictionary(PdfName.Colorants);
            if (colorants != null) {
                for (Map.Entry<PdfName, PdfObject> entry : colorants.entrySet()) {
                    PdfArray separation = (PdfArray)entry.getValue();
                    this.checkSeparationInsideDeviceN(separation, ((PdfArray)deviceN.getPdfObject()).get(2), ((PdfArray)deviceN.getPdfObject()).get(3).getIndirectReference());
                }
            }
            if (checkAlternate) {
                this.checkColorSpace(deviceN.getBaseCs(), currentColorSpaces, false, fill);
            }
        } else if (colorSpace instanceof PdfSpecialCs.Indexed) {
            if (checkAlternate) {
                this.checkColorSpace(((PdfSpecialCs.Indexed)colorSpace).getBaseCs(), currentColorSpaces, true, fill);
            }
        } else if (colorSpace instanceof PdfSpecialCs.UncoloredTilingPattern) {
            if (checkAlternate) {
                this.checkColorSpace(((PdfSpecialCs.UncoloredTilingPattern)colorSpace).getUnderlyingColorSpace(), currentColorSpaces, true, fill);
            }
        } else if (colorSpace instanceof PdfDeviceCs.Rgb) {
            if (!this.checkDefaultCS(currentColorSpaces, fill, PdfName.DefaultRGB, 3)) {
                this.rgbIsUsed = true;
            }
        } else if (colorSpace instanceof PdfDeviceCs.Cmyk) {
            if (!this.checkDefaultCS(currentColorSpaces, fill, PdfName.DefaultCMYK, 4)) {
                this.cmykIsUsed = true;
            }
        } else if (colorSpace instanceof PdfDeviceCs.Gray && !this.checkDefaultCS(currentColorSpaces, fill, PdfName.DefaultGray, 1)) {
            this.grayIsUsed = true;
        }
        if (fill != null && colorSpace instanceof PdfCieBasedCs.IccBased && "CMYK".equals(IccProfile.getIccColorSpaceName(iccBytes = ((PdfArray)colorSpace.getPdfObject()).getAsStream(1).getBytes()))) {
            if (fill.booleanValue()) {
                this.currentFillCsIsIccBasedCMYK = true;
            } else {
                this.currentStrokeCsIsIccBasedCMYK = true;
            }
        }
    }

    @Override
    public void checkExtGState(CanvasGraphicsState extGState) {
        PdfObject bm;
        if (Integer.valueOf(1).equals(extGState.getOverprintMode())) {
            if (extGState.getFillOverprint() && this.currentFillCsIsIccBasedCMYK) {
                throw new PdfAConformanceException("Overprint mode shall not be one when an ICCBased CMYK colour space is used and when overprinting is set to true");
            }
            if (extGState.getStrokeOverprint() && this.currentStrokeCsIsIccBasedCMYK) {
                throw new PdfAConformanceException("Overprint mode shall not be one when an ICCBased CMYK colour space is used and when overprinting is set to true");
            }
        }
        if (extGState.getTransferFunction() != null) {
            throw new PdfAConformanceException("An extgstate dictionary shall not contain the tr key");
        }
        if (extGState.getHTP() != null) {
            throw new PdfAConformanceException("An extgstate dictionary shall not contain the HTP key");
        }
        PdfObject transferFunction2 = extGState.getTransferFunction2();
        if (transferFunction2 != null && !PdfName.Default.equals(transferFunction2)) {
            throw new PdfAConformanceException("An extgstate dictionary shall not contain the TR2 key with a value other than default");
        }
        if (extGState.getHalftone() instanceof PdfDictionary) {
            PdfDictionary halftoneDict = (PdfDictionary)extGState.getHalftone();
            Integer halftoneType = halftoneDict.getAsInt(PdfName.HalftoneType);
            if (halftoneType != 1 && halftoneType != 5) {
                throw new PdfAConformanceException("All halftones shall have halftonetype 1 or 5");
            }
            if (halftoneDict.containsKey(PdfName.HalftoneName)) {
                throw new PdfAConformanceException("Halftones shall not contain halftonename");
            }
        }
        this.checkRenderingIntent(extGState.getRenderingIntent());
        if (extGState.getSoftMask() != null && extGState.getSoftMask() instanceof PdfDictionary) {
            this.transparencyIsUsed = true;
        }
        if (extGState.getStrokeOpacity() < 1.0f) {
            this.transparencyIsUsed = true;
        }
        if (extGState.getFillOpacity() < 1.0f) {
            this.transparencyIsUsed = true;
        }
        if ((bm = extGState.getBlendMode()) != null) {
            if (!PdfName.Normal.equals(bm)) {
                this.transparencyIsUsed = true;
            }
            if (bm instanceof PdfArray) {
                for (PdfObject b : (PdfArray)bm) {
                    this.checkBlendMode((PdfName)b);
                }
            } else if (bm instanceof PdfName) {
                this.checkBlendMode((PdfName)bm);
            }
        }
    }

    @Override
    protected void checkNonSymbolicTrueTypeFont(PdfTrueTypeFont trueTypeFont) {
        String encoding = trueTypeFont.getFontEncoding().getBaseEncoding();
        if (!"Cp1252".equals(encoding) && !encoding.equals("MacRoman")) {
            throw new PdfAConformanceException("All non-symbolic TrueType fonts shall specify MacRomanEncoding or WinAnsiEncoding as the value of the Encoding entry in the font dictionary ", trueTypeFont);
        }
    }

    @Override
    protected double getMaxRealValue() {
        return 3.4028234663852886E38;
    }

    @Override
    protected int getMaxStringLength() {
        return Short.MAX_VALUE;
    }

    @Override
    protected void checkAnnotation(PdfDictionary annotDic) {
        PdfName subtype = annotDic.getAsName(PdfName.Subtype);
        if (subtype == null) {
            throw new PdfAConformanceException("Annotation type 1 is not permitted").setMessageParams("null");
        }
        if (forbiddenAnnotations.contains(subtype)) {
            throw new PdfAConformanceException("Annotation type 1 is not permitted").setMessageParams(subtype.getValue());
        }
        if (!subtype.equals(PdfName.Popup)) {
            PdfNumber f = annotDic.getAsNumber(PdfName.F);
            if (f == null) {
                throw new PdfAConformanceException("An annotation dictionary shall contain the f key");
            }
            int flags = f.intValue();
            if (!PdfA2Checker.checkFlag(flags, 4) || PdfA2Checker.checkFlag(flags, 2) || PdfA2Checker.checkFlag(flags, 1) || PdfA2Checker.checkFlag(flags, 32) || PdfA2Checker.checkFlag(flags, 256)) {
                throw new PdfAConformanceException("The f keys print flag bit shall be set to 1 and its hidden invisible noview and togglenoview flag bits shall be set to 0");
            }
            if (!(!subtype.equals(PdfName.Text) || PdfA2Checker.checkFlag(flags, 8) && PdfA2Checker.checkFlag(flags, 16))) {
                throw new PdfAConformanceException("Text annotations should set the nozoom and norotate flag bits of the f key to 1");
            }
        }
        if (PdfName.Widget.equals(subtype) && (annotDic.containsKey(PdfName.AA) || annotDic.containsKey(PdfName.A))) {
            throw new PdfAConformanceException("Widget annotation dictionary or field dictionary shall not include a or aa entry");
        }
        if (annotDic.containsKey(PdfName.AA)) {
            throw new PdfAConformanceException("An annotation dictionary shall not contain aa key");
        }
        if (PdfA2Checker.checkStructure(this.conformanceLevel) && contentAnnotations.contains(subtype) && !annotDic.containsKey(PdfName.Contents)) {
            throw new PdfAConformanceException("Annotation of type 1 should have contents key").setMessageParams(subtype);
        }
        PdfDictionary ap = annotDic.getAsDictionary(PdfName.AP);
        if (ap != null) {
            if (ap.containsKey(PdfName.R) || ap.containsKey(PdfName.D)) {
                throw new PdfAConformanceException("Appearance dictionary shall contain only the n key with stream value");
            }
            PdfObject n = ap.get(PdfName.N);
            if (PdfName.Widget.equals(subtype) && PdfName.Btn.equals(annotDic.getAsName(PdfName.FT))) {
                if (n == null || !n.isDictionary()) {
                    throw new PdfAConformanceException("Appearance dictionary of widget subtype and btn field type shall contain only the n key with dictionary value");
                }
            } else if (n == null || !n.isStream()) {
                throw new PdfAConformanceException("Appearance dictionary shall contain only the n key with stream value");
            }
            this.checkResourcesOfAppearanceStreams(ap);
        } else {
            boolean isCorrectRect = false;
            PdfArray rect = annotDic.getAsArray(PdfName.Rect);
            if (rect != null && rect.size() == 4) {
                PdfNumber index0 = rect.getAsNumber(0);
                PdfNumber index1 = rect.getAsNumber(1);
                PdfNumber index2 = rect.getAsNumber(2);
                PdfNumber index3 = rect.getAsNumber(3);
                if (index0 != null && index1 != null && index2 != null && index3 != null && index0.floatValue() == index2.floatValue() && index1.floatValue() == index3.floatValue()) {
                    isCorrectRect = true;
                }
            }
            if (!(PdfName.Popup.equals(subtype) || PdfName.Link.equals(subtype) || isCorrectRect)) {
                throw new PdfAConformanceException("Every annotation shall have at least one appearance dictionary");
            }
        }
    }

    @Override
    protected void checkForm(PdfDictionary form) {
        if (form != null) {
            PdfBoolean needAppearances = form.getAsBoolean(PdfName.NeedAppearances);
            if (needAppearances != null && needAppearances.getValue()) {
                throw new PdfAConformanceException("Needappearances flag of the interactive form dictionary shall either not be presented or shall be false");
            }
            if (form.containsKey(PdfName.XFA)) {
                throw new PdfAConformanceException("The interactive form dictionary shall not contain the xfa key");
            }
            this.checkResources(form.getAsDictionary(PdfName.DR));
            PdfArray fields = form.getAsArray(PdfName.Fields);
            if (fields != null) {
                fields = this.getFormFields(fields);
                for (PdfObject field : fields) {
                    PdfDictionary fieldDic = (PdfDictionary)field;
                    this.checkResources(fieldDic.getAsDictionary(PdfName.DR));
                }
            }
        }
    }

    @Override
    protected void checkCatalogValidEntries(PdfDictionary catalogDict) {
        PdfDictionary namesDictionary;
        if (catalogDict.containsKey(PdfName.NeedsRendering)) {
            throw new PdfAConformanceException("The catalog dictionary shall not contain the needsrendering key");
        }
        if (catalogDict.containsKey(PdfName.AA)) {
            throw new PdfAConformanceException("Catalog dictionary shall not contain aa entry");
        }
        if (catalogDict.containsKey(PdfName.Requirements)) {
            throw new PdfAConformanceException("Catalog dictionary shall not contain a requirements entry");
        }
        PdfDictionary permissions = catalogDict.getAsDictionary(PdfName.Perms);
        if (permissions != null) {
            for (PdfName dictKey : permissions.keySet()) {
                if (PdfName.DocMDP.equals(dictKey)) {
                    PdfArray references;
                    PdfDictionary signatureDict = permissions.getAsDictionary(PdfName.DocMDP);
                    if (signatureDict == null || (references = signatureDict.getAsArray(PdfName.Reference)) == null) continue;
                    for (int i = 0; i < references.size(); ++i) {
                        PdfDictionary referenceDict = references.getAsDictionary(i);
                        if (!referenceDict.containsKey(PdfName.DigestLocation) && !referenceDict.containsKey(PdfName.DigestMethod) && !referenceDict.containsKey(PdfName.DigestValue)) continue;
                        throw new PdfAConformanceException("Signature references dictionary shall not contain digestlocation digestmethod digestvalue");
                    }
                    continue;
                }
                if (PdfName.UR3.equals(dictKey)) continue;
                throw new PdfAConformanceException("No keys other than UR3 and DocMDP shall be present in a permissions dictionary");
            }
        }
        if ((namesDictionary = catalogDict.getAsDictionary(PdfName.Names)) != null && namesDictionary.containsKey(PdfName.AlternatePresentations)) {
            throw new PdfAConformanceException("Catalog dictionary shall not contain alternatepresentations names entry");
        }
        PdfDictionary oCProperties = catalogDict.getAsDictionary(PdfName.OCProperties);
        if (oCProperties != null) {
            PdfArray configs;
            ArrayList<PdfDictionary> configList = new ArrayList<PdfDictionary>();
            PdfDictionary d = oCProperties.getAsDictionary(PdfName.D);
            if (d != null) {
                configList.add(d);
            }
            if ((configs = oCProperties.getAsArray(PdfName.Configs)) != null) {
                for (PdfObject config : configs) {
                    configList.add((PdfDictionary)config);
                }
            }
            HashSet<PdfObject> ocgs = new HashSet<PdfObject>();
            PdfArray ocgsArray = oCProperties.getAsArray(PdfName.OCGs);
            if (ocgsArray != null) {
                for (PdfObject ocg : ocgsArray) {
                    ocgs.add(ocg);
                }
            }
            HashSet<String> names = new HashSet<String>();
            HashSet<PdfObject> order = new HashSet<PdfObject>();
            for (PdfDictionary config : configList) {
                PdfString name = config.getAsString(PdfName.Name);
                if (name == null) {
                    throw new PdfAConformanceException("Optional content configuration dictionary shall contain name entry");
                }
                if (!names.add(name.toUnicodeString())) {
                    throw new PdfAConformanceException("Value of name entry shall be unique among all optional content configuration dictionaries");
                }
                if (config.containsKey(PdfName.AS)) {
                    throw new PdfAConformanceException("The as key shall not appear in any optional content configuration dictionary");
                }
                PdfArray orderArray = config.getAsArray(PdfName.Order);
                if (orderArray == null) continue;
                this.fillOrderRecursively(orderArray, order);
            }
            if (order.size() != ocgs.size()) {
                throw new PdfAConformanceException("Order array shall contain references to all ocgs");
            }
            order.retainAll(ocgs);
            if (order.size() != ocgs.size()) {
                throw new PdfAConformanceException("Order array shall contain references to all ocgs");
            }
        }
    }

    @Override
    protected void checkPageSize(PdfDictionary page) {
        PdfName[] boxNames;
        for (PdfName boxName : boxNames = new PdfName[]{PdfName.MediaBox, PdfName.CropBox, PdfName.TrimBox, PdfName.ArtBox, PdfName.BleedBox}) {
            Rectangle box = page.getAsRectangle(boxName);
            if (box == null) continue;
            float width = box.getWidth();
            float height = box.getHeight();
            if (!(width < 3.0f || width > 14400.0f || height < 3.0f) && !(height > 14400.0f)) continue;
            throw new PdfAConformanceException("The page less 3 units no greater 14400 in either direction");
        }
    }

    @Override
    protected void checkFileSpec(PdfDictionary fileSpec) {
        if (fileSpec.containsKey(PdfName.EF)) {
            if (!(fileSpec.containsKey(PdfName.F) && fileSpec.containsKey(PdfName.UF) && fileSpec.containsKey(PdfName.Desc))) {
                throw new PdfAConformanceException("File specification dictionary shall contain f key uf key and desc key");
            }
            PdfDictionary ef = fileSpec.getAsDictionary(PdfName.EF);
            PdfStream embeddedFile = ef.getAsStream(PdfName.F);
            if (embeddedFile == null) {
                throw new PdfAConformanceException("Ef key of file specification dictionary shall contain dictionary with valid f key");
            }
            PdfName subtype = embeddedFile.getAsName(PdfName.Subtype);
            if (!PdfName.ApplicationPdf.equals(subtype)) {
                throw new PdfAConformanceException("Embedded file shall be of pdf mime type");
            }
        }
    }

    @Override
    protected void checkPdfStream(PdfStream stream) {
        if (stream.containsKey(PdfName.F) || stream.containsKey(PdfName.FFilter) || stream.containsKey(PdfName.FDecodeParams)) {
            throw new PdfAConformanceException("Stream object dictionary shall not contain the f ffilter or fdecodeparams keys");
        }
        PdfObject filter = stream.get(PdfName.Filter);
        if (filter instanceof PdfName) {
            PdfString cryptFilterName;
            PdfDictionary decodeParams;
            if (filter.equals(PdfName.LZWDecode)) {
                throw new PdfAConformanceException("lzwdecode filter is not permitted");
            }
            if (filter.equals(PdfName.Crypt) && (decodeParams = stream.getAsDictionary(PdfName.DecodeParms)) != null && (cryptFilterName = decodeParams.getAsString(PdfName.Name)) != null && !cryptFilterName.equals(PdfName.Identity)) {
                throw new PdfAConformanceException("Not identity crypt filter is not permitted");
            }
        } else if (filter instanceof PdfArray) {
            for (int i = 0; i < ((PdfArray)filter).size(); ++i) {
                PdfDictionary decodeParam;
                PdfString cryptFilterName;
                PdfArray decodeParams;
                PdfName f = ((PdfArray)filter).getAsName(i);
                if (f.equals(PdfName.LZWDecode)) {
                    throw new PdfAConformanceException("lzwdecode filter is not permitted");
                }
                if (!f.equals(PdfName.Crypt) || (decodeParams = stream.getAsArray(PdfName.DecodeParms)) == null || i >= decodeParams.size() || (cryptFilterName = (decodeParam = decodeParams.getAsDictionary(i)).getAsString(PdfName.Name)) == null || cryptFilterName.equals(PdfName.Identity)) continue;
                throw new PdfAConformanceException("Not identity crypt filter is not permitted");
            }
        }
    }

    @Override
    protected void checkPageObject(PdfDictionary pageDict, PdfDictionary pageResources) {
        if (pageDict.containsKey(PdfName.AA)) {
            throw new PdfAConformanceException("Page dictionary shall not contain aa entry");
        }
        if (pageDict.containsKey(PdfName.PresSteps)) {
            throw new PdfAConformanceException("Page dictionary shall not contain pressteps entry");
        }
        if (pageDict.containsKey(PdfName.Group) && PdfName.Transparency.equals(pageDict.getAsDictionary(PdfName.Group).getAsName(PdfName.S))) {
            this.transparencyIsUsed = true;
            PdfObject cs = pageDict.getAsDictionary(PdfName.Group).get(PdfName.CS);
            if (cs != null) {
                PdfDictionary currentColorSpaces = pageResources.getAsDictionary(PdfName.ColorSpace);
                this.checkColorSpace(PdfColorSpace.makeColorSpace(cs), currentColorSpaces, true, null);
            }
        }
    }

    @Override
    protected void checkOutputIntents(PdfDictionary catalog) {
        int i;
        PdfArray outputIntents = catalog.getAsArray(PdfName.OutputIntents);
        if (outputIntents == null) {
            return;
        }
        PdfObject destOutputProfile = null;
        for (i = 0; i < outputIntents.size() && destOutputProfile == null; ++i) {
            destOutputProfile = outputIntents.getAsDictionary(i).get(PdfName.DestOutputProfile);
        }
        while (i < outputIntents.size()) {
            PdfObject otherDestOutputProfile = outputIntents.getAsDictionary(i).get(PdfName.DestOutputProfile);
            if (otherDestOutputProfile != null && destOutputProfile != otherDestOutputProfile) {
                throw new PdfAConformanceException("If outputintents array has more than one entry with destoutputprofile key the same indirect object shall be used as the value of that object");
            }
            ++i;
        }
        if (destOutputProfile != null) {
            String deviceClass = IccProfile.getIccDeviceClass(((PdfStream)destOutputProfile).getBytes());
            if (!"prtr".equals(deviceClass) && !"mntr".equals(deviceClass)) {
                throw new PdfAConformanceException("Profile stream of outputintent shall be output profile (prtr) or monitor profile (mntr)");
            }
            String cs = IccProfile.getIccColorSpaceName(((PdfStream)destOutputProfile).getBytes());
            if (!("RGB ".equals(cs) || "CMYK".equals(cs) || "GRAY".equals(cs))) {
                throw new PdfAConformanceException("Output intent color space shall be either gray rgb or cmyk");
            }
        }
    }

    @Override
    protected Set<PdfName> getForbiddenActions() {
        return forbiddenActions;
    }

    @Override
    protected Set<PdfName> getAllowedNamedActions() {
        return allowedNamedActions;
    }

    @Override
    protected void checkColorsUsages() {
        if (this.transparencyIsUsed && this.pdfAOutputIntentColorSpace == null) {
            throw new PdfAConformanceException("If the document does not contain a pdfa outputintent transparency is forbidden");
        }
        if ((this.rgbIsUsed || this.cmykIsUsed || this.grayIsUsed) && this.pdfAOutputIntentColorSpace == null) {
            throw new PdfAConformanceException("If device rgb cmyk gray used in file that file shall contain pdfa outputintent orDefaultRgb Cmyk Gray in usage context");
        }
        if (this.rgbIsUsed && !"RGB ".equals(this.pdfAOutputIntentColorSpace)) {
            throw new PdfAConformanceException("Devicergb may be used only if the file has a rgb pdfa outputIntent or defaultrgb in usage context");
        }
        if (this.cmykIsUsed && !"CMYK".equals(this.pdfAOutputIntentColorSpace)) {
            throw new PdfAConformanceException("Devicecmyk may be used only if the file has a cmyk pdfa outputIntent or defaultcmyk in usage context");
        }
    }

    @Override
    protected void checkImage(PdfStream image, PdfDictionary currentColorSpaces) {
        PdfColorSpace colorSpace = null;
        if (this.isAlreadyChecked(image)) {
            colorSpace = (PdfColorSpace)this.checkedObjectsColorspace.get(image);
            this.checkColorSpace(colorSpace, currentColorSpaces, true, null);
            return;
        }
        PdfObject colorSpaceObj = image.get(PdfName.ColorSpace);
        if (colorSpaceObj != null) {
            colorSpace = PdfColorSpace.makeColorSpace(colorSpaceObj);
            this.checkColorSpace(colorSpace, currentColorSpaces, true, null);
            this.checkedObjectsColorspace.put(image, colorSpace);
        }
        if (image.containsKey(PdfName.Alternates)) {
            throw new PdfAConformanceException("An image dictionary shall not contain alternates key");
        }
        if (image.containsKey(PdfName.OPI)) {
            throw new PdfAConformanceException("An image dictionary shall not contain opi key");
        }
        if (image.containsKey(PdfName.Interpolate) && image.getAsBool(PdfName.Interpolate).booleanValue()) {
            throw new PdfAConformanceException("The value of interpolate key shall not be true");
        }
        this.checkRenderingIntent(image.getAsName(PdfName.Intent));
        if (image.getAsStream(PdfName.SMask) != null) {
            this.transparencyIsUsed = true;
        }
        if (image.containsKey(PdfName.SMaskInData) && image.getAsInt(PdfName.SMaskInData) > 0) {
            this.transparencyIsUsed = true;
        }
        if (PdfName.JPXDecode.equals(image.get(PdfName.Filter))) {
            Jpeg2000ImageData jpgImage = (Jpeg2000ImageData)ImageDataFactory.createJpeg2000(image.getBytes(false));
            Jpeg2000ImageData.Parameters params = jpgImage.getParameters();
            if (!params.isJp2) {
                throw new PdfAConformanceException("Only jpx baseline set of features shall be used");
            }
            if (params.numOfComps != 1 && params.numOfComps != 3 && params.numOfComps != 4) {
                throw new PdfAConformanceException("The number of colour channels in the jpeg2000 data shall be 123");
            }
            if (params.colorSpecBoxes != null && params.colorSpecBoxes.size() > 1) {
                int numOfApprox0x01 = 0;
                for (Jpeg2000ImageData.ColorSpecBox colorSpecBox : params.colorSpecBoxes) {
                    if (colorSpecBox.getApprox() == 1) {
                        if (++numOfApprox0x01 == 1 && colorSpecBox.getMeth() != 1 && colorSpecBox.getMeth() != 2 && colorSpecBox.getMeth() != 3) {
                            throw new PdfAConformanceException("The value of the meth entry in colr box shall be 123");
                        }
                        if (image.get(PdfName.ColorSpace) == null) {
                            switch (colorSpecBox.getEnumCs()) {
                                case 1: {
                                    PdfDeviceCs.Gray deviceGrayCs = new PdfDeviceCs.Gray();
                                    this.checkColorSpace(deviceGrayCs, currentColorSpaces, true, null);
                                    this.checkedObjectsColorspace.put(image, deviceGrayCs);
                                    break;
                                }
                                case 3: {
                                    PdfDeviceCs.Rgb deviceRgbCs = new PdfDeviceCs.Rgb();
                                    this.checkColorSpace(deviceRgbCs, currentColorSpaces, true, null);
                                    this.checkedObjectsColorspace.put(image, deviceRgbCs);
                                    break;
                                }
                                case 12: {
                                    PdfDeviceCs.Cmyk deviceCmykCs = new PdfDeviceCs.Cmyk();
                                    this.checkColorSpace(deviceCmykCs, currentColorSpaces, true, null);
                                    this.checkedObjectsColorspace.put(image, deviceCmykCs);
                                }
                            }
                        }
                    }
                    if (colorSpecBox.getEnumCs() != 19) continue;
                    throw new PdfAConformanceException("jpeg2000 enumerated colour space 19 (CIEJab) shall not be used");
                }
                if (numOfApprox0x01 != 1) {
                    throw new PdfAConformanceException("Exactly one colour space specification shall have the value 0x01 in the approx field");
                }
            }
            if (jpgImage.getBpc() < 1 || jpgImage.getBpc() > 38) {
                throw new PdfAConformanceException("The bit-depth of the jpeg2000 data shall have a value in the range 1to38");
            }
            if (params.bpcBoxData != null) {
                throw new PdfAConformanceException("All colour channels in the jpeg2000 data shall have the same bit-depth");
            }
        }
    }

    @Override
    protected void checkFormXObject(PdfStream form) {
        if (this.isAlreadyChecked(form)) {
            return;
        }
        if (form.containsKey(PdfName.OPI)) {
            throw new PdfAConformanceException("A form xobject dictionary shall not contain opi key");
        }
        if (form.containsKey(PdfName.PS)) {
            throw new PdfAConformanceException("A form xobject dictionary shall not contain PS key");
        }
        if (PdfName.PS.equals(form.getAsName(PdfName.Subtype2))) {
            throw new PdfAConformanceException("A form xobject dictionary shall not contain subtype2 key with a value of PS");
        }
        if (form.containsKey(PdfName.Group) && PdfName.Transparency.equals(form.getAsDictionary(PdfName.Group).getAsName(PdfName.S))) {
            this.transparencyIsUsed = true;
            PdfObject cs = form.getAsDictionary(PdfName.Group).get(PdfName.CS);
            PdfDictionary resources = form.getAsDictionary(PdfName.Resources);
            if (cs != null && resources != null) {
                PdfDictionary currentColorSpaces = resources.getAsDictionary(PdfName.ColorSpace);
                this.checkColorSpace(PdfColorSpace.makeColorSpace(cs), currentColorSpaces, true, null);
            }
        }
        this.checkResources(form.getAsDictionary(PdfName.Resources));
    }

    private void checkBlendMode(PdfName blendMode) {
        if (!allowedBlendModes.contains(blendMode)) {
            throw new PdfAConformanceException("Only standard blend modes shall be used for the value of the BM key in an extended graphic state dictionary");
        }
    }

    private void checkSeparationInsideDeviceN(PdfArray separation, PdfObject deviceNColorSpace, PdfIndirectReference deviceNTintTransform) {
        if (!this.isAltCSIsTheSame(separation.get(2), deviceNColorSpace) || !deviceNTintTransform.equals(separation.getAsDictionary(3).getIndirectReference())) {
            throw new PdfAConformanceException("TintTransform and alternateSpace of separation arrays in the colorants of deviceN shall be consistent with same attributes of deviceN");
        }
        this.checkSeparationCS(separation);
    }

    private void checkSeparationCS(PdfArray separation) {
        if (this.separationColorSpaces.containsKey(separation.getAsName(0))) {
            boolean altCSIsTheSame = false;
            boolean tintTransformIsTheSame = false;
            PdfArray sameNameSeparation = this.separationColorSpaces.get(separation.getAsName(0));
            PdfObject cs1 = separation.get(2);
            PdfObject cs2 = sameNameSeparation.get(2);
            altCSIsTheSame = this.isAltCSIsTheSame(cs1, cs2);
            PdfDictionary f1 = separation.getAsDictionary(3);
            PdfDictionary f2 = sameNameSeparation.getAsDictionary(3);
            tintTransformIsTheSame = f1.getIndirectReference().equals(f2.getIndirectReference());
            if (!altCSIsTheSame || !tintTransformIsTheSame) {
                throw new PdfAConformanceException("TintTransform and alternateSpace shall be the same for the all separation cs with the same name");
            }
        } else {
            this.separationColorSpaces.put(separation.getAsName(0), separation);
        }
    }

    private boolean isAltCSIsTheSame(PdfObject cs1, PdfObject cs2) {
        boolean altCSIsTheSame = false;
        if (cs1 instanceof PdfName) {
            altCSIsTheSame = cs1.equals(cs2);
        } else if (cs1 instanceof PdfArray && cs2 instanceof PdfArray) {
            altCSIsTheSame = ((PdfArray)cs1).get(0).equals(((PdfArray)cs1).get(0));
        }
        return altCSIsTheSame;
    }

    private void fillOrderRecursively(PdfArray orderArray, Set<PdfObject> order) {
        for (PdfObject orderItem : orderArray) {
            if (!orderItem.isArray()) {
                order.add(orderItem);
                continue;
            }
            this.fillOrderRecursively((PdfArray)orderItem, order);
        }
    }

    private boolean checkDefaultCS(PdfDictionary currentColorSpaces, Boolean fill, PdfName defaultCsName, int numOfComponents) {
        if (currentColorSpaces == null) {
            return false;
        }
        if (!currentColorSpaces.containsKey(defaultCsName)) {
            return false;
        }
        PdfObject defaultCsObj = currentColorSpaces.get(defaultCsName);
        PdfColorSpace defaultCs = PdfColorSpace.makeColorSpace(defaultCsObj);
        if (defaultCs instanceof PdfDeviceCs) {
            throw new PdfAConformanceException("Color space 1 shall be device independent").setMessageParams(defaultCsName.toString());
        }
        if (defaultCs.getNumberOfComponents() != numOfComponents) {
            throw new PdfAConformanceException("Color space 1 shall have 2 components").setMessageParams(defaultCsName.toString(), numOfComponents);
        }
        this.checkColorSpace(defaultCs, currentColorSpaces, false, fill);
        return true;
    }
}

