/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.java.security.CFCAAlgorithmConstraints;
import cfca.sadk.tls.javax.net.ssl.CFCAExtendedSSLSession;
import cfca.sadk.tls.javax.net.ssl.CFCASSLEngine;
import cfca.sadk.tls.javax.net.ssl.CFCASSLSocket;
import cfca.sadk.tls.javax.net.ssl.CFCAX509ExtendedTrustManager;
import cfca.sadk.tls.sun.security.provider.certpath.CFCAAlgorithmChecker;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.sec.SSLAlgorithmConstraints;
import cfca.sadk.tls.sun.security.util.CFCASSLHelper;
import java.net.Socket;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;

final class AbstractTrustManagerWrapper
extends CFCAX509ExtendedTrustManager
implements X509TrustManager {
    private final X509TrustManager tm;

    AbstractTrustManagerWrapper(X509TrustManager tm) {
        this.tm = tm;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType);
        this.checkAdditionalTrust(chain, authType, socket, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType);
        this.checkAdditionalTrust(chain, authType, socket, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, CFCASSLEngine engine) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType);
        this.checkAdditionalTrust(chain, authType, engine, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, CFCASSLEngine engine) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType);
        this.checkAdditionalTrust(chain, authType, engine, false);
    }

    private void checkAdditionalTrust(X509Certificate[] chain, String authType, Socket socket, boolean isClient) throws CertificateException {
        if (socket != null && socket.isConnected() && socket instanceof CFCASSLSocket) {
            CFCASSLSocket sslSocket = (CFCASSLSocket)socket;
            SSLSession session = sslSocket.getHandshakeSession();
            if (session == null) {
                throw new CertificateException("No handshake session");
            }
            String identityAlg = sslSocket.getCFCASSLParameters().getEndpointIdentificationAlgorithm();
            if (identityAlg != null && identityAlg.length() != 0) {
                String hostname = session.getPeerHost();
                CFCASSLHelper.checkIdentity(chain[0], identityAlg, hostname);
            }
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf(session.getProtocol());
            SSLAlgorithmConstraints constraints = null;
            if (protocolVersion.isStandardTLS12()) {
                if (session instanceof CFCAExtendedSSLSession) {
                    CFCAExtendedSSLSession extSession = (CFCAExtendedSSLSession)session;
                    String[] peerSupportedSignAlgs = extSession.getLocalSupportedSignatureAlgorithms();
                    constraints = new SSLAlgorithmConstraints(sslSocket, peerSupportedSignAlgs, true);
                } else {
                    constraints = new SSLAlgorithmConstraints(sslSocket, true);
                }
            } else {
                constraints = new SSLAlgorithmConstraints(sslSocket, true);
            }
            this.checkAlgorithmConstraints(chain, constraints);
        }
    }

    private void checkAdditionalTrust(X509Certificate[] chain, String authType, CFCASSLEngine engine, boolean isClient) throws CertificateException {
        if (engine != null) {
            SSLSession session = engine.getHandshakeSession();
            if (session == null) {
                throw new CertificateException("No handshake session");
            }
            String identityAlg = engine.getCFCASSLParameters().getEndpointIdentificationAlgorithm();
            if (identityAlg != null && identityAlg.length() != 0) {
                String hostname = session.getPeerHost();
                CFCASSLHelper.checkIdentity(chain[0], identityAlg, hostname);
            }
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf(session.getProtocol());
            SSLAlgorithmConstraints constraints = null;
            if (protocolVersion.isStandardTLS12()) {
                if (session instanceof CFCAExtendedSSLSession) {
                    CFCAExtendedSSLSession extSession = (CFCAExtendedSSLSession)session;
                    String[] peerSupportedSignAlgs = extSession.getLocalSupportedSignatureAlgorithms();
                    constraints = new SSLAlgorithmConstraints(engine, peerSupportedSignAlgs, true);
                } else {
                    constraints = new SSLAlgorithmConstraints(engine, true);
                }
            } else {
                constraints = new SSLAlgorithmConstraints(engine, true);
            }
            this.checkAlgorithmConstraints(chain, constraints);
        }
    }

    private void checkAlgorithmConstraints(X509Certificate[] chain, CFCAAlgorithmConstraints constraints) throws CertificateException {
        try {
            int checkedLength = chain.length - 1;
            HashSet trustedCerts = new HashSet();
            X509Certificate[] certs = this.tm.getAcceptedIssuers();
            if (certs != null && certs.length > 0) {
                Collections.addAll(trustedCerts, certs);
            }
            if (trustedCerts.contains(chain[checkedLength])) {
                --checkedLength;
            }
            if (checkedLength >= 0) {
                CFCAAlgorithmChecker checker = new CFCAAlgorithmChecker(constraints);
                checker.init(false);
                for (int i = checkedLength; i >= 0; --i) {
                    X509Certificate cert = chain[i];
                    checker.check(cert, Collections.<String>emptySet());
                }
            }
        }
        catch (CertPathValidatorException cpve) {
            throw new CertificateException("Certificates does not conform to algorithm constraints");
        }
    }
}

