/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf.security.pkcs7;

import cfca.com.itextpdf.text.pdf.security.pkcs7.PKCS7PackageFacade;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7AttachSourceFile;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.FastEncoding;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.BERSet;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DEROutputStream;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.pkcs.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public abstract class AbstractPKCS7Package {
    public static final ASN1Integer SIGNINFO_VERSION = new ASN1Integer(1L);
    public static final ASN1Integer SIGNEDDATA_VERSION = new ASN1Integer(1L);

    public static final byte[] packagePKCS7(Session session, byte[] pkcs7SignedData, byte[] p1Sig, Mechanism mechanism, byte[] timeStampPKCS7, DERSet derSet, X509Cert[] signerCerts) throws PKIException {
        DERSet unauthenticatedAttributes = null;
        if (timeStampPKCS7 != null) {
            ASN1InputStream tempstream = new ASN1InputStream((InputStream)new ByteArrayInputStream(timeStampPKCS7));
            ASN1EncodableVector unauthAttributes = new ASN1EncodableVector();
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            ASN1Sequence seq = null;
            try {
                seq = (ASN1Sequence)tempstream.readObject();
            }
            catch (IOException e) {
                throw new PKIException("packagePKCS7 failed", (Throwable)e);
            }
            v.add((ASN1Encodable)new DERSet((ASN1Encodable)seq));
            unauthAttributes.add((ASN1Encodable)new DERSequence(v));
            unauthenticatedAttributes = new DERSet(unauthAttributes);
        }
        return PKCS7PackageFacade.packageSignedData(false, null, null, p1Sig, mechanism, signerCerts, (ASN1Set)derSet, unauthenticatedAttributes);
    }

    public void packageSignedFile(String sourceFile, String signFileName, byte[] signature, Mechanism mechanism, X509Cert[] certs) throws PKIException {
        DEROutputStream dos = null;
        try {
            if (certs == null || certs[0] == null) {
                throw new PKIException(PKIException.NULL_ENCRYPT_CERTS_ERR, PKIException.NULL_ENCRYPT_CERTS_ERR_DES);
            }
            BigInteger sn = certs[0].getSerialNumber();
            X500Name issuer = certs[0].getIssuerX500Name();
            IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
            AlgorithmIdentifier digestAlgIdentifier = this.getDigestAlgIdentifier(mechanism);
            ASN1ObjectIdentifier signDataIdentifier = this.getSignDataIdentifier();
            ASN1Object signerInfo = this.getSignerInfo(signature, issuerAndSn, mechanism);
            ContentInfo contentInfo = this.getContentInfo(null, sourceFile);
            ASN1EncodableVector derV = new ASN1EncodableVector();
            derV.add((ASN1Encodable)digestAlgIdentifier);
            BERSet digestAlgorithmSets = new BERSet(derV);
            derV = new ASN1EncodableVector();
            derV.add((ASN1Encodable)signerInfo);
            DERSet signerInfos = new DERSet(derV);
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i < certs.length; ++i) {
                v.add((ASN1Encodable)new FastEncoding(certs[i]));
            }
            BERSet setCert = new BERSet(v);
            SignedData signedData = new SignedData(SIGNEDDATA_VERSION, (ASN1Set)digestAlgorithmSets, contentInfo, (ASN1Set)setCert, null, (ASN1Set)signerInfos);
            ContentInfo contentInfoTemp = new ContentInfo(signDataIdentifier, (ASN1Encodable)signedData);
            File signFile = new File(signFileName);
            if (!signFile.exists()) {
                signFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(signFileName);
            dos = new DEROutputStream((OutputStream)fos);
            dos.writeObject((ASN1Encodable)contentInfoTemp);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("build signedFile failure", (Throwable)e);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e) {
                    throw new PKIException("build signedFile failure", (Throwable)e);
                }
            }
        }
    }

    public final byte[] packageSignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] signature, Mechanism mechanism, X509Cert[] certs, ASN1Set authenticatedAttributes, ASN1Set unauthenticatedAttributes) throws PKIException {
        if (certs == null || certs[0] == null) {
            throw new PKIException(PKIException.NULL_ENCRYPT_CERTS_ERR, PKIException.NULL_ENCRYPT_CERTS_ERR_DES);
        }
        BigInteger sn = certs[0].getSerialNumber();
        X500Name issuer = certs[0].getIssuerX500Name();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
        ASN1Object signerInfo = this.getSignerInfo(signature, issuerAndSn, mechanism, authenticatedAttributes, unauthenticatedAttributes);
        ASN1ObjectIdentifier signDataIdentifier = this.getSignDataIdentifier();
        ContentInfo contentInfo = this.getContentInfo(ifAttach, contentType, sourceData);
        ASN1EncodableVector derV = new ASN1EncodableVector();
        AlgorithmIdentifier digestAlgIdentifier = this.getDigestAlgIdentifier(mechanism);
        derV.add((ASN1Encodable)digestAlgIdentifier);
        DERSet digestAlgorithmSets = new DERSet(derV);
        derV = new ASN1EncodableVector();
        derV.add((ASN1Encodable)signerInfo);
        DERSet signerInfos = new DERSet(derV);
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < certs.length; ++i) {
            v.add((ASN1Encodable)new FastEncoding(certs[i]));
        }
        BERSet setCert = new BERSet(v);
        SignedData signedData = new SignedData(SIGNEDDATA_VERSION, (ASN1Set)digestAlgorithmSets, contentInfo, (ASN1Set)setCert, null, (ASN1Set)signerInfos);
        ContentInfo contentInfoTemp = new ContentInfo(signDataIdentifier, (ASN1Encodable)signedData);
        return ASN1Parser.parseDERObj2Bytes((ASN1Encodable)contentInfoTemp);
    }

    private ContentInfo getContentInfo(boolean ifAttach, String contentType, byte[] sourceData) throws PKIException {
        ContentInfo contentInfo = null;
        ASN1ObjectIdentifier contentIdentifier = this.getContentIdentifier();
        if (ifAttach) {
            DEROctetString derSourceData = new DEROctetString(sourceData);
            contentInfo = contentType == null ? new ContentInfo(contentIdentifier, (ASN1Encodable)derSourceData) : new ContentInfo(new ASN1ObjectIdentifier(contentType), (ASN1Encodable)derSourceData);
        } else {
            contentInfo = contentType == null ? new ContentInfo(contentIdentifier, null) : new ContentInfo(new ASN1ObjectIdentifier(contentType), null);
        }
        return contentInfo;
    }

    private ContentInfo getContentInfo(String contentType, String sourceFile) throws PKIException {
        ContentInfo contentInfo = null;
        ASN1ObjectIdentifier contentIdentifier = this.getContentIdentifier();
        PKCS7AttachSourceFile derSourceData = new PKCS7AttachSourceFile(new File(sourceFile));
        contentInfo = contentType == null ? new ContentInfo(contentIdentifier, (ASN1Encodable)derSourceData) : new ContentInfo(new ASN1ObjectIdentifier(contentType), (ASN1Encodable)derSourceData);
        return contentInfo;
    }

    protected abstract ASN1Object getSignerInfo(byte[] var1, IssuerAndSerialNumber var2, Mechanism var3) throws PKIException;

    protected abstract ASN1Object getSignerInfo(byte[] var1, IssuerAndSerialNumber var2, Mechanism var3, ASN1Set var4, ASN1Set var5) throws PKIException;

    protected abstract AlgorithmIdentifier getDigestAlgIdentifier(Mechanism var1) throws PKIException;

    protected abstract ASN1ObjectIdentifier getContentIdentifier() throws PKIException;

    protected abstract ASN1ObjectIdentifier getSignDataIdentifier() throws PKIException;
}

