/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.layout.hyphenation;

import cfca.sadk.com.itextpdf.layout.hyphenation.ByteVector;
import cfca.sadk.com.itextpdf.layout.hyphenation.Hyphenation;
import cfca.sadk.com.itextpdf.layout.hyphenation.HyphenationException;
import cfca.sadk.com.itextpdf.layout.hyphenation.IPatternConsumer;
import cfca.sadk.com.itextpdf.layout.hyphenation.PatternParser;
import cfca.sadk.com.itextpdf.layout.hyphenation.TernaryTree;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HyphenationTree
extends TernaryTree
implements IPatternConsumer {
    private static final long serialVersionUID = -7842107987915665573L;
    protected ByteVector vspace;
    protected Map<String, List> stoplist = new HashMap<String, List>(23);
    protected TernaryTree classmap = new TernaryTree();
    private transient TernaryTree ivalues;

    public HyphenationTree() {
        this.vspace = new ByteVector();
        this.vspace.alloc(1);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    protected int packValues(String values) {
        int n = values.length();
        int m = (n & 1) == 1 ? (n >> 1) + 2 : (n >> 1) + 1;
        int offset = this.vspace.alloc(m);
        byte[] va = this.vspace.getArray();
        for (int i = 0; i < n; ++i) {
            int j = i >> 1;
            byte v = (byte)(values.charAt(i) - 48 + 1 & 0xF);
            va[j + offset] = (i & 1) == 1 ? (byte)(va[j + offset] | v) : (byte)(v << 4);
        }
        va[m - 1 + offset] = 0;
        return offset;
    }

    protected String unpackValues(int k) {
        StringBuffer buf = new StringBuffer();
        byte v = this.vspace.get(k++);
        while (v != 0) {
            char c = (char)((v >>> 4) - 1 + 48);
            buf.append(c);
            c = (char)(v & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001' + 48);
            buf.append(c);
            v = this.vspace.get(k++);
        }
        return buf.toString();
    }

    public void loadPatterns(String filename) throws HyphenationException, FileNotFoundException {
        this.loadPatterns(new FileInputStream(filename), filename);
    }

    public void loadPatterns(InputStream stream, String name) throws HyphenationException {
        PatternParser pp = new PatternParser(this);
        this.ivalues = new TernaryTree();
        pp.parse(stream, name);
        this.trimToSize();
        this.vspace.trimToSize();
        this.classmap.trimToSize();
        this.ivalues = null;
    }

    public String findPattern(String pat) {
        int k = super.find(pat);
        if (k >= 0) {
            return this.unpackValues(k);
        }
        return "";
    }

    protected int hstrcmp(char[] s, int si, char[] t, int ti) {
        while (s[si] == t[ti]) {
            if (s[si] == '\u0000') {
                return 0;
            }
            ++si;
            ++ti;
        }
        if (t[ti] == '\u0000') {
            return 0;
        }
        return s[si] - t[ti];
    }

    protected byte[] getValues(int k) {
        StringBuffer buf = new StringBuffer();
        byte v = this.vspace.get(k++);
        while (v != 0) {
            char c = (char)((v >>> 4) - 1);
            buf.append(c);
            c = (char)(v & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001');
            buf.append(c);
            v = this.vspace.get(k++);
        }
        byte[] res = new byte[buf.length()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)buf.charAt(i);
        }
        return res;
    }

    protected void searchPatterns(char[] word, int index, byte[] il) {
        int i = index;
        char sp = word[i];
        char p = this.root;
        block0: while (p > '\u0000' && p < this.sc.length) {
            byte[] values;
            if (this.sc[p] == '\uffff') {
                if (this.hstrcmp(word, i, this.kv.getArray(), this.lo[p]) == 0) {
                    values = this.getValues(this.eq[p]);
                    int j = index;
                    for (int k = 0; k < values.length; ++k) {
                        if (j < il.length && values[k] > il[j]) {
                            il[j] = values[k];
                        }
                        ++j;
                    }
                }
                return;
            }
            int d = sp - this.sc[p];
            if (d == 0) {
                if (sp == '\u0000') break;
                sp = word[++i];
                char q = p = this.eq[p];
                while (q > '\u0000' && q < this.sc.length && this.sc[q] != '\uffff') {
                    if (this.sc[q] == '\u0000') {
                        values = this.getValues(this.eq[q]);
                        int j = index;
                        for (int k = 0; k < values.length; ++k) {
                            if (j < il.length && values[k] > il[j]) {
                                il[j] = values[k];
                            }
                            ++j;
                        }
                        continue block0;
                    }
                    q = this.lo[q];
                }
                continue;
            }
            p = d < 0 ? this.lo[p] : this.hi[p];
        }
    }

    public Hyphenation hyphenate(String word, int remainCharCount, int pushCharCount) {
        char[] w = word.toCharArray();
        if (this.isMultiPartWord(w, w.length)) {
            List<char[]> words = this.splitOnNonCharacters(w);
            return new Hyphenation(new String(w), this.getHyphPointsForWords(words, remainCharCount, pushCharCount));
        }
        return this.hyphenate(w, 0, w.length, remainCharCount, pushCharCount);
    }

    private boolean isMultiPartWord(char[] w, int len) {
        int wordParts = 0;
        for (int i = 0; i < len; ++i) {
            char[] c = new char[2];
            c[0] = w[i];
            int nc = this.classmap.find(c, 0);
            if (nc > 0) {
                if (wordParts > 1) {
                    return true;
                }
                wordParts = 1;
                continue;
            }
            if (wordParts != true) continue;
            ++wordParts;
        }
        return false;
    }

    private List<char[]> splitOnNonCharacters(char[] word) {
        List<Integer> breakPoints = this.getNonLetterBreaks(word);
        if (breakPoints.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<char[]> words = new ArrayList<char[]>();
        for (int ibreak = 0; ibreak < breakPoints.size(); ++ibreak) {
            char[] newWord = this.getWordFromCharArray(word, ibreak == 0 ? 0 : breakPoints.get(ibreak - 1), breakPoints.get(ibreak));
            words.add(newWord);
        }
        if (word.length - breakPoints.get(breakPoints.size() - 1) - 1 > 1) {
            char[] newWord = this.getWordFromCharArray(word, breakPoints.get(breakPoints.size() - 1), word.length);
            words.add(newWord);
        }
        return words;
    }

    private List<Integer> getNonLetterBreaks(char[] word) {
        char[] c = new char[2];
        ArrayList<Integer> breakPoints = new ArrayList<Integer>();
        boolean foundLetter = false;
        for (int i = 0; i < word.length; ++i) {
            c[0] = word[i];
            if (this.classmap.find(c, 0) < 0) {
                if (!foundLetter) continue;
                breakPoints.add(i);
                continue;
            }
            foundLetter = true;
        }
        return breakPoints;
    }

    private char[] getWordFromCharArray(char[] word, int startIndex, int endIndex) {
        int i;
        char[] newWord = new char[endIndex - (startIndex == 0 ? startIndex : startIndex + 1)];
        int iChar = 0;
        int n = i = startIndex == 0 ? 0 : startIndex + 1;
        while (i < endIndex) {
            newWord[iChar++] = word[i];
            ++i;
        }
        return newWord;
    }

    private int[] getHyphPointsForWords(List<char[]> nonLetterWords, int remainCharCount, int pushCharCount) {
        int[] breaks = new int[]{};
        for (int iNonLetterWord = 0; iNonLetterWord < nonLetterWords.size(); ++iNonLetterWord) {
            char[] nonLetterWord = nonLetterWords.get(iNonLetterWord);
            Hyphenation curHyph = this.hyphenate(nonLetterWord, 0, nonLetterWord.length, iNonLetterWord == 0 ? remainCharCount : 1, iNonLetterWord == nonLetterWords.size() - 1 ? pushCharCount : 1);
            if (curHyph == null) continue;
            int[] combined = new int[breaks.length + curHyph.getHyphenationPoints().length];
            int[] hyphPoints = curHyph.getHyphenationPoints();
            int foreWordsSize = this.calcForeWordsSize(nonLetterWords, iNonLetterWord);
            int i = 0;
            while (i < hyphPoints.length) {
                int n = i++;
                hyphPoints[n] = hyphPoints[n] + foreWordsSize;
            }
            System.arraycopy(breaks, 0, combined, 0, breaks.length);
            System.arraycopy(hyphPoints, 0, combined, breaks.length, hyphPoints.length);
            breaks = combined;
        }
        return breaks;
    }

    private int calcForeWordsSize(List<char[]> nonLetterWords, int iNonLetterWord) {
        int result = 0;
        for (int i = 0; i < iNonLetterWord; ++i) {
            result += nonLetterWords.get(i).length + 1;
        }
        return result;
    }

    public Hyphenation hyphenate(char[] w, int offset, int len, int remainCharCount, int pushCharCount) {
        int i;
        char[] word = new char[len + 3];
        char[] c = new char[2];
        int iIgnoreAtBeginning = 0;
        int iLength = len;
        boolean bEndOfLetters = false;
        for (i = 1; i <= len; ++i) {
            c[0] = w[offset + i - 1];
            int nc = this.classmap.find(c, 0);
            if (nc < 0) {
                if (i == 1 + iIgnoreAtBeginning) {
                    ++iIgnoreAtBeginning;
                } else {
                    bEndOfLetters = true;
                }
                --iLength;
                continue;
            }
            if (!bEndOfLetters) {
                word[i - iIgnoreAtBeginning] = (char)nc;
                continue;
            }
            return null;
        }
        len = iLength;
        if (len < remainCharCount + pushCharCount) {
            return null;
        }
        int[] result = new int[len + 1];
        int k = 0;
        String sw = new String(word, 1, len);
        if (this.stoplist.containsKey(sw)) {
            ArrayList hw = (ArrayList)this.stoplist.get(sw);
            int j = 0;
            for (i = 0; i < hw.size(); ++i) {
                Object o = hw.get(i);
                if (!(o instanceof String) || (j += ((String)o).length()) < remainCharCount || j >= len - pushCharCount) continue;
                result[k++] = j + iIgnoreAtBeginning;
            }
        } else {
            word[0] = 46;
            word[len + 1] = 46;
            word[len + 2] = '\u0000';
            byte[] il = new byte[len + 3];
            for (i = 0; i < len + 1; ++i) {
                this.searchPatterns(word, i, il);
            }
            for (i = 0; i < len; ++i) {
                if ((il[i + 1] & 1) != 1 || i < remainCharCount || i > len - pushCharCount) continue;
                result[k++] = i + iIgnoreAtBeginning;
            }
        }
        if (k > 0) {
            int[] res = new int[k];
            System.arraycopy(result, 0, res, 0, k);
            return new Hyphenation(new String(w, offset, len), res);
        }
        return null;
    }

    @Override
    public void addClass(String chargroup) {
        if (chargroup.length() > 0) {
            char equivChar = chargroup.charAt(0);
            char[] key = new char[2];
            key[1] = '\u0000';
            for (int i = 0; i < chargroup.length(); ++i) {
                key[0] = chargroup.charAt(i);
                this.classmap.insert(key, 0, equivChar);
            }
        }
    }

    @Override
    public void addException(String word, List hyphenatedword) {
        this.stoplist.put(word, hyphenatedword);
    }

    @Override
    public void addPattern(String pattern, String ivalue) {
        int k = this.ivalues.find(ivalue);
        if (k <= 0) {
            k = this.packValues(ivalue);
            this.ivalues.insert(ivalue, (char)k);
        }
        this.insert(pattern, (char)k);
    }
}

