/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.forms.PdfAcroForm;
import cfca.sadk.com.itextpdf.forms.fields.PdfFormField;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.pdf.StampingProperties;
import cfca.sadk.seal.base.exception.SealException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FlattenUtil {
    private static Logger businessLog = LoggerFactory.getLogger(FlattenUtil.class);

    public static byte[] flattenFields(byte[] pdfData, String[] flattenFields) throws SealException {
        businessLog.info("flattenFields begin...");
        try {
            PdfReader reader = new PdfReader(pdfData);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            FlattenUtil.flattenFields(reader, (OutputStream)outputStream, flattenFields);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (SealException e) {
            throw e;
        }
        catch (Exception e) {
            businessLog.error("flattenAll failed", (Throwable)e);
            throw new SealException("flattenAll failed", e);
        }
        finally {
            businessLog.info("flattenFields end...");
        }
    }

    public static void flattenFields(InputStream inputStream, OutputStream outputStream, String[] flattenFields) throws SealException {
        businessLog.info("flattenFields begin...");
        try {
            PdfReader reader = new PdfReader(inputStream);
            FlattenUtil.flattenFields(reader, outputStream, flattenFields);
        }
        catch (SealException e) {
            throw e;
        }
        catch (Exception e) {
            businessLog.error("flattenAll failed", (Throwable)e);
            throw new SealException("flattenAll failed", e);
        }
        finally {
            businessLog.info("flattenFields end...");
        }
    }

    private static void flattenFields(PdfReader reader, OutputStream outputStream, String[] flattenFields) throws SealException {
        PdfDocument doc = null;
        try {
            StampingProperties properties = new StampingProperties();
            doc = new PdfDocument(reader, new PdfWriter(outputStream), properties, false);
            PdfAcroForm form = PdfAcroForm.getAcroForm(doc, true);
            if (null != flattenFields && flattenFields.length > 0) {
                for (String fieldName : flattenFields) {
                    PdfFormField field = form.getField(fieldName);
                    if (field == null) {
                        throw new SealException("fieldName = " + fieldName + " is not exists!");
                    }
                    form.partialFormFlattening(fieldName);
                }
            }
            form.flattenFields(true);
            doc.close();
        }
        catch (SealException e) {
            businessLog.error("flattenAll failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("flattenAll failed", (Throwable)e);
            throw new SealException("flattenAll failed", e);
        }
        finally {
            if (null != doc) {
                doc.close();
            }
        }
    }
}

