/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf.parser;

import cfca.com.itextpdf.text.pdf.parser.ImageRenderInfo;
import cfca.com.itextpdf.text.pdf.parser.RenderFilter;
import cfca.com.itextpdf.text.pdf.parser.RenderListener;
import cfca.com.itextpdf.text.pdf.parser.TextRenderInfo;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFilteredRenderListener
implements RenderListener {
    private final List<RenderListener> delegates = new ArrayList<RenderListener>();
    private final List<RenderFilter[]> filters = new ArrayList<RenderFilter[]>();

    public <E extends RenderListener> E attachRenderListener(E delegate, RenderFilter ... filterSet) {
        this.delegates.add(delegate);
        this.filters.add(filterSet);
        return delegate;
    }

    @Override
    public void beginTextBlock() {
        for (RenderListener delegate : this.delegates) {
            delegate.beginTextBlock();
        }
    }

    @Override
    public void renderText(TextRenderInfo renderInfo) {
        for (int i = 0; i < this.delegates.size(); ++i) {
            boolean filtersPassed = true;
            for (RenderFilter filter : this.filters.get(i)) {
                if (filter.allowText(renderInfo)) continue;
                filtersPassed = false;
                break;
            }
            if (!filtersPassed) continue;
            this.delegates.get(i).renderText(renderInfo);
        }
    }

    @Override
    public void endTextBlock() {
        for (RenderListener delegate : this.delegates) {
            delegate.endTextBlock();
        }
    }

    @Override
    public void renderImage(ImageRenderInfo renderInfo) {
        for (int i = 0; i < this.delegates.size(); ++i) {
            boolean filtersPassed = true;
            for (RenderFilter filter : this.filters.get(i)) {
                if (filter.allowImage(renderInfo)) continue;
                filtersPassed = false;
                break;
            }
            if (!filtersPassed) continue;
            this.delegates.get(i).renderImage(renderInfo);
        }
    }
}

