/*
 * Decompiled with CFR 0.152.
 */
package io.github.autoffice.luckysheet.model.image;

import com.fasterxml.jackson.annotation.JsonValue;
import io.github.autoffice.luckysheet.util.Util;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.ss.usermodel.ClientAnchor;

public enum ImageType {
    MOVE_AND_RESIZE(1, ClientAnchor.AnchorType.MOVE_AND_RESIZE),
    MOVE_DONT_RESIZE(2, ClientAnchor.AnchorType.MOVE_DONT_RESIZE),
    DONT_MOVE_AND_RESIZE(3, ClientAnchor.AnchorType.DONT_MOVE_AND_RESIZE);

    @JsonValue
    private final Integer lsValue;
    private final ClientAnchor.AnchorType poiValue;
    private static final Map<ClientAnchor.AnchorType, ImageType> TYPES;

    public static ImageType of(ClientAnchor.AnchorType anchorType) {
        ImageType imageType = TYPES.get(anchorType);
        return Util.requireNonNullElse(imageType, MOVE_AND_RESIZE);
    }

    @Generated
    private ImageType(Integer lsValue, ClientAnchor.AnchorType poiValue) {
        this.lsValue = lsValue;
        this.poiValue = poiValue;
    }

    @Generated
    public ClientAnchor.AnchorType getPoiValue() {
        return this.poiValue;
    }

    static {
        TYPES = Arrays.stream(ImageType.values()).collect(Collectors.toMap(ImageType::getPoiValue, Function.identity()));
    }
}

