/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf.security.pkcs7;

import cfca.com.itextpdf.text.pdf.security.pkcs7.AbstractPKCS7Package;
import cfca.com.itextpdf.text.pdf.security.pkcs7.PKCS7RSAPackageUtil;
import cfca.com.itextpdf.text.pdf.security.pkcs7.PKCS7SM2PackageUtil;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.x509.certificate.X509Cert;

public class PKCS7PackageFacade {
    public static final AbstractPKCS7Package SM2_PKCS7 = new PKCS7SM2PackageUtil();
    public static final AbstractPKCS7Package RSA_PKCS7 = new PKCS7RSAPackageUtil();

    public static final byte[] packageSignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] encryptData, Mechanism digestAlgorithm, X509Cert[] receiverCerts, ASN1Set authenticatedAttributes, ASN1Set unauthenticatedAttributes) throws PKIException {
        if (receiverCerts == null || receiverCerts.length < 1 || receiverCerts[0] == null) {
            throw new PKIException("required receiverCerts!");
        }
        if (receiverCerts[0].isSM2Cert()) {
            return SM2_PKCS7.packageSignedData(ifAttach, contentType, sourceData, encryptData, null, receiverCerts, authenticatedAttributes, unauthenticatedAttributes);
        }
        return RSA_PKCS7.packageSignedData(ifAttach, contentType, sourceData, encryptData, digestAlgorithm, receiverCerts, authenticatedAttributes, unauthenticatedAttributes);
    }

    public static final void packageSignedFile(String sourceFilePath, String signFile, byte[] signture, Mechanism mechanism, X509Cert[] receiverCerts) throws PKIException {
        if (receiverCerts == null || receiverCerts.length < 1 || receiverCerts[0] == null) {
            throw new PKIException("required receiverCerts!");
        }
        if (receiverCerts[0].isSM2Cert()) {
            SM2_PKCS7.packageSignedFile(sourceFilePath, signFile, signture, null, receiverCerts);
        } else {
            RSA_PKCS7.packageSignedFile(sourceFilePath, signFile, signture, mechanism, receiverCerts);
        }
    }
}

