/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.format;

import cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.system.logging.LoggerManager;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class SM2FormatKey {
    private SM2FormatKey() {
    }

    public static PublicKey convertToProviderSM2PublicKey(Provider provider, PublicKey pubKey) throws Exception {
        PublicKey returnKey = null;
        try {
            if (pubKey != null && pubKey instanceof ECPublicKey) {
                LoggerManager.debugLogger.debug("SM2HardPublicKey::::::::X509EncodedKeySpec: Running");
                KeyFactory kf = KeyFactory.getInstance("SM2", provider);
                X509EncodedKeySpec x509spec = new X509EncodedKeySpec(pubKey.getEncoded());
                returnKey = kf.generatePublic(x509spec);
                LoggerManager.debugLogger.debug("SM2HardPublicKey::::::::X509EncodedKeySpec: Finished");
            } else {
                LoggerManager.debugLogger.debug("SM2HardPublicKey::::::::X509EncodedKeySpec: Not ECPublicKey");
                returnKey = pubKey;
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2HardPublicKey failure", (Throwable)e);
            throw new Exception("SM2HardPublicKey failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2HardPublicKey failure", e);
            throw new Exception("SM2HardPublicKey failure", e);
        }
        return returnKey;
    }

    public static PrivateKey convertToProviderSM2PrivateKey(Provider provider, PrivateKey privKey) throws Exception {
        PrivateKey returnKey = null;
        try {
            if (privKey != null && privKey instanceof ECPrivateKey) {
                LoggerManager.debugLogger.debug("SM2HardPublicKey::::::::PKCS8EncodedKeySpec: Running");
                KeyFactory kf = KeyFactory.getInstance("SM2", provider);
                PKCS8EncodedKeySpec x509spec = new PKCS8EncodedKeySpec(privKey.getEncoded());
                returnKey = kf.generatePrivate(x509spec);
                LoggerManager.debugLogger.debug("SM2HardPublicKey::::::::PKCS8EncodedKeySpec: Finished");
            } else {
                LoggerManager.debugLogger.debug("SM2HardPublicKey::::::::PKCS8EncodedKeySpec: Not ECPrivateKey");
                returnKey = privKey;
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2HardPrivateKey failure", (Throwable)e);
            throw new Exception("SM2HardPrivateKey failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2HardPrivateKey failure", e);
            throw new Exception("SM2HardPrivateKey failure", e);
        }
        return returnKey;
    }
}

