/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cms;

import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.cms.CMSException;
import cfca.sadk.org.bouncycastle.cms.CMSReadable;
import cfca.sadk.org.bouncycastle.cms.CMSTypedData;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CMSProcessableFile
implements CMSTypedData,
CMSReadable {
    private static final int DEFAULT_BUF_SIZE = 32768;
    private final ASN1ObjectIdentifier type;
    private final File file;
    private final byte[] buf;

    public CMSProcessableFile(File file) {
        this(file, 32768);
    }

    public CMSProcessableFile(File file, int bufSize) {
        this(new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId()), file, bufSize);
    }

    public CMSProcessableFile(ASN1ObjectIdentifier type, File file, int bufSize) {
        this.type = type;
        this.file = file;
        this.buf = new byte[bufSize];
    }

    public InputStream getInputStream() throws IOException, CMSException {
        return new BufferedInputStream(new FileInputStream(this.file), 32768);
    }

    public void write(OutputStream zOut) throws IOException, CMSException {
        int len;
        FileInputStream fIn = new FileInputStream(this.file);
        while ((len = fIn.read(this.buf, 0, this.buf.length)) > 0) {
            zOut.write(this.buf, 0, len);
        }
        fIn.close();
    }

    public Object getContent() {
        return this.file;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }
}

