/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;
import cfca.sadk.tls.sun.security.ssl.prf.TlsRsaPremasterSecretParameters;
import cfca.sadk.tls.sun.security.ssl.sec.SecureRandoms;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class TlsRsaPremasterSecretGenerator {
    TlsRsaPremasterSecretGenerator() {
    }

    final SecretKey generatePremasterKey(TlsRsaPremasterSecretParameters params) {
        return this.generatePremasterKey(params, null);
    }

    final SecretKey generatePremasterKey(TlsRsaPremasterSecretParameters params, SecureRandom random) {
        if (params == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "TlsRsaPremasterSecretParameters"));
        }
        byte[] keyBytes = params.getEncodedSecret();
        if (keyBytes == null) {
            if (random == null) {
                random = SecureRandoms.newSecure();
            }
            keyBytes = new byte[48];
            random.nextBytes(keyBytes);
            keyBytes[0] = (byte)params.getMajorVersion();
            keyBytes[1] = (byte)params.getMinorVersion();
        }
        return new SecretKeySpec(keyBytes, "TlsRsaPremasterSecret");
    }
}

