/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.tls.java.security.CFCAAlgorithmConstraints;
import cfca.sadk.tls.java.security.CFCACryptoPrimitive;
import cfca.sadk.tls.javax.net.ssl.CFCASSLTransfer;
import cfca.sadk.tls.sun.security.ssl.sec.CipherBulk;
import cfca.sadk.tls.sun.security.ssl.sec.CipherSuite;
import cfca.sadk.tls.sun.security.ssl.sec.KeyExchangeAlgorithm;
import cfca.sadk.tls.sun.security.ssl.sec.MacAlg;
import cfca.sadk.tls.sun.security.util.CFCADisabledAlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.util.HashSet;
import java.util.Set;

public final class SSLAlgorithmConstraints
implements CFCAAlgorithmConstraints {
    private static final CFCAAlgorithmConstraints tlsDisabledAlgConstraints = new TLSDisabledAlgConstraints();
    private static final CFCAAlgorithmConstraints x509DisabledAlgConstraints = new X509DisabledAlgConstraints();
    private CFCAAlgorithmConstraints userAlgConstraints = null;
    private CFCAAlgorithmConstraints peerAlgConstraints = null;
    private boolean enabledX509DisabledAlgConstraints = true;

    public SSLAlgorithmConstraints(CFCAAlgorithmConstraints algorithmConstraints) {
        this.userAlgConstraints = algorithmConstraints;
    }

    public SSLAlgorithmConstraints(CFCASSLTransfer transfer, boolean withDefaultCertPathConstraints) {
        if (transfer != null) {
            this.userAlgConstraints = transfer.getAlgorithmConstraints();
        }
        if (!withDefaultCertPathConstraints) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    public SSLAlgorithmConstraints(CFCASSLTransfer transfer, String[] supportedAlgorithms, boolean withDefaultCertPathConstraints) {
        if (transfer != null) {
            this.userAlgConstraints = transfer.getAlgorithmConstraints();
            this.peerAlgConstraints = new SupportedSignatureAlgorithmConstraints(supportedAlgorithms);
        }
        if (!withDefaultCertPathConstraints) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    @Override
    public boolean permits(Set<CFCACryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        boolean permitted = true;
        if (this.peerAlgConstraints != null) {
            permitted = this.peerAlgConstraints.permits(primitives, algorithm, parameters);
        }
        if (permitted && this.userAlgConstraints != null) {
            permitted = this.userAlgConstraints.permits(primitives, algorithm, parameters);
        }
        if (permitted) {
            permitted = tlsDisabledAlgConstraints.permits(primitives, algorithm, parameters);
        }
        if (permitted && this.enabledX509DisabledAlgConstraints) {
            permitted = x509DisabledAlgConstraints.permits(primitives, algorithm, parameters);
        }
        return permitted;
    }

    @Override
    public boolean permits(Set<CFCACryptoPrimitive> primitives, Key key) {
        boolean permitted = true;
        if (this.peerAlgConstraints != null) {
            permitted = this.peerAlgConstraints.permits(primitives, key);
        }
        if (permitted && this.userAlgConstraints != null) {
            permitted = this.userAlgConstraints.permits(primitives, key);
        }
        if (permitted) {
            permitted = tlsDisabledAlgConstraints.permits(primitives, key);
        }
        if (permitted && this.enabledX509DisabledAlgConstraints) {
            permitted = x509DisabledAlgConstraints.permits(primitives, key);
        }
        return permitted;
    }

    @Override
    public boolean permits(Set<CFCACryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        boolean permitted = true;
        if (this.peerAlgConstraints != null) {
            permitted = this.peerAlgConstraints.permits(primitives, algorithm, key, parameters);
        }
        if (permitted && this.userAlgConstraints != null) {
            permitted = this.userAlgConstraints.permits(primitives, algorithm, key, parameters);
        }
        if (permitted) {
            permitted = tlsDisabledAlgConstraints.permits(primitives, algorithm, key, parameters);
        }
        if (permitted && this.enabledX509DisabledAlgConstraints) {
            permitted = x509DisabledAlgConstraints.permits(primitives, algorithm, key, parameters);
        }
        return permitted;
    }

    private static class X509DisabledAlgConstraints
    extends BasicDisabledAlgConstraints {
        X509DisabledAlgConstraints() {
            super("jdk.certpath.disabledAlgorithms");
        }

        @Override
        protected Set<String> decomposes(String algorithm) {
            if (algorithm.startsWith("SSL_") || algorithm.startsWith("TLS_")) {
                CipherSuite cipherSuite = null;
                try {
                    cipherSuite = CipherSuite.valueOf(algorithm);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
                if (cipherSuite != null) {
                    HashSet<String> components = new HashSet<String>();
                    if (cipherSuite.keyExchange != null) {
                        components.addAll(this.decomposes(cipherSuite.keyExchange, true));
                    }
                    return components;
                }
            }
            return super.decomposes(algorithm);
        }
    }

    private static class TLSDisabledAlgConstraints
    extends BasicDisabledAlgConstraints {
        TLSDisabledAlgConstraints() {
            super("jdk.tls.disabledAlgorithms");
        }

        @Override
        protected Set<String> decomposes(String algorithm) {
            if (algorithm.startsWith("SSL_") || algorithm.startsWith("TLS_")) {
                CipherSuite cipherSuite = null;
                try {
                    cipherSuite = CipherSuite.valueOf(algorithm);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
                if (cipherSuite != null) {
                    HashSet<String> components = new HashSet<String>();
                    if (cipherSuite.keyExchange != null) {
                        components.addAll(this.decomposes(cipherSuite.keyExchange, false));
                    }
                    if (cipherSuite.cipher != null) {
                        components.addAll(this.decomposes(cipherSuite.cipher));
                    }
                    if (cipherSuite.macAlg != null) {
                        components.addAll(this.decomposes(cipherSuite.macAlg));
                    }
                    return components;
                }
            }
            return super.decomposes(algorithm);
        }
    }

    private static class BasicDisabledAlgConstraints
    extends CFCADisabledAlgorithmConstraints {
        BasicDisabledAlgConstraints(String propertyName) {
            super(propertyName);
        }

        protected Set<String> decomposes(KeyExchangeAlgorithm keyExchange, boolean forCertPathOnly) {
            HashSet<String> components = new HashSet<String>();
            switch (keyExchange) {
                case K_NULL: {
                    if (forCertPathOnly) break;
                    components.add("NULL");
                    break;
                }
                case K_RSAPKEA: {
                    components.add("RSA");
                    break;
                }
                case K_SM2PKEA_SM2DSA: {
                    components.add("ECDH");
                    components.add("SM2DSA");
                    components.add("ECDH_SM2DSA");
                    break;
                }
                case K_ECDHE_SM2DSA: {
                    components.add("ECDHE");
                    components.add("SM2DSA");
                    components.add("ECDHE_SM2DSA");
                    break;
                }
            }
            return components;
        }

        protected Set<String> decomposes(CipherBulk bulkCipher) {
            HashSet<String> components = new HashSet<String>();
            if (bulkCipher.transformation != null) {
                components.addAll(super.decomposes(bulkCipher.transformation));
            }
            return components;
        }

        protected Set<String> decomposes(MacAlg macAlg) {
            HashSet<String> components = new HashSet<String>();
            if (macAlg == MacAlg.SM3) {
                components.add("SM3");
                components.add("HmacSM3");
            } else if (macAlg == MacAlg.SHA) {
                components.add("SHA1");
                components.add("SHA-1");
                components.add("HmacSHA1");
            }
            return components;
        }
    }

    private static class SupportedSignatureAlgorithmConstraints
    implements CFCAAlgorithmConstraints {
        private String[] supportedAlgorithms;

        SupportedSignatureAlgorithmConstraints(String[] supportedAlgorithms) {
            this.supportedAlgorithms = supportedAlgorithms != null ? (String[])supportedAlgorithms.clone() : null;
        }

        @Override
        public boolean permits(Set<CFCACryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
            if (algorithm == null || algorithm.length() == 0) {
                throw new IllegalArgumentException("No algorithm name specified");
            }
            if (primitives == null || primitives.isEmpty()) {
                throw new IllegalArgumentException("No cryptographic primitive specified");
            }
            if (this.supportedAlgorithms == null || this.supportedAlgorithms.length == 0) {
                return false;
            }
            int position = algorithm.indexOf("and");
            if (position > 0) {
                algorithm = algorithm.substring(0, position);
            }
            for (String supportedAlgorithm : this.supportedAlgorithms) {
                if (!algorithm.equalsIgnoreCase(supportedAlgorithm)) continue;
                return true;
            }
            return false;
        }

        @Override
        public final boolean permits(Set<CFCACryptoPrimitive> primitives, Key key) {
            return true;
        }

        @Override
        public final boolean permits(Set<CFCACryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
            if (algorithm == null || algorithm.length() == 0) {
                throw new IllegalArgumentException("No algorithm name specified");
            }
            return this.permits(primitives, algorithm, parameters);
        }
    }
}

