/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss.config;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import org.springblade.core.oss.S3Template;
import org.springblade.core.oss.config.OssConfiguration;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.OssRule;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfiguration(after={OssConfiguration.class})
@ConditionalOnClass(value={AmazonS3.class})
@EnableConfigurationProperties(value={OssProperties.class})
@ConditionalOnProperty(value={"oss.name"}, havingValue="s3")
public class S3Configuration {
    private final OssProperties ossProperties;
    private final OssRule ossRule;

    @Bean
    @ConditionalOnMissingBean(value={AmazonS3.class})
    public AmazonS3 amazonS3() {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.ossProperties.getAccessKey(), this.ossProperties.getSecretKey());
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setSignerOverride("AWSS3V4SignerType");
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.ossProperties.getEndpoint(), StringUtil.isBlank((CharSequence)this.ossProperties.getRegion()) ? Regions.DEFAULT_REGION.name() : Regions.fromName((String)this.ossProperties.getRegion()).getName()))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).build();
    }

    @Bean
    @ConditionalOnBean(value={AmazonS3.class})
    @ConditionalOnMissingBean(value={S3Template.class})
    public S3Template s3Template(AmazonS3 amazonS3) {
        return new S3Template(amazonS3, this.ossRule, this.ossProperties);
    }

    public S3Configuration(OssProperties ossProperties, OssRule ossRule) {
        this.ossProperties = ossProperties;
        this.ossRule = ossRule;
    }
}

