/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.ofd.base.asn1.SES_Signature;
import cfca.sadk.ofd.base.asn1.SESeal;
import cfca.sadk.ofd.base.common.CFCATSAClient;
import cfca.sadk.ofd.base.common.StringUtil;
import cfca.sadk.ofd.base.common.ZipUtil;
import cfca.sadk.ofd.base.config.SignAppearance;
import cfca.sadk.ofd.base.config.SignInfoConfig;
import cfca.sadk.ofd.base.config.VersionInfo;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.base.seal.SealResultInfo;
import cfca.sadk.ofd.base.seal.SealXMLUtil;
import cfca.sadk.ofd.util.SignatureUtil;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.util.Base64;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.Map;

public class AsynSignatureUtil {
    private static Logger businessLog = LoggerFactory.getLogger(AsynSignatureUtil.class);

    public static SealResultInfo createBlankSignature(byte[] ofdDatas, SESeal eSseal, SignAppearance appearance, SignInfoConfig signInfo) throws SealException {
        long start = System.currentTimeMillis();
        businessLog.info("createBlankSignature start...");
        if (null == signInfo) {
            throw new IllegalArgumentException("signInfo is null!");
        }
        try {
            SealResultInfo sealResult;
            signInfo.setAsyn(true);
            signInfo.setPrivateKey(null);
            SealResultInfo sealResultInfo = sealResult = SignatureUtil.signLocation(ofdDatas, eSseal, appearance, signInfo);
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("createBlankSignature failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("createBlankSignature failed:", (Throwable)e);
            throw new SealException("createBlankSignature failed:", e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("createBlankSignature end...cost= " + (end - start) + " ms");
        }
    }

    public static SealResultInfo createBlankSignature(InputStream inputStream, SESeal eSseal, SignAppearance appearance, SignInfoConfig signInfo) throws SealException {
        long start = System.currentTimeMillis();
        businessLog.info("createBlankSignature start...");
        if (null == signInfo) {
            throw new IllegalArgumentException("signInfo is null!");
        }
        try {
            SealResultInfo sealResult;
            signInfo.setAsyn(true);
            signInfo.setPrivateKey(null);
            SealResultInfo sealResultInfo = sealResult = SignatureUtil.signLocation(inputStream, eSseal, appearance, signInfo);
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("createBlankSignature failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("createBlankSignature failed:", (Throwable)e);
            throw new SealException("createBlankSignature failed:", e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("createBlankSignature end...cost= " + (end - start) + " ms");
        }
    }

    public static SealResultInfo combineExternalSignature(byte[] ofdDatas, String signatureID, byte[] signature, SignInfoConfig signInfo) throws SealException {
        if (null == ofdDatas) {
            throw new IllegalArgumentException("ofdDatas is null!");
        }
        return AsynSignatureUtil.combineExternalSignature(new ByteArrayInputStream(ofdDatas), signatureID, signature, signInfo);
    }

    public static SealResultInfo combineExternalSignature(InputStream inputStream, String signatureID, byte[] signature, SignInfoConfig signInfo) throws SealException {
        long start = System.currentTimeMillis();
        businessLog.info("combineExternalSignature start...");
        SealResultInfo sealResult = new SealResultInfo();
        if (StringUtil.isEmpty(signatureID)) {
            throw new IllegalArgumentException("signatureID is null!");
        }
        if (null == signature) {
            throw new IllegalArgumentException("signature is null!");
        }
        if (null == signInfo) {
            throw new IllegalArgumentException("signInfo is null!");
        }
        try {
            String baseDir;
            String signName;
            Map<String, byte[]> filesMap;
            byte[] signedValue;
            if (Base64.isBase64Compatability((byte[])signature)) {
                signature = Base64.decode((byte[])signature);
            }
            if (null == (signedValue = (filesMap = ZipUtil.uncompress(inputStream)).get(signName = (baseDir = SealXMLUtil.getBaseDir(filesMap)) + "Signs/Sign_" + signatureID + "/" + "SignedValue.dat"))) {
                throw new IllegalArgumentException("signatureID= " + signatureID + " not exists!");
            }
            SES_Signature sesSign = SES_Signature.getInstance(signedValue);
            byte[] sourceData = sesSign.getToSign().getEncoded();
            Signature util = new Signature();
            Mechanism signAlg = signInfo.getSignAlg();
            if (null == signAlg) {
                throw new IllegalArgumentException("signAlg is null!");
            }
            X509Cert signCert = signInfo.getSignCert();
            if (null == signCert) {
                throw new IllegalArgumentException("signCert is null!");
            }
            PublicKey pubKey = signCert.getPublicKey();
            boolean verifyResult = util.p1VerifyMessage(signAlg.getMechanismType(), sourceData, signature, pubKey, BCSoftLib.INSTANCE());
            if (!verifyResult) {
                throw new IllegalArgumentException("verify failed,signature is not matched the sourceData or publicKey! DN =" + signCert.getSubject() + "signAlg =" + signAlg);
            }
            sesSign.setSignature(new DERBitString(signature));
            CFCATSAClient tsaClient = signInfo.getTsaClient();
            if (tsaClient != null) {
                try {
                    byte[] timeStampToken = tsaClient.getGM20520Token(signature);
                    DERBitString timestamp = new DERBitString(timeStampToken);
                    sesSign.setTimestamp(timestamp);
                }
                catch (Exception e) {
                    businessLog.error("getTimeStamp failed", (Throwable)e);
                }
            }
            filesMap.put(signName, sesSign.getEncoded());
            ByteArrayOutputStream output = ZipUtil.compress(filesMap);
            sealResult.setSignedData(output.toByteArray());
            sealResult.setSignStatus(true);
            SealResultInfo sealResultInfo = sealResult;
            return sealResultInfo;
        }
        catch (IllegalArgumentException e) {
            sealResult.setFailReason(e.getMessage());
            throw e;
        }
        catch (SealException e) {
            sealResult.setFailReason(e.getMessage());
            businessLog.error("combineExternalSignature failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            sealResult.setFailReason(e.getMessage());
            businessLog.error("combineExternalSignature failed:", (Throwable)e);
            throw new SealException("combineExternalSignature failed:", e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("combineExternalSignature end...cost= " + (end - start) + " ms");
        }
    }

    static {
        VersionInfo.environments();
    }
}

