/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;
import cfca.sadk.tls.sun.security.ssl.prf.TlsProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.prf.TlsRsaPremasterSecretGenerator;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;

public final class TlsRsaPremasterSecretParameters {
    private final TlsProtocolVersion versions;
    private byte[] encodedSecret;

    public TlsRsaPremasterSecretParameters(int majorVersion, int minorVersion) {
        this.versions = new TlsProtocolVersion(majorVersion, minorVersion);
        this.encodedSecret = null;
    }

    public TlsRsaPremasterSecretParameters(int majorVersion, int minorVersion, byte[] encodedSecret) {
        this(majorVersion, minorVersion);
        if (encodedSecret == null || encodedSecret.length != 48) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.premasterSecretEncodedNotExactly"));
        }
        this.encodedSecret = (byte[])encodedSecret.clone();
    }

    public int getMajorVersion() {
        return this.versions.majorVersion;
    }

    public int getMinorVersion() {
        return this.versions.minorVersion;
    }

    public byte[] getEncodedSecret() {
        return this.encodedSecret == null ? null : (byte[])this.encodedSecret.clone();
    }

    public final SecretKey generatePremasterkey() throws GeneralSecurityException {
        return new TlsRsaPremasterSecretGenerator().generatePremasterKey(this);
    }

    public final SecretKey generatePremasterkey(SecureRandom secure) throws GeneralSecurityException {
        return new TlsRsaPremasterSecretGenerator().generatePremasterKey(this, secure);
    }
}

