/*
 * Decompiled with CFR 0.152.
 */
package io.github.autoffice.luckysheet.model.cell;

import com.fasterxml.jackson.annotation.JsonValue;
import io.github.autoffice.luckysheet.util.Util;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

public enum CellHorizontalType {
    CENTER(0, HorizontalAlignment.CENTER),
    LEFT(1, HorizontalAlignment.LEFT),
    RIGHT(2, HorizontalAlignment.RIGHT);

    @JsonValue
    private final Integer lsValue;
    private final HorizontalAlignment poiValue;
    private static final Map<HorizontalAlignment, CellHorizontalType> TYPES;

    public static CellHorizontalType of(HorizontalAlignment alignment) {
        CellHorizontalType cellHorizontalType = TYPES.get(alignment);
        return Util.requireNonNullElse(cellHorizontalType, LEFT);
    }

    @Generated
    private CellHorizontalType(Integer lsValue, HorizontalAlignment poiValue) {
        this.lsValue = lsValue;
        this.poiValue = poiValue;
    }

    @Generated
    public HorizontalAlignment getPoiValue() {
        return this.poiValue;
    }

    static {
        TYPES = Arrays.stream(CellHorizontalType.values()).collect(Collectors.toMap(CellHorizontalType::getPoiValue, Function.identity()));
    }
}

