/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.keyword;

import cfca.com.itextpdf.text.Rectangle;
import cfca.com.itextpdf.text.pdf.DocumentFont;
import cfca.com.itextpdf.text.pdf.parser.ImageRenderInfo;
import cfca.com.itextpdf.text.pdf.parser.LineSegment;
import cfca.com.itextpdf.text.pdf.parser.Matrix;
import cfca.com.itextpdf.text.pdf.parser.TextRenderInfo;
import cfca.com.itextpdf.text.pdf.parser.Vector;
import cfca.seal.sadk.LocationInfo;
import cfca.seal.sadk.SignatureLandscape;
import cfca.seal.sadk.keyword.KeywordExtractionStrategy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationKeywordExtractionStrategy
implements KeywordExtractionStrategy {
    private String keyword;
    private int page;
    static boolean DUMP_STATE = false;
    private final List<TextChunk> locationalResult = new ArrayList<TextChunk>();
    private int rotation;

    public LocationKeywordExtractionStrategy() {
    }

    public LocationKeywordExtractionStrategy(String keyword, int page, int rotation) {
        this.keyword = keyword;
        this.page = page;
        this.rotation = rotation;
    }

    @Override
    public void beginTextBlock() {
    }

    @Override
    public void endTextBlock() {
    }

    private boolean startsWithSpace(String str) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(0) == ' ';
    }

    private boolean endsWithSpace(String str) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(str.length() - 1) == ' ';
    }

    private List<TextChunk> filterTextChunks(List<TextChunk> textChunks, TextChunkFilter filter) {
        if (filter == null) {
            return textChunks;
        }
        ArrayList<TextChunk> filtered = new ArrayList<TextChunk>();
        for (TextChunk textChunk : textChunks) {
            if (!filter.accept(textChunk)) continue;
            filtered.add(textChunk);
        }
        return filtered;
    }

    protected boolean isChunkAtWordBoundary(TextChunk chunk, TextChunk previousChunk) {
        float dist = chunk.distanceFromEndOf(previousChunk);
        return dist < -chunk.getCharSpaceWidth() || dist > chunk.getCharSpaceWidth() / 2.0f;
    }

    public LocationInfo getResultantKeyword(TextChunkFilter chunkFilter) {
        if (DUMP_STATE) {
            this.dumpState();
        }
        LocationInfo locInfo = new LocationInfo(this.keyword);
        List<TextChunk> textChunksFiltered = this.filterTextChunks(this.locationalResult, chunkFilter);
        StringBuilder forwardStringBuilder = new StringBuilder();
        String forwardString = null;
        StringBuilder backwardStringBuilder = new StringBuilder();
        String backwardString = null;
        ArrayList<TextChunk> forwardTextChunkList = new ArrayList<TextChunk>();
        ArrayList<TextChunk> backwardTextChunkList = new ArrayList<TextChunk>();
        TextChunk forwardTextChunk = null;
        TextChunk lastForwardTextChunk = null;
        TextChunk backwardTextChunk = null;
        TextChunk lastBackwardTextChunk = null;
        int sizeOfTextChunksFiltered = textChunksFiltered.size();
        for (int i = 0; i < sizeOfTextChunksFiltered; ++i) {
            forwardTextChunk = textChunksFiltered.get(i);
            if (lastForwardTextChunk == null) {
                forwardStringBuilder.append(forwardTextChunk.text);
                forwardTextChunkList.add(forwardTextChunk);
                forwardString = forwardStringBuilder.toString();
                if (forwardString.contains(this.keyword)) {
                    this.prepareKeywordLocInfo(locInfo, forwardTextChunkList, this.prepareKeywordIndices(forwardString, this.keyword));
                    this.clearStringBuilderAndTextChunkList(forwardStringBuilder, forwardTextChunkList);
                    forwardTextChunk = null;
                }
            } else if (forwardTextChunk.sameLine(lastForwardTextChunk)) {
                this.appendStringBuilderAndTextChunkList(forwardStringBuilder, forwardTextChunk.text, forwardTextChunkList, forwardTextChunk);
                forwardString = forwardStringBuilder.toString();
                if (forwardString.contains(this.keyword)) {
                    int sizeOfTextChunksForward = forwardTextChunkList.size();
                    for (int j = sizeOfTextChunksForward - 1; j >= 0; --j) {
                        backwardTextChunk = forwardTextChunkList.get(j);
                        if (lastBackwardTextChunk == null) {
                            this.appendStringBuilderAndTextChunkList(backwardStringBuilder, backwardTextChunk.text, backwardTextChunkList, backwardTextChunk);
                            backwardString = backwardStringBuilder.toString();
                            if (backwardString.contains(this.keyword)) {
                                this.prepareKeywordLocInfo(locInfo, backwardTextChunkList, this.prepareKeywordIndices(backwardString, this.keyword));
                                this.clearStringBuilderAndTextChunkList(forwardStringBuilder, forwardTextChunkList);
                                this.clearStringBuilderAndTextChunkList(backwardStringBuilder, backwardTextChunkList);
                                lastBackwardTextChunk = null;
                                forwardTextChunk = null;
                                break;
                            }
                        } else if (lastBackwardTextChunk.sameLine(backwardTextChunk)) {
                            backwardStringBuilder.insert(0, backwardTextChunk.text);
                            backwardTextChunkList.add(0, backwardTextChunk);
                            backwardString = backwardStringBuilder.toString();
                            if (backwardString.contains(this.keyword)) {
                                this.prepareKeywordLocInfo(locInfo, backwardTextChunkList, this.prepareKeywordIndices(backwardString, this.keyword));
                                this.clearStringBuilderAndTextChunkList(forwardStringBuilder, forwardTextChunkList);
                                this.clearStringBuilderAndTextChunkList(backwardStringBuilder, backwardTextChunkList);
                                lastBackwardTextChunk = null;
                                forwardTextChunk = null;
                                break;
                            }
                        } else {
                            this.clearStringBuilderAndTextChunkList(forwardStringBuilder, forwardTextChunkList);
                            this.clearStringBuilderAndTextChunkList(backwardStringBuilder, backwardTextChunkList);
                            this.appendStringBuilderAndTextChunkList(forwardStringBuilder, forwardTextChunk.text, forwardTextChunkList, forwardTextChunk);
                            this.appendStringBuilderAndTextChunkList(backwardStringBuilder, backwardTextChunk.text, backwardTextChunkList, backwardTextChunk);
                        }
                        lastBackwardTextChunk = backwardTextChunk;
                    }
                }
            } else {
                forwardString = forwardTextChunk.text;
                if (forwardString.contains(this.keyword)) {
                    ArrayList<TextChunk> textChunkList = new ArrayList<TextChunk>();
                    textChunkList.add(forwardTextChunk);
                    this.prepareKeywordLocInfo(locInfo, textChunkList, this.prepareKeywordIndices(forwardString, this.keyword));
                    this.clearStringBuilderAndTextChunkList(forwardStringBuilder, forwardTextChunkList);
                } else {
                    this.clearStringBuilderAndTextChunkList(forwardStringBuilder, forwardTextChunkList);
                    this.appendStringBuilderAndTextChunkList(forwardStringBuilder, forwardTextChunk.text, forwardTextChunkList, forwardTextChunk);
                }
            }
            lastForwardTextChunk = forwardTextChunk;
        }
        return locInfo;
    }

    private void removeOverlappedTextChunk(List<TextChunk> textChunksFiltered) {
        ArrayList<TextChunk> workTextChunksFiltered = new ArrayList<TextChunk>();
        Iterator<TextChunk> iterator = textChunksFiltered.iterator();
        boolean hasNext = iterator.hasNext();
        if (!hasNext) {
            return;
        }
        TextChunk lastTextChunk = iterator.next();
        workTextChunksFiltered.add(lastTextChunk);
        while (iterator.hasNext()) {
            TextChunk currentTextChunk = iterator.next();
            Vector lastStartVector = lastTextChunk.getStartLocation();
            Vector currentStartVector = currentTextChunk.getStartLocation();
            String lastText = lastTextChunk.getText();
            String currentText = currentTextChunk.getText();
            float gap = 0.0f;
            if (0 == this.rotation || 180 == this.rotation) {
                float lastStartX = lastStartVector.get(0);
                float currentStartX = currentStartVector.get(0);
                gap = Math.abs(lastStartX - currentStartX);
            } else if (90 == this.rotation || 270 == this.rotation) {
                float lastStartY = lastStartVector.get(1);
                float currentStartY = currentStartVector.get(1);
                gap = Math.abs(lastStartY - currentStartY);
            }
            if (gap < currentTextChunk.charSpaceWidth / 2.0f) {
                if (currentText.charAt(0) == ' ') {
                    lastTextChunk = currentTextChunk;
                    continue;
                }
                if (lastText.charAt(0) != ' ' && currentText.charAt(0) != ' ') {
                    lastTextChunk = currentTextChunk;
                    continue;
                }
                if (lastText.charAt(0) != ' ' || currentText.charAt(0) == ' ') continue;
                lastTextChunk = currentTextChunk;
                workTextChunksFiltered.add(currentTextChunk);
                continue;
            }
            lastTextChunk = currentTextChunk;
            workTextChunksFiltered.add(currentTextChunk);
        }
        textChunksFiltered.clear();
        textChunksFiltered.addAll(workTextChunksFiltered);
    }

    private void clearStringBuilderAndTextChunkList(StringBuilder stringBuilder, ArrayList<TextChunk> textChunkList) {
        stringBuilder.setLength(0);
        textChunkList.clear();
    }

    private void appendStringBuilderAndTextChunkList(StringBuilder stringBuilder, String appendedString, ArrayList<TextChunk> textChunkList, TextChunk appendedTextChunk) {
        stringBuilder.append(appendedString);
        textChunkList.add(appendedTextChunk);
    }

    private void prepareKeywordLocInfo(LocationInfo locInfo, ArrayList<TextChunk> textChunkList, int[] keywordIndices) {
        SignatureLandscape signatureLandscape = null;
        float[] positions = this.prepareKeywordPositions(textChunkList, keywordIndices);
        int len = positions.length;
        int n = (len - 5) / 2;
        float baseline = positions[len - 5];
        float ascend = positions[len - 4];
        float descent = positions[len - 3];
        float charSpaceWidth = positions[len - 2];
        float charTextWidth = positions[len - 1];
        for (int i = 0; i < n; ++i) {
            float y;
            float x;
            float endPos;
            float startPos;
            float width;
            if (0 == this.rotation) {
                float height = ascend - descent;
                float startPos2 = positions[i * 2];
                float endPos2 = positions[i * 2 + 1];
                float x2 = startPos2;
                float y2 = descent;
                width = endPos2 - startPos2;
                signatureLandscape = new SignatureLandscape(new Integer(this.page), new Rectangle(x2, y2, x2 + width, y2 + height), charSpaceWidth, charTextWidth, null);
            } else if (90 == this.rotation) {
                startPos = positions[i * 2];
                endPos = positions[i * 2 + 1];
                x = baseline;
                y = startPos;
                float height = endPos - startPos;
                width = ascend - descent;
                signatureLandscape = new SignatureLandscape(new Integer(this.page), new Rectangle(x, y, x + width, y + height), charSpaceWidth, charTextWidth, null);
            } else if (180 == this.rotation) {
                startPos = positions[i * 2];
                endPos = positions[i * 2 + 1];
                x = startPos;
                y = descent;
                float width2 = endPos - startPos;
                float height = ascend - descent;
                signatureLandscape = new SignatureLandscape(this.page, new Rectangle(x, y, x + width2, y + height), charSpaceWidth, charTextWidth, null);
            } else if (270 == this.rotation) {
                // empty if block
            }
            locInfo.addSignature(signatureLandscape);
        }
    }

    private int[] prepareKeywordIndices(String ContainingKeywordsString, String keyword) {
        LinkedBlockingQueue<Integer> queue = new LinkedBlockingQueue<Integer>();
        int tmpIndex = 0;
        do {
            if ((tmpIndex = ContainingKeywordsString.indexOf(keyword, tmpIndex)) <= -1) continue;
            queue.add(tmpIndex++);
        } while (tmpIndex > -1);
        int indexSize = queue.size();
        int[] keywordIndices = new int[indexSize];
        Integer tmpKeywordIndex = null;
        int i = 0;
        while ((tmpKeywordIndex = (Integer)queue.poll()) != null) {
            keywordIndices[i++] = tmpKeywordIndex;
        }
        return keywordIndices;
    }

    private float[] prepareKeywordPositions(ArrayList<TextChunk> chunkList, int[] indices) {
        int indiceslen = indices.length;
        int positionslen = indiceslen * 2 + 5;
        float[] positions = new float[positionslen];
        float charSpaceWidth = 0.0f;
        float charTextWidth = 0.0f;
        int size = chunkList.size();
        float startXY = Float.NaN;
        int keywordLen = this.keyword.length();
        if (size == 1) {
            TextChunk textChunk = chunkList.get(0);
            charSpaceWidth = textChunk.charSpaceWidth;
            DocumentFont documentFont = textChunk.getDocumentFont();
            float fontSize = textChunk.getFontSize();
            String text = textChunk.text;
            Vector startLocation = textChunk.getStartLocation();
            if (0 == this.rotation) {
                startXY = startLocation.get(0);
            } else if (90 == this.rotation) {
                startXY = startLocation.get(1);
            } else if (180 == this.rotation) {
                startXY = startLocation.get(0);
            } else if (270 == this.rotation) {
                startXY = startLocation.get(1);
            }
            float startPosition = startXY;
            float endPosition = 0.0f;
            int lastIndex = 0;
            for (int i = 0; i < indiceslen; ++i) {
                int curIndex = indices[i];
                for (int j = lastIndex; j < curIndex; ++j) {
                    char tmpChar = text.charAt(j);
                    float tmpCharTextWidth = documentFont.getWidthPoint(tmpChar, fontSize);
                    float f = charTextWidth = tmpCharTextWidth > charTextWidth ? tmpCharTextWidth : charTextWidth;
                    if (0 == this.rotation || 90 == this.rotation) {
                        startPosition += tmpCharTextWidth;
                        continue;
                    }
                    if (180 != this.rotation && 270 != this.rotation) continue;
                    startPosition -= tmpCharTextWidth;
                }
                positions[i * 2] = startPosition;
                endPosition = startPosition;
                int endIndex = keywordLen + curIndex;
                for (int j = curIndex; j < endIndex; ++j) {
                    char tmpChar = text.charAt(j);
                    float tmpCharTextWidth = documentFont.getWidthPoint(tmpChar, fontSize);
                    float f = charTextWidth = tmpCharTextWidth > charTextWidth ? tmpCharTextWidth : charTextWidth;
                    if (0 == this.rotation || 90 == this.rotation) {
                        endPosition += tmpCharTextWidth;
                        continue;
                    }
                    if (180 != this.rotation && 270 != this.rotation) continue;
                    endPosition -= tmpCharTextWidth;
                }
                positions[i * 2 + 1] = endPosition;
                if (indiceslen <= 1) continue;
                lastIndex = curIndex + keywordLen;
                startPosition = endPosition;
            }
        } else {
            String tmpLastText;
            String tmpKeyword;
            TextChunk firstChunk = chunkList.get(0);
            charSpaceWidth = firstChunk.getCharSpaceWidth();
            Vector startLocation = firstChunk.getStartLocation();
            String firstText = firstChunk.text;
            DocumentFont documentFont = firstChunk.getDocumentFont();
            float fontSize = firstChunk.getFontSize();
            if (0 == this.rotation) {
                startXY = startLocation.get(0);
            } else if (90 == this.rotation) {
                startXY = startLocation.get(1);
            } else if (180 == this.rotation) {
                startXY = startLocation.get(0);
            } else if (270 == this.rotation) {
                startXY = startLocation.get(1);
            }
            int index = indices[0];
            float startPosition = startXY;
            float endPosition = 0.0f;
            for (int i = 0; i < index; ++i) {
                float tmpCharTextWidth = documentFont.getWidthPoint(firstText.charAt(i), fontSize);
                float f = charTextWidth = tmpCharTextWidth > charTextWidth ? tmpCharTextWidth : charTextWidth;
                if (0 == this.rotation || 90 == this.rotation) {
                    startPosition += tmpCharTextWidth;
                    continue;
                }
                if (180 != this.rotation && 270 != this.rotation) continue;
                startPosition -= tmpCharTextWidth;
            }
            positions[0] = startPosition;
            TextChunk lastChunk = chunkList.get(size - 1);
            String lastText = lastChunk.text;
            startLocation = lastChunk.getStartLocation();
            documentFont = lastChunk.getDocumentFont();
            fontSize = lastChunk.getFontSize();
            if (0 == this.rotation) {
                startXY = startLocation.get(0);
            } else if (90 == this.rotation) {
                startXY = startLocation.get(1);
            } else if (180 == this.rotation) {
                startXY = startLocation.get(0);
            } else if (270 == this.rotation) {
                startXY = startLocation.get(1);
            }
            int step = 0;
            while (!(tmpKeyword = this.keyword.substring(keywordLen - step - 1)).equals(tmpLastText = lastText.substring(0, step + 1))) {
                ++step;
            }
            int tmpIndex = ++step;
            endPosition = startXY;
            for (int i = 0; i < tmpIndex; ++i) {
                float tmpCharTextWidth = documentFont.getWidthPoint(lastText.charAt(i), fontSize);
                float f = charTextWidth = tmpCharTextWidth > charTextWidth ? tmpCharTextWidth : charTextWidth;
                if (0 == this.rotation || 90 == this.rotation) {
                    endPosition += tmpCharTextWidth;
                    continue;
                }
                if (180 != this.rotation && 270 != this.rotation) continue;
                endPosition -= tmpCharTextWidth;
            }
            positions[1] = endPosition;
        }
        float ascend = chunkList.get(0).ascend;
        float descent = chunkList.get(0).descent;
        positions[positionslen - 5] = chunkList.get(0).baseline;
        positions[positionslen - 4] = ascend;
        positions[positionslen - 3] = descent;
        positions[positionslen - 2] = charSpaceWidth;
        positions[positionslen - 1] = charTextWidth;
        return positions;
    }

    @Override
    public LocationInfo getResultantKeyword() {
        LocationInfo keywordLocationInfo = this.getResultantKeyword(null);
        return keywordLocationInfo;
    }

    private void dumpState() {
        for (TextChunk location : this.locationalResult) {
            location.printDiagnostics();
            System.out.println();
        }
    }

    @Override
    public void renderText(TextRenderInfo renderInfo) {
        LineSegment ascendLine;
        LineSegment segment = renderInfo.getBaseline();
        if (renderInfo.getRise() != 0.0f) {
            Matrix riseOffsetTransform = new Matrix(0.0f, -renderInfo.getRise());
            segment = segment.transformBy(riseOffsetTransform);
        }
        float bi2 = 0.0f;
        float ai2 = 0.0f;
        float di2 = 0.0f;
        if (0 == this.rotation) {
            bi2 = segment.getStartPoint().get(1);
            ascendLine = renderInfo.getAscentLine();
            ai2 = ascendLine.getStartPoint().get(1);
            LineSegment descentLine = renderInfo.getDescentLine();
            di2 = descentLine.getStartPoint().get(1);
        } else if (90 == this.rotation) {
            bi2 = segment.getStartPoint().get(0);
            ascendLine = renderInfo.getAscentLine();
            ai2 = ascendLine.getStartPoint().get(0);
            LineSegment descentLine = renderInfo.getDescentLine();
            di2 = descentLine.getStartPoint().get(0);
        } else if (180 == this.rotation) {
            bi2 = segment.getStartPoint().get(1);
            ascendLine = renderInfo.getAscentLine();
            ai2 = ascendLine.getStartPoint().get(1);
            LineSegment descentLine = renderInfo.getDescentLine();
            di2 = descentLine.getStartPoint().get(1);
        } else if (270 == this.rotation) {
            // empty if block
        }
        TextChunk location = new TextChunk(renderInfo.getText(), segment.getStartPoint(), segment.getEndPoint(), renderInfo.getSingleSpaceWidth(), bi2, ai2, di2, renderInfo.getFont(), ai2 - di2);
        this.locationalResult.add(location);
    }

    @Override
    public void renderImage(ImageRenderInfo renderInfo) {
    }

    public static interface TextChunkFilter {
        public boolean accept(TextChunk var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TextChunk
    implements Comparable<TextChunk> {
        private final String text;
        private final Vector startLocation;
        private final Vector endLocation;
        private final Vector orientationVector;
        private final int orientationMagnitude;
        private final int distPerpendicular;
        private final float distParallelStart;
        private final float distParallelEnd;
        private final float charSpaceWidth;
        private float ascend;
        private float descent;
        private float baseline;
        private DocumentFont documentFont;
        private float fontSize;

        public TextChunk(String string, Vector startLocation, Vector endLocation, float charSpaceWidth) {
            this.text = string;
            this.startLocation = startLocation;
            this.endLocation = endLocation;
            this.charSpaceWidth = charSpaceWidth;
            Vector oVector = endLocation.subtract(startLocation);
            if (oVector.length() == 0.0f) {
                oVector = new Vector(1.0f, 0.0f, 0.0f);
            }
            this.orientationVector = oVector.normalize();
            this.orientationMagnitude = (int)(Math.atan2(this.orientationVector.get(1), this.orientationVector.get(0)) * 1000.0);
            Vector origin = new Vector(0.0f, 0.0f, 1.0f);
            this.distPerpendicular = (int)startLocation.subtract(origin).cross(this.orientationVector).get(2);
            this.distParallelStart = this.orientationVector.dot(startLocation);
            this.distParallelEnd = this.orientationVector.dot(endLocation);
        }

        public TextChunk(String string, Vector startLocation, Vector endLocation, float charSpaceWidth, float baseline, float ascend, float descent, DocumentFont documentFont, float fontSize) {
            this(string, startLocation, endLocation, charSpaceWidth);
            this.baseline = baseline;
            this.ascend = ascend;
            this.descent = descent;
            this.documentFont = documentFont;
            this.fontSize = Math.abs(fontSize);
        }

        public Vector getStartLocation() {
            return this.startLocation;
        }

        public DocumentFont getDocumentFont() {
            return this.documentFont;
        }

        public float getFontSize() {
            return this.fontSize;
        }

        public Vector getEndLocation() {
            return this.endLocation;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "Text (@" + this.startLocation + " -> " + this.endLocation + "): " + this.text;
        }

        public float getCharSpaceWidth() {
            return this.charSpaceWidth;
        }

        private void printDiagnostics() {
            System.out.println("Text (@" + this.startLocation + " -> " + this.endLocation + "): " + this.text);
            System.out.println("orientationMagnitude: " + this.orientationMagnitude);
            System.out.println("distPerpendicular: " + this.distPerpendicular);
            System.out.println("distParallel: " + this.distParallelStart);
        }

        public boolean sameLine(TextChunk textChunk) {
            if (this.orientationMagnitude != textChunk.orientationMagnitude) {
                return false;
            }
            float offsetLine = textChunk.getFontSize() / 5.0f;
            return this.distPerpendicular == textChunk.distPerpendicular;
        }

        public float distanceFromEndOf(TextChunk other) {
            float distance = this.distParallelStart - other.distParallelEnd;
            return distance;
        }

        @Override
        public int compareTo(TextChunk rhs) {
            if (this == rhs) {
                return 0;
            }
            int rslt = TextChunk.compareInts(this.orientationMagnitude, rhs.orientationMagnitude);
            if (rslt != 0) {
                return rslt;
            }
            rslt = TextChunk.compareInts(this.distPerpendicular, rhs.distPerpendicular);
            if (rslt != 0) {
                return rslt;
            }
            return Float.compare(this.distParallelStart, rhs.distParallelStart);
        }

        private static int compareInts(int int1, int int2) {
            return int1 == int2 ? 0 : (int1 < int2 ? -1 : 1);
        }
    }
}

