/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf;

import cfca.com.itextpdf.text.Document;
import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.pdf.PdfCopy;
import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.com.itextpdf.text.pdf.PdfSmartCopy;
import java.io.IOException;
import java.io.OutputStream;

public class PdfConcatenate {
    protected Document document = new Document();
    protected PdfCopy copy;

    public PdfConcatenate(OutputStream os) throws DocumentException {
        this(os, false);
    }

    public PdfConcatenate(OutputStream os, boolean smart) throws DocumentException {
        this.copy = smart ? new PdfSmartCopy(this.document, os) : new PdfCopy(this.document, os);
    }

    public int addPages(PdfReader reader) throws DocumentException, IOException {
        this.open();
        int n = reader.getNumberOfPages();
        for (int i = 1; i <= n; ++i) {
            this.copy.addPage(this.copy.getImportedPage(reader, i));
        }
        this.copy.freeReader(reader);
        reader.close();
        return n;
    }

    public PdfCopy getWriter() {
        return this.copy;
    }

    public void open() {
        if (!this.document.isOpen()) {
            this.document.open();
        }
    }

    public void close() {
        this.document.close();
    }
}

