/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.access.servlet;

import cfca.ch.qos.logback.access.servlet.TeeHttpServletRequest;
import cfca.ch.qos.logback.access.servlet.TeeHttpServletResponse;
import cfca.logback.util.SystemUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TeeFilter
implements Filter {
    boolean active;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.active && request instanceof HttpServletRequest) {
            try {
                TeeHttpServletRequest teeRequest = new TeeHttpServletRequest((HttpServletRequest)request);
                TeeHttpServletResponse teeResponse = new TeeHttpServletResponse((HttpServletResponse)response);
                filterChain.doFilter((ServletRequest)teeRequest, (ServletResponse)teeResponse);
                teeResponse.finish();
                teeRequest.setAttribute("LB_OUTPUT_BUFFER", teeResponse.getOutputBuffer());
            }
            catch (IOException e) {
                SystemUtil.printStackTrace(e);
                throw e;
            }
            catch (ServletException e) {
                SystemUtil.printStackTrace(e);
                throw e;
            }
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String includeListAsStr = filterConfig.getInitParameter("includes");
        String excludeListAsStr = filterConfig.getInitParameter("excludes");
        String localhostName = TeeFilter.getLocalhostName();
        this.active = TeeFilter.computeActivation(localhostName, includeListAsStr, excludeListAsStr);
        if (this.active) {
            SystemUtil.OUT.println("TeeFilter will be ACTIVE on this host [" + localhostName + "]");
        } else {
            SystemUtil.OUT.println("TeeFilter will be DISABLED on this host [" + localhostName + "]");
        }
    }

    static List<String> extractNameList(String nameListAsStr) {
        String[] nameArray;
        ArrayList<String> nameList = new ArrayList<String>();
        if (nameListAsStr == null) {
            return nameList;
        }
        if ((nameListAsStr = nameListAsStr.trim()).length() == 0) {
            return nameList;
        }
        for (String n : nameArray = nameListAsStr.split("[,;]")) {
            n = n.trim();
            nameList.add(n);
        }
        return nameList;
    }

    static String getLocalhostName() {
        String hostname = "127.0.0.1";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            SystemUtil.printStackTrace(e);
        }
        return hostname;
    }

    static boolean computeActivation(String hostname, String includeListAsStr, String excludeListAsStr) {
        List<String> includeList = TeeFilter.extractNameList(includeListAsStr);
        List<String> excludeList = TeeFilter.extractNameList(excludeListAsStr);
        boolean inIncludesList = TeeFilter.mathesIncludesList(hostname, includeList);
        boolean inExcludesList = TeeFilter.mathesExcludesList(hostname, excludeList);
        return inIncludesList && !inExcludesList;
    }

    static boolean mathesIncludesList(String hostname, List<String> includeList) {
        boolean includesListFlag = true;
        includesListFlag = includeList.isEmpty() ? true : includeList.contains(hostname);
        return includesListFlag;
    }

    static boolean mathesExcludesList(String hostname, List<String> excludesList) {
        boolean excludesListFlag = false;
        excludesListFlag = excludesList.isEmpty() ? false : excludesList.contains(hostname);
        return excludesListFlag;
    }
}

