/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.javax.net.ssl;

import cfca.sadk.tls.java.security.CFCAAlgorithmConstraints;
import cfca.sadk.tls.javax.net.ssl.CFCASNIMatcher;
import cfca.sadk.tls.javax.net.ssl.CFCASNIServerName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CFCASSLParameters {
    private String[] cipherSuites;
    private String[] protocols;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private String identificationAlgorithm;
    private CFCAAlgorithmConstraints algorithmConstraints;
    private Map<Integer, CFCASNIServerName> sniNames = null;
    private Map<Integer, CFCASNIMatcher> sniMatchers = null;
    private boolean preferLocalCipherSuites;

    public CFCASSLParameters() {
    }

    public CFCASSLParameters(String[] cipherSuites) {
        this.setCipherSuites(cipherSuites);
    }

    public CFCASSLParameters(String[] cipherSuites, String[] protocols) {
        this.setCipherSuites(cipherSuites);
        this.setProtocols(protocols);
    }

    private static String[] clone(String[] s) {
        return s == null ? null : (String[])s.clone();
    }

    public String[] getCipherSuites() {
        return CFCASSLParameters.clone(this.cipherSuites);
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = CFCASSLParameters.clone(cipherSuites);
    }

    public String[] getProtocols() {
        return CFCASSLParameters.clone(this.protocols);
    }

    public void setProtocols(String[] protocols) {
        this.protocols = CFCASSLParameters.clone(protocols);
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
        this.needClientAuth = false;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.wantClientAuth = false;
        this.needClientAuth = needClientAuth;
    }

    public CFCAAlgorithmConstraints getAlgorithmConstraints() {
        return this.algorithmConstraints;
    }

    public void setAlgorithmConstraints(CFCAAlgorithmConstraints constraints) {
        this.algorithmConstraints = constraints;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.identificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String algorithm) {
        this.identificationAlgorithm = algorithm;
    }

    public final void setServerNames(List<CFCASNIServerName> serverNames) {
        if (serverNames != null) {
            if (!serverNames.isEmpty()) {
                this.sniNames = new LinkedHashMap<Integer, CFCASNIServerName>(serverNames.size());
                for (CFCASNIServerName serverName : serverNames) {
                    if (this.sniNames.put(serverName.getType(), serverName) == null) continue;
                    throw new IllegalArgumentException("Duplicated server name of type " + serverName.getType());
                }
            } else {
                this.sniNames = Collections.emptyMap();
            }
        } else {
            this.sniNames = null;
        }
    }

    public final List<CFCASNIServerName> getServerNames() {
        if (this.sniNames != null) {
            if (!this.sniNames.isEmpty()) {
                return Collections.unmodifiableList(new ArrayList<CFCASNIServerName>(this.sniNames.values()));
            }
            return Collections.emptyList();
        }
        return null;
    }

    public final void setSNIMatchers(List<CFCASNIMatcher> matchers) {
        if (matchers != null) {
            if (!matchers.isEmpty()) {
                this.sniMatchers = new HashMap<Integer, CFCASNIMatcher>(matchers.size());
                for (CFCASNIMatcher matcher : matchers) {
                    if (this.sniMatchers.put(matcher.getType(), matcher) == null) continue;
                    throw new IllegalArgumentException("Duplicated server name of type " + matcher.getType());
                }
            } else {
                this.sniMatchers = Collections.emptyMap();
            }
        } else {
            this.sniMatchers = null;
        }
    }

    public final List<CFCASNIMatcher> getSNIMatchers() {
        if (this.sniMatchers != null) {
            if (!this.sniMatchers.isEmpty()) {
                return Collections.unmodifiableList(new ArrayList<CFCASNIMatcher>(this.sniMatchers.values()));
            }
            return Collections.emptyList();
        }
        return null;
    }

    public final void setUseCipherSuitesOrder(boolean honorOrder) {
        this.preferLocalCipherSuites = honorOrder;
    }

    public final boolean getUseCipherSuitesOrder() {
        return this.preferLocalCipherSuites;
    }
}

