/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.log;

import cfca.com.itextpdf.text.log.Appender;
import cfca.com.itextpdf.text.log.ConsoleAppender;
import cfca.com.itextpdf.text.log.FileAppender;
import cfca.com.itextpdf.text.log.Level;
import cfca.com.itextpdf.text.log.Logger;
import cfca.com.itextpdf.text.log.LoggerFactory;
import cfca.com.itextpdf.text.log.SysoLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LoggerConfigure {
    private static Logger logger = null;
    private static int level;
    private static ArrayList<Appender> appenderList;

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
        LoggerConfigure.configure();
    }

    public static void configure() throws ParserConfigurationException, SAXException, IOException {
        InputStream is = LoggerConfigure.class.getClassLoader().getResourceAsStream("logself.xml");
        LoggerConfigure.configure(is);
    }

    public static void configure(String configFilePath) throws ParserConfigurationException, SAXException, IOException {
        FileInputStream fis = new FileInputStream(configFilePath);
        LoggerConfigure.configure(fis);
    }

    public static void configure(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder db = factory.newDocumentBuilder();
        Document document = db.parse(is);
        NodeList nodeList = document.getElementsByTagName("root");
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element element = (Element)nodeList.item(i);
            String levelAsString = element.getAttribute("level");
            if ("error".equals(levelAsString)) {
                level = Level.ERROR.ordinal();
            } else if ("warn".equals(levelAsString)) {
                level = Level.WARN.ordinal();
            } else if ("info".equals(levelAsString)) {
                level = Level.INFO.ordinal();
            } else if ("debug".equals(levelAsString)) {
                level = Level.DEBUG.ordinal();
            } else if ("trace".equals(levelAsString)) {
                level = Level.TRACE.ordinal();
            }
            NodeList appenderNodeList = element.getElementsByTagName("appender-ref");
            appenderList.clear();
            int length1 = appenderNodeList.getLength();
            for (int j = 0; j < length1; ++j) {
                Element appenderElement = (Element)appenderNodeList.item(j);
                String refAsString = appenderElement.getAttribute("ref");
                if ("ConsoleAppender".equals(refAsString)) {
                    ConsoleAppender appender = new ConsoleAppender();
                    appenderList.add(appender);
                    continue;
                }
                if (!"FileAppender".equals(refAsString)) continue;
                NodeList propertyNodeList = document.getElementsByTagName("property");
                int klength = propertyNodeList.getLength();
                for (int k = 0; k < klength; ++k) {
                    String value;
                    Element propertyElement = (Element)propertyNodeList.item(k);
                    String name = propertyElement.getAttribute("name");
                    if (!"LogFolder".equals(name)) continue;
                    String logFolderPath = value = propertyElement.getAttribute("value");
                    FileAppender appender = new FileAppender(logFolderPath);
                    appenderList.add(appender);
                }
            }
        }
    }

    public static Logger getLogger(Class clazz) {
        SysoLogger sysoLogger = new SysoLogger(0);
        sysoLogger.setAppenderList(appenderList);
        sysoLogger.setLevel(level);
        LoggerFactory loggerFactory = LoggerFactory.getInstance();
        loggerFactory.setLogger(sysoLogger);
        logger = LoggerFactory.getLogger(clazz);
        return logger;
    }

    static {
        appenderList = new ArrayList();
    }
}

