/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sadk.tls.sun.security.ssl.sec.CryptoFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public final class SM2Signature
extends Signature {
    private static final Mechanism signAlg = new Mechanism("sm3WithSM2Encryption");
    private SM3Digest hash = new SM3Digest();
    private PublicKey publicKey = null;
    private PrivateKey privateKey = null;

    public SM2Signature(String algorithm) {
        super(algorithm);
    }

    public static final SM2Signature newSignature() {
        return new SM2Signature(signAlg.getMechanismType());
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = null;
        this.privateKey = null;
        if (publicKey == null) {
            throw new InvalidKeyException("null publicKey");
        }
        this.hash.reset();
        SM2PublicKey sm2PublicKey = null;
        if (publicKey instanceof SM2PublicKey) {
            sm2PublicKey = (SM2PublicKey)publicKey;
        } else if (publicKey instanceof BCECPublicKey) {
            sm2PublicKey = new SM2PublicKey(publicKey.getEncoded());
        } else {
            throw new InvalidKeyException("invalid publicKey");
        }
        byte[] zvalue = sm2PublicKey.getZvalue();
        this.hash.update(zvalue, 0, zvalue.length);
        this.publicKey = sm2PublicKey;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.publicKey = null;
        this.privateKey = null;
        if (privateKey == null) {
            throw new InvalidKeyException("null privateKey");
        }
        this.hash.reset();
        SM2PrivateKey sm2PrivateKey = null;
        if (privateKey instanceof SM2PrivateKey) {
            sm2PrivateKey = (SM2PrivateKey)privateKey;
        } else if (privateKey instanceof BCECPrivateKey) {
            BCECPrivateKey ecPrivateKey = (BCECPrivateKey)privateKey;
            ECPoint iPub = ecPrivateKey.getQ().normalize();
            sm2PrivateKey = new SM2PrivateKey(ecPrivateKey.getD(), iPub.getAffineXCoord().toBigInteger(), iPub.getAffineYCoord().toBigInteger());
        } else {
            throw new InvalidKeyException("invalid privateKey");
        }
        byte[] zvalue = sm2PrivateKey.getZvalue();
        this.hash.update(zvalue, 0, zvalue.length);
        this.privateKey = sm2PrivateKey;
    }

    @Override
    protected void engineUpdate(byte data) throws SignatureException {
        this.hash.update(data);
    }

    @Override
    protected void engineUpdate(byte[] data, int off, int len) throws SignatureException {
        this.hash.update(data, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.privateKey == null) {
            throw new SignatureException("null privateKey");
        }
        byte[] hashValue = new byte[32];
        this.hash.doFinal(hashValue, 0);
        byte[] signData = null;
        if (this.privateKey instanceof SM2PrivateKey) {
            try {
                Session session = CryptoFactory.singleton().session();
                signData = session.signByHash(signAlg, this.privateKey, hashValue);
                signData = signData.length == 64 ? new ASN1SM2Signature(signData).getEncoded() : new ASN1SM2Signature(signData).getEncoded();
            }
            catch (IOException e) {
                throw new SignatureException(e);
            }
            catch (SecurityException e) {
                throw new SignatureException(e);
            }
            catch (PKIException e) {
                throw new SignatureException(e);
            }
        }
        return signData;
    }

    @Override
    protected boolean engineVerify(byte[] signData) throws SignatureException {
        if (signData == null) {
            throw new SignatureException("null signData");
        }
        if (this.publicKey == null) {
            throw new SignatureException("null publicKey");
        }
        byte[] hashValue = new byte[32];
        this.hash.doFinal(hashValue, 0);
        boolean verifiedResult = false;
        if (this.publicKey instanceof SM2PublicKey) {
            try {
                Session session = CryptoFactory.singleton().session();
                if (signData.length != 64) {
                    ASN1SM2Signature signValue = new ASN1SM2Signature(signData);
                    byte[] rBytes = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)signValue.getR().getPositiveValue());
                    byte[] sBytes = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)signValue.getS().getPositiveValue());
                    signData = new byte[64];
                    System.arraycopy(rBytes, 0, signData, 0, 32);
                    System.arraycopy(sBytes, 0, signData, 32, 32);
                }
                verifiedResult = session.verifyByHash(signAlg, this.publicKey, hashValue, signData);
            }
            catch (SecurityException e) {
                throw new SignatureException(e);
            }
            catch (PKIException e) {
                e.printStackTrace();
                throw new SignatureException(e);
            }
        }
        return verifiedResult;
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }
}

