/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;
import cfca.sadk.tls.sun.security.ssl.prf.HashPRF;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialsConstants;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialsTools;
import cfca.sadk.tls.sun.security.ssl.prf.TlsPrfParameters;
import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class TlsPrfGenerator
implements TlsKeyMaterialsConstants {
    private static final byte[] B0 = new byte[0];
    private static final byte[] HMAC_ipad64 = TlsKeyMaterialsTools.genPad((byte)54, 64);
    private static final byte[] HMAC_ipad128 = TlsKeyMaterialsTools.genPad((byte)54, 128);
    private static final byte[] HMAC_opad64 = TlsKeyMaterialsTools.genPad((byte)92, 64);
    private static final byte[] HMAC_opad128 = TlsKeyMaterialsTools.genPad((byte)92, 128);

    TlsPrfGenerator() {
    }

    final SecretKey generateKey(TlsPrfParameters params, boolean newForm) throws GeneralSecurityException {
        this.checkParameters(params);
        SecretKey key = params.getSecret();
        byte[] secret = key == null ? null : key.getEncoded();
        try {
            byte[] labelBytes = params.getLabel().getBytes("UTF8");
            byte[] seedBytes = params.getSeed();
            int outputLength = params.getOutputLength();
            byte[] prfBytes = null;
            prfBytes = newForm ? TlsPrfGenerator.doTLS12PRF(secret, labelBytes, seedBytes, outputLength, params.hashPRF()) : TlsPrfGenerator.doTLS10PRF(secret, labelBytes, seedBytes, outputLength);
            return new SecretKeySpec(prfBytes, "TlsPrf");
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.generateKey"), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ProviderException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.generateKey"), e);
        }
    }

    private void checkParameters(TlsPrfParameters params) {
        if (params == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "TlsPrfParameters"));
        }
        if (!"RAW".equals(params.getSecret().getFormat())) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.mustBeRAW", "TlsPrfParameters#Secret"));
        }
        if (params.getLabel() == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "TlsPrfParameters#Label"));
        }
    }

    static byte[] doSSL30PRF(byte[] masterSecret, byte[] serverRandom, byte[] clientRandom, int keyBlockLen, MessageDigest md5, MessageDigest sha) throws DigestException {
        byte[] keyBlock = new byte[keyBlockLen];
        byte[] tmp = new byte[20];
        int i = 0;
        for (int remaining = keyBlockLen; remaining > 0; remaining -= 16) {
            sha.update(SSL3_CONST[i]);
            sha.update(masterSecret);
            sha.update(serverRandom);
            sha.update(clientRandom);
            sha.digest(tmp, 0, 20);
            md5.update(masterSecret);
            md5.update(tmp);
            if (remaining >= 16) {
                md5.digest(keyBlock, i << 4, 16);
            } else {
                md5.digest(tmp, 0, 16);
                System.arraycopy(tmp, 0, keyBlock, i << 4, remaining);
            }
            ++i;
        }
        return keyBlock;
    }

    static byte[] doTLS12PRF(byte[] secret, byte[] labelBytes, byte[] seed, int outputLength, HashPRF prfHashParameters) throws NoSuchAlgorithmException, DigestException {
        byte[] opad;
        byte[] ipad;
        if (prfHashParameters == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "prfHashParameters"));
        }
        if (prfHashParameters.prfHashAlg == null) {
            throw new NoSuchAlgorithmException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "prfHashParameters#prfHash"));
        }
        MessageDigest mdPRF = JSSEJCE.getMessageDigest(prfHashParameters.prfHashAlg);
        if (mdPRF == null) {
            throw new IllegalStateException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "mdPRF"));
        }
        int mdPRFLen = prfHashParameters.prfHashLength;
        int mdPRFBlockSize = prfHashParameters.prfBlockSize;
        if (secret == null) {
            secret = B0;
        }
        if (secret.length > mdPRFBlockSize) {
            secret = mdPRF.digest(secret);
        }
        byte[] output = new byte[outputLength];
        switch (mdPRFBlockSize) {
            case 64: {
                ipad = (byte[])HMAC_ipad64.clone();
                opad = (byte[])HMAC_opad64.clone();
                break;
            }
            case 128: {
                ipad = (byte[])HMAC_ipad128.clone();
                opad = (byte[])HMAC_opad128.clone();
                break;
            }
            default: {
                throw new DigestException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.unexpectedBlockSize"));
            }
        }
        TlsPrfGenerator.expand(mdPRF, mdPRFLen, secret, 0, secret.length, labelBytes, seed, output, ipad, opad);
        return output;
    }

    static byte[] doTLS10PRF(byte[] secret, byte[] labelBytes, byte[] seed, int outputLength) throws NoSuchAlgorithmException, DigestException {
        MessageDigest md5 = JSSEJCE.getMessageDigest("MD5");
        MessageDigest sha = JSSEJCE.getMessageDigest("SHA1");
        return TlsPrfGenerator.doTLS10PRF(secret, labelBytes, seed, outputLength, md5, sha);
    }

    static byte[] doTLS10PRF(byte[] secret, byte[] labelBytes, byte[] seed, int outputLength, MessageDigest md5, MessageDigest sha) throws DigestException {
        if (secret == null) {
            secret = B0;
        }
        int off = secret.length >> 1;
        int seclen = off + (secret.length & 1);
        byte[] secKey = secret;
        int keyLen = seclen;
        byte[] output = new byte[outputLength];
        if (seclen > 64) {
            md5.update(secret, 0, seclen);
            secKey = md5.digest();
            keyLen = secKey.length;
        }
        TlsPrfGenerator.expand(md5, 16, secKey, 0, keyLen, labelBytes, seed, output, (byte[])HMAC_ipad64.clone(), (byte[])HMAC_opad64.clone());
        if (seclen > 64) {
            sha.update(secret, off, seclen);
            secKey = sha.digest();
            keyLen = secKey.length;
            off = 0;
        }
        TlsPrfGenerator.expand(sha, 20, secKey, off, keyLen, labelBytes, seed, output, (byte[])HMAC_ipad64.clone(), (byte[])HMAC_opad64.clone());
        return output;
    }

    private static void expand(MessageDigest digest, int hmacSize, byte[] secret, int secOff, int secLen, byte[] label, byte[] seed, byte[] output, byte[] pad1, byte[] pad2) throws DigestException {
        int k;
        for (int i = 0; i < secLen; ++i) {
            int n = i;
            pad1[n] = (byte)(pad1[n] ^ secret[i + secOff]);
            int n2 = i;
            pad2[n2] = (byte)(pad2[n2] ^ secret[i + secOff]);
        }
        byte[] tmp = new byte[hmacSize];
        byte[] aBytes = null;
        int ofs = 0;
        for (int remaining = output.length; remaining > 0; remaining -= k) {
            digest.update(pad1);
            if (aBytes == null) {
                digest.update(label);
                digest.update(seed);
            } else {
                digest.update(aBytes);
            }
            digest.digest(tmp, 0, hmacSize);
            digest.update(pad2);
            digest.update(tmp);
            if (aBytes == null) {
                aBytes = new byte[hmacSize];
            }
            digest.digest(aBytes, 0, hmacSize);
            digest.update(pad1);
            digest.update(aBytes);
            digest.update(label);
            digest.update(seed);
            digest.digest(tmp, 0, hmacSize);
            digest.update(pad2);
            digest.update(tmp);
            digest.digest(tmp, 0, hmacSize);
            k = Math.min(hmacSize, remaining);
            for (int i = 0; i < k; ++i) {
                int n = ofs++;
                output[n] = (byte)(output[n] ^ tmp[i]);
            }
        }
    }
}

