/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.bitmap;

import cfca.com.google.typography.font.sfntly.data.FontData;
import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.math.FontMath;
import cfca.com.google.typography.font.sfntly.table.SubTable;
import cfca.com.google.typography.font.sfntly.table.bitmap.BitmapGlyphInfo;
import cfca.com.google.typography.font.sfntly.table.bitmap.EblcTable;
import cfca.com.google.typography.font.sfntly.table.bitmap.IndexSubTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public final class BitmapSizeTable
extends SubTable {
    private static final boolean USE_BINARY_SEARCH = false;
    private final Object indexSubTablesLock = new Object();
    private volatile List<IndexSubTable> indexSubTables = null;

    protected BitmapSizeTable(ReadableFontData data, ReadableFontData masterData) {
        super(data, masterData);
    }

    public int indexSubTableArrayOffset() {
        return this.data.readULongAsInt(EblcTable.Offset.bitmapSizeTable_indexSubTableArrayOffset.offset);
    }

    public int indexTableSize() {
        return this.data.readULongAsInt(EblcTable.Offset.bitmapSizeTable_indexTableSize.offset);
    }

    private static int numberOfIndexSubTables(ReadableFontData data, int tableOffset) {
        return data.readULongAsInt(tableOffset + EblcTable.Offset.bitmapSizeTable_numberOfIndexSubTables.offset);
    }

    public int numberOfIndexSubTables() {
        return BitmapSizeTable.numberOfIndexSubTables(this.data, 0);
    }

    public int colorRef() {
        return this.data.readULongAsInt(EblcTable.Offset.bitmapSizeTable_colorRef.offset);
    }

    public void hori() {
    }

    public void vert() {
    }

    public int startGlyphIndex() {
        return this.data.readUShort(EblcTable.Offset.bitmapSizeTable_startGlyphIndex.offset);
    }

    public int endGlyphIndex() {
        return this.data.readUShort(EblcTable.Offset.bitmapSizeTable_endGlyphIndex.offset);
    }

    public int ppemX() {
        return this.data.readByte(EblcTable.Offset.bitmapSizeTable_ppemX.offset);
    }

    public int ppemY() {
        return this.data.readByte(EblcTable.Offset.bitmapSizeTable_ppemY.offset);
    }

    public int bitDepth() {
        return this.data.readByte(EblcTable.Offset.bitmapSizeTable_bitDepth.offset);
    }

    public int flagsAsInt() {
        return this.data.readChar(EblcTable.Offset.bitmapSizeTable_flags.offset);
    }

    public IndexSubTable indexSubTable(int index) {
        List<IndexSubTable> subTableList = this.getIndexSubTableList();
        return subTableList.get(index);
    }

    public BitmapGlyphInfo glyphInfo(int glyphId) {
        IndexSubTable subTable = this.searchIndexSubTables(glyphId);
        if (subTable == null) {
            return null;
        }
        return subTable.glyphInfo(glyphId);
    }

    public int glyphOffset(int glyphId) {
        IndexSubTable subTable = this.searchIndexSubTables(glyphId);
        if (subTable == null) {
            return -1;
        }
        return subTable.glyphOffset(glyphId);
    }

    public int glyphLength(int glyphId) {
        IndexSubTable subTable = this.searchIndexSubTables(glyphId);
        if (subTable == null) {
            return -1;
        }
        return subTable.glyphLength(glyphId);
    }

    public int glyphFormat(int glyphId) {
        IndexSubTable subTable = this.searchIndexSubTables(glyphId);
        if (subTable == null) {
            return -1;
        }
        return subTable.imageFormat();
    }

    private IndexSubTable searchIndexSubTables(int glyphId) {
        return this.linearSearchIndexSubTables(glyphId);
    }

    private IndexSubTable linearSearchIndexSubTables(int glyphId) {
        for (IndexSubTable subTable : this.getIndexSubTableList()) {
            if (subTable.firstGlyphIndex() > glyphId || subTable.lastGlyphIndex() < glyphId) continue;
            return subTable;
        }
        return null;
    }

    private IndexSubTable binarySearchIndexSubTables(int glyphId) {
        List<IndexSubTable> subTableList = this.getIndexSubTableList();
        int index = 0;
        int bottom = 0;
        int top = subTableList.size();
        while (top != bottom) {
            index = (top + bottom) / 2;
            IndexSubTable subTable = subTableList.get(index);
            if (glyphId < subTable.firstGlyphIndex()) {
                top = index;
                continue;
            }
            if (glyphId <= subTable.lastGlyphIndex()) {
                return subTable;
            }
            bottom = index + 1;
        }
        return null;
    }

    private IndexSubTable createIndexSubTable(int index) {
        return IndexSubTable.createIndexSubTable(this.masterReadData(), this.indexSubTableArrayOffset(), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IndexSubTable> getIndexSubTableList() {
        if (this.indexSubTables == null) {
            Object object = this.indexSubTablesLock;
            synchronized (object) {
                if (this.indexSubTables == null) {
                    ArrayList<IndexSubTable> subTables = new ArrayList<IndexSubTable>(this.numberOfIndexSubTables());
                    for (int i = 0; i < this.numberOfIndexSubTables(); ++i) {
                        subTables.add(this.createIndexSubTable(i));
                    }
                    this.indexSubTables = subTables;
                }
            }
        }
        return this.indexSubTables;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("BitmapSizeTable: ");
        List<IndexSubTable> indexSubTableList = this.getIndexSubTableList();
        sb.append("[s=0x");
        sb.append(Integer.toHexString(this.startGlyphIndex()));
        sb.append(", e=0x");
        sb.append(Integer.toHexString(this.endGlyphIndex()));
        sb.append(", ppemx=");
        sb.append(this.ppemX());
        sb.append(", index subtables count=");
        sb.append(this.numberOfIndexSubTables());
        sb.append("]");
        for (int index = 0; index < indexSubTableList.size(); ++index) {
            sb.append("\n\t");
            sb.append(index);
            sb.append(": ");
            sb.append(indexSubTableList.get(index));
            sb.append(", ");
        }
        sb.append("\n");
        return sb.toString();
    }

    public static final class Builder
    extends SubTable.Builder<BitmapSizeTable> {
        List<IndexSubTable.Builder<? extends IndexSubTable>> indexSubTables;

        static Builder createBuilder(WritableFontData data, ReadableFontData masterData) {
            return new Builder(data, masterData);
        }

        static Builder createBuilder(ReadableFontData data, ReadableFontData masterData) {
            return new Builder(data, masterData);
        }

        private Builder(WritableFontData data, ReadableFontData masterData) {
            super(data, masterData);
        }

        private Builder(ReadableFontData data, ReadableFontData masterData) {
            super(data, masterData);
        }

        public int indexSubTableArrayOffset() {
            return this.internalReadData().readULongAsInt(EblcTable.Offset.bitmapSizeTable_indexSubTableArrayOffset.offset);
        }

        void setIndexSubTableArrayOffset(int offset) {
            this.internalWriteData().writeULong(EblcTable.Offset.bitmapSizeTable_indexSubTableArrayOffset.offset, offset);
        }

        public int indexTableSize() {
            return this.internalReadData().readULongAsInt(EblcTable.Offset.bitmapSizeTable_indexTableSize.offset);
        }

        void setIndexTableSize(int size) {
            this.internalWriteData().writeULong(EblcTable.Offset.bitmapSizeTable_indexTableSize.offset, size);
        }

        public int numberOfIndexSubTables() {
            return this.getIndexSubTableBuilders().size();
        }

        private void setNumberOfIndexSubTables(int numberOfIndexSubTables) {
            this.internalWriteData().writeULong(EblcTable.Offset.bitmapSizeTable_numberOfIndexSubTables.offset, numberOfIndexSubTables);
        }

        public int colorRef() {
            return this.internalReadData().readULongAsInt(EblcTable.Offset.bitmapSizeTable_colorRef.offset);
        }

        public void hori() {
        }

        public void vert() {
        }

        public int startGlyphIndex() {
            return this.internalReadData().readUShort(EblcTable.Offset.bitmapSizeTable_startGlyphIndex.offset);
        }

        public int endGlyphIndex() {
            return this.internalReadData().readUShort(EblcTable.Offset.bitmapSizeTable_endGlyphIndex.offset);
        }

        public int ppemX() {
            return this.internalReadData().readByte(EblcTable.Offset.bitmapSizeTable_ppemX.offset);
        }

        public int ppemY() {
            return this.internalReadData().readByte(EblcTable.Offset.bitmapSizeTable_ppemY.offset);
        }

        public int bitDepth() {
            return this.internalReadData().readByte(EblcTable.Offset.bitmapSizeTable_bitDepth.offset);
        }

        public int flagsAsInt() {
            return this.internalReadData().readChar(EblcTable.Offset.bitmapSizeTable_flags.offset);
        }

        public IndexSubTable.Builder<? extends IndexSubTable> indexSubTableBuilder(int index) {
            List<IndexSubTable.Builder<? extends IndexSubTable>> subTableList = this.getIndexSubTableBuilders();
            return subTableList.get(index);
        }

        public BitmapGlyphInfo glyphInfo(int glyphId) {
            IndexSubTable.Builder<? extends IndexSubTable> subTable = this.searchIndexSubTables(glyphId);
            if (subTable == null) {
                return null;
            }
            return subTable.glyphInfo(glyphId);
        }

        public int glyphOffset(int glyphId) {
            IndexSubTable.Builder<? extends IndexSubTable> subTable = this.searchIndexSubTables(glyphId);
            if (subTable == null) {
                return -1;
            }
            return subTable.glyphOffset(glyphId);
        }

        public int glyphLength(int glyphId) {
            IndexSubTable.Builder<? extends IndexSubTable> subTable = this.searchIndexSubTables(glyphId);
            if (subTable == null) {
                return -1;
            }
            return subTable.glyphLength(glyphId);
        }

        public int glyphFormat(int glyphId) {
            IndexSubTable.Builder<? extends IndexSubTable> subTable = this.searchIndexSubTables(glyphId);
            if (subTable == null) {
                return -1;
            }
            return subTable.imageFormat();
        }

        public List<IndexSubTable.Builder<? extends IndexSubTable>> indexSubTableBuilders() {
            return this.getIndexSubTableBuilders();
        }

        Iterator<BitmapGlyphInfo> iterator() {
            return new BitmapGlyphInfoIterator();
        }

        protected void revert() {
            this.indexSubTables = null;
            this.setModelChanged(false);
        }

        public Map<Integer, BitmapGlyphInfo> generateLocaMap() {
            HashMap<Integer, BitmapGlyphInfo> locaMap = new HashMap<Integer, BitmapGlyphInfo>();
            Iterator<BitmapGlyphInfo> iter = this.iterator();
            while (iter.hasNext()) {
                BitmapGlyphInfo info = iter.next();
                locaMap.put(info.glyphId(), info);
            }
            return locaMap;
        }

        private IndexSubTable.Builder<? extends IndexSubTable> searchIndexSubTables(int glyphId) {
            return this.linearSearchIndexSubTables(glyphId);
        }

        private IndexSubTable.Builder<? extends IndexSubTable> linearSearchIndexSubTables(int glyphId) {
            List<IndexSubTable.Builder<? extends IndexSubTable>> subTableList = this.getIndexSubTableBuilders();
            for (IndexSubTable.Builder<? extends IndexSubTable> subTable : subTableList) {
                if (subTable.firstGlyphIndex() > glyphId || subTable.lastGlyphIndex() < glyphId) continue;
                return subTable;
            }
            return null;
        }

        private IndexSubTable.Builder<? extends IndexSubTable> binarySearchIndexSubTables(int glyphId) {
            List<IndexSubTable.Builder<? extends IndexSubTable>> subTableList = this.getIndexSubTableBuilders();
            int index = 0;
            int bottom = 0;
            int top = subTableList.size();
            while (top != bottom) {
                index = (top + bottom) / 2;
                IndexSubTable.Builder<? extends IndexSubTable> subTable = subTableList.get(index);
                if (glyphId < subTable.firstGlyphIndex()) {
                    top = index;
                    continue;
                }
                if (glyphId <= subTable.lastGlyphIndex()) {
                    return subTable;
                }
                bottom = index + 1;
            }
            return null;
        }

        private List<IndexSubTable.Builder<? extends IndexSubTable>> getIndexSubTableBuilders() {
            if (this.indexSubTables == null) {
                this.initialize(this.internalReadData());
                this.setModelChanged();
            }
            return this.indexSubTables;
        }

        private void initialize(ReadableFontData data) {
            if (this.indexSubTables == null) {
                this.indexSubTables = new ArrayList<IndexSubTable.Builder<? extends IndexSubTable>>();
            } else {
                this.indexSubTables.clear();
            }
            if (data != null) {
                int numberOfIndexSubTables = BitmapSizeTable.numberOfIndexSubTables(data, 0);
                for (int i = 0; i < numberOfIndexSubTables; ++i) {
                    this.indexSubTables.add(this.createIndexSubTableBuilder(i));
                }
            }
        }

        private IndexSubTable.Builder<? extends IndexSubTable> createIndexSubTableBuilder(int index) {
            return IndexSubTable.Builder.createBuilder(this.masterReadData(), this.indexSubTableArrayOffset(), index);
        }

        @Override
        protected BitmapSizeTable subBuildTable(ReadableFontData data) {
            return new BitmapSizeTable(data, this.masterReadData());
        }

        @Override
        protected void subDataSet() {
            this.revert();
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.indexSubTableBuilders() == null) {
                return 0;
            }
            int size = EblcTable.Offset.bitmapSizeTableLength.offset;
            boolean variable = false;
            for (IndexSubTable.Builder<? extends IndexSubTable> subTableBuilder : this.indexSubTables) {
                size += EblcTable.Offset.indexSubTableEntryLength.offset;
                int subTableSize = subTableBuilder.subDataSizeToSerialize();
                int padding = FontMath.paddingRequired(Math.abs(subTableSize), FontData.DataSize.ULONG.size());
                variable = subTableSize > 0 ? variable : true;
                size += Math.abs(subTableSize) + padding;
            }
            return variable ? -size : size;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.indexSubTableBuilders() != null;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            this.setNumberOfIndexSubTables(this.indexSubTableBuilders().size());
            int size = this.internalReadData().copyTo(newData);
            return size;
        }

        private class BitmapGlyphInfoIterator
        implements Iterator<BitmapGlyphInfo> {
            Iterator<IndexSubTable.Builder<? extends IndexSubTable>> subTableIter;
            Iterator<BitmapGlyphInfo> subTableGlyphInfoIter;

            public BitmapGlyphInfoIterator() {
                this.subTableIter = Builder.this.getIndexSubTableBuilders().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.subTableGlyphInfoIter != null && this.subTableGlyphInfoIter.hasNext()) {
                    return true;
                }
                while (this.subTableIter.hasNext()) {
                    IndexSubTable.Builder<? extends IndexSubTable> indexSubTable = this.subTableIter.next();
                    this.subTableGlyphInfoIter = indexSubTable.iterator();
                    if (!this.subTableGlyphInfoIter.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public BitmapGlyphInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more characters to iterate.");
                }
                return this.subTableGlyphInfoIter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unable to remove a glyph info.");
            }
        }
    }
}

