/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.format;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HashLengths {
    md5("MD5", 16),
    sha1("SHA-1", 20),
    sha256("SHA-256", 32),
    sha384("SHA-384", 48),
    sha512("SHA-512", 64),
    md5WithRSA("md5WithRSAEncryption", 16),
    sha1WithRSA("sha1WithRSAEncryption", 20),
    sha256WithRSA("sha256WithRSAEncryption", 32),
    sha384WithRSA("sha384WithRSAEncryption", 48),
    sha512WithRSA("sha512WithRSAEncryption", 64),
    sha1WithECDSA("sha1WithECDSAEncryption", 20),
    sha256WithECDSA("sha256WithECDSAEncryption", 32),
    sha384WithECDSA("sha384WithECDSAEncryption", 48),
    sha512WithECDSA("sha512WithECDSAEncryption", 64),
    sm3("sm3WithSM2Encryption", 32),
    sm3WithSM2("sm3WithSM2Encryption", 32),
    sm3WithSM2Old("sm3WithSM2Encryption_OLD", 32);

    public final String algName;
    public final int hashLength;
    private static final Map<String, HashLengths> HASH_LENGTHS;

    private HashLengths(String algName, int hashLength) {
        this.algName = algName;
        this.hashLength = hashLength;
    }

    private static final Map<String, HashLengths> cacheHashLengths() {
        HashLengths[] values = HashLengths.values();
        ConcurrentHashMap<String, HashLengths> mapping = new ConcurrentHashMap<String, HashLengths>(values.length << 1);
        for (HashLengths value : values) {
            mapping.put(value.algName, value);
            mapping.put(value.algName.replace("-", ""), value);
        }
        return mapping;
    }

    public static void checkHashLength(String algName, byte[] hashValue) throws Exception {
        if (hashValue == null) {
            throw new IllegalArgumentException("hashValue=null");
        }
        HashLengths hashLengths = HASH_LENGTHS.get(algName);
        if (hashLengths != null && hashValue.length != hashLengths.hashLength) {
            throw new IllegalArgumentException(String.format("hashLength=%d not match algName=%s", hashValue.length, algName));
        }
    }

    static {
        HASH_LENGTHS = HashLengths.cacheHashLengths();
    }
}

