/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.pkcs;

import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.cms.CMSAttributes;
import cfca.sadk.org.bouncycastle.asn1.pkcs.Attribute;
import cfca.sadk.system.logging.LoggerManager;
import java.util.Enumeration;

public class AuthenticatedAttributesUtil {
    public static byte[] getMessageDigest(ASN1Set authAttributes) {
        byte[] hashValue = null;
        if (authAttributes != null) {
            try {
                Enumeration authAttrEnumer = authAttributes.getObjects();
                while (authAttrEnumer.hasMoreElements()) {
                    Attribute attribute = Attribute.getInstance(authAttrEnumer.nextElement());
                    if (!CMSAttributes.messageDigest.equals(attribute.getAttrType())) continue;
                    ASN1Set values = attribute.getAttrValues();
                    ASN1OctetString hash = DEROctetString.getInstance(values.getObjectAt(0));
                    hashValue = hash.getOctets();
                    break;
                }
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("getMessageDigest failure with exception", (Throwable)e);
            }
        }
        return hashValue;
    }
}

