/*
 * Decompiled with CFR 0.152.
 */
package io.github.autoffice.luckysheet;

import io.github.autoffice.luckysheet.mapper.PoiFactory;
import io.github.autoffice.luckysheet.mapper.WorkbookMapperToExcel;
import io.github.autoffice.luckysheet.mapper.WorkbookMapperToLuckySheet;
import io.github.autoffice.luckysheet.model.LuckyFile;
import io.github.autoffice.luckysheet.util.JSONUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuckysheetConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LuckysheetConverter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void luckysheetToExcel(String srcLuckySheet, String destXlsx) throws IOException {
        LuckyFile luckyFile = LuckysheetConverter.readAsLuckyFile(srcLuckySheet);
        XSSFWorkbook workbook = null;
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(destXlsx);
            workbook = WorkbookMapperToExcel.mapToWorkbook(luckyFile);
            workbook.write((OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            PoiFactory.closeWorkbookQuietly(workbook);
            IOUtils.closeQuietly((OutputStream)outputStream);
            throw throwable;
        }
        PoiFactory.closeWorkbookQuietly(workbook);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void luckysheetToExcel(String srcLuckySheet, OutputStream xlsxOutputStream) throws IOException {
        LuckyFile luckyFile = LuckysheetConverter.readAsLuckyFile(srcLuckySheet);
        XSSFWorkbook workbook = null;
        try {
            workbook = WorkbookMapperToExcel.mapToWorkbook(luckyFile);
            workbook.write(xlsxOutputStream);
        }
        finally {
            PoiFactory.closeWorkbookQuietly(workbook);
            IOUtils.closeQuietly((OutputStream)xlsxOutputStream);
        }
    }

    public static void excelToLuckySheetFile(String srcXlsx, String destLuckySheet) throws IOException, InvalidFormatException {
        FileUtils.writeStringToFile((File)new File(destLuckySheet), (String)LuckysheetConverter.excelToLuckySheetJson(srcXlsx), (Charset)StandardCharsets.UTF_8);
    }

    public static String excelToLuckySheetJson(String srcXlsx) throws IOException, InvalidFormatException {
        return JSONUtil.asJSONString(LuckysheetConverter.excelToLuckySheet(srcXlsx));
    }

    public static LuckyFile excelToLuckySheet(String srcXlsx) throws IOException, InvalidFormatException {
        return WorkbookMapperToLuckySheet.mapToLuckyFile(srcXlsx);
    }

    public static LuckyFile readAsLuckyFile(String srcJsonFile) {
        return JSONUtil.asEntity(new File(srcJsonFile), LuckyFile.class);
    }
}

