/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.forms.PdfAcroForm;
import cfca.sadk.com.itextpdf.io.source.RandomAccessFileOrArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.pdf.StampingProperties;
import cfca.sadk.com.itextpdf.signatures.SignatureUtil;
import cfca.sadk.seal.base.bean.sign.RevokeResultInfo;
import cfca.sadk.seal.base.exception.SealException;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class RevokeUtil {
    private static Logger businessLog = LoggerFactory.getLogger(RevokeUtil.class);
    private static final int[] MARK_OF_EOF = new int[]{37, 37, 69, 79, 70};
    private static final int ENTER = 13;
    private static final long END_OF_FILE_FLAG_LENGTH = 6L;
    private static final long FILE_START_POSITION = 0L;
    private static final long BACK_LENGTH = 5L;

    public static RevokeResultInfo revokeLastSignature(InputStream is, OutputStream os) throws SealException, IOException {
        PdfReader reader = null;
        if (is == null) {
            throw new SealException("inputStream is null");
        }
        if (os == null) {
            throw new SealException("outputStream is null");
        }
        reader = new PdfReader(is);
        return RevokeUtil.revokeLastSignature(reader, os);
    }

    public static RevokeResultInfo revokeLastSignature(byte[] pdfData, OutputStream os) throws SealException, IOException {
        PdfReader reader = null;
        if (pdfData == null) {
            throw new SealException("pdfData is null");
        }
        if (os == null) {
            throw new SealException("outputStream is null");
        }
        reader = new PdfReader(pdfData);
        return RevokeUtil.revokeLastSignature(reader, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RevokeResultInfo revokeLastSignature(PdfReader reader, OutputStream os) throws SealException, IOException {
        businessLog.info("revokeLastSignature begin...");
        RevokeResultInfo result = new RevokeResultInfo();
        PdfWriter writer = null;
        if (reader == null) {
            throw new SealException("reader is null");
        }
        if (os == null) {
            throw new SealException("outputStream is null");
        }
        PdfDocument pdfDoc = null;
        try {
            writer = new PdfWriter(os);
            pdfDoc = new PdfDocument(reader, writer, new StampingProperties(), false);
            SignatureUtil signatureUtil = new SignatureUtil(pdfDoc);
            List<String> sigNames = signatureUtil.getSignatureNames();
            PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDoc, true);
            if (sigNames.size() == 1) {
                String sigName = sigNames.get(0);
                form.removeField(sigName);
                pdfDoc.close();
            } else {
                long fileLength = reader.getFileLength();
                RandomAccessFileOrArray rafa = reader.getSafeFile();
                long p1 = 0L;
                long p2 = 0L;
                while (rafa.getPosition() <= fileLength - 6L) {
                    int m0 = rafa.read();
                    int m1 = rafa.read();
                    int m2 = rafa.read();
                    int m3 = rafa.read();
                    int m4 = rafa.read();
                    int m5 = rafa.read();
                    if (m0 == MARK_OF_EOF[0] && m1 == MARK_OF_EOF[1] && m2 == MARK_OF_EOF[2] && m3 == MARK_OF_EOF[3] && m4 == MARK_OF_EOF[4]) {
                        if (p1 == 0L) {
                            if (m5 == 13) {
                                rafa.read();
                            }
                            p1 = rafa.getPosition();
                        }
                        p2 = p1;
                        if (m5 == 13) {
                            rafa.read();
                        }
                        p1 = rafa.getPosition();
                    }
                    rafa.seek(rafa.getPosition() - 5L);
                }
                rafa.seek(0L);
                while (rafa.getPosition() < p2) {
                    int readInt = rafa.read();
                    os.write(readInt);
                }
            }
            result.setRevoked(true);
        }
        catch (IOException e) {
            result.setFailReason(e.getMessage());
            businessLog.error("revokeLastSignature:", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            os.close();
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            try {
                if (pdfDoc != null) {
                    pdfDoc.close();
                }
            }
            catch (Exception exception) {}
            businessLog.info("revokeLastSignature end...");
        }
        return result;
    }

    public static RevokeResultInfo revokeAllSignature(byte[] sourceData, String destFile) throws SealException {
        businessLog.info("revokeAllSignature begin...");
        RevokeResultInfo result = new RevokeResultInfo();
        if (sourceData == null || sourceData.length == 0) {
            throw new SealException("sourceData is null");
        }
        businessLog.info("sourceData length = " + sourceData.length);
        businessLog.info("destFile = " + destFile);
        try {
            result = RevokeUtil.revokeAllSignature(new ByteArrayInputStream(sourceData), new FileOutputStream(destFile));
        }
        catch (IOException e) {
            result.setFailReason(e.getMessage());
            businessLog.error("revokeAllSignature:", (Throwable)e);
        }
        businessLog.info("revokeAllSignature end...");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RevokeResultInfo revokeAllSignature(InputStream inputStream, OutputStream outputStream) throws SealException {
        businessLog.info("revokeAllSignature begin...");
        RevokeResultInfo result = new RevokeResultInfo();
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        if (outputStream == null) {
            throw new SealException("outputStream is null");
        }
        PdfDocument pdfDoc = null;
        try {
            PdfReader reader = new PdfReader(inputStream);
            PdfWriter writer = new PdfWriter(outputStream);
            pdfDoc = new PdfDocument(reader, writer, new StampingProperties(), false);
            SignatureUtil signatureUtil = new SignatureUtil(pdfDoc);
            List<String> sigNames = signatureUtil.getSignatureNames();
            PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDoc, true);
            for (int i = 0; i < sigNames.size(); ++i) {
                String sigName = sigNames.get(i);
                form.removeField(sigName);
            }
            List<String> blankSigNames = signatureUtil.getBlankSignatureNames();
            for (int i = 0; i < blankSigNames.size(); ++i) {
                String sigName = blankSigNames.get(i);
                form.removeField(sigName);
            }
            result.setRevoked(true);
            pdfDoc.close();
        }
        catch (IOException e) {
            result.setFailReason(e.getMessage());
            businessLog.error("revokeAllSignature:", (Throwable)e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
        businessLog.info("revokeAllSignature end...");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RevokeResultInfo revokeBlankSignature(InputStream inputStream, OutputStream outputStream, List<String> fieldNames) throws SealException {
        businessLog.info("revokeBlankSignature begin...");
        RevokeResultInfo result = new RevokeResultInfo();
        PdfDocument pdfDoc = null;
        if (fieldNames == null || fieldNames.isEmpty()) {
            throw new SealException("List of fieldNames is null");
        }
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        if (outputStream == null) {
            throw new SealException("outputStream is null");
        }
        try {
            PdfReader reader = new PdfReader(inputStream);
            PdfWriter writer = new PdfWriter(outputStream);
            pdfDoc = new PdfDocument(reader, writer, new StampingProperties(), false);
            SignatureUtil signatureUtil = new SignatureUtil(pdfDoc);
            PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDoc, true);
            List<String> blankSigNames = signatureUtil.getBlankSignatureNames();
            int removeFieldNums = 0;
            for (int i = 0; i < blankSigNames.size(); ++i) {
                String sigName = blankSigNames.get(i);
                if (!fieldNames.contains(sigName)) continue;
                form.removeField(sigName);
                ++removeFieldNums;
            }
            if (removeFieldNums == fieldNames.size()) {
                result.setRevoked(true);
            }
        }
        catch (IOException e) {
            result.setFailReason(e.getMessage());
            businessLog.error("revokeAllSignature:", (Throwable)e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
        businessLog.info("revokeBlankSignature end...");
        return result;
    }
}

