/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.original;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.io.source.PdfTokenizer;
import cfca.sadk.com.itextpdf.io.source.RandomAccessFileOrArray;
import cfca.sadk.com.itextpdf.io.source.RandomAccessSourceFactory;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfIndirectReference;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfLiteral;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfOutputStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfResources;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.pdf.StampingProperties;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.util.PdfCanvasParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public class GrayPDFUtil {
    private static Logger businessLog = LoggerFactory.getLogger(GrayPDFUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void grayPdf(InputStream inputStream, OutputStream outputStream, int[] pages, int grayStyle) throws IOException, InterruptedException {
        PdfDocument pdfDocument = null;
        try {
            PdfDictionary resDict;
            PdfResources pdfResources;
            int i;
            int numberOfPages;
            PdfDictionary resDict2;
            PdfResources pdfResources2;
            PdfPage pdfPage;
            int page;
            int i2;
            int len;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            PdfReader reader = new PdfReader(inputStream);
            PdfWriter writer = new PdfWriter(outputStream);
            pdfDocument = new PdfDocument(reader, writer, new StampingProperties(), false);
            PdfName prevName = null;
            PdfName prntName = null;
            if ((grayStyle & 2) == 2 || (grayStyle & 4) == 4) {
                if (pages[0] != -1) {
                    len = pages.length;
                    for (i2 = 0; i2 < len; ++i2) {
                        page = pages[i2];
                        pdfPage = pdfDocument.getPage(page);
                        pdfResources2 = pdfPage.getResources();
                        resDict2 = (PdfDictionary)pdfResources2.getPdfObject();
                        GrayPDFUtil.grayPageResources(resDict2, grayStyle, hashSet, prevName, prntName);
                    }
                } else if (pages[0] == -1) {
                    numberOfPages = pdfDocument.getNumberOfPages();
                    for (i = 1; i <= numberOfPages; ++i) {
                        PdfPage pdfPage2 = pdfDocument.getPage(i);
                        pdfResources = pdfPage2.getResources();
                        resDict = (PdfDictionary)pdfResources.getPdfObject();
                        GrayPDFUtil.grayPageResources(resDict, grayStyle, hashSet, prevName, prntName);
                    }
                }
            }
            if ((grayStyle & 1) == 1) {
                if (pages[0] != -1) {
                    len = pages.length;
                    for (i2 = 0; i2 < len; ++i2) {
                        page = pages[i2];
                        pdfPage = pdfDocument.getPage(page);
                        pdfResources2 = pdfPage.getResources();
                        resDict2 = (PdfDictionary)pdfResources2.getPdfObject();
                        PdfDictionary pageDict = (PdfDictionary)pdfPage.getPdfObject();
                        GrayPDFUtil.grayPageContents(pageDict.get(PdfName.Contents), grayStyle, hashSet, prevName, prntName, resDict2);
                    }
                }
                if (pages[0] == -1) {
                    numberOfPages = pdfDocument.getNumberOfPages();
                    for (i = 1; i <= numberOfPages; ++i) {
                        PdfPage pdfPage3 = pdfDocument.getPage(i);
                        pdfResources = pdfPage3.getResources();
                        resDict = (PdfDictionary)pdfResources.getPdfObject();
                        PdfDictionary pageDict = (PdfDictionary)pdfPage3.getPdfObject();
                        GrayPDFUtil.grayPageContents(pageDict.get(PdfName.Contents), grayStyle, hashSet, prevName, prntName, resDict);
                    }
                }
            }
            pdfDocument.close();
        }
        catch (Exception e) {
            businessLog.error("grayPdf failed", (Throwable)e);
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
        }
    }

    private static void grayPageContents(PdfObject pdfObject, int grayStyle, HashSet<Integer> hashSet, PdfName prevName, PdfName prntName, PdfDictionary resDict) throws IOException, InterruptedException {
        block8: {
            block7: {
                if (!(pdfObject instanceof PdfStream)) break block7;
                LinkedBlockingQueue<String> lbq = new LinkedBlockingQueue<String>();
                PdfStream stream = (PdfStream)pdfObject;
                byte[] stmBytes = stream.getBytes();
                PdfObject obj = null;
                ArrayList<PdfObject> updatedObjs = new ArrayList<PdfObject>();
                List<String> colorCmds = Arrays.asList("rg", "RG", "scn", "SCN");
                PdfTokenizer tokeniser = new PdfTokenizer(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(stmBytes)));
                PdfCanvasParser ps = new PdfCanvasParser(tokeniser);
                while ((obj = ps.readObject()) != null) {
                    String objString = obj.toString();
                    if (colorCmds.contains(objString)) {
                        GrayPDFUtil.updateColorCmds(updatedObjs);
                    }
                    if ("Do".equals(objString)) {
                        PdfName doName = (PdfName)updatedObjs.get(updatedObjs.size() - 1);
                        String doString = doName.toString();
                        lbq.put(doString);
                    }
                    updatedObjs.add(obj);
                }
                PdfObject[] arrObjs = updatedObjs.toArray(new PdfObject[0]);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PdfOutputStream pdfOutputStream = new PdfOutputStream(baos);
                for (int i = 0; i < arrObjs.length; ++i) {
                    PdfObject aObj = arrObjs[i];
                    pdfOutputStream.write(aObj);
                    if (aObj instanceof PdfLiteral) {
                        pdfOutputStream.writeNewLine();
                        continue;
                    }
                    pdfOutputStream.writeSpace();
                }
                pdfOutputStream.flush();
                pdfOutputStream.close();
                stream.setData(baos.toByteArray());
                while (!lbq.isEmpty()) {
                    String xfn = (String)lbq.poll();
                    String tmpXfn = xfn.substring(1);
                    if (null == resDict) continue;
                    PdfDictionary xobj = resDict.getAsDictionary(PdfName.XObject);
                    PdfStream tmpStream = xobj.getAsStream(new PdfName(tmpXfn));
                    PdfDictionary tmpResources = tmpStream.getAsDictionary(PdfName.Resources);
                    PdfName subTypeName = tmpStream.getAsName(PdfName.Subtype);
                    if (PdfName.Image.equals(subTypeName)) continue;
                    GrayPDFUtil.grayPageContents(tmpStream, grayStyle, hashSet, prevName, prntName, tmpResources);
                }
                break block8;
            }
            if (!(pdfObject instanceof PdfArray)) break block8;
            PdfArray pdfArray = (PdfArray)pdfObject;
            int size = pdfArray.size();
            for (int i = 0; i < size; ++i) {
                PdfStream stream = pdfArray.getAsStream(i);
                GrayPDFUtil.grayPageContents(stream, grayStyle, hashSet, prevName, prntName, resDict);
            }
        }
    }

    private static void updateColorCmds(ArrayList<PdfObject> updatedObjs) {
        int size = updatedObjs.size();
        PdfObject last1Objs = updatedObjs.get(size - 1);
        PdfObject last2Objs = updatedObjs.get(size - 2);
        if (!(last1Objs instanceof PdfNumber)) {
            return;
        }
        if (last1Objs instanceof PdfNumber && !(last2Objs instanceof PdfNumber)) {
            return;
        }
        PdfNumber bNumber = (PdfNumber)updatedObjs.remove(updatedObjs.size() - 1);
        PdfNumber gNumber = (PdfNumber)updatedObjs.remove(updatedObjs.size() - 1);
        PdfNumber rNumber = (PdfNumber)updatedObjs.remove(updatedObjs.size() - 1);
        if (rNumber.intValue() == 1 && gNumber.intValue() == 1 && bNumber.intValue() == 1) {
            updatedObjs.add(rNumber);
            updatedObjs.add(gNumber);
            updatedObjs.add(bNumber);
        } else {
            updatedObjs.add(new PdfNumber(0.45));
            updatedObjs.add(new PdfNumber(0.45));
            updatedObjs.add(new PdfNumber(0.45));
        }
    }

    private static void grayPageResources(PdfDictionary resDict, int grayStyle, HashSet<Integer> hashSet, PdfName prevName, PdfName prntName) {
        PdfDictionary xobject;
        if (null != resDict && null != (xobject = resDict.getAsDictionary(PdfName.XObject))) {
            Set<PdfName> nameSet = xobject.keySet();
            PdfName[] currNames = nameSet.toArray(new PdfName[0]);
            for (int i = 0; i < currNames.length; ++i) {
                PdfName currName = currNames[i];
                PdfStream stream = xobject.getAsStream(currName);
                int objNumber = stream.getIndirectReference().getObjNumber();
                if (hashSet.contains(objNumber)) continue;
                hashSet.add(objNumber);
                PdfName subtype = stream.getAsName(PdfName.Subtype);
                if (subtype.equals(PdfName.Image)) {
                    PdfName csName0;
                    PdfName csName02;
                    PdfArray csArray0;
                    PdfArray csArray;
                    boolean rowLength;
                    int bpc;
                    int columns;
                    int colors;
                    PdfDictionary dpParam;
                    int height;
                    int width;
                    byte[] stmBytes;
                    PdfName csName;
                    if ((grayStyle & 4) == 4 && new PdfName("n2").equals(prntName)) {
                        csName = stream.getAsName(PdfName.ColorSpace);
                        if (!PdfName.DeviceGray.equals(csName)) {
                            stmBytes = stream.getBytes();
                            width = stream.getAsNumber(PdfName.Width).intValue();
                            height = stream.getAsNumber(PdfName.Height).intValue();
                            dpParam = stream.getAsDictionary(PdfName.DecodeParms);
                            colors = 1;
                            columns = 1;
                            bpc = 1;
                            rowLength = true;
                            if (dpParam != null) {
                                colors = dpParam.getAsNumber(PdfName.Colors).intValue();
                                columns = dpParam.getAsNumber(PdfName.Columns).intValue();
                                bpc = dpParam.getAsNumber(PdfName.BitsPerComponent).intValue();
                                csArray = stream.getAsArray(PdfName.ColorSpace);
                                if (null != csArray && PdfName.Indexed.equals(csArray.getAsName(0))) {
                                    if (PdfName.DeviceRGB.equals(csArray.getAsName(1))) {
                                        GrayPDFUtil.grayIndexedColorPng(csArray);
                                    }
                                    if (null != (csArray0 = csArray.getAsArray(1)) && PdfName.CalRGB.equals(csArray0.getAsName(0))) {
                                        GrayPDFUtil.grayIndexedColorPng(csArray);
                                    }
                                }
                                if (null != (csName02 = stream.getAsName(PdfName.ColorSpace)) && PdfName.DeviceRGB.equals(csName02)) {
                                    GrayPDFUtil.grayTrueColorPng(stream, stmBytes, width, height, colors, bpc);
                                }
                            } else {
                                bpc = stream.getAsNumber(PdfName.BitsPerComponent).intValue();
                                csName0 = stream.getAsName(PdfName.ColorSpace);
                                if (null == csName0) {
                                    PdfIndirectReference tIRef;
                                    PdfObject pdfObject;
                                    PdfStream tStm;
                                    PdfName altName;
                                    PdfArray csArr = stream.getAsArray(PdfName.ColorSpace);
                                    csName0 = csArr.getAsName(0);
                                    if (PdfName.CalRGB.equals(csName0)) {
                                        colors = 3;
                                    } else if (PdfName.ICCBased.equals(csName0) && PdfName.DeviceRGB.equals(altName = (tStm = (PdfStream)(pdfObject = (tIRef = csArr.get(1).getIndirectReference()).getRefersTo())).getAsName(PdfName.Alternate))) {
                                        colors = 3;
                                    }
                                } else if (PdfName.DeviceRGB.equals(csName0)) {
                                    colors = 3;
                                }
                                GrayPDFUtil.grayTrueColorPng(stream, stmBytes, width, height, colors, bpc);
                            }
                        }
                        prevName = currName;
                        continue;
                    }
                    if ((grayStyle & 2) != 2 || new PdfName("n2").equals(prevName)) continue;
                    csName = stream.getAsName(PdfName.ColorSpace);
                    if (!PdfName.DeviceGray.equals(csName)) {
                        stmBytes = stream.getBytes();
                        width = stream.getAsNumber(PdfName.Width).intValue();
                        height = stream.getAsNumber(PdfName.Height).intValue();
                        dpParam = stream.getAsDictionary(PdfName.DecodeParms);
                        colors = 1;
                        columns = 1;
                        bpc = 1;
                        rowLength = true;
                        if (dpParam != null) {
                            colors = dpParam.getAsNumber(PdfName.Colors).intValue();
                            columns = dpParam.getAsNumber(PdfName.Columns).intValue();
                            bpc = dpParam.getAsNumber(PdfName.BitsPerComponent).intValue();
                            csArray = stream.getAsArray(PdfName.ColorSpace);
                            if (null != csArray && PdfName.Indexed.equals(csArray.getAsName(0))) {
                                if (PdfName.DeviceRGB.equals(csArray.getAsName(1))) {
                                    GrayPDFUtil.grayIndexedColorPng(csArray);
                                }
                                if (null != (csArray0 = csArray.getAsArray(1)) && PdfName.CalRGB.equals(csArray0.getAsName(0))) {
                                    GrayPDFUtil.grayIndexedColorPng(csArray);
                                }
                            }
                            if (null != (csName02 = stream.getAsName(PdfName.ColorSpace)) && PdfName.DeviceRGB.equals(csName02)) {
                                GrayPDFUtil.grayTrueColorPng(stream, stmBytes, width, height, colors, bpc);
                            }
                        } else {
                            bpc = stream.getAsNumber(PdfName.BitsPerComponent).intValue();
                            csName0 = stream.getAsArray(PdfName.ColorSpace).getAsName(0);
                            if (PdfName.CalRGB.equals(csName0)) {
                                colors = 3;
                            }
                            GrayPDFUtil.grayTrueColorPng(stream, stmBytes, width, height, colors, bpc);
                        }
                    }
                    prevName = currName;
                    continue;
                }
                if (!subtype.equals(PdfName.Form)) continue;
                prevName = currName;
                prntName = currName;
                PdfDictionary resources0 = stream.getAsDictionary(PdfName.Resources);
                GrayPDFUtil.grayPageResources(resources0, grayStyle, hashSet, prevName, prntName);
            }
        }
    }

    private static void grayTrueColorPng(PdfStream stream, byte[] stmBytes, int width, int height, int colors, int bpc) {
        int rowLength = colors * width * bpc / 8;
        byte[] grayBytes = new byte[height * rowLength];
        byte[] rowBytes = new byte[rowLength];
        for (int j = 0; j < height; ++j) {
            byte[] tmpBytes = new byte[rowLength];
            System.arraycopy(stmBytes, j * rowLength, tmpBytes, 0, rowLength);
            for (int k = 0; k < rowLength; k += 3) {
                int r = tmpBytes[k] & 0xFF;
                int g = tmpBytes[k + 1] & 0xFF;
                int b = tmpBytes[k + 2] & 0xFF;
                int tmp = (r * 299 + g * 587 + b * 114 + 500) / 1000;
                byte by = (byte)tmp;
                tmpBytes[k + 2] = by;
                tmpBytes[k + 1] = by;
                tmpBytes[k] = by;
            }
            System.arraycopy(tmpBytes, 0, rowBytes, 0, rowLength);
            System.arraycopy(rowBytes, 0, grayBytes, j * rowLength, rowLength);
        }
        stream.setData(grayBytes);
    }

    private static void grayIndexedColorPng(PdfArray csArray) {
        PdfNumber pdfNumber = csArray.getAsNumber(2);
        int colorTableSize = pdfNumber.intValue();
        PdfString colorTableString = csArray.getAsString(3);
        byte[] colorTableBytes = colorTableString.getValueBytes();
        int bytesSize = (colorTableSize + 1) * 3;
        byte[] grayTableBytes = new byte[bytesSize];
        grayTableBytes[0] = colorTableBytes[0];
        grayTableBytes[1] = colorTableBytes[1];
        grayTableBytes[2] = colorTableBytes[2];
        for (int j = 1; j < colorTableSize; ++j) {
            int r = colorTableBytes[j * 3] & 0xFF;
            int g = colorTableBytes[j * 3 + 1] & 0xFF;
            int b = colorTableBytes[j * 3 + 2] & 0xFF;
            int tmp = (r * 299 + g * 587 + b * 114 + 500) / 1000;
            byte by = (byte)tmp;
            grayTableBytes[j * 3 + 2] = by;
            grayTableBytes[j * 3 + 1] = by;
            grayTableBytes[j * 3] = by;
        }
        PdfString grayTableString = new PdfString(grayTableBytes);
        csArray.set(3, grayTableString);
    }

    public static interface GrayStyle {
        public static final int GRAY_TEXT = 1;
        public static final int GRAY_IMAGE_XIF = 2;
        public static final int GRAY_IMAGE_N2 = 4;
    }
}

