/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import asposewobfuscated.zz68;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.Rule;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzZ;

public class ForeignKeyConstraint
extends Constraint {
    private DataColumn[] zzY6m;
    private DataColumn[] zzY6l;
    private Rule zzY5Y = Rule.CASCADE;
    private Rule zzY5X = Rule.CASCADE;
    private UniqueConstraint zzY5W;
    private zzZ zzY5V = zzZ.zzY6F;

    public ForeignKeyConstraint(String constraintName, DataColumn[] parentColumns, DataColumn[] childColumns) {
        this.setConstraintName(constraintName);
        this.zzY6m = new DataColumn[parentColumns.length];
        System.arraycopy(parentColumns, 0, this.zzY6m, 0, parentColumns.length);
        this.zzY6l = new DataColumn[childColumns.length];
        System.arraycopy(childColumns, 0, this.zzY6l, 0, childColumns.length);
    }

    public ForeignKeyConstraint(String constraintName, DataColumn parentColumn, DataColumn childColumn) {
        this(constraintName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn});
    }

    public Rule getDeleteRule() {
        return this.zzY5Y;
    }

    public Rule getUpdateRule() {
        return this.zzY5X;
    }

    public int hashCode() {
        int n;
        int n2 = 32;
        int n3 = 88;
        if (this.getColumns().length > 0) {
            n2 ^= this.getColumns()[0].hashCode();
        }
        for (n = 1; n < this.getColumns().length; ++n) {
            n2 ^= this.getColumns()[1].hashCode();
        }
        if (this.getRelatedColumns().length > 0) {
            n3 ^= this.getColumns()[0].hashCode();
        }
        for (n = 1; n < this.getRelatedColumns().length; ++n) {
            n3 ^= this.getRelatedColumns()[1].hashCode();
        }
        return n2 ^ n3;
    }

    public boolean equals(Object key) {
        ForeignKeyConstraint foreignKeyConstraint;
        ForeignKeyConstraint foreignKeyConstraint2 = foreignKeyConstraint = key instanceof ForeignKeyConstraint ? (ForeignKeyConstraint)key : null;
        if (null == foreignKeyConstraint) {
            return false;
        }
        if (!DataColumn.areColumnSetsTheSame(this.getRelatedColumns(), foreignKeyConstraint.getRelatedColumns())) {
            return false;
        }
        return DataColumn.areColumnSetsTheSame(this.getColumns(), foreignKeyConstraint.getColumns());
    }

    public DataColumn[] getColumns() {
        return this.zzY6l;
    }

    public DataColumn[] getRelatedColumns() {
        return this.zzY6m;
    }

    public DataTable getTable() {
        if (this.zzY6l != null && this.zzY6l.length > 0) {
            return this.zzY6l[0].getTable();
        }
        throw new UnsupportedOperationException("Property not accessible because 'Object reference not set to an instance of an object'");
    }

    public DataTable getRelatedTable() {
        if (this.zzY6m != null && this.zzY6m.length > 0) {
            return this.zzY6m[0].getTable();
        }
        throw new UnsupportedOperationException("Property not accessible because 'Object reference not set to an instance of an object'");
    }

    public zzZ getAcceptRejectRule() {
        return this.zzY5V;
    }

    @Override
    protected void addToConstraintCollectionSetup(ConstraintCollection collection) throws DataException, InvalidConstraintException {
        if (collection.getTable() != this.getTable()) {
            throw new DataException("This constraint cannot be added since ForeignKey doesn't belong to table " + this.getRelatedTable().getTableName() + ".");
        }
        this.zzY(this.zzY6m, this.zzY6l);
        this.zzZ(collection, this.zzY6m);
        if ((this.getTable().getDataSet() != null && this.getTable().getDataSet().getEnforceConstraints() || this.getTable().getDataSet() == null && this.getTable().getEnforceConstraints()) && this.zzYWi()) {
            throw new IllegalArgumentException("This constraint cannot be enabled as not all values have corresponding parent values.");
        }
    }

    private void zzY(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) throws DataException {
        if (null == dataColumnArray || null == dataColumnArray2) {
            throw new IllegalArgumentException();
        }
        if (dataColumnArray.length < 1 || dataColumnArray2.length < 1) {
            throw new IllegalArgumentException("Neither ParentColumns or ChildColumns can't be zero length.");
        }
        if (dataColumnArray.length != dataColumnArray2.length) {
            throw new IllegalArgumentException("Parent columns and child columns must be the same length.");
        }
        DataTable dataTable = dataColumnArray[0].getTable();
        DataTable dataTable2 = dataColumnArray2[0].getTable();
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (null == dataColumn.getTable()) {
                throw new IllegalArgumentException("All columns must belong to a table. ColumnName: " + dataColumn.getColumnName() + " does not belong to a table.");
            }
            if (dataTable != dataColumn.getTable()) {
                throw new DataException("Parent columns must all belong to the same table.");
            }
            if (null == dataColumn2.getTable()) {
                throw new IllegalArgumentException("All columns must belong to a table. ColumnName: " + dataColumn.getColumnName() + " does not belong to a table.");
            }
            if (dataTable2 != dataColumn2.getTable()) {
                throw new DataException("Child columns must all belong to the same table.");
            }
            if (dataColumn.zzYWr() != null) {
                throw new IllegalArgumentException(zz68.format("Cannot create a constraint based on Expression column {0}.", dataColumn.getColumnName()));
            }
            if (dataColumn2.zzYWr() == null) continue;
            throw new IllegalArgumentException(zz68.format("Cannot create a constraint based on Expression column {0}.", dataColumn2.getColumnName()));
        }
    }

    private void zzZ(ConstraintCollection constraintCollection, DataColumn[] dataColumnArray) throws DataException, InvalidConstraintException {
        if (null == dataColumnArray) {
            throw new IllegalArgumentException("ParentColumns can't be null");
        }
        UniqueConstraint uniqueConstraint = null;
        if (dataColumnArray[0] != null) {
            uniqueConstraint = UniqueConstraint.zzY(dataColumnArray[0].getTable().getConstraints(), dataColumnArray);
        }
        if (null == uniqueConstraint) {
            uniqueConstraint = new UniqueConstraint(dataColumnArray, false);
            dataColumnArray[0].getTable().getConstraints().add(uniqueConstraint);
        }
        this.zzY5W = uniqueConstraint;
        this.zzY5W.zzZ(this);
    }

    private boolean zzYWi() {
        if (this.getTable().getDataSet() == null || this.getRelatedTable().getDataSet() == null) {
            return false;
        }
        boolean bl = false;
        for (DataRow dataRow : this.getTable().getRows()) {
            if (dataRow.getRowState() == 8 || dataRow.zzZ(this.zzY6l) || this.getRelatedTable().zzZ(this.zzY6m, this.zzY6l, dataRow)) continue;
            bl = true;
            String[] stringArray = new String[this.zzY6l.length];
            for (int i = 0; i < this.zzY6l.length; ++i) {
                DataColumn dataColumn = this.zzY6l[i];
                stringArray[i] = dataRow.get(dataColumn).toString();
            }
            dataRow.zzYX(zz68.format("ForeignKeyConstraint {0} requires the child key values ({1}) to exist in the parent table.", this.getConstraintName()), zz68.zzX(",", stringArray));
        }
        return bl;
    }
}

