/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.core;

import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.Header;
import cfca.sadk.com.google.typography.font.sfntly.table.Table;
import cfca.sadk.com.google.typography.font.sfntly.table.TableBasedTableBuilder;
import java.util.EnumSet;

public final class FontHeaderTable
extends Table {
    public static final long CHECKSUM_ADJUSTMENT_BASE = 2981146554L;
    public static final long MAGIC_NUMBER = 1594834165L;
    private static final int[] CHECKSUM_RANGES = new int[]{0, Offset.access$000(Offset.checkSumAdjustment), Offset.access$000(Offset.magicNumber)};

    private FontHeaderTable(Header header, ReadableFontData data) {
        super(header, data);
        data.setCheckSumRanges(0, Offset.checkSumAdjustment.offset, Offset.magicNumber.offset);
    }

    public int tableVersion() {
        return this.data.readFixed(Offset.tableVersion.offset);
    }

    public int fontRevision() {
        return this.data.readFixed(Offset.fontRevision.offset);
    }

    public long checkSumAdjustment() {
        return this.data.readULong(Offset.checkSumAdjustment.offset);
    }

    public long magicNumber() {
        return this.data.readULong(Offset.magicNumber.offset);
    }

    public int flagsAsInt() {
        return this.data.readUShort(Offset.flags.offset);
    }

    public EnumSet<Flags> flags() {
        return Flags.asSet(this.flagsAsInt());
    }

    public int unitsPerEm() {
        return this.data.readUShort(Offset.unitsPerEm.offset);
    }

    public long created() {
        return this.data.readDateTimeAsLong(Offset.created.offset);
    }

    public long modified() {
        return this.data.readDateTimeAsLong(Offset.modified.offset);
    }

    public int xMin() {
        return this.data.readShort(Offset.xMin.offset);
    }

    public int yMin() {
        return this.data.readShort(Offset.yMin.offset);
    }

    public int xMax() {
        return this.data.readShort(Offset.xMax.offset);
    }

    public int yMax() {
        return this.data.readShort(Offset.yMax.offset);
    }

    public int macStyleAsInt() {
        return this.data.readUShort(Offset.macStyle.offset);
    }

    public EnumSet<MacStyle> macStyle() {
        return MacStyle.asSet(this.macStyleAsInt());
    }

    public int lowestRecPPEM() {
        return this.data.readUShort(Offset.lowestRecPPEM.offset);
    }

    public int fontDirectionHintAsInt() {
        return this.data.readShort(Offset.fontDirectionHint.offset);
    }

    public FontDirectionHint fontDirectionHint() {
        return FontDirectionHint.valueOf(this.fontDirectionHintAsInt());
    }

    public int indexToLocFormatAsInt() {
        return this.data.readShort(Offset.indexToLocFormat.offset);
    }

    public IndexToLocFormat indexToLocFormat() {
        return IndexToLocFormat.valueOf(this.indexToLocFormatAsInt());
    }

    public int glyphdataFormat() {
        return this.data.readShort(Offset.glyphDataFormat.offset);
    }

    public static class Builder
    extends TableBasedTableBuilder<FontHeaderTable> {
        private boolean fontChecksumSet = false;
        private long fontChecksum = 0L;

        public static Builder createBuilder(Header header, WritableFontData data) {
            return new Builder(header, data);
        }

        protected Builder(Header header, WritableFontData data) {
            super(header, data);
            data.setCheckSumRanges(0, Offset.checkSumAdjustment.offset, Offset.magicNumber.offset);
        }

        protected Builder(Header header, ReadableFontData data) {
            super(header, data);
            data.setCheckSumRanges(CHECKSUM_RANGES);
        }

        @Override
        protected boolean subReadyToSerialize() {
            ReadableFontData data;
            if (this.dataChanged()) {
                data = this.internalReadData();
                data.setCheckSumRanges(CHECKSUM_RANGES);
            }
            if (this.fontChecksumSet) {
                data = this.internalReadData();
                data.setCheckSumRanges(CHECKSUM_RANGES);
                long checksumAdjustment = 2981146554L - (this.fontChecksum + data.checksum());
                this.setCheckSumAdjustment(checksumAdjustment);
            }
            return super.subReadyToSerialize();
        }

        @Override
        protected FontHeaderTable subBuildTable(ReadableFontData data) {
            return new FontHeaderTable(this.header(), data);
        }

        public void setFontChecksum(long checksum) {
            if (this.fontChecksumSet) {
                return;
            }
            this.fontChecksumSet = true;
            this.fontChecksum = checksum;
        }

        public void clearFontChecksum() {
            this.fontChecksumSet = false;
        }

        public int tableVersion() {
            return ((FontHeaderTable)this.table()).tableVersion();
        }

        public void setTableVersion(int version) {
            this.internalWriteData().writeFixed(Offset.tableVersion.offset, version);
        }

        public int fontRevision() {
            return ((FontHeaderTable)this.table()).fontRevision();
        }

        public void setFontRevision(int revision) {
            this.internalWriteData().writeFixed(Offset.fontRevision.offset, revision);
        }

        public long checkSumAdjustment() {
            return ((FontHeaderTable)this.table()).checkSumAdjustment();
        }

        public void setCheckSumAdjustment(long adjustment) {
            this.internalWriteData().writeULong(Offset.checkSumAdjustment.offset, adjustment);
        }

        public long magicNumber() {
            return ((FontHeaderTable)this.table()).magicNumber();
        }

        public void setMagicNumber(long magicNumber) {
            this.internalWriteData().writeULong(Offset.magicNumber.offset, magicNumber);
        }

        public int flagsAsInt() {
            return ((FontHeaderTable)this.table()).flagsAsInt();
        }

        public EnumSet<Flags> flags() {
            return ((FontHeaderTable)this.table()).flags();
        }

        public void setFlagsAsInt(int flags) {
            this.internalWriteData().writeUShort(Offset.flags.offset, flags);
        }

        public void setFlags(EnumSet<Flags> flags) {
            this.setFlagsAsInt(Flags.cleanValue(flags));
        }

        public int unitsPerEm() {
            return ((FontHeaderTable)this.table()).unitsPerEm();
        }

        public void setUnitsPerEm(int units) {
            this.internalWriteData().writeUShort(Offset.unitsPerEm.offset, units);
        }

        public long created() {
            return ((FontHeaderTable)this.table()).created();
        }

        public void setCreated(long date) {
            this.internalWriteData().writeDateTime(Offset.created.offset, date);
        }

        public long modified() {
            return ((FontHeaderTable)this.table()).modified();
        }

        public void setModified(long date) {
            this.internalWriteData().writeDateTime(Offset.modified.offset, date);
        }

        public int xMin() {
            return ((FontHeaderTable)this.table()).xMin();
        }

        public void setXMin(int xmin) {
            this.internalWriteData().writeShort(Offset.xMin.offset, xmin);
        }

        public int yMin() {
            return ((FontHeaderTable)this.table()).yMin();
        }

        public void setYMin(int ymin) {
            this.internalWriteData().writeShort(Offset.yMin.offset, ymin);
        }

        public int xMax() {
            return ((FontHeaderTable)this.table()).xMax();
        }

        public void setXMax(int xmax) {
            this.internalWriteData().writeShort(Offset.xMax.offset, xmax);
        }

        public int yMax() {
            return ((FontHeaderTable)this.table()).yMax();
        }

        public void setYMax(int ymax) {
            this.internalWriteData().writeShort(Offset.yMax.offset, ymax);
        }

        public int macStyleAsInt() {
            return ((FontHeaderTable)this.table()).macStyleAsInt();
        }

        public void setMacStyleAsInt(int style) {
            this.internalWriteData().writeUShort(Offset.macStyle.offset, style);
        }

        public EnumSet<MacStyle> macStyle() {
            return ((FontHeaderTable)this.table()).macStyle();
        }

        public void macStyle(EnumSet<MacStyle> style) {
            this.setMacStyleAsInt(MacStyle.cleanValue(style));
        }

        public int lowestRecPPEM() {
            return ((FontHeaderTable)this.table()).lowestRecPPEM();
        }

        public void setLowestRecPPEM(int size) {
            this.internalWriteData().writeUShort(Offset.lowestRecPPEM.offset, size);
        }

        public int fontDirectionHintAsInt() {
            return ((FontHeaderTable)this.table()).fontDirectionHintAsInt();
        }

        public void setFontDirectionHintAsInt(int hint) {
            this.internalWriteData().writeShort(Offset.fontDirectionHint.offset, hint);
        }

        public FontDirectionHint fontDirectionHint() {
            return ((FontHeaderTable)this.table()).fontDirectionHint();
        }

        public void setFontDirectionHint(FontDirectionHint hint) {
            this.setFontDirectionHintAsInt(hint.value());
        }

        public int indexToLocFormatAsInt() {
            return ((FontHeaderTable)this.table()).indexToLocFormatAsInt();
        }

        public void setIndexToLocFormatAsInt(int format) {
            this.internalWriteData().writeShort(Offset.indexToLocFormat.offset, format);
        }

        public IndexToLocFormat indexToLocFormat() {
            return ((FontHeaderTable)this.table()).indexToLocFormat();
        }

        public void setIndexToLocFormat(IndexToLocFormat format) {
            this.setIndexToLocFormatAsInt(format.value());
        }

        public int glyphdataFormat() {
            return ((FontHeaderTable)this.table()).glyphdataFormat();
        }

        public void setGlyphdataFormat(int format) {
            this.internalWriteData().writeShort(Offset.glyphDataFormat.offset, format);
        }
    }

    public static enum IndexToLocFormat {
        shortOffset(0),
        longOffset(1);

        private final int value;

        private IndexToLocFormat(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int value) {
            return value == this.value;
        }

        public static IndexToLocFormat valueOf(int value) {
            for (IndexToLocFormat format : IndexToLocFormat.values()) {
                if (!format.equals(value)) continue;
                return format;
            }
            return null;
        }
    }

    public static enum FontDirectionHint {
        FullyMixed(0),
        OnlyStrongLTR(1),
        StrongLTRAndNeutral(2),
        OnlyStrongRTL(-1),
        StrongRTLAndNeutral(-2);

        private final int value;

        private FontDirectionHint(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int value) {
            return value == this.value;
        }

        public static FontDirectionHint valueOf(int value) {
            for (FontDirectionHint hint : FontDirectionHint.values()) {
                if (!hint.equals(value)) continue;
                return hint;
            }
            return null;
        }
    }

    public static enum MacStyle {
        Bold,
        Italic,
        Underline,
        Outline,
        Shadow,
        Condensed,
        Extended,
        Reserved7,
        Reserved8,
        Reserved9,
        Reserved10,
        Reserved11,
        Reserved12,
        Reserved13,
        Reserved14,
        Reserved15;

        private static final EnumSet<MacStyle> reserved;

        public int mask() {
            return 1 << this.ordinal();
        }

        public static EnumSet<MacStyle> asSet(int value) {
            EnumSet<MacStyle> set = EnumSet.noneOf(MacStyle.class);
            for (MacStyle style : MacStyle.values()) {
                if ((value & style.mask()) != style.mask()) continue;
                set.add(style);
            }
            return set;
        }

        public static int value(EnumSet<MacStyle> set) {
            int value = 0;
            for (MacStyle style : set) {
                value |= style.mask();
            }
            return value;
        }

        public static int cleanValue(EnumSet<MacStyle> set) {
            EnumSet<MacStyle> clean = EnumSet.copyOf(set);
            clean.removeAll(reserved);
            return MacStyle.value(clean);
        }

        static {
            reserved = EnumSet.range(Reserved7, Reserved15);
        }
    }

    public static enum Flags {
        BaselineAtY0,
        LeftSidebearingAtX0,
        InstructionsDependOnPointSize,
        ForcePPEMToInteger,
        InstructionsAlterAdvanceWidth,
        Apple_Vertical,
        Apple_Zero,
        Apple_RequiresLayout,
        Apple_GXMetamorphosis,
        Apple_StrongRTL,
        Apple_IndicRearrangement,
        FontDataLossless,
        FontConverted,
        OptimizedForClearType,
        Reserved14,
        Reserved15;


        public int mask() {
            return 1 << this.ordinal();
        }

        public static EnumSet<Flags> asSet(int value) {
            EnumSet<Flags> set = EnumSet.noneOf(Flags.class);
            for (Flags flag : Flags.values()) {
                if ((value & flag.mask()) != flag.mask()) continue;
                set.add(flag);
            }
            return set;
        }

        public static int value(EnumSet<Flags> set) {
            int value = 0;
            for (Flags flag : set) {
                value |= flag.mask();
            }
            return value;
        }

        public static int cleanValue(EnumSet<Flags> set) {
            EnumSet<Flags> clean = EnumSet.copyOf(set);
            clean.remove((Object)Reserved14);
            clean.remove((Object)Reserved15);
            return Flags.value(clean);
        }
    }

    private static enum Offset {
        tableVersion(0),
        fontRevision(4),
        checkSumAdjustment(8),
        magicNumber(12),
        flags(16),
        unitsPerEm(18),
        created(20),
        modified(28),
        xMin(36),
        yMin(38),
        xMax(40),
        yMax(42),
        macStyle(44),
        lowestRecPPEM(46),
        fontDirectionHint(48),
        indexToLocFormat(50),
        glyphDataFormat(52);

        private final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }
}

