/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.geom;

import cfca.sadk.com.itextpdf.kernel.geom.BezierCurve;
import cfca.sadk.com.itextpdf.kernel.geom.IShape;
import cfca.sadk.com.itextpdf.kernel.geom.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Subpath
implements Serializable {
    private static final long serialVersionUID = -3464451279777771490L;
    private Point startPoint;
    private List<IShape> segments = new ArrayList<IShape>();
    private boolean closed;

    public Subpath() {
    }

    public Subpath(Subpath subpath) {
        this.startPoint = subpath.startPoint;
        this.segments.addAll(subpath.getSegments());
        this.closed = subpath.closed;
    }

    public Subpath(Point startPoint) {
        this((float)startPoint.getX(), (float)startPoint.getY());
    }

    public Subpath(float startPointX, float startPointY) {
        this.startPoint = new Point(startPointX, startPointY);
    }

    public void setStartPoint(Point startPoint) {
        this.setStartPoint((float)startPoint.getX(), (float)startPoint.getY());
    }

    public void setStartPoint(float x, float y) {
        this.startPoint = new Point(x, y);
    }

    public Point getStartPoint() {
        return this.startPoint;
    }

    public Point getLastPoint() {
        Point lastPoint = this.startPoint;
        if (this.segments.size() > 0 && !this.closed) {
            IShape shape = this.segments.get(this.segments.size() - 1);
            lastPoint = shape.getBasePoints().get(shape.getBasePoints().size() - 1);
        }
        return lastPoint;
    }

    public void addSegment(IShape segment) {
        if (this.closed) {
            return;
        }
        if (this.isSinglePointOpen()) {
            this.startPoint = segment.getBasePoints().get(0);
        }
        this.segments.add(segment);
    }

    public List<IShape> getSegments() {
        return this.segments;
    }

    public boolean isEmpty() {
        return this.startPoint == null;
    }

    public boolean isSinglePointOpen() {
        return this.segments.size() == 0 && !this.closed;
    }

    public boolean isSinglePointClosed() {
        return this.segments.size() == 0 && this.closed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isDegenerate() {
        if (this.segments.size() > 0 && this.closed) {
            return false;
        }
        for (IShape segment : this.segments) {
            HashSet<Point> points = new HashSet<Point>(segment.getBasePoints());
            if (points.size() == 1) continue;
            return false;
        }
        return this.segments.size() > 0 || this.closed;
    }

    public List<Point> getPiecewiseLinearApproximation() {
        ArrayList<Point> result = new ArrayList<Point>();
        if (this.segments.size() == 0) {
            return result;
        }
        if (this.segments.get(0) instanceof BezierCurve) {
            result.addAll(((BezierCurve)this.segments.get(0)).getPiecewiseLinearApproximation());
        } else {
            result.addAll(this.segments.get(0).getBasePoints());
        }
        for (int i = 1; i < this.segments.size(); ++i) {
            List<Point> segApprox;
            if (this.segments.get(i) instanceof BezierCurve) {
                segApprox = ((BezierCurve)this.segments.get(i)).getPiecewiseLinearApproximation();
                segApprox = segApprox.subList(1, segApprox.size());
            } else {
                segApprox = this.segments.get(i).getBasePoints();
                segApprox = segApprox.subList(1, segApprox.size());
            }
            result.addAll(segApprox);
        }
        return result;
    }
}

