/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener;

import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.EventType;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.IEventListener;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class TextMarginFinder
implements IEventListener {
    private Rectangle textRectangle = null;

    @Override
    public void eventOccurred(IEventData data, EventType type) {
        if (type != EventType.RENDER_TEXT) {
            throw new IllegalStateException(MessageFormatUtil.format("Event type not supported: {0}", new Object[]{type}));
        }
        TextRenderInfo info = (TextRenderInfo)data;
        this.textRectangle = this.textRectangle == null ? info.getDescentLine().getBoundingRectangle() : Rectangle.getCommonRectangle(this.textRectangle, info.getDescentLine().getBoundingRectangle());
        this.textRectangle = Rectangle.getCommonRectangle(this.textRectangle, info.getAscentLine().getBoundingRectangle());
    }

    @Override
    public Set<EventType> getSupportedEvents() {
        return new LinkedHashSet<EventType>(Collections.singletonList(EventType.RENDER_TEXT));
    }

    public Rectangle getTextRectangle() {
        return this.textRectangle;
    }
}

