/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.signatures;

import cfca.sadk.com.itextpdf.forms.PdfAcroForm;
import cfca.sadk.com.itextpdf.forms.fields.PdfFormField;
import cfca.sadk.com.itextpdf.io.image.ImageData;
import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.font.PdfFontFactory;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfStream;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import cfca.sadk.com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import cfca.sadk.com.itextpdf.layout.Canvas;
import cfca.sadk.com.itextpdf.layout.element.Cell;
import cfca.sadk.com.itextpdf.layout.element.Paragraph;
import cfca.sadk.com.itextpdf.layout.layout.LayoutArea;
import cfca.sadk.com.itextpdf.layout.layout.LayoutContext;
import cfca.sadk.com.itextpdf.layout.layout.LayoutResult;
import cfca.sadk.com.itextpdf.layout.property.TextAlignment;
import cfca.sadk.com.itextpdf.layout.property.VerticalAlignment;
import cfca.sadk.com.itextpdf.layout.renderer.IRenderer;
import cfca.sadk.com.itextpdf.signatures.CertificateInfo;
import cfca.sadk.seal.base.config.SysEnv;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;

public class PdfSignatureAppearance {
    public static final float TOP_SECTION = 0.3f;
    public static final float MARGIN = 2.0f;
    private PdfDocument document;
    private int page = 1;
    private Rectangle rect;
    private Rectangle pageRect;
    private PdfFormXObject n0;
    private PdfFormXObject n1;
    public static final String questionMark = "% DSUnknown\nq\n1 G\n1 g\n0.1 0 0 0.1 9 0 cm\n0 J 0 j 4 M []0 d\n1 i \n0 g\n313 292 m\n313 404 325 453 432 529 c\n478 561 504 597 504 645 c\n504 736 440 760 391 760 c\n286 760 271 681 265 626 c\n265 625 l\n100 625 l\n100 828 253 898 381 898 c\n451 898 679 878 679 650 c\n679 555 628 499 538 435 c\n488 399 467 376 467 292 c\n313 292 l\nh\n308 214 170 -164 re\nf\n0.44 G\n1.2 w\n1 1 0.4 rg\n287 318 m\n287 430 299 479 406 555 c\n451 587 478 623 478 671 c\n478 762 414 786 365 786 c\n260 786 245 707 239 652 c\n239 651 l\n74 651 l\n74 854 227 924 355 924 c\n425 924 653 904 653 676 c\n653 581 602 525 512 461 c\n462 425 441 402 441 318 c\n287 318 l\nh\n282 240 170 -164 re\nB\nQ\n";
    private PdfFormXObject n2;
    private PdfFormXObject n3;
    private PdfFormXObject topLayer;
    private RenderingMode renderingMode = RenderingMode.DESCRIPTION;
    private String reason = "";
    private String reasonCaption = "Reason: ";
    private String location = "";
    private String locationCaption = "Location: ";
    private String signatureCreator = "";
    private String contact = "";
    private Calendar signDate;
    private Certificate signCertificate;
    private ImageData signatureGraphic = null;
    private ImageData image;
    private float imageScale;
    private int gsBlendMode;
    private float transparency;
    private String layer2Text;
    private PdfFont layer2Font;
    private float layer2FontSize = 12.0f;
    private Color layer2FontColor = Color.BLACK;
    private float timeRectHeight = 20.0f;
    private float imageRectHeight = 20.0f;
    private boolean changeImageHeight = true;
    private boolean reverseRect = false;
    private TextAlignment alignmentH = TextAlignment.CENTER;
    private VerticalAlignment alignmentV = VerticalAlignment.TOP;
    private VerticalAlignment graphicAlignmentV = VerticalAlignment.MIDDLE;
    private boolean isSM2 = false;
    private String fieldName;
    private boolean reuseAppearance = false;

    public void setGraphicAlignmentV(VerticalAlignment graphicAlignmentV) {
        this.graphicAlignmentV = graphicAlignmentV;
    }

    public PdfSignatureAppearance(PdfDocument document, Rectangle pageRect, int pageNumber) {
        this.document = document;
        this.pageRect = new Rectangle(pageRect);
        this.rect = new Rectangle(pageRect.getWidth(), pageRect.getHeight());
        this.page = pageNumber;
    }

    public int getPageNumber() {
        return this.page;
    }

    public PdfSignatureAppearance setPageNumber(int pageNumber) {
        this.page = pageNumber;
        return this;
    }

    public Rectangle getPageRect() {
        return this.pageRect;
    }

    public PdfSignatureAppearance setPageRect(Rectangle pageRect) {
        this.pageRect = new Rectangle(pageRect);
        this.rect = new Rectangle(pageRect.getWidth(), pageRect.getHeight());
        return this;
    }

    public PdfFormXObject getLayer0() {
        if (this.n0 == null) {
            this.n0 = new PdfFormXObject(this.rect);
            this.n0.makeIndirect(this.document);
        }
        return this.n0;
    }

    public PdfFormXObject getLayer1() {
        if (this.n1 == null) {
            this.n1 = new PdfFormXObject(new Rectangle(100.0f, 100.0f));
            this.n1.makeIndirect(this.document);
            PdfCanvas canvas = new PdfCanvas(this.n1, this.document);
            canvas.writeLiteral(questionMark);
        }
        return this.n1;
    }

    public PdfFormXObject getLayer2() {
        if (this.n2 == null) {
            this.n2 = new PdfFormXObject(this.rect);
            this.n2.makeIndirect(this.document);
        }
        return this.n2;
    }

    public PdfFormXObject getLayer3() {
        if (this.n3 == null) {
            this.n3 = new PdfFormXObject(new Rectangle(100.0f, 100.0f));
            this.n3.makeIndirect(this.document);
        }
        return this.n3;
    }

    public RenderingMode getRenderingMode() {
        return this.renderingMode;
    }

    public PdfSignatureAppearance setRenderingMode(RenderingMode renderingMode) {
        this.renderingMode = renderingMode;
        return this;
    }

    public String getReason() {
        return this.reason;
    }

    public PdfSignatureAppearance setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public PdfSignatureAppearance setReasonCaption(String reasonCaption) {
        this.reasonCaption = reasonCaption;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public PdfSignatureAppearance setLocation(String location) {
        this.location = location;
        return this;
    }

    public PdfSignatureAppearance setLocationCaption(String locationCaption) {
        this.locationCaption = locationCaption;
        return this;
    }

    public String getSignatureCreator() {
        return this.signatureCreator;
    }

    public PdfSignatureAppearance setSignatureCreator(String signatureCreator) {
        this.signatureCreator = signatureCreator;
        return this;
    }

    public String getContact() {
        return this.contact;
    }

    public PdfSignatureAppearance setContact(String contact) {
        this.contact = contact;
        return this;
    }

    public PdfSignatureAppearance setCertificate(Certificate signCertificate) {
        this.signCertificate = signCertificate;
        return this;
    }

    public Certificate getCertificate() {
        return this.signCertificate;
    }

    public ImageData getSignatureGraphic() {
        return this.signatureGraphic;
    }

    public PdfSignatureAppearance setSignatureGraphic(ImageData signatureGraphic) {
        this.signatureGraphic = signatureGraphic;
        return this;
    }

    public PdfSignatureAppearance setReuseAppearance(boolean reuseAppearance) {
        this.reuseAppearance = reuseAppearance;
        return this;
    }

    public ImageData getImage() {
        return this.image;
    }

    public PdfSignatureAppearance setImage(ImageData image) {
        this.image = image;
        return this;
    }

    public float getImageScale() {
        return this.imageScale;
    }

    public PdfSignatureAppearance setImageScale(float imageScale) {
        this.imageScale = imageScale;
        return this;
    }

    public PdfSignatureAppearance setLayer2Text(String text) {
        this.layer2Text = text;
        return this;
    }

    public String getLayer2Text() {
        return this.layer2Text;
    }

    public PdfFont getLayer2Font() {
        return this.layer2Font;
    }

    public PdfSignatureAppearance setLayer2Font(PdfFont layer2Font) {
        this.layer2Font = layer2Font;
        return this;
    }

    public void setLayer2FontColor(Color layer2FontColor) {
        this.layer2FontColor = layer2FontColor;
    }

    public void setTimeRectHeight(float timeRectHeight) {
        this.timeRectHeight = timeRectHeight;
    }

    public void setImageRectHeight(float imageRectHeight) {
        if (imageRectHeight > 0.0f) {
            this.imageRectHeight = imageRectHeight;
        }
    }

    public void setChangeImageHeight(boolean changeImageHeight) {
        this.changeImageHeight = changeImageHeight;
    }

    public void setReverseRect(boolean reverseRect) {
        this.reverseRect = reverseRect;
        if (reverseRect) {
            this.changeImageHeight = true;
        }
    }

    public PdfSignatureAppearance setLayer2FontSize(float fontSize) {
        this.layer2FontSize = fontSize;
        return this;
    }

    public void setAlignmentH(TextAlignment alignmentH) {
        this.alignmentH = alignmentH;
    }

    public void setAlignmentV(VerticalAlignment alignmentV) {
        this.alignmentV = alignmentV;
    }

    public boolean isInvisible() {
        return this.rect == null || this.rect.getWidth() == 0.0f || this.rect.getHeight() == 0.0f;
    }

    public PdfFormXObject getAppearance() throws IOException {
        PdfCanvas canvas;
        if (this.isInvisible()) {
            PdfFormXObject appearance = new PdfFormXObject(new Rectangle(0.0f, 0.0f));
            appearance.makeIndirect(this.document);
            return appearance;
        }
        if (this.n0 == null && !this.reuseAppearance) {
            this.createBlankN0();
        }
        if (this.n2 == null || this.renderingMode.equals((Object)RenderingMode.GRAPHIC_AND_DESCRIPTION)) {
            String text;
            this.n2 = new PdfFormXObject(this.rect);
            this.n2.makeIndirect(this.document);
            PdfFont font = null;
            if (this.layer2Text == null) {
                text = "";
            } else {
                text = this.layer2Text;
                font = this.layer2Font == null ? PdfFontFactory.createFont() : this.layer2Font;
            }
            if (this.image != null) {
                if (this.imageScale == 0.0f) {
                    canvas = new PdfCanvas(this.n2, this.document);
                    canvas.addImage(this.image, this.rect.getWidth(), 0.0f, 0.0f, this.rect.getHeight(), 0.0f, 0.0f);
                } else {
                    float usableScale = this.imageScale;
                    if (this.imageScale < 0.0f) {
                        usableScale = Math.min(this.rect.getWidth() / this.image.getWidth(), this.rect.getHeight() / this.image.getHeight());
                    }
                    float w = this.image.getWidth() * usableScale;
                    float h = this.image.getHeight() * usableScale;
                    float x = (this.rect.getWidth() - w) / 2.0f;
                    float y = (this.rect.getHeight() - h) / 2.0f;
                    canvas = new PdfCanvas(this.n2, this.document);
                    canvas.addImage(this.image, w, 0.0f, 0.0f, h, x, y);
                }
            }
            Rectangle dataRect = null;
            Rectangle signatureRect = null;
            if (this.renderingMode == RenderingMode.NAME_AND_DESCRIPTION || this.renderingMode == RenderingMode.GRAPHIC_AND_DESCRIPTION && this.signatureGraphic != null) {
                if (!this.changeImageHeight) {
                    signatureRect = this.rect;
                    dataRect = new Rectangle(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.timeRectHeight);
                } else {
                    Rectangle imageRect = new Rectangle(this.rect.getX(), this.rect.getY() + this.timeRectHeight, this.rect.getWidth(), this.rect.getHeight() - this.timeRectHeight);
                    Rectangle textRect = new Rectangle(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.timeRectHeight);
                    if (this.reverseRect) {
                        signatureRect = textRect;
                        signatureRect.setWidth(this.rect.getWidth() / 2.0f);
                        signatureRect.setX(this.rect.getX() + this.rect.getWidth() / 2.0f);
                        signatureRect.setHeight(this.imageRectHeight);
                        dataRect = this.rect;
                    } else {
                        signatureRect = imageRect;
                        dataRect = textRect;
                    }
                }
            } else if (this.renderingMode == RenderingMode.GRAPHIC) {
                if (this.signatureGraphic == null) {
                    throw new IllegalStateException("A signature image must be present when rendering mode is graphic. Use setSignatureGraphic()");
                }
                signatureRect = new Rectangle(2.0f, 2.0f, this.rect.getWidth() - 4.0f, this.rect.getHeight() - 4.0f);
            } else {
                dataRect = new Rectangle(2.0f, 2.0f, this.rect.getWidth() - 4.0f, this.rect.getHeight() * 0.7f - 4.0f);
            }
            switch (this.renderingMode) {
                case NAME_AND_DESCRIPTION: {
                    String signedBy = CertificateInfo.getSubjectFields((X509Certificate)this.signCertificate).getField("CN");
                    if (signedBy == null) {
                        signedBy = CertificateInfo.getSubjectFields((X509Certificate)this.signCertificate).getField("E");
                    }
                    if (signedBy == null) {
                        signedBy = "";
                    }
                    this.addTextToCanvas(signedBy, font, signatureRect);
                    break;
                }
                case GRAPHIC_AND_DESCRIPTION: {
                    float imgHeight;
                    if (this.signatureGraphic == null) {
                        throw new IllegalStateException("A signature image must be present when rendering mode is graphic and description. Use setSignatureGraphic()");
                    }
                    float imgWidth = this.signatureGraphic.getWidth();
                    if (imgWidth == 0.0f) {
                        imgWidth = signatureRect.getWidth();
                    }
                    if ((imgHeight = this.signatureGraphic.getHeight()) == 0.0f) {
                        imgHeight = signatureRect.getHeight();
                    }
                    float multiplierH = signatureRect.getWidth() / this.signatureGraphic.getWidth();
                    float multiplierW = signatureRect.getHeight() / this.signatureGraphic.getHeight();
                    float multiplier = Math.min(multiplierH, multiplierW);
                    imgHeight *= multiplier;
                    float x = (this.rect.getWidth() - (imgWidth *= multiplier)) / 2.0f;
                    if (this.changeImageHeight && this.reverseRect) {
                        x = this.rect.getWidth() - imgWidth;
                    }
                    float y = signatureRect.getBottom() + (signatureRect.getHeight() - imgHeight) / 2.0f;
                    if (VerticalAlignment.TOP == this.graphicAlignmentV) {
                        y = signatureRect.getBottom() + (signatureRect.getHeight() - imgHeight);
                    }
                    canvas = new PdfCanvas(this.n2, this.document);
                    if (this.gsBlendMode == 1) {
                        PdfExtGState gs = new PdfExtGState();
                        gs.put(PdfName.BM, PdfName.Multiply);
                        gs.put(PdfName.Type, PdfName.ExtGState);
                        gs.setFillOpacity(this.transparency);
                        canvas.setExtGState(gs);
                    } else if (this.gsBlendMode == 0) {
                        PdfExtGState gs = new PdfExtGState();
                        gs.setFillOpacity(this.transparency);
                        canvas.setExtGState(gs);
                    }
                    canvas.addImage(this.signatureGraphic, imgWidth, 0.0f, 0.0f, imgHeight, x, y);
                    break;
                }
                case GRAPHIC: {
                    float imgHeight;
                    float imgWidth = this.signatureGraphic.getWidth();
                    if (imgWidth == 0.0f) {
                        imgWidth = signatureRect.getWidth();
                    }
                    if ((imgHeight = this.signatureGraphic.getHeight()) == 0.0f) {
                        imgHeight = signatureRect.getHeight();
                    }
                    float multiplierH = signatureRect.getWidth() / this.signatureGraphic.getWidth();
                    float multiplierW = signatureRect.getHeight() / this.signatureGraphic.getHeight();
                    float multiplier = Math.min(multiplierH, multiplierW);
                    float x = signatureRect.getLeft() + (signatureRect.getWidth() - (imgWidth *= multiplier)) / 2.0f;
                    float y = signatureRect.getBottom() + (signatureRect.getHeight() - (imgHeight *= multiplier)) / 2.0f;
                    canvas = new PdfCanvas(this.n2, this.document);
                    canvas.addImage(this.signatureGraphic, imgWidth, 0.0f, 0.0f, imgHeight, x, y);
                    break;
                }
            }
            if (this.renderingMode != RenderingMode.GRAPHIC && !text.equals("")) {
                this.addTextToCanvas(text, font, dataRect, this.layer2FontColor);
            }
        }
        int rotation = this.document.getPage(this.page).getRotation();
        Rectangle rotated = new Rectangle(this.rect);
        if (rotation == 90 || rotation == 270) {
            float width = this.rect.getWidth();
            float height = this.rect.getHeight();
            rotated.setHeight(width);
            rotated.setWidth(height);
        }
        if (this.topLayer == null) {
            float scale = Math.min(this.rect.getWidth(), this.rect.getHeight()) * 0.9f;
            float x = (this.rect.getWidth() - scale) / 2.0f;
            float y = (this.rect.getHeight() - scale) / 2.0f;
            scale /= 100.0f;
            this.topLayer = new PdfFormXObject(rotated);
            this.topLayer.makeIndirect(this.document);
            canvas = new PdfCanvas(this.topLayer, this.document);
            if (rotation == 90) {
                canvas.concatMatrix(0.0, 1.0, -1.0, 0.0, this.rect.getHeight(), 0.0);
            } else if (rotation == 180) {
                canvas.concatMatrix(-1.0, 0.0, 0.0, -1.0, this.rect.getWidth(), this.rect.getHeight());
            } else if (rotation == 270) {
                canvas.concatMatrix(0.0, -1.0, 1.0, 0.0, 0.0, this.rect.getWidth());
            }
            if (this.reuseAppearance) {
                PdfAcroForm acroForm = PdfAcroForm.getAcroForm(this.document, true);
                PdfFormField field = acroForm.getField(this.fieldName);
                PdfStream stream = field.getWidgets().get(0).getAppearanceDictionary().getAsStream(PdfName.N);
                PdfFormXObject xobj = new PdfFormXObject(stream);
                if (stream != null) {
                    this.topLayer.getResources().addForm(xobj, new PdfName("n0"));
                    PdfCanvas canvas1 = new PdfCanvas(this.topLayer, this.document);
                    canvas1.addXObject(xobj, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                } else {
                    this.reuseAppearance = false;
                    if (this.n0 == null) {
                        this.createBlankN0();
                    }
                }
            }
            if (!this.reuseAppearance) {
                this.topLayer.getResources().addForm(this.n0, new PdfName("n0"));
                PdfCanvas canvas1 = new PdfCanvas(this.topLayer, this.document);
                canvas1.addXObject(this.n0, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            if (!this.isSM2 && SysEnv.isAcro6Layers()) {
                this.n1 = this.getLayer1();
                this.topLayer.getResources().addForm(this.n1, new PdfName("n1"));
                PdfCanvas canvas1 = new PdfCanvas(this.topLayer, this.document);
                canvas1.addXObject(this.n1, scale, 0.0f, 0.0f, scale, 777.0f, 777.0f);
            }
            this.topLayer.getResources().addForm(this.n2, new PdfName("n2"));
            PdfCanvas canvas2 = new PdfCanvas(this.topLayer, this.document);
            canvas2.addXObject(this.n2, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            if (!this.isSM2 && SysEnv.isAcro6Layers()) {
                this.n3 = this.getLayer3();
                this.topLayer.getResources().addForm(this.n3, new PdfName("n3"));
                PdfCanvas canvas3 = new PdfCanvas(this.topLayer, this.document);
                canvas3.addXObject(this.n3, scale, 0.0f, 0.0f, scale, x, y);
                canvas3.writeLiteral("% DSBlank\n");
            }
        }
        PdfFormXObject napp = new PdfFormXObject(rotated);
        napp.makeIndirect(this.document);
        napp.getResources().addForm(this.topLayer, new PdfName("FRM"));
        canvas = new PdfCanvas(napp, this.document);
        canvas.addXObject(this.topLayer, 0.0f, 0.0f);
        return napp;
    }

    protected Calendar getSignDate() {
        return this.signDate;
    }

    protected PdfSignatureAppearance setSignDate(Calendar signDate) {
        this.signDate = signDate;
        return this;
    }

    protected PdfSignatureAppearance setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    private void createBlankN0() {
        this.n0 = new PdfFormXObject(new Rectangle(100.0f, 100.0f));
        this.n0.makeIndirect(this.document);
        PdfCanvas canvas = new PdfCanvas(this.n0, this.document);
        canvas.writeLiteral("% DSBlank\n");
    }

    private void addTextToCanvas(String text, PdfFont font, Rectangle dataRect) {
        this.addTextToCanvas(text, font, dataRect, Color.BLACK);
    }

    private void addTextToCanvas(String text, PdfFont font, Rectangle dataRect, Color fontColor) {
        PdfExtGState gs;
        PdfCanvas canvas = new PdfCanvas(this.n2, this.document);
        Paragraph paragraph = ((Paragraph)((Paragraph)new Paragraph(text).setFont(font)).setMargin(0.0f)).setMultipliedLeading(0.9f);
        Canvas layoutCanvas = new Canvas(canvas, this.document, dataRect);
        if (this.gsBlendMode == 1) {
            gs = new PdfExtGState();
            gs.put(PdfName.BM, PdfName.Multiply);
            gs.put(PdfName.Type, PdfName.ExtGState);
            gs.setFillOpacity(this.transparency);
            canvas.setExtGState(gs);
        } else if (this.gsBlendMode == 0) {
            gs = new PdfExtGState();
            gs.setFillOpacity(this.transparency);
            canvas.setExtGState(gs);
        }
        if (this.layer2FontSize == 0.0f) {
            this.applyCopyFittingFontSize(paragraph, dataRect, layoutCanvas.getRenderer());
        } else {
            paragraph.setFontSize(this.layer2FontSize);
        }
        paragraph.setFontColor(fontColor);
        Cell cell = new Cell();
        cell.add(paragraph);
        cell.setHeight(dataRect.getHeight());
        cell.setWidth(dataRect.getWidth());
        cell.setTextAlignment(this.alignmentH);
        cell.setVerticalAlignment(this.alignmentV);
        layoutCanvas.add(cell);
    }

    private void applyCopyFittingFontSize(Paragraph paragraph, Rectangle rect, IRenderer parentRenderer) {
        IRenderer renderer = paragraph.createRendererSubTree().setParent(parentRenderer);
        LayoutContext layoutContext = new LayoutContext(new LayoutArea(1, rect));
        float lFontSize = 0.1f;
        float rFontSize = 100.0f;
        int numberOfIterations = 15;
        for (int i = 0; i < numberOfIterations; ++i) {
            float mFontSize = (lFontSize + rFontSize) / 2.0f;
            paragraph.setFontSize(mFontSize);
            LayoutResult result = renderer.layout(layoutContext);
            if (result.getStatus() == 1) {
                lFontSize = mFontSize;
                continue;
            }
            rFontSize = mFontSize;
        }
        paragraph.setFontSize(lFontSize);
    }

    public void setN2(PdfFormXObject n2) {
        this.n2 = n2;
    }

    public void setGsBlendMode(int gsBlendMode) {
        this.gsBlendMode = gsBlendMode;
    }

    public void setTransparency(float transparency) {
        this.transparency = transparency;
    }

    public void setSM2(boolean isSM2) {
        this.isSM2 = isSM2;
    }

    public static enum RenderingMode {
        DESCRIPTION,
        NAME_AND_DESCRIPTION,
        GRAPHIC_AND_DESCRIPTION,
        GRAPHIC;

    }
}

