/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.com.itextpdf.signatures.IExternalSignature;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.seal.base.bean.sign.SignInfoConfig;
import cfca.sadk.seal.base.util.CFCAP7AttributeSigner;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.Base64;
import cfca.sadk.util.Signature;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;

public class CFCAP1Signer
implements IExternalSignature {
    private static Logger businessLog = LoggerFactory.getLogger(CFCAP7AttributeSigner.class);
    private PrivateKey privatekey = null;
    private Session session = null;
    private Mechanism mechanism = null;

    public CFCAP1Signer(SignInfoConfig signatureConfig) {
        this.mechanism = signatureConfig.getSignAlg();
        this.privatekey = signatureConfig.getPrivateKey();
        this.session = signatureConfig.getSession();
    }

    @Override
    public String getHashAlgorithm() {
        Digest engine = Mechanisms.getDigest((Mechanism)this.mechanism);
        return engine.getAlgorithmName();
    }

    @Override
    public String getEncryptionAlgorithm() {
        if (Mechanisms.isSM2Type((Mechanism)this.mechanism)) {
            return "SM2";
        }
        if (Mechanisms.isECDSA((Mechanism)this.mechanism)) {
            return "ECC";
        }
        return "RSA";
    }

    @Override
    public byte[] sign(byte[] paramArrayOfByte) throws GeneralSecurityException {
        Signature sig = new Signature();
        byte[] p1SignedData = null;
        try {
            if (this.session == null) {
                String deviceName = "JSOFT_LIB";
                JCrypto.getInstance().initialize("JSOFT_LIB", null);
                this.session = JCrypto.getInstance().openSession("JSOFT_LIB");
            }
            p1SignedData = sig.p1SignMessage(this.mechanism.getMechanismType(), paramArrayOfByte, this.privatekey, this.session);
            return Base64.decode((byte[])p1SignedData);
        }
        catch (PKIException e) {
            businessLog.error("sign failed:", (Throwable)e);
            throw new GeneralSecurityException("CFCAP1Signer sign failed:", e);
        }
    }
}

