/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.pdf.StampingProperties;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfFileAttachmentAnnotation;
import cfca.sadk.com.itextpdf.kernel.pdf.filespec.PdfFileSpec;
import cfca.sadk.seal.base.bean.annotation.Annotation;
import cfca.sadk.seal.base.bean.annotation.AnnotationList;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AnnotationUtil {
    private static Logger businessLog = LoggerFactory.getLogger(AnnotationUtil.class);

    public static void addAnnotationList(InputStream inputStream, OutputStream outputStream, AnnotationList annotationList) throws SealException {
        businessLog.info("addAnnotationList begin...");
        PdfDocument pdfDoc = null;
        try {
            int size = annotationList.size();
            Annotation annotation = null;
            PdfWriter writer = new PdfWriter(outputStream);
            StampingProperties properties = new StampingProperties();
            properties.useAppendMode();
            pdfDoc = new PdfDocument(new PdfReader(inputStream), writer, properties, true);
            ParamsCheckUtil.checkSignature(pdfDoc);
            for (int i = 0; i < size; ++i) {
                annotation = (Annotation)annotationList.get(i);
                Rectangle rect = annotation.getRect();
                if (null == rect) {
                    businessLog.error("parameter rectangle is required!");
                    throw new SealException("parameter rectangle is required!");
                }
                String filePath = annotation.getFilePath();
                byte[] fileData = annotation.getFileData();
                if (null == filePath && fileData == null) {
                    businessLog.error("parameter filePath or fileData is required!");
                    throw new SealException("parameter filePath or fileData is required!");
                }
                String description = annotation.getDescription();
                String fileDisplay = annotation.getFileDisplay();
                if (null == fileDisplay) {
                    businessLog.error("parameter fileDisplay is required!");
                    throw new SealException("parameter fileDisplay is required!");
                }
                PdfFileSpec fs = null;
                if (filePath != null) {
                    fs = PdfFileSpec.createEmbeddedFileSpec(pdfDoc, filePath, description, fileDisplay, null, null, true);
                } else if (fileData != null) {
                    fs = PdfFileSpec.createEmbeddedFileSpec(pdfDoc, fileData, description, fileDisplay, null, null, null, true);
                }
                PdfFileAttachmentAnnotation fileAttachmentAnnotation = new PdfFileAttachmentAnnotation(rect, fs);
                if (null != annotation.getSubject()) {
                    fileAttachmentAnnotation.setSubject(new PdfString(annotation.getSubject(), "UnicodeBig"));
                }
                if (null != annotation.getContents()) {
                    fileAttachmentAnnotation.setContents(annotation.getContents());
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                String date = format.format(new Date());
                fileAttachmentAnnotation.setDate(new PdfString(date));
                if (null != annotation.getAuthor()) {
                    fileAttachmentAnnotation.setTitle(new PdfString(annotation.getAuthor(), "UnicodeBig"));
                }
                fileAttachmentAnnotation.setOpacity(new PdfNumber(0));
                pdfDoc.getPage(annotation.getPageNum()).addAnnotation(fileAttachmentAnnotation);
            }
            pdfDoc.close();
        }
        catch (Exception e) {
            businessLog.error("addTextAnnotation:", (Throwable)e);
            throw new SealException("addTextAnnotation:", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
            businessLog.info("addAnnotationList end...");
        }
    }

    public static void addAnnotationList(byte[] inputData, OutputStream outputStream, AnnotationList annotationList) throws SealException {
        businessLog.info("addAnnotationList begin...");
        PdfDocument pdfDoc = null;
        try {
            int size = annotationList.size();
            Annotation annotation = null;
            StampingProperties properties = new StampingProperties();
            properties.useAppendMode();
            PdfWriter writer = new PdfWriter(outputStream);
            pdfDoc = new PdfDocument(new PdfReader(inputData), writer, properties, true);
            ParamsCheckUtil.checkSignature(pdfDoc);
            for (int i = 0; i < size; ++i) {
                annotation = (Annotation)annotationList.get(i);
                Rectangle rect = annotation.getRect();
                if (null == rect) {
                    businessLog.error("parameter rectangle is required!");
                    throw new SealException("parameter rectangle is required!");
                }
                byte[] fileData = annotation.getFileData();
                if (null == fileData || fileData.length == 0) {
                    businessLog.error("parameter fileData is required!");
                    throw new SealException("parameter fileData is required!");
                }
                String fileDisplay = annotation.getFileDisplay();
                if (null == fileDisplay) {
                    businessLog.error("parameter fileDisplay is required!");
                    throw new SealException("parameter fileDisplay is required!");
                }
                PdfFileSpec fs = PdfFileSpec.createEmbeddedFileSpec(pdfDoc, fileData, null, fileDisplay, null, null, null, true);
                PdfFileAttachmentAnnotation fileAttachmentAnnotation = new PdfFileAttachmentAnnotation(rect, fs);
                if (null != annotation.getSubject()) {
                    fileAttachmentAnnotation.setSubject(new PdfString(annotation.getSubject(), "UnicodeBig"));
                }
                if (null != annotation.getContents()) {
                    fileAttachmentAnnotation.setContents(annotation.getContents());
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                String date = format.format(new Date());
                fileAttachmentAnnotation.setDate(new PdfString(date));
                if (null != annotation.getAuthor()) {
                    fileAttachmentAnnotation.setTitle(new PdfString(annotation.getAuthor(), "UnicodeBig"));
                }
                fileAttachmentAnnotation.setOpacity(new PdfNumber(0));
                pdfDoc.getPage(annotation.getPageNum()).addAnnotation(fileAttachmentAnnotation);
            }
            pdfDoc.close();
        }
        catch (Exception e) {
            businessLog.error("addTextAnnotation:", (Throwable)e);
            throw new SealException("addTextAnnotation:", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
            businessLog.info("addAnnotationList end...");
        }
    }
}

