/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.manager;

import cfca.sadk.tls.java.security.CFCAAlgorithmConstraints;
import cfca.sadk.tls.javax.net.ssl.CFCASSLEngine;
import cfca.sadk.tls.javax.net.ssl.CFCASSLSocket;
import cfca.sadk.tls.javax.net.ssl.CFCASSLTransfer;
import cfca.sadk.tls.javax.net.ssl.CFCAX509ExtendedTrustManager;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.util.CFCAAlgorithmConstraintsHelper;
import cfca.sadk.tls.sun.security.util.CFCASSLHelper;
import cfca.sadk.tls.sun.security.validator.TLSValidator;
import cfca.sadk.tls.sun.security.validator.TLSValidatorVariant;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;

final class CFCAX509TrustManager
extends CFCAX509ExtendedTrustManager
implements X509TrustManager {
    private final Collection<X509Certificate> trustedCerts;
    private final PKIXBuilderParameters pkixParams;
    private volatile TLSValidator clientValidator;
    private volatile TLSValidator serverValidator;

    CFCAX509TrustManager(KeyStore keystore) throws KeyStoreException {
        this.pkixParams = null;
        this.trustedCerts = CFCASSLHelper.getTrustedCerts(keystore);
        this.showTrustedCerts();
    }

    CFCAX509TrustManager(PKIXBuilderParameters params) {
        this.pkixParams = params;
        TLSValidator localValidator = this.getValidator(TLSValidatorVariant.TLS_SERVER);
        this.trustedCerts = this.serverValidator.getTrustedCertificates();
        this.serverValidator = localValidator;
        this.showTrustedCerts();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(chain, authType, (Socket)null, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(chain, authType, (Socket)null, false);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustedCerts.toArray(new X509Certificate[0]);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkTrusted(chain, authType, socket, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkTrusted(chain, authType, socket, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, CFCASSLEngine engine) throws CertificateException {
        this.checkTrusted(chain, authType, engine, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, CFCASSLEngine engine) throws CertificateException {
        this.checkTrusted(chain, authType, engine, false);
    }

    private final void checkTrusted(X509Certificate[] chain, String authType, Socket socket, boolean isClient) throws CertificateException {
        CFCASSLSocket transfer = null;
        if (socket != null && socket.isConnected() && socket instanceof CFCASSLSocket) {
            transfer = (CFCASSLSocket)socket;
        }
        this.checkTrusted(chain, authType, transfer, isClient);
    }

    private final void checkTrusted(X509Certificate[] chain, String authType, CFCASSLTransfer transfer, boolean isClient) throws CertificateException {
        TLSValidator validator = this.checkTrustedInit(chain, authType, isClient);
        CFCAAlgorithmConstraints constraints = null;
        if (transfer != null) {
            SSLSession session = transfer.getHandshakeSession();
            if (session == null) {
                throw new CertificateException("No handshake session");
            }
            String identityAlg = transfer.getCFCASSLParameters().getEndpointIdentificationAlgorithm();
            if (identityAlg != null && identityAlg.length() != 0) {
                CFCASSLHelper.checkIdentity(session, chain[0], identityAlg, isClient, CFCASSLHelper.getRequestedServerNames(transfer));
            } else {
                CFCASSLHelper.checkIdentity(session, chain[0], "TCP", isClient, CFCASSLHelper.getRequestedServerNames(transfer));
            }
            constraints = CFCAAlgorithmConstraintsHelper.createAlgorithmConstraintsForTrustManager(transfer);
        }
        X509Certificate[] trustedChain = CFCASSLHelper.validate(validator, chain, constraints, authType, isClient);
        if (Debugger.check.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("\nFound trusted certificate:");
            if (trustedChain == null || trustedChain.length < 1) {
                builder.append("NONE");
            } else {
                builder.append(trustedChain[trustedChain.length - 1]);
            }
            Debugger.check.debug(builder.toString());
        }
    }

    private final TLSValidator checkTrustedInit(X509Certificate[] chain, String authType, boolean isClient) {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("null or zero-length certificate chain");
        }
        if (authType == null || authType.length() == 0) {
            throw new IllegalArgumentException("null or zero-length authentication type");
        }
        TLSValidator v = null;
        v = isClient ? this.getSingletonClientValidator() : this.getSingletonServerValidator();
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TLSValidator getSingletonClientValidator() {
        TLSValidator validator = this.clientValidator;
        if (validator == null) {
            CFCAX509TrustManager cFCAX509TrustManager = this;
            synchronized (cFCAX509TrustManager) {
                validator = this.clientValidator;
                if (validator == null) {
                    this.clientValidator = validator = this.getValidator(TLSValidatorVariant.TLS_CLIENT);
                }
            }
        }
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TLSValidator getSingletonServerValidator() {
        TLSValidator validator = this.serverValidator;
        if (validator == null) {
            CFCAX509TrustManager cFCAX509TrustManager = this;
            synchronized (cFCAX509TrustManager) {
                validator = this.serverValidator;
                if (validator == null) {
                    this.serverValidator = validator = this.getValidator(TLSValidatorVariant.TLS_SERVER);
                }
            }
        }
        return validator;
    }

    private void showTrustedCerts() {
        if (Debugger.check.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            if (this.trustedCerts == null) {
                builder.append("\nnone trusted cert:");
            } else {
                Iterator<X509Certificate> i$ = this.trustedCerts.iterator();
                while (i$.hasNext()) {
                    X509Certificate obj;
                    X509Certificate cert = obj = i$.next();
                    builder.append("\nadding as trusted cert:");
                    builder.append("\n  Subject: " + cert.getSubjectX500Principal());
                    builder.append("\n  Issuer:  " + cert.getIssuerX500Principal());
                    builder.append("\n  Algorithm: " + cert.getPublicKey().getAlgorithm() + "; Serial number: 0x" + cert.getSerialNumber().toString(16));
                    builder.append("\n  Valid from " + cert.getNotBefore() + " until " + cert.getNotAfter());
                    builder.append('\n');
                }
            }
            Debugger.check.debug(builder.toString());
        }
    }

    private TLSValidator getValidator(TLSValidatorVariant variant) {
        TLSValidator v = this.pkixParams == null ? TLSValidator.getInstance(variant, this.trustedCerts) : TLSValidator.getInstance(variant, this.pkixParams);
        return v;
    }
}

